@extends('layouts.admin')

@section('page-title')
    {{ __('Dashboard') }}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item">{{ __('Home') }}</li>
@endsection
@section('content')
<div class="dashboard-page mt-md-3 mt-2">
    <div class="dashboard-page-wrp row-gap-1 row mb-4">
        <div class="col-xxl-4 col-12">
            <div class="card create-tickets">
                <div class="card-body">
                <img src="{{ asset('assets/images/dashboard/dashboard-card-bg1.png') }}" alt="background-image"
                class="create-ticked-card-bg">
                    <div class="card-content d-flex align-items-sm-center gap-sm-4 flex-sm-row flex-column gap-3">
                        <div class="card-content-left flex-1">
                            <p>{{ __('Did you know that you can quickly Create your Ticket by using this link.') }}</p>
                            <div class="btn-wrp">
                                <a href="#" class="btn p-2 btn-sm btn-primary btn-icon cp_link"
                                    data-link="{{ url(\Auth::user()->slug . '/') }}" data-toggle="tooltip"
                                    data-original-title="{{ __('Click To Copy Support Ticket Url') }}"
                                    title="{{ __('Click To Copy Support Ticket Url') }}" data-bs-toggle="tooltip"
                                    data-bs-placement="top">
                                    <i class="ti ti-copy"></i>
                                    {{ __('Create Ticket') }}
                                </a>
                            </div>
                        </div>
                        <div class="card-content-right">
                        <div class="card-icon">
                        <svg width="48" height="49" viewBox="0 0 48 49" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M44.0089 29.548C40.073 27.6915 32.944 31.6273 27.3001 34.8206C24.998 36.083 22.8444 37.2712 21.879 37.494C20.9879 37.6425 20.2453 37.494 19.6512 37.1227C18.9086 36.6028 18.5373 35.7117 18.3145 35.1919C18.7601 35.0434 19.3542 34.8948 20.0225 34.8948C25.5178 34.672 28.9339 32.7413 29.0081 29.8451C29.0081 28.8054 28.7111 27.9885 28.0427 27.3944C27.0031 26.5033 25.5178 26.6518 25.3693 26.7261C25.2951 26.7261 20.4681 27.3944 17.5719 27.0231H17.3491C14.3787 26.6518 11.8538 26.3548 9.25463 29.9193C7.10106 32.8155 3.61078 32.3699 3.46226 32.3699C3.23948 32.3699 3.01669 32.3699 2.86817 32.5185C2.71965 32.667 2.64539 32.8898 2.64539 33.1126V44.4745C2.64539 44.8458 2.94243 45.1429 3.31374 45.2171L17.8689 46.7766C18.3888 46.8509 18.8343 46.8509 19.3542 46.8509C21.9533 46.8509 24.4782 46.1083 26.706 44.6973L44.3059 33.5581C45.0485 33.1126 45.4198 32.2957 45.3456 31.4788C45.2713 30.5877 44.7515 29.8451 44.0089 29.548Z" fill="#10B77F"/>
<path d="M13.1162 22.7902H34.5777V21.305V20.1911C34.5777 19.8198 34.8748 19.4484 35.3203 19.4484C35.7659 19.4484 36.0629 19.8198 36.0629 20.1911V21.305V22.7902H40.3701C41.4097 22.7902 42.2266 21.9733 42.2266 20.9337V15.5869C42.2266 15.1413 41.8553 14.8443 41.484 14.8443C40.2216 14.8443 39.1077 13.8046 39.1077 12.4679C39.1077 11.1312 40.1473 10.1658 41.484 10.1658C41.8553 10.1658 42.2266 9.79449 42.2266 9.42319V4.07638C42.2266 3.03672 41.4097 2.21985 40.3701 2.21985H36.0629V3.70507V4.81899C36.0629 5.26456 35.7659 5.5616 35.3203 5.5616C34.8748 5.5616 34.5777 5.26456 34.5777 4.81899V3.70507V2.21985H13.1162C12.0766 2.21985 11.2597 3.03672 11.2597 4.07638V9.42319C11.2597 9.79449 11.631 10.1658 12.0023 10.1658C13.2648 10.1658 14.3044 11.2055 14.3044 12.4679C14.3044 13.7303 13.2648 14.8443 12.0023 14.8443C11.631 14.8443 11.2597 15.1413 11.2597 15.5869V20.9337C11.2597 21.9733 12.0766 22.7902 13.1162 22.7902ZM18.3888 11.7995H30.4191C30.8647 11.7995 31.1617 12.1708 31.1617 12.5422C31.1617 12.9135 30.8647 13.2848 30.4191 13.2848H18.3888C17.9432 13.2848 17.6462 12.9135 17.6462 12.5422C17.6462 12.1708 18.0175 11.7995 18.3888 11.7995ZM17.6462 8.08648C17.6462 7.71518 17.9432 7.34387 18.3888 7.34387H30.4191C30.8647 7.34387 31.1617 7.71518 31.1617 8.08648C31.1617 8.45779 30.8647 8.8291 30.4191 8.8291H18.3888C18.0175 8.8291 17.6462 8.45779 17.6462 8.08648ZM18.3888 16.181H30.4191C30.8647 16.181 31.1617 16.478 31.1617 16.9236C31.1617 17.3691 30.8647 17.6662 30.4191 17.6662H18.3888C17.9432 17.6662 17.6462 17.3691 17.6462 16.9236C17.6462 16.5523 18.0175 16.181 18.3888 16.181ZM35.3203 17.889C34.8748 17.889 34.5777 17.5919 34.5777 17.1464V14.1016C34.5777 13.6561 34.8748 13.359 35.3203 13.359C35.7659 13.359 36.0629 13.6561 36.0629 14.1016V17.1464C36.0629 17.5177 35.6916 17.889 35.3203 17.889ZM35.3203 7.12109C35.7659 7.12109 36.0629 7.41813 36.0629 7.8637V10.9084C36.0629 11.2797 35.7659 11.651 35.3203 11.651C34.8748 11.651 34.5777 11.2797 34.5777 10.9084V7.8637C34.5777 7.49239 34.8748 7.12109 35.3203 7.12109Z" fill="#10B77F"/>
</svg>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xxl-2 col-lg-3 col-sm-6 col-12">
            <div class="card total-category">
                <div class="card-body d-flex flex-column justify-content-between gap-3">
                    <div class="bottom-img">
                        <svg width="128" height="95" viewBox="0 0 128 95" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <rect width="102.001" height="83.0013" rx="6"
                                transform="matrix(0.746641 -0.667026 0.686312 0.725658 -2 110.038)" fill="#FF3A6E"
                                fill-opacity="0.10" />
                            <rect width="75.3406" height="61.3067" rx="6"
                                transform="matrix(0.746641 -0.667026 0.686312 0.725658 88 48.2542)" fill="#FF3A6E"
                                fill-opacity="0.10" />
                        </svg>
                    </div>
                    <div class="card-icon-wrp d-flex flex-wrap justify-content-between gap-2">
                        <div class="card-icon">
                            <svg width="30" height="30" viewBox="0 0 30 30" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M4.77652 1.17188C4.05987 1.17187 3.35931 1.38439 2.76344 1.78253C2.16757 2.18068 1.70314 2.74659 1.4289 3.40868C1.15465 4.07078 1.08289 4.79933 1.2227 5.50221C1.36251 6.20509 1.70761 6.85072 2.21436 7.35747C2.7211 7.86422 3.36674 8.20932 4.06962 8.34913C4.7725 8.48894 5.50105 8.41718 6.16315 8.14293C6.82524 7.86868 7.39115 7.40426 7.78929 6.80839C8.18744 6.21252 8.39995 5.51196 8.39995 4.79531C8.39871 3.8347 8.01656 2.91378 7.3373 2.23453C6.65805 1.55527 5.73713 1.17312 4.77652 1.17188ZM4.77652 7.0125C4.338 7.0125 3.90933 6.88246 3.54471 6.63884C3.1801 6.39521 2.89591 6.04893 2.7281 5.64379C2.56029 5.23866 2.51638 4.79285 2.60193 4.36276C2.68748 3.93267 2.89865 3.5376 3.20873 3.22752C3.51881 2.91745 3.91387 2.70628 4.34396 2.62073C4.77406 2.53518 5.21986 2.57908 5.625 2.7469C6.03013 2.91471 6.37641 3.19889 6.62004 3.56351C6.86367 3.92812 6.9937 4.35679 6.9937 4.79531C6.99618 5.08805 6.94066 5.37838 6.83034 5.64955C6.72003 5.92072 6.5571 6.16736 6.35097 6.37524C6.14484 6.58311 5.89958 6.74811 5.62935 6.8607C5.35912 6.9733 5.06926 7.03126 4.77652 7.03125V7.0125Z"
                                    fill="#FF3A6E" />
                                <path
                                    d="M4.77652 11.3766C4.05987 11.3766 3.35931 11.5891 2.76344 11.9872C2.16757 12.3854 1.70314 12.9513 1.4289 13.6134C1.15465 14.2755 1.08289 15.004 1.2227 15.7069C1.36251 16.4098 1.70761 17.0554 2.21436 17.5622C2.7211 18.0689 3.36674 18.414 4.06962 18.5538C4.7725 18.6937 5.50105 18.6219 6.16315 18.3476C6.82524 18.0734 7.39115 17.609 7.78929 17.0131C8.18744 16.4172 8.39995 15.7167 8.39995 15C8.39871 14.0394 8.01656 13.1185 7.3373 12.4392C6.65805 11.76 5.73713 11.3778 4.77652 11.3766ZM4.77652 17.2172C4.338 17.2172 3.90933 17.0872 3.54471 16.8435C3.1801 16.5999 2.89591 16.2536 2.7281 15.8485C2.56029 15.4434 2.51638 14.9976 2.60193 14.5675C2.68748 14.1374 2.89865 13.7423 3.20873 13.4322C3.51881 13.1222 3.91387 12.911 4.34396 12.8254C4.77406 12.7399 5.21986 12.7838 5.625 12.9516C6.03013 13.1194 6.37641 13.4036 6.62004 13.7682C6.86367 14.1328 6.9937 14.5615 6.9937 15C6.9937 15.2912 6.93635 15.5795 6.82493 15.8485C6.71351 16.1175 6.55019 16.3619 6.3443 16.5678C6.13842 16.7737 5.894 16.937 5.625 17.0484C5.356 17.1599 5.06768 17.2172 4.77652 17.2172Z"
                                    fill="#FF3A6E" />
                                <path
                                    d="M4.77652 21.5625C4.05987 21.5625 3.35931 21.775 2.76344 22.1732C2.16757 22.5713 1.70314 23.1372 1.4289 23.7993C1.15465 24.4614 1.08289 25.19 1.2227 25.8928C1.36251 26.5957 1.70761 27.2413 2.21436 27.7481C2.7211 28.2548 3.36674 28.5999 4.06962 28.7398C4.7725 28.8796 5.50105 28.8078 6.16315 28.5336C6.82524 28.2593 7.39115 27.7949 7.78929 27.199C8.18744 26.6031 8.39995 25.9026 8.39995 25.1859C8.39871 24.2253 8.01656 23.3044 7.3373 22.6252C6.65805 21.9459 5.73713 21.5637 4.77652 21.5625ZM4.77652 27.4031C4.338 27.4031 3.90933 27.2731 3.54471 27.0295C3.1801 26.7858 2.89591 26.4396 2.7281 26.0344C2.56029 25.6293 2.51638 25.1835 2.60193 24.7534C2.68748 24.3233 2.89865 23.9282 3.20873 23.6181C3.51881 23.3081 3.91387 23.0969 4.34396 23.0114C4.77406 22.9258 5.21986 22.9697 5.625 23.1375C6.03013 23.3053 6.37641 23.5895 6.62004 23.9541C6.86367 24.3187 6.9937 24.7474 6.9937 25.1859C6.99618 25.4787 6.94066 25.769 6.83034 26.0402C6.72003 26.3113 6.5571 26.558 6.35097 26.7659C6.14484 26.9737 5.89958 27.1387 5.62935 27.2513C5.35912 27.3639 5.06926 27.4219 4.77652 27.4219V27.4031Z"
                                    fill="#FF3A6E" />
                                <path
                                    d="M14.0249 6.95623H26.6811C26.9737 6.96985 27.266 6.92399 27.5403 6.82142C27.8146 6.71885 28.0653 6.5617 28.2771 6.35948C28.489 6.15726 28.6576 5.91417 28.7728 5.64491C28.8881 5.37565 28.9475 5.08582 28.9475 4.79294C28.9475 4.50007 28.8881 4.21024 28.7728 3.94098C28.6576 3.67172 28.489 3.42863 28.2771 3.22641C28.0653 3.02419 27.8146 2.86704 27.5403 2.76447C27.266 2.6619 26.9737 2.61604 26.6811 2.62966H14.0249C13.4685 2.65557 12.9436 2.8948 12.5591 3.29765C12.1745 3.70051 11.96 4.23602 11.96 4.79294C11.96 5.34987 12.1745 5.88538 12.5591 6.28824C12.9436 6.69109 13.4685 6.93032 14.0249 6.95623ZM14.0249 4.03591H26.6811C26.7855 4.02769 26.8905 4.04116 26.9895 4.07547C27.0885 4.10979 27.1793 4.16421 27.2562 4.23531C27.3331 4.30641 27.3945 4.39265 27.4365 4.48862C27.4784 4.58458 27.5001 4.6882 27.5001 4.79294C27.5001 4.89769 27.4784 5.0013 27.4365 5.09727C27.3945 5.19324 27.3331 5.27948 27.2562 5.35058C27.1793 5.42168 27.0885 5.4761 26.9895 5.51042C26.8905 5.54473 26.7855 5.5582 26.6811 5.54998H14.0249C13.8344 5.53497 13.6565 5.44871 13.5268 5.3084C13.3971 5.16808 13.3251 4.98402 13.3251 4.79294C13.3251 4.60187 13.3971 4.41781 13.5268 4.27749C13.6565 4.13718 13.8344 4.05091 14.0249 4.03591Z"
                                    fill="#FF3A6E" />
                                <path
                                    d="M26.6812 12.8344H14.025C13.4506 12.8344 12.8998 13.0625 12.4937 13.4686C12.0875 13.8748 11.8594 14.4256 11.8594 15C11.8594 15.5743 12.0875 16.1252 12.4937 16.5313C12.8998 16.9374 13.4506 17.1656 14.025 17.1656H26.6812C27.2556 17.1656 27.8064 16.9374 28.2126 16.5313C28.6187 16.1252 28.8469 15.5743 28.8469 15C28.8469 14.4256 28.6187 13.8748 28.2126 13.4686C27.8064 13.0625 27.2556 12.8344 26.6812 12.8344ZM26.6812 15.7594H14.025C13.8236 15.7594 13.6305 15.6793 13.488 15.5369C13.3456 15.3945 13.2656 15.2014 13.2656 15C13.2656 14.7986 13.3456 14.6054 13.488 14.463C13.6305 14.3206 13.8236 14.2406 14.025 14.2406H26.6812C26.8826 14.2406 27.0758 14.3206 27.2182 14.463C27.3606 14.6054 27.4406 14.7986 27.4406 15C27.4406 15.2014 27.3606 15.3945 27.2182 15.5369C27.0758 15.6793 26.8826 15.7594 26.6812 15.7594Z"
                                    fill="#FF3A6E" />
                                <path
                                    d="M26.6811 23.0391H14.0249C13.4685 23.065 12.9436 23.3042 12.5591 23.7071C12.1745 24.1099 11.96 24.6454 11.96 25.2024C11.96 25.7593 12.1745 26.2948 12.5591 26.6977C12.9436 27.1005 13.4685 27.3397 14.0249 27.3656H26.6811C26.9737 27.3793 27.266 27.3334 27.5403 27.2308C27.8146 27.1283 28.0653 26.9711 28.2771 26.7689C28.489 26.5667 28.6576 26.3236 28.7728 26.0543C28.8881 25.7851 28.9475 25.4952 28.9475 25.2024C28.9475 24.9095 28.8881 24.6197 28.7728 24.3504C28.6576 24.0811 28.489 23.8381 28.2771 23.6358C28.0653 23.4336 27.8146 23.2765 27.5403 23.1739C27.266 23.0713 26.9737 23.0255 26.6811 23.0391ZM26.6811 25.9594H14.0249C13.8344 25.9444 13.6565 25.8581 13.5268 25.7178C13.3971 25.5775 13.3251 25.3934 13.3251 25.2024C13.3251 25.0113 13.3971 24.8272 13.5268 24.6869C13.6565 24.5466 13.8344 24.4603 14.0249 24.4453H26.6811C26.7855 24.4371 26.8905 24.4506 26.9895 24.4849C27.0885 24.5192 27.1793 24.5736 27.2562 24.6447C27.3331 24.7158 27.3945 24.8021 27.4365 24.898C27.4784 24.994 27.5001 25.0976 27.5001 25.2024C27.5001 25.3071 27.4784 25.4107 27.4365 25.5067C27.3945 25.6027 27.3331 25.6889 27.2562 25.76C27.1793 25.8311 27.0885 25.8855 26.9895 25.9198C26.8905 25.9542 26.7855 25.9676 26.6811 25.9594Z"
                                    fill="#FF3A6E" />
                            </svg>
                        </div>
                        <h4 class="mb-0 h3">{{ $categories }}</h4>
                    </div>
                    <div class="card-content">
                        <h3 class="h4 mb-0">{{ __('Total Categories') }}</h3>
                    </div>
                </div>
            </div>
        </div>




        <div class="col-xxl-2 col-lg-3 col-sm-6 col-12">
            <div class="card open-tickets">
                <div class="card-body d-flex flex-column justify-content-between gap-3">
                    <div class="bottom-img">
                        <svg width="128" height="95" viewBox="0 0 128 95" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <rect width="102.001" height="83.0013" rx="6"
                                transform="matrix(0.746641 -0.667026 0.686312 0.725658 -2 110.038)" fill="#FF3A6E"
                                fill-opacity="0.10" />
                            <rect width="75.3406" height="61.3067" rx="6"
                                transform="matrix(0.746641 -0.667026 0.686312 0.725658 88 48.2542)" fill="#FF3A6E"
                                fill-opacity="0.10" />
                        </svg>
                    </div>
                    <div class="card-icon-wrp d-flex flex-wrap justify-content-between gap-2">
                        <div class="card-icon">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M20.0085 14.7976L19.9992 12.4907C19.3131 12.4907 18.7247 12.2456 18.2346 11.7555C17.7444 11.2653 17.4995 10.6771 17.4995 9.99112C17.4994 9.3047 17.7446 8.71676 18.2348 8.22654C18.7251 7.73629 19.3133 7.49132 19.9995 7.49119L19.9993 5.19345C19.999 4.7399 19.8352 4.34937 19.5076 4.02174C19.1798 3.69392 18.7892 3.53017 18.3359 3.53004L1.67359 3.5208C1.22 3.52084 0.829284 3.68488 0.501785 4.01238C0.174028 4.34013 0.0102473 4.73059 0.0101827 5.18421L0.000878345 7.4911C0.687037 7.49122 1.27534 7.73625 1.76549 8.22641C2.25561 8.71653 2.50077 9.30451 2.50064 9.99086C2.50064 10.677 2.25558 11.2652 1.7654 11.7553C1.27521 12.2455 0.687328 12.4905 0.000912231 12.4906L0.000975283 14.8066C0.00100664 15.2601 0.16495 15.6507 0.492739 15.9785C0.82056 16.3063 1.21118 16.4703 1.66448 16.4702L18.3451 16.461C18.7985 16.461 19.1889 16.2971 19.5167 15.9692C19.8445 15.6414 20.0084 15.251 20.0085 14.7976ZM15.6797 14.145L4.32056 14.1448C4.0999 14.1451 3.90695 14.0624 3.74143 13.8968C3.57607 13.7315 3.49331 13.5386 3.49354 13.3178L3.49318 6.66404C3.49331 6.43105 3.57295 6.23508 3.73213 6.0759C3.89144 5.9166 4.0876 5.83677 4.32049 5.83673L15.6797 5.83676C15.9004 5.83683 16.0936 5.91956 16.259 6.08501C16.4243 6.25027 16.507 6.44338 16.507 6.66407L16.5069 13.3178C16.507 13.5509 16.4273 13.7469 16.268 13.9062C16.1087 14.0653 15.9128 14.145 15.6797 14.145Z"
                                    fill="white" />
                                <path d="M15.2567 7.08726L15.2569 12.8956H4.74315L4.74315 7.08742L15.2567 7.08726Z"
                                    fill="white" />
                            </svg>

                        </div>
                        <h4 class="mb-0 h3">{{ $open_ticket }}</h4>
                    </div>
                    <div class="card-content">
                        <h3 class="h4 mb-0">{{ __('open tickets') }}</h3>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xxl-2 col-lg-3 col-sm-6 col-12">
            <div class="card close-tickets">
                <div class="card-body d-flex flex-column justify-content-between gap-3">
                    <div class="bottom-img">
                        <svg width="128" height="95" viewBox="0 0 128 95" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <rect width="102.001" height="83.0013" rx="6"
                                transform="matrix(0.746641 -0.667026 0.686312 0.725658 -2 110.038)" fill="#FF3A6E"
                                fill-opacity="0.10" />
                            <rect width="75.3406" height="61.3067" rx="6"
                                transform="matrix(0.746641 -0.667026 0.686312 0.725658 88 48.2542)" fill="#FF3A6E"
                                fill-opacity="0.10" />
                        </svg>
                    </div>
                    <div class="card-icon-wrp d-flex flex-wrap justify-content-between gap-2">
                        <div class="card-icon">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M19.1668 10.8333C19.3752 10.8333 19.5836 10.6249 19.5836 10.4165V7.9165C19.5836 7.2081 19.042 6.6665 18.3336 6.6665H15V18.3333H18.3332C19.0416 18.3333 19.5832 17.7917 19.5832 17.0833V14.5833C19.583 14.4728 19.539 14.367 19.4609 14.2888C19.3827 14.2107 19.2769 14.1667 19.1664 14.1665C18.7288 14.1597 18.3115 13.9811 18.0045 13.6694C17.6975 13.3575 17.5254 12.9375 17.5254 12.4999C17.5254 12.0623 17.6975 11.6423 18.0045 11.3305C18.3115 11.0186 18.7293 10.84 19.1668 10.8333Z"
                                fill="white" />
                            <path
                                d="M18.8745 5.41684C19.0829 5.33364 19.2077 5.08364 19.1245 4.87524L18.2909 2.50004C18.0825 1.83324 17.3309 1.50004 16.7077 1.70844L4.87451 5.79164H18.2078C18.4053 5.62718 18.6313 5.50017 18.8745 5.41684Z"
                                fill="white" />
                            <path
                                d="M0.416504 7.91699V10.417C0.416504 10.667 0.583304 10.8338 0.833304 10.8338C1.05434 10.8304 1.27385 10.871 1.47905 10.9532C1.68425 11.0354 1.87105 11.1576 2.02856 11.3127C2.18609 11.4678 2.31118 11.6527 2.39656 11.8565C2.48195 12.0605 2.52592 12.2794 2.52592 12.5004C2.52592 12.7215 2.48195 12.9403 2.39656 13.1442C2.31118 13.3481 2.18609 13.533 2.02856 13.6881C1.87105 13.8432 1.68425 13.9654 1.47905 14.0476C1.27385 14.1299 1.05434 14.1705 0.833304 14.167C0.583304 14.167 0.416504 14.3338 0.416504 14.5838V17.0838C0.416504 17.7922 0.958104 18.3338 1.6665 18.3338H14.1665V6.66699H1.6665C0.959704 6.66699 0.416504 7.20859 0.416504 7.91699ZM5.4165 10.0002H7.9165C8.1665 10.0002 8.33334 10.167 8.33334 10.417C8.33334 10.667 8.1665 10.8338 7.9165 10.8338H5.4165C5.1665 10.8338 4.9997 10.667 4.9997 10.417C4.9997 10.167 5.1665 10.0002 5.4165 10.0002ZM5.4165 12.0834H10.8329C11.0829 12.0834 11.2497 12.2502 11.2497 12.5002C11.2497 12.7502 11.0829 12.917 10.8329 12.917H5.4165C5.1665 12.917 4.9997 12.7502 4.9997 12.5002C4.9997 12.2502 5.1665 12.0834 5.4165 12.0834ZM5.4165 14.1666H10.8329C11.0829 14.1666 11.2497 14.3334 11.2497 14.5834C11.2497 14.8334 11.0829 15.0002 10.8329 15.0002H5.4165C5.1665 15.0002 4.9997 14.8334 4.9997 14.5834C4.9997 14.3334 5.1665 14.1666 5.4165 14.1666Z"
                                fill="white" />
                            <rect x="4.1665" y="9.16675" width="7.5" height="6.66667" fill="white" />
                            <g clip-path="url(#clip0_1363_47)">
                                <path class="theme-color"
                                    d="M8.88419 12.5003L10.7536 10.6308C10.805 10.5794 10.8334 10.5107 10.8335 10.4375C10.8335 10.3642 10.8051 10.2955 10.7536 10.2441L10.5898 10.0803C10.5383 10.0287 10.4696 10.0005 10.3963 10.0005C10.3232 10.0005 10.2545 10.0287 10.203 10.0803L8.33358 11.9497L6.46407 10.0803C6.41264 10.0287 6.34394 10.0005 6.27069 10.0005C6.19752 10.0005 6.12882 10.0287 6.0774 10.0803L5.9135 10.2441C5.80683 10.3508 5.80683 10.5243 5.9135 10.6308L7.78297 12.5003L5.9135 14.3698C5.86203 14.4213 5.8337 14.49 5.8337 14.5632C5.8337 14.6364 5.86203 14.705 5.9135 14.7565L6.07736 14.9203C6.12878 14.9719 6.19752 15.0002 6.27065 15.0002C6.3439 15.0002 6.4126 14.9719 6.46402 14.9203L8.33354 13.0509L10.203 14.9203C10.2545 14.9719 10.3231 15.0002 10.3963 15.0002H10.3964C10.4696 15.0002 10.5383 14.9719 10.5898 14.9203L10.7536 14.7565C10.805 14.7051 10.8334 14.6364 10.8334 14.5632C10.8334 14.49 10.805 14.4213 10.7536 14.3698L8.88419 12.5003Z"
                                    fill="#EF9F44" />
                            </g>
                            <defs>
                                <clipPath id="clip0_1363_47">
                                    <rect width="5" height="5" fill="white" transform="translate(5.8335 10)" />
                                </clipPath>
                            </defs>
                        </svg>

                        </div>
                        <h4 class="mb-0 h3">{{ $close_ticket }}</h4>
                    </div>
                    <div class="card-content">
                        <h3 class="h4 mb-0">{{ __('close tickets') }}</h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-2 col-lg-3 col-sm-6 col-12">
            <div class="card total-agents">
                <div class="card-body d-flex flex-column justify-content-between gap-3">
                    <div class="bottom-img">
                        <svg width="128" height="95" viewBox="0 0 128 95" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <rect width="102.001" height="83.0013" rx="6"
                                transform="matrix(0.746641 -0.667026 0.686312 0.725658 -2 110.038)" fill="#FF3A6E"
                                fill-opacity="0.10" />
                            <rect width="75.3406" height="61.3067" rx="6"
                                transform="matrix(0.746641 -0.667026 0.686312 0.725658 88 48.2542)" fill="#FF3A6E"
                                fill-opacity="0.10" />
                        </svg>
                    </div>
                    <div class="card-icon-wrp d-flex flex-wrap justify-content-between gap-2">

                        <div class="card-icon">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_1364_78)">
                                    <path
                                        d="M10.4976 9C12.9828 9 14.9976 6.98528 14.9976 4.5C14.9976 2.01472 12.9828 0 10.4976 0C8.01228 0 5.99756 2.01472 5.99756 4.5C5.99756 6.98528 8.01228 9 10.4976 9Z"
                                        fill="white" />
                                    <path d="M10.3642 13H9.63089L8.99756 20H10.9976L10.3642 13Z" fill="white" />
                                    <path
                                        d="M7.87083 10.6294V10C6.51868 10.2613 5.28408 10.8998 4.33136 11.8305C3.37863 12.7611 2.75296 13.9399 2.53764 15.2098L2.01183 18.1119C1.98034 18.3435 2.00109 18.5786 2.07275 18.8023C2.14441 19.026 2.26539 19.2333 2.42798 19.411C2.59057 19.5887 2.79119 19.7328 3.01701 19.8342C3.24283 19.9357 3.4889 19.9921 3.73948 20H8.28396L8.99756 12.6224C8.64744 12.4028 8.36126 12.1058 8.16464 11.758C7.96801 11.4101 7.86706 11.0224 7.87083 10.6294Z"
                                        fill="white" />
                                    <path
                                        d="M8.99756 10.6774C9.00376 11.0256 9.1111 11.3573 9.29731 11.6036C9.48352 11.8498 9.73429 11.9918 9.99756 12C10.2608 11.9918 10.5116 11.8498 10.6978 11.6036C10.884 11.3573 10.9914 11.0256 10.9976 10.6774V10H8.99756V10.6774Z"
                                        fill="white" />
                                    <path
                                        d="M17.9514 18.0351L17.2748 14.9474C17.014 13.749 16.3901 12.6458 15.4772 11.7688C14.5643 10.8918 13.4009 10.2779 12.1252 10V10.5965C12.129 10.9909 12.028 11.38 11.8312 11.729C11.6344 12.0781 11.348 12.3761 10.9976 12.5965L11.7117 20H16.26C16.519 20.0015 16.775 19.9487 17.0093 19.8455C17.2435 19.7422 17.4498 19.5912 17.6131 19.4035C17.7788 19.2152 17.8956 18.9937 17.9542 18.7563C18.0129 18.5189 18.012 18.2721 17.9514 18.0351Z"
                                        fill="white" />
                                </g>
                                <defs>
                                    <clipPath id="clip0_1364_78">
                                        <rect width="20" height="20" fill="white" />
                                    </clipPath>
                                </defs>
                            </svg>

                        </div>
                        <h4 class="mb-0 h3">{{ $agents }}</h4>
                    </div>
                    <div class="card-content">
                        <h3 class="h4 mb-0">{{ __('Total agents') }}</h3>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

    <div class="row">
        <div class="col-xxl-4 col-md-6 d-flex">
            <div class="card w-100">
                <div class="card-header">
                    <h5>{{ __('Tickets by Category') }}</h5>
                </div>
                <div class="card-body">
                    <div id="categoryPie" class="h-100 d-flex align-items-center"></div>
                </div>
            </div>
        </div>

        <div class="col-xxl-4 col-md-6 d-flex">
            <div class="card w-100">
                <div class="card-header">
                    <h5>{{ __('Tickets by Status') }}</h5>
                </div>
                <div class="card-body">
                    <div id="statusPie" class="h-100 d-flex align-items-center justify-content-center"></div>
                </div>
            </div>
        </div>

        <div class="col-xxl-4 d-flex">
            <div class="card w-100">
                <div class="card-header">
                    <h5>{{ __('Tickets by Priority') }}</h5>
                </div>
                <div class="card-body">
                    <div id="priorityPie" class="h-100 d-flex align-items-center"></div>
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5>{{ __('Agent Wise Tickets') }}</h5>
                </div>
                <div class="card-body">
                    <div id="agentWiseTicketChart"></div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5>{{ __('This Year Tickets') }}</h5>
                </div>
                <div class="card-body">
                    <div id="chartBar"></div>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('scripts')
    <script src="{{ asset('assets/js/plugins/apexcharts.min.js') }}"></script>
    <script>
        $('.cp_link').on('click', function() {
            var value = $(this).attr('data-link');
            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val(value).select();
            document.execCommand("copy");
            $temp.remove();
            show_toastr('Success', '{{ __('Link Copy on Clipboard') }}', 'success')
            window.open(value, '_blank');

        });
    </script>

    <script>
        (function() {
            var chartBarOptions = {
                series: [{
                    name: '{{ __('Tickets') }}',
                    data: {!! json_encode(array_values($monthData)) !!}
                }, ],

                chart: {
                    height: 300,
                    type: 'area',
                    // type: 'line',
                    dropShadow: {
                        enabled: true,
                        color: '#000',
                        top: 18,
                        left: 7,
                        blur: 10,
                        opacity: 0.2
                    },
                    toolbar: {
                        show: false
                    }
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    width: 2,
                    curve: 'smooth'
                },
                title: {
                    text: '',
                    align: 'left'
                },
                xaxis: {
                    categories: {!! json_encode(array_keys($monthData)) !!},
                    title: {
                        text: '{{ __('Months') }}'
                    }
                },
                colors: ['#EF9F44', '#FF3A6E'],

                grid: {
                    strokeDashArray: 4,
                },
                legend: {
                    show: false,
                },
                markers: {
                    size: 4,
                    colors: ['#EF9F44', '#FF3A6E'],
                    opacity: 0.9,
                    strokeWidth: 2,
                    hover: {
                        size: 7,
                    }
                },
                yaxis: {
                    title: {
                        text: '{{ __('Tickets') }}'
                    },
                    tickAmount: 3,
                }
            };
            var arChart = new ApexCharts(document.querySelector("#chartBar"), chartBarOptions);
            arChart.render();
        })();

        (function() {
            var options = {
                series: {!! json_encode($chartData['value']) !!},
                colors: {!! json_encode($chartData['color']) !!},
                chart: {
                    type: 'radialBar',
                },
                plotOptions: {
                    radialBar: {
                        dataLabels: {
                            name: {
                                fontSize: '22px',
                            },
                            value: {
                                fontSize: '16px',
                            },
                            total: {
                                show: true,
                                label: 'Total',
                                formatter: function(w) {
                                    var totalSum = w.globals.initialSeries.reduce(function(acc, value) {
                                        return acc + value;
                                    }, 0);
                                    return totalSum
                                }
                            }
                        }
                    }
                },
                labels: {!! json_encode($chartData['name']) !!},
                responsive: [
            {
                breakpoint: 420,
                options: {
                    chart: {
                        height: 250
                    }
                }
            },
        ]
            };

            var chart = new ApexCharts(document.querySelector("#categoryPie"), options);
            chart.render();

        })();

        // Tickets by Status chart

        var options = {
    series: {!! json_encode($statusData['value']) !!},
    chart: {
        type: 'pie',
        width: 380 // Default width for large screens
    },
    labels: {!! json_encode($statusData['name']) !!},
    legend: {
        position: 'right',
        fontSize: '14px'
    },
    responsive: [
        {
            breakpoint: 1024,
            options: {
                chart: {
                    width: 320
                },
                legend: {
                    position: 'bottom',
                    fontSize: '13px'
                }
            }
        },
        {
            breakpoint: 768,
            options: {
                chart: {
                    width: 300
                },
                legend: {
                    position: 'bottom',
                    fontSize: '12px'
                }
            }
        },
        {
            breakpoint: 480,
            options: {
                chart: {
                    width: 280 // Better visibility on 320px wide screens
                },
                legend: {
                    position: 'bottom',
                    fontSize: '11px'
                }
            }
        }
    ]
};

var chart = new ApexCharts(document.querySelector("#statusPie"), options);
chart.render();


        (function() {
            var priorityPieOptions = {
                chart: {
                    height: 200,
                    type: 'donut',
                },
                dataLabels: {
                    enabled: false,
                },
                plotOptions: {
                    pie: {
                        donut: {
                            size: '70%',
                        }
                    }
                },
                series: {!! json_encode($priorityData['value']) !!},
                labels: {!! json_encode($priorityData['name']) !!},
                // colors: ['#FF5733', '#FFC300', '#DAF7A6', '#C70039'],
                legend: {
                    show: true
                }
            };
            var priorityPieChart = new ApexCharts(document.querySelector("#priorityPie"), priorityPieOptions);
            priorityPieChart.render();
        })();

        // Agent Wise Ticket Chart
        var options = {
            series: [{
                name: 'Total Number Of Tickets',
                data: {!! json_encode($totalTicketAgentWise['ticket_counts']) !!}
            }],
            annotations: {
                points: [{
                    x: 'Bananas',
                    seriesIndex: 0,
                    label: {
                        borderColor: '#775DD0',
                        offsetY: 0,
                        style: {
                            color: '#fff',
                            background: '#775DD0',
                        },
                        text: 'Bananas are good',
                    }
                }]
            },
            chart: {
                height: 350,
                type: 'bar',
                toolbar: {
                    show: false
                }
            },
            plotOptions: {
                bar: {
                    borderRadius: 10,
                    columnWidth: '20%',
                }
            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                width: 0
            },
            grid: {
                row: {
                    colors: ['#fff', '#f2f2f2']
                }
            },
            xaxis: {
                title: {
                    text: 'Agents',
                },
                labels: {
                    rotate: -45
                },
                categories: {!! json_encode($totalTicketAgentWise['agent_names']) !!},
                tickPlacement: 'on'
            },
            yaxis: {
                title: {
                    text: 'Total Number Of Tickets',
                },
            },
            fill: {
                type: 'gradient',
                gradient: {
                    shade: 'light',
                    type: "horizontal",
                    shadeIntensity: 0.25,
                    gradientToColors: undefined,
                    inverseColors: true,
                    opacityFrom: 0.85,
                    opacityTo: 0.85,
                    stops: [50, 0, 100]
                },
            }
        };

        var chart = new ApexCharts(document.querySelector("#agentWiseTicketChart"), options);
        chart.render();
    </script>
@endpush
