<?php

namespace Workdo\Mail2Ticket\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Workdo\Mail2Ticket\Entities\ImapSetting;
use Workdo\Mail2Ticket\Services\ImapService;

class FetchEmailsCommand extends Command
{
    protected $signature = 'mail2ticket:fetch-emails';
    protected $description = 'Fetch unread emails from configured IMAP account';

    public function handle()
    {
        try {           
            // Get email settings
            $settings = ImapSetting::pluck('value', 'name')->toArray();            
            $imapService = new ImapService($settings);
            $emails = $imapService->fetchUnreadEmails($settings);
            $this->info('Successfully fetched ' . count($emails) . ' emails');
            return 0;
        } catch (\Exception $e) {
            Log::info('Error fetching emails: ' . $e->getMessage());
            return 1;
        }
    }
} 