<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('mail2_tickets')) {
            Schema::create('mail2_tickets', function (Blueprint $table) {
                $table->id();
                $table->string('from')->nullable();
                $table->string('subject')->nullable();
                $table->longText('body')->nullable();
                $table->timestamp('received_at')->nullable();
                $table->string('message_id')->nullable();
                $table->string('created_by')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mail2_tickets');
    }
};
