<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('imap_settings')) {
            Schema::create('imap_settings', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('name');
                $table->longText('value');
                $table->integer('created_by');
                $table->timestamps();
                $table->unique(['name', 'created_by']);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('imap_settings');
    }
};
