<?php

namespace Workdo\Mail2Ticket\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Session;
use League\OAuth2\Client\Provider\GenericProvider;
use Workdo\Mail2Ticket\Entities\ImapSetting;

class Mail2TicketAuthController extends Controller
{
    public function redirect()
    {
        $settings = ImapSetting::where('created_by', creatorId())->pluck('value', 'name')->toArray();

        $provider = new GenericProvider([
            'clientId' => isset($settings['outlook_client_id']) ? $settings['outlook_client_id'] : '',
            'clientSecret' => isset($settings['outlook_client_secret']) ? $settings['outlook_client_id'] : '',
            'redirectUri' => env('APP_URL') . 'outlook/webhook',
            'urlAuthorize' => 'https://login.microsoftonline.com/consumers/oauth2/v2.0/authorize',
            'urlAccessToken' => 'https://login.microsoftonline.com/consumers/oauth2/v2.0/token',
            'urlResourceOwnerDetails' => '',
            'scopes' => 'https://outlook.office.com/IMAP.AccessAsUser.All offline_access',
        ]);
        $authUrl = $provider->getAuthorizationUrl();
        session(['oauth2state' => $provider->getState()]);
        return redirect($authUrl);
    }

    public function callback(Request $request)
    {
        $settings = ImapSetting::where('created_by', creatorId())->pluck('value', 'name')->toArray();


        $provider = new GenericProvider([
            'clientId' => isset($settings['outlook_client_id']) ? $settings['outlook_client_id'] : '',
            'clientSecret' => isset($settings['outlook_client_secret']) ? $settings['outlook_client_secret'] : '',
            'redirectUri' => env('APP_URL') . 'outlook/webhook',
            'urlAuthorize' => 'https://login.microsoftonline.com/consumers/oauth2/v2.0/authorize',
            'urlAccessToken' => 'https://login.microsoftonline.com/consumers/oauth2/v2.0/token',
            'urlResourceOwnerDetails' => '',
            'scopes' => 'https://outlook.office.com/IMAP.AccessAsUser.All offline_access',
        ]);


        if ($request->input('state') !== session('oauth2state')) {
            return redirect()->route('mail2ticket.imap.index')->with('error', 'Invalid state parameter.');
        }

        if ($request->has('error') && $request->input('error') === 'access_denied') {
            return redirect()->route('mail2ticket.imap.index')->with('error', 'Synchronization Canceled.');
        }



        try {
            $token = $provider->getAccessToken('authorization_code', ['code' => $request->input('code')]);
            \Log::info('Token Response: ' . json_encode($token->jsonSerialize()));
        } catch (\Exception $e) {
            \Log::error('Error exchanging code for token: ' . $e->getMessage());
            return response("Error exchanging code for token: " . $e->getMessage(), 400);
        }

        $accessToken = $token->getToken();
        $refreshToken = $token->getRefreshToken();
        $expiresAtTimestamp = $token->getExpires();
        $expiresAt = date('Y-m-d H:i:s', $expiresAtTimestamp);
        $data = [
            'outlook_access_token' => $accessToken,
            'outlook_refresh_token' => $refreshToken,
            'outlook_expires_at' => $expiresAt,
        ];

        foreach ($data as $key => $value) {
            ImapSetting::updateOrInsert(
                ['name' => $key],
                [
                    'value' => $value,
                    'created_by' => creatorId(),
                ]
            );
        }

        return redirect()->route('mail2ticket.imap.index')->with('success', 'Outlook Authentication complete.');
    }
}
