<?php

namespace Workdo\Mail2Ticket\Http\Controllers;

use App\Models\Settings;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Validator;
use Workdo\Mail2Ticket\Entities\ImapSetting;

class Mail2TicketController extends Controller
{
    public function index()
    {
        if (Auth::user()->isAbleTo('imap-setting manage')) {
            $settings = ImapSetting::where('created_by', creatorId())->pluck('value', 'name')->toArray();

            return view('mail2ticket::imap.index', compact('settings'));
        } else {
            return redirect()->back()->with('error', __('Permission Denied'));
        }
    }
    public function storeGmail(Request $request)
    {
        if (Auth::user()->isAbleTo('imap-setting create')) {            
            $validator = Validator::make($request->all(), [
                'imap_email_address' => 'required|string|max:50',
                'imap_email_password' => 'required|string|max:50',
                'imap_mail_port' => 'required|string|max:50',
                'imap_mail_driver' => 'required|string|max:50',
                'imap_mail_encryption' => 'required|string|max:50',
                'imap_mail_host' => 'required|string|max:50',
            ]);

            if ($validator->fails()) {
                $messages = $validator->getMessageBag();    
                return redirect()->back()->with('error', $messages->first());
            }

            $post = $request->all();
            unset($post['_token']);
            ImapSetting::where('created_by', creatorId())->delete();

            foreach ($post as $key => $value) {
                ImapSetting::updateOrInsert(
                    ['name' => $key], 
                    [
                        'value' => $value,
                        'created_by' => creatorId(),
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s')
                    ]
                );
            }
            if(Cache::get('imap_connection_config')){
                Cache::flush('imap_connection_config');
            }         

            return redirect()->back()->with('success', __('IMAP setting saved successfully.'));
        } else {
            return redirect()->back()->with('error', __('Permission Denied'));
        }
    } 
    public function storeOutlook(Request $request)
    {
        if (Auth::user()->isAbleTo('imap-setting create')) {            
            $validator = Validator::make($request->all(), [
                'outlook_client_id' => 'required',
                'outlook_client_secret' => 'required',               
            ]);

            if ($validator->fails()) {
                $messages = $validator->getMessageBag();
                return redirect()->back()->with('error', $messages->first());
            }

            $post = $request->all();
            unset($post['_token']);
            ImapSetting::where('created_by', creatorId())->delete();

            foreach ($post as $key => $value) {
                ImapSetting::updateOrInsert(
                    ['name' => $key], 
                    [
                        'value' => $value,
                        'created_by' => creatorId(),
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s')
                    ]
                );
            }
            if(Cache::get('imap_connection_config')){
                Cache::flush('imap_connection_config');
            }         

            return redirect()->back()->with('success', __('IMAP setting saved successfully.'));
        } else {
            return redirect()->back()->with('error', __('Permission Denied'));
        }
    }
    public function storeOutlookSync(Request $request)
    {
        if (Auth::user()->isAbleTo('imap-setting create')) {            
            $validator = Validator::make($request->all(), [
                'outlook_imap_email_address' => 'required|string|max:50',
                'outlook_imap_email_password' => 'required',
                'outlook_imap_mail_port' => 'required|string|max:50',
                'outlook_imap_mail_driver' => 'required|string|max:50',
                'outlook_imap_mail_encryption' => 'required|string|max:50',
                'outlook_imap_mail_host' => 'required|string|max:50',
                'outlook_imap_mail_authentication' => 'required|string|max:50',
            ]);

            if ($validator->fails()) {
                $messages = $validator->getMessageBag();
                return redirect()->back()->with('error', $messages->first());
            }

            $post = $request->all();
            unset($post['_token']);
            

            foreach ($post as $key => $value) {
                ImapSetting::updateOrInsert(
                    ['name' => $key], 
                    [
                        'value' => $value,
                        'created_by' => creatorId(),
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s')
                    ]
                );
            }
            if(Cache::get('imap_connection_config')){
                Cache::flush('imap_connection_config');
            }         

            return redirect()->back()->with('success', __('Outlook IMAP setting saved successfully.'));
        } else {
            return redirect()->back()->with('error', __('Permission Denied'));
        }
    } 
}
