<?php

namespace Workdo\Mail2Ticket\Listeners;

use App\Models\Ticket;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Workdo\Mail2Ticket\Entities\Mail2Ticket;
use Workdo\TicketNumber\Entities\TicketNumber;

class TicketReplyLis
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    public function handle($event)
    {
        if (moduleIsActive('Mail2Ticket')) {
            $conversion = $event->conversion;
            $request    = $event->request->all();
            $ticket = Ticket::find($conversion->ticket_id);
            if (isset($ticket->type) && $ticket->type == 'Mail') {
                $subject = $ticket->subject;
                $ticketNumber = moduleIsActive('TicketNumber') ? TicketNumber::ticketNumberFormat($ticket->id) : $ticket->ticket_id;

                $uArr = [
                    'ticket_name' => $ticket->name,
                    'ticket_id' => $ticketNumber,
                    'originalTicketId' => $ticket->id,
                    'subject' => $subject,
                    'ticket_description' => $request['reply_description'] ?? ''
                ];
                Mail2Ticket::sendIMAPTicketEmail('Reply Mail To Customer', $ticket, $uArr);
            }
        }
    }
}
