<?php

namespace Workdo\Mail2Ticket\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class Mail2TicketTemplate extends Mailable
{
    use Queueable, SerializesModels;

    public $content;
    public $subjectLine;
    public $settings;
    public $user_id;

    public function __construct($content, $settings, $subjectLine, $user_id)
    {
        $this->content = $content;
        $this->subjectLine = $subjectLine;
        $this->settings = $settings;
        $this->user_id = $user_id;
    }

    public function build()
    {
        
        return $this->from(company_setting('mail_from_address',$this->user_id))->markdown('mail2ticket::email.common_email_template')->subject($this->subjectLine)->with(
            [
                'reply_content' => $this->content->content,
                'mail_header' => (!empty($this->settings['company_name'])) ? $this->settings['company_name'] : env('APP_NAME'),
            ]
        );                
            
    }
}
