<?php

namespace Workdo\Mail2Ticket\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as Provider;
use App\Events\CompanyMenuEvent;
use App\Events\TicketReply;
use Workdo\Mail2Ticket\Listeners\CompanyMenuListener;
use Workdo\Mail2Ticket\Listeners\TicketReplyLis;

class EventServiceProvider extends Provider
{
    /**
     * Determine if events and listeners should be automatically discovered.
     *
     * @return bool
     */
    protected $listen = [
        CompanyMenuEvent::class => [
            CompanyMenuListener::class,
        ],
        TicketReply::class => [
            TicketReplyLis::class,
        ]      
    ];

    /**
     * Get the listener directories that should be used to discover events.
     *
     * @return array
     */
    protected function discoverEventsWithin()
    {
        return [
            __DIR__ . '/../Listeners',
        ];
    }
}
