<?php

namespace Workdo\Mail2Ticket\Providers;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Support\ServiceProvider;
use Workdo\Mail2Ticket\Console\Commands\FetchEmailsCommand;
use Workdo\Mail2Ticket\Providers\EventServiceProvider;
use Workdo\Mail2Ticket\Providers\RouteServiceProvider;

class Mail2TicketServiceProvider extends ServiceProvider
{

    protected $moduleName = 'Mail2Ticket';
    protected $moduleNameLower = 'mail2ticket';

    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
        $this->app->register(EventServiceProvider::class);
        $this->commands([ FetchEmailsCommand::class]);
    }

    public function boot()
    {
        $this->loadRoutesFrom(__DIR__ . '/../Routes/web.php');
        $this->loadViewsFrom(__DIR__ . '/../Resources/views', 'mail2ticket');
        $this->loadMigrationsFrom(__DIR__ . '/../Database/Migrations');
        $this->registerTranslations();       
        $this->app->booted(function(){
            $schedule = $this->app->make(Schedule::class);
            $schedule->command('mail2ticket:fetch-emails')->everyTwoMinutes()->withoutOverlapping();
        });
    }

    /**
     * Register translations.
     *
     * @return void
     */
    public function registerTranslations()
    {
        $langPath = resource_path('lang/modules/' . $this->moduleNameLower);

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, $this->moduleNameLower);
            $this->loadJsonTranslationsFrom($langPath);
        } else {
            $this->loadTranslationsFrom(__DIR__.'/../Resources/lang', $this->moduleNameLower);
            $this->loadJsonTranslationsFrom(__DIR__.'/../Resources/lang');
        }
    }
}