@extends('layouts.admin')

@section('page-title')
    {{ __('Manage IMAP Setting') }}
@endsection
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a></li>
    <li class="breadcrumb-item">{{ __('IMAP Setting') }}</li>
@endsection
@push('css-page')
    <link rel="stylesheet" href="{{ asset('packages/workdo/Mail2Ticket/src/Resources/assets/custom.css') }}">
@endpush
@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header p-3">
                    <h5 class="mb-1">{{ __('IMAP Setting') }}</h5>
                    <small>{{ __('To automate the retrieval of new emails, you need to set up a cron job on your server. (Command: * * * * * /usr/bin/php /home/username/public_html/artisan schedule:run >> /dev/null 2>&1)') }}</small>
                </div>
                {{-- Mail Type Selector --}}
                <div class="card-body pb-0">
                    <div class="d-flex align-items-start justify-content-between">
                        <div class="d-flex flex-column">
                            <label class="form-label">{{ __('Select Mail Type') }} <x-required /></label>
                            <div class="d-flex gap-3 mail-type-selector">
                                <div>
                                    <input type="radio" id="gmail" name="mail_type" value="gmail"
                                        {{ ($settings['mail_type'] ?? '') == 'gmail' ? 'checked' : 'checked' }}>
                                    <label for="gmail">{{ __('Gmail') }}</label>
                                </div>
                                <div>
                                    <input type="radio" id="outlook" name="mail_type" value="outlook"
                                        {{ ($settings['mail_type'] ?? '') == 'outlook' ? 'checked' : '' }}>
                                    <label for="outlook">{{ __('Outlook') }}</label>
                                </div>
                            </div>
                        </div>
                        @if (!empty($settings['outlook_client_id']) && !empty($settings['outlook_client_secret']))
                            <a href="{{ route('outlook.sync') }}">
                                <div class="btn btn-sm btn-primary btn-icon" data-bs-toggle="tooltip"
                                    data-bs-placement="top" title="{{ __('Sync') }}">
                                    <i class="fas fa-sync-alt text-white"></i>
                                </div>
                            </a>
                        @endif
                    </div>
                </div>

                {{-- Gmail Form --}}
                <form id="gmail-form" action="{{ route('mail2ticket.imap.gmail') }}" method="POST">
                    @csrf
                    <input type="hidden" name="mail_type" value="gmail">
                    <div class="card-body">
                        <div class="row">
                            {{-- Gmail fields same as before --}}
                            {{-- Example: --}}
                            <div class="col-md-4 mb-3">
                                <label class="form-label">{{ __('IMAP Mail Driver') }} <x-required /></label>
                                <input type="text" class="form-control" name="imap_mail_driver"
                                    value="{{ $settings['imap_mail_driver'] ?? '' }}"
                                    placeholder="{{ __('IMAP Mail Driver') }}">
                                @error('imap_mail_driver')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label class="form-label">{{ __('IMAP Mail Host') }} <x-required /></label>
                                <input class="form-control" placeholder="{{ __('IMAP Mail Host') }}" name="imap_mail_host"
                                    type="text" value="{{ $settings['imap_mail_host'] ?? '' }}">
                                @error('imap_mail_host')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label class="form-label">{{ __('IMAP Mail Port') }} <x-required /></label>
                                <input type="text" class="form-control" name="imap_mail_port"
                                    value="{{ $settings['imap_mail_port'] ?? '' }}"
                                    placeholder="{{ __('IMAP Mail Port') }}">
                                @error('imap_mail_port')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label class="form-label">{{ __('IMAP Mail Username') }} <x-required /></label>
                                <input type="email" class="form-control" name="imap_email_address"
                                    value="{{ $settings['imap_email_address'] ?? '' }}"
                                    placeholder="{{ __('Enter IMAP Mail Username') }}">
                                @error('imap_email_address')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label class="form-label">{{ __('IMAP Mail Password') }} <x-required /></label>
                                <input type="text" class="form-control" name="imap_email_password"
                                    value="{{ $settings['imap_email_password'] ?? '' }}"
                                    placeholder="{{ __('Enter IMAP Mail Password') }}">
                                @error('imap_email_password')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label class="form-label">{{ __('IMAP Mail Encryption') }} <x-required /></label>
                                <input type="text" class="form-control" name="imap_mail_encryption"
                                    value="{{ $settings['imap_mail_encryption'] ?? '' }}"
                                    placeholder="{{ __('IMAP Mail Encryption') }}">
                                @error('imap_mail_encryption')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                    </div>
                    <div class="card-footer">
                        <div class="text-end">
                            <button type="submit" class="btn btn-primary">{{ __('Save Changes') }}</button>
                        </div>
                    </div>
                </form>

                {{-- Outlook Form --}}

                <form id="outlook-form" action="{{ route('mail2ticket.imap.outlook') }}" method="POST"
                    style="display: none;">
                    @csrf
                    <input type="hidden" name="mail_type" value="outlook">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Outlook Client ID') }} <x-required /></label>
                                <input type="text" class="form-control" name="outlook_client_id"
                                    value="{{ $settings['outlook_client_id'] ?? '' }}"
                                    placeholder="{{ __('Enter Client ID') }}">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Outlook Client Secret') }} <x-required /></label>
                                <input type="text" class="form-control" name="outlook_client_secret"
                                    value="{{ $settings['outlook_client_secret'] ?? '' }}"
                                    placeholder="{{ __('Enter Client Secret') }}">
                            </div>
                            <div class="form-group mb-0">
                                <label class="form-label">{{ __('Webhook') }}</label><x-required></x-required>
                                <div class="input-group gap-2">
                                    <input class="form-control rounded-1" placeholder="{{ __('Access Token') }}"
                                        name="outlook_webhook_url" type="text" value="{{ route('outlook.webhook') }}"
                                        id="webhookInput" readonly>
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-primary" type="button"
                                            onclick="copyWebhookLink()" id="outlook_webhook"><i class="far fa-copy"></i>
                                            {{ __('Copy Link') }}</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="card-footer">
                        <div class="text-end">
                            <button type="submit" class="btn btn-primary">{{ __('Save Changes') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @if (isset($settings['outlook_access_token'], $settings['outlook_refresh_token'], $settings['outlook_expires_at']))
        <div class="row" id="outlookSynForm">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header p-3">
                        <h5 class="mb-1">{{ __('Outlook IMAP Setting') }}</h5>
                    </div>
                    <form id="outlook-form-sync" action="{{ route('mail2ticket.imap.outlook.sync') }}" method="POST">
                        @csrf
                        <input type="hidden" name="mail_type" value="outlook">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">{{ __('IMAP Mail Driver') }} <x-required /></label>
                                    <input type="text" class="form-control" name="outlook_imap_mail_driver"
                                        value="{{ $settings['outlook_imap_mail_driver'] ?? '' }}"
                                        placeholder="{{ __('IMAP Mail Driver') }}">
                                    @error('outlook_imap_mail_driver')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label">{{ __('IMAP Mail Host') }} <x-required /></label>
                                    <input class="form-control" placeholder="{{ __('IMAP Mail Host') }}"
                                        name="outlook_imap_mail_host" type="text"
                                        value="{{ $settings['outlook_imap_mail_host'] ?? '' }}">
                                    @error('outlook_imap_mail_host')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label">{{ __('IMAP Mail Port') }} <x-required /></label>
                                    <input type="text" class="form-control" name="outlook_imap_mail_port"
                                        value="{{ $settings['outlook_imap_mail_port'] ?? '' }}"
                                        placeholder="{{ __('IMAP Mail Port') }}">
                                    @error('outlook_imap_mail_port')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label">{{ __('IMAP Mail Username') }} <x-required /></label>
                                    <input type="email" class="form-control" name="outlook_imap_email_address"
                                        value="{{ $settings['outlook_imap_email_address'] ?? '' }}"
                                        placeholder="{{ __('Enter IMAP Mail Username') }}">
                                    @error('outlook_imap_email_address')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label">{{ __('IMAP Mail Password') }} <x-required /></label>
                                    <input type="text" class="form-control" name="outlook_imap_email_password"
                                        value="{{ $settings['outlook_access_token'] ?? '' }}"
                                        placeholder="{{ __('Enter IMAP Mail Password') }}" readonly>
                                    @error('outlook_imap_email_password')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label">{{ __('IMAP Mail Encryption') }} <x-required /></label>
                                    <input type="text" class="form-control" name="outlook_imap_mail_encryption"
                                        value="{{ $settings['outlook_imap_mail_encryption'] ?? '' }}"
                                        placeholder="{{ __('IMAP Mail Encryption') }}">
                                    @error('outlook_imap_mail_encryption')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">{{ __('IMAP Mail Authentication') }} <x-required /></label>
                                    <input type="text" class="form-control" name="outlook_imap_mail_authentication"
                                        value="{{ $settings['outlook_imap_mail_authentication'] ?? '' }}"
                                        placeholder="{{ __('IMAP Mail Authentication') }}">
                                    @error('outlook_imap_mail_authentication')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                        </div>
                        <div class="card-footer">
                            <div class="text-end">
                                <button type="submit" class="btn btn-primary">{{ __('Save Changes') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif
@endsection
@push('scripts')
    <script>
        $(document).ready(function() {
            function toggleTypeFields() {
                var selected = $('input[name="mail_type"]:checked').val();
                if (selected === 'gmail') {
                    $('#gmail-form').show();
                    $('#outlook-form').hide();
                    $('#outlookSynForm').hide();
                } else if (selected === 'outlook') {
                    $('#gmail-form').hide();
                    $('#outlook-form').show();
                    $('#outlookSynForm').show();
                }
            }

            // Bind change event
            $('input[name="mail_type"]').on('change', toggleTypeFields);

            // Trigger on page load
            toggleTypeFields();
        });
    </script>
    <script>
        function copyWebhookLink() {
            var copyText = document.getElementById("webhookInput");
            navigator.clipboard.writeText(copyText.value).then(function() {
                show_toastr('Success', '{{ __('Link Copy on Clipboard ') }}', 'success');
            }, function(err) {
                show_toastr('Error', '{{ __('Failed to copy ') }}', 'error');
            });
        }
    </script>
@endpush
