<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Route;
use Workdo\Mail2Ticket\Http\Controllers\Mail2TicketAuthController;
use Workdo\Mail2Ticket\Http\Controllers\Mail2TicketController;

Route::group(['middleware' => ['web', 'auth', 'verified', 'XSS', 'ModuleCheckEnable:Mail2Ticket']], function () {      
        Route::get('mail2ticket/imap', [Mail2TicketController::class, 'index'])->name('mail2ticket.imap.index');
        Route::post('mail2ticket/imap/gmail', [Mail2TicketController::class, 'storeGmail'])->name('mail2ticket.imap.gmail');
        Route::post('mail2ticket/imap/outlook', [Mail2TicketController::class, 'storeOutlook'])->name('mail2ticket.imap.outlook');
        Route::post('mail2ticket/imap/outlook/sync', [Mail2TicketController::class, 'storeOutlookSync'])->name('mail2ticket.imap.outlook.sync');
        Route::get('/outlook/redirect', [Mail2TicketAuthController::class, 'redirect'])->name('outlook.sync');
        Route::get('/outlook/webhook', [Mail2TicketAuthController::class, 'callback'])->name('outlook.webhook');
    });
