<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Manage Priority')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Priority')); ?></li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('action-button'); ?>
    <?php if (app('laratrust')->hasPermission('priority create')) : ?>
        <div class="float-end">
            <div class="col-auto">
                <a href="#" class="btn btn-sm btn-primary btn-icon" title="<?php echo e(__('Create')); ?>" data-bs-toggle="tooltip"
                    data-bs-placement="top" data-ajax-popup="true" data-title="<?php echo e(__('Create Priority')); ?>"
                    data-url="<?php echo e(route('admin.priority.create')); ?>" data-size="md"><i class="ti ti-plus"></i></a>
            </div>
        </div>
    <?php endif; // app('laratrust')->permission ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-3 col-12">
            <?php echo $__env->make('layouts.setup', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
        <div class="col-md-9 col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="pc-dt-simple" class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col"><?php echo e(__('Name')); ?></th>
                                    <th scope="col"><?php echo e(__('Color')); ?></th>
                                    <?php if(Laratrust::hasPermission('priority edit') || Laratrust::hasPermission('priority delete')): ?>  
                                    <th scope="col" class="text-end me-3"><?php echo e(__('Action')); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>

                            <tbody>
                                <?php $__currentLoopData = $priority; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $priorities): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <th scope="row"><?php echo e(++$index); ?></th>
                                        <td><?php echo e($priorities->name); ?></td>
                                        <td><span class="badge"
                                                style="background: <?php echo e($priorities->color); ?>">&nbsp;&nbsp;&nbsp;</span></td>

                                        <td class="text-end">
                                            <?php if (app('laratrust')->hasPermission('priority edit')) : ?>
                                            <div class="action-btn me-2">
                                                <a href="#"
                                                    class="mx-3 bg-info btn btn-sm d-inline-flex align-items-center"
                                                    title="<?php echo e(__('Edit')); ?>" data-bs-toggle="tooltip"
                                                    data-bs-placement="top"
                                                    data-url="<?php echo e(route('admin.priority.edit', $priorities->id)); ?>"
                                                    data-ajax-popup="true" data-title="<?php echo e(__('Edit Priority')); ?>"
                                                    data-size="md"><span class="text-white"><i
                                                            class="ti ti-pencil"></i></span></a>

                                            </div>
                                            <?php endif; // app('laratrust')->permission ?>

                                            <?php if (app('laratrust')->hasPermission('priority delete')) : ?>
                                            <div class="action-btn me-2">
                                                <form method="POST"
                                                    action="<?php echo e(route('admin.priority.destroy', $priorities->id)); ?>"
                                                    id="">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <input name="_method" type="hidden" value="DELETE">
                                                    <a class="mx-3 bg-danger btn btn-sm  align-items-center bs-pass-para show_confirm"
                                                    data-bs-toggle="tooltip" title=""
                                                    data-bs-original-title="Delete" aria-label="Delete"
                                                    data-confirm="<?php echo e(__('Are You Sure?')); ?>"
                                                    data-text="<?php echo e(__('This action can not be undone. Do you want to continue?')); ?>"
                                                    data-confirm-yes="delete-form-<?php echo e($priorities->id); ?>"><i
                                                        class="ti ti-trash text-white text-white"></i></a>
                                                </form>
                                            </div>
                                            <?php endif; // app('laratrust')->permission ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/sevenonesix/public_html/ticket.buffalorepair.net/resources/views/admin/priority/index.blade.php ENDPATH**/ ?>