<?php
    config([
        'captcha.secret' => isset($settings['NOCAPTCHA_SECRET']) ? $settings['NOCAPTCHA_SECRET'] : '',
        'captcha.sitekey' => isset($settings['NOCAPTCHA_SITEKEY']) ? $settings['NOCAPTCHA_SITEKEY'] : '',
        'options' => [
            'timeout' => 30,
        ],
    ]);
?>


<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Login')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('language-bar'); ?>
    <div class="lang-dropdown-only-desk">
        <li class="dropdown dash-h-item drp-language">
            <a class="dash-head-link dropdown-toggle btn" href="#" data-bs-toggle="dropdown" aria-expanded="false">
                <span class="drp-text"> <?php echo e(ucfirst($language->fullName)); ?>

                </span>
            </a>
            <div class="dropdown-menu dash-h-dropdown dropdown-menu-end">
                <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('login', $code)); ?>" tabindex="0"
                        class="dropdown-item dropdown-item <?php echo e($lang == $code ? 'active' : ''); ?>">
                        <span><?php echo e(ucFirst($language)); ?></span>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </li>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="auth-wrapper login-page">
        <div class="bottom-bg">
            <svg width="69" height="129" viewBox="0 0 69 129" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M2.6351 123.878C3.41663 123.079 4.68262 123.075 5.47146 123.847C6.2603 124.619 6.27396 125.895 5.50185 126.684C4.72031 127.482 3.45432 127.486 2.66548 126.714C1.87664 125.942 1.85356 124.676 2.6351 123.878Z"
                    fill="white" />
                <path
                    d="M10.2806 116.066C11.0527 115.277 12.3281 115.263 13.117 116.035C13.9058 116.808 13.9195 118.083 13.1474 118.872C12.3658 119.67 11.0904 119.684 10.3016 118.912C9.52215 118.13 9.50849 116.855 10.2806 116.066Z"
                    fill="white" />
                <path
                    d="M2.63314 108.58C3.40526 107.792 4.68067 107.778 5.46951 108.55C6.25835 109.322 6.27201 110.597 5.4999 111.386C4.71837 112.185 3.44295 112.198 2.65411 111.426C1.86507 110.635 1.86103 109.369 2.63314 108.58Z"
                    fill="white" />
                <path
                    d="M17.9265 108.255C18.6986 107.466 19.993 107.452 20.7722 108.215C21.5611 108.987 21.5747 110.262 20.7932 111.061C20.0211 111.849 18.7457 111.863 17.9568 111.091C17.168 110.319 17.1543 109.043 17.9265 108.255Z"
                    fill="white" />
                <path
                    d="M10.279 100.769C11.0511 99.98 12.3359 99.9567 13.1248 100.729C13.9136 101.501 13.9273 102.776 13.1458 103.575C12.3736 104.364 11.0982 104.377 10.3094 103.605C9.51092 102.824 9.50688 101.558 10.279 100.769Z"
                    fill="white" />
                <path
                    d="M2.62177 93.2737C3.39389 92.4848 4.67872 92.4616 5.46756 93.2337C6.25639 94.0058 6.27006 95.2812 5.48853 96.0797C4.71641 96.8685 3.45061 96.8916 2.65215 96.1101C1.85369 95.3285 1.84965 94.0625 2.62177 93.2737Z"
                    fill="white" />
                <path
                    d="M25.5814 100.433C26.3629 99.6349 27.6385 99.6403 28.4178 100.403C29.2066 101.175 29.2203 102.451 28.4481 103.239C27.676 104.028 26.3912 104.051 25.6024 103.279C24.8135 102.507 24.7999 101.232 25.5814 100.433Z"
                    fill="white" />
                <path
                    d="M17.9339 92.9479C18.7155 92.1494 19.9815 92.1454 20.7703 92.9175C21.5591 93.6896 21.5728 94.965 20.8007 95.7539C20.0286 96.5427 18.7437 96.566 17.9549 95.7939C17.1564 95.0124 17.1524 93.7464 17.9339 92.9479Z"
                    fill="white" />
                <path
                    d="M10.2757 85.4527C11.0573 84.6542 12.3232 84.6502 13.1121 85.4223C13.9009 86.1944 13.9146 87.4698 13.1425 88.2586C12.3704 89.0475 11.0951 89.0802 10.2967 88.2987C9.49823 87.5171 9.49419 86.2511 10.2757 85.4527Z"
                    fill="white" />
                <path
                    d="M2.62826 77.9668C3.40979 77.1684 4.66617 77.1549 5.46463 77.9364C6.25346 78.7086 6.26713 79.984 5.49502 80.7728C4.7229 81.5616 3.43807 81.5849 2.64923 80.8128C1.85077 80.0313 1.84673 78.7653 2.62826 77.9668Z"
                    fill="white" />
                <path
                    d="M33.2279 92.6221C34.0094 91.8236 35.285 91.829 36.0642 92.5917C36.8531 93.3638 36.8667 94.6392 36.0946 95.4281C35.3225 96.2169 34.0471 96.2306 33.2583 95.4585C32.4694 94.6863 32.4463 93.4206 33.2279 92.6221Z"
                    fill="white" />
                <path
                    d="M25.5794 85.1361C26.361 84.3377 27.627 84.3336 28.4158 85.1057C29.2046 85.8779 29.2183 87.1533 28.4462 87.9421C27.6741 88.731 26.3987 88.7446 25.6098 87.9725C24.8114 87.191 24.7979 85.9346 25.5794 85.1361Z"
                    fill="white" />
                <path
                    d="M17.9222 77.641C18.7037 76.8426 19.9697 76.8385 20.7586 77.6106C21.5474 78.3827 21.5611 79.6582 20.789 80.447C20.0168 81.2358 18.751 81.2589 17.9526 80.4774C17.1541 79.6959 17.1407 78.4395 17.9222 77.641Z"
                    fill="white" />
                <path
                    d="M10.2747 70.1555C11.0563 69.3571 12.3127 69.3436 13.1111 70.1252C13.8999 70.8973 13.9136 72.1727 13.1415 72.9615C12.3694 73.7504 11.094 73.764 10.3051 72.9919C9.50667 72.2104 9.49321 70.954 10.2747 70.1555Z"
                    fill="white" />
                <path
                    d="M2.60678 62.6507C3.38831 61.8522 4.65431 61.8482 5.44315 62.6203C6.23198 63.3924 6.24565 64.6678 5.47353 65.4566C4.70141 66.2455 3.426 66.2592 2.63716 65.487C1.84832 64.7149 1.82524 63.4491 2.60678 62.6507Z"
                    fill="white" />
                <path
                    d="M40.8734 84.8107C41.6455 84.0219 42.9209 84.0082 43.7097 84.7803C44.4986 85.5524 44.5122 86.8278 43.7401 87.6167C42.9586 88.4151 41.6832 88.4288 40.8943 87.6567C40.1149 86.8749 40.1013 85.5995 40.8734 84.8107Z"
                    fill="white" />
                <path
                    d="M33.2249 77.3249C33.9971 76.536 35.2725 76.5224 36.0613 77.2945C36.8501 78.0666 36.8638 79.342 36.0823 80.1405C35.3102 80.9293 34.0347 80.943 33.2459 80.1708C32.4569 79.3797 32.4528 78.1137 33.2249 77.3249Z"
                    fill="white" />
                <path
                    d="M25.5687 69.8296C26.3408 69.0408 27.6162 69.0271 28.4051 69.7992C29.1939 70.5713 29.2076 71.8468 28.426 72.6452C27.6539 73.4341 26.3881 73.4571 25.5897 72.6756C24.8006 71.8845 24.7966 70.6185 25.5687 69.8296Z"
                    fill="white" />
                <path
                    d="M17.9203 62.3439C18.6924 61.5551 19.9582 61.532 20.7566 62.3135C21.5455 63.0856 21.5591 64.361 20.7776 65.1595C20.0055 65.9483 18.7301 65.962 17.9412 65.1899C17.1522 64.3987 17.1481 63.1327 17.9203 62.3439Z"
                    fill="white" />
                <path
                    d="M10.2533 54.8394C11.0254 54.0505 12.3008 54.0369 13.0896 54.809C13.8785 55.5811 13.8921 56.8565 13.1106 57.655C12.3385 58.4438 11.0631 58.4575 10.2742 57.6854C9.49481 56.9036 9.48114 55.6282 10.2533 54.8394Z"
                    fill="white" />
                <path
                    d="M2.59505 47.3441C3.36717 46.5553 4.65221 46.5511 5.44104 47.3232C6.22988 48.0953 6.24355 49.3707 5.46201 50.1692C4.6899 50.958 3.41448 50.9717 2.62564 50.1996C1.8366 49.4084 1.82294 48.133 2.59505 47.3441Z"
                    fill="white" />
                <path
                    d="M48.5192 76.9993C49.3008 76.2008 50.5762 76.1871 51.365 76.9593C52.1539 77.7314 52.1675 79.0068 51.386 79.8053C50.6139 80.5941 49.3385 80.6078 48.5496 79.8356C47.7608 79.0635 47.7471 77.7881 48.5192 76.9993Z"
                    fill="white" />
                <path
                    d="M40.8708 69.5133C41.6523 68.7149 42.9277 68.7012 43.7166 69.4733C44.5054 70.2454 44.5191 71.5208 43.7376 72.3193C42.9654 73.1081 41.69 73.1218 40.9012 72.3497C40.1027 71.5681 40.0987 70.3021 40.8708 69.5133Z"
                    fill="white" />
                <path
                    d="M33.2136 62.0182C33.9951 61.2197 35.2705 61.2061 36.0594 61.9782C36.8482 62.7503 36.8619 64.0257 36.0803 64.8242C35.3082 65.613 34.0424 65.6361 33.244 64.8546C32.4455 64.073 32.4415 62.807 33.2136 62.0182Z"
                    fill="white" />
                <path
                    d="M25.5661 54.5324C26.3476 53.7339 27.6134 53.7108 28.4119 54.4923C29.2007 55.2645 29.2144 56.5399 28.4329 57.3383C27.6607 58.1272 26.3853 58.1408 25.5965 57.3687C24.798 56.5872 24.794 55.3212 25.5661 54.5324Z"
                    fill="white" />
                <path
                    d="M17.8991 47.0278C18.6806 46.2294 19.9561 46.2157 20.7449 46.9878C21.5337 47.7599 21.5474 49.0354 20.7659 49.8338C19.9938 50.6227 18.7183 50.6363 17.9295 49.8642C17.1407 49.0921 17.127 47.8167 17.8991 47.0278Z"
                    fill="white" />
                <path
                    d="M10.2419 39.5327C11.0234 38.7343 12.3085 38.73 13.0973 39.5021C13.8861 40.2742 13.8998 41.5497 13.1183 42.3481C12.3461 43.137 11.0707 43.1506 10.2819 42.3785C9.48344 41.597 9.46977 40.3216 10.2419 39.5327Z"
                    fill="white" />
                <path
                    d="M2.59345 32.0469C3.37498 31.2484 4.6504 31.2348 5.43924 32.0069C6.22808 32.779 6.24174 34.0544 5.46021 34.8529C4.68809 35.6417 3.41268 35.6554 2.62384 34.8832C1.835 34.1111 1.82133 32.8357 2.59345 32.0469Z"
                    fill="white" />
                <path
                    d="M56.1742 69.1783C56.9463 68.3894 58.2217 68.3757 59.0105 69.1479C59.7994 69.92 59.813 71.1954 59.0409 71.9842C58.2688 72.7731 56.9934 72.7867 56.2045 72.0146C55.4157 71.2425 55.3926 69.9767 56.1742 69.1783Z"
                    fill="white" />
                <path
                    d="M48.5267 61.6924C49.2988 60.9036 50.5742 60.8899 51.3631 61.662C52.1519 62.4341 52.1656 63.7096 51.3935 64.4984C50.6213 65.2872 49.3459 65.3009 48.5571 64.5288C47.7586 63.7472 47.7452 62.4909 48.5267 61.6924Z"
                    fill="white" />
                <path
                    d="M40.8695 54.1972C41.6416 53.4083 42.917 53.3947 43.7058 54.1668C44.4947 54.9389 44.5083 56.2143 43.7362 57.0032C42.9641 57.792 41.6983 57.8151 40.8999 57.0335C40.1014 56.252 40.0879 54.9956 40.8695 54.1972Z"
                    fill="white" />
                <path
                    d="M33.221 46.7113C33.9931 45.9225 35.2589 45.8994 36.0574 46.6809C36.8462 47.4531 36.8599 48.7285 36.0878 49.5173C35.3157 50.3062 34.0403 50.3198 33.2514 49.5477C32.453 48.7662 32.4395 47.5098 33.221 46.7113Z"
                    fill="white" />
                <path
                    d="M25.554 39.2069C26.3262 38.4181 27.6016 38.4044 28.3904 39.1766C29.1792 39.9487 29.1929 41.2241 28.4208 42.0129C27.6487 42.8018 26.3733 42.8154 25.5844 42.0433C24.7956 41.2712 24.7725 40.0054 25.554 39.2069Z"
                    fill="white" />
                <path
                    d="M17.8968 31.7117C18.6689 30.9229 19.954 30.9186 20.7428 31.6907C21.5316 32.4628 21.5453 33.7383 20.7732 34.5271C20.0011 35.3159 18.7257 35.3296 17.9368 34.5575C17.1384 33.776 17.1153 32.5102 17.8968 31.7117Z"
                    fill="white" />
                <path
                    d="M10.2484 24.2259C11.0205 23.437 12.2959 23.4234 13.0847 24.1955C13.8736 24.9676 13.8872 26.243 13.1151 27.0318C12.343 27.8207 11.0676 27.8343 10.2788 27.0622C9.48992 26.2901 9.46684 25.0243 10.2484 24.2259Z"
                    fill="white" />
                <path
                    d="M2.59115 16.7307C3.36327 15.9419 4.63868 15.9282 5.43714 16.7098C6.22598 17.4819 6.23964 18.7573 5.46752 19.5461C4.69541 20.335 3.41037 20.3392 2.63115 19.5765C1.83269 18.795 1.80962 17.5292 2.59115 16.7307Z"
                    fill="white" />
                <path
                    d="M63.8197 61.3666C64.5918 60.5778 65.8672 60.5641 66.656 61.3362C67.4449 62.1083 67.4585 63.3837 66.6864 64.1726C65.9049 64.971 64.6389 64.9751 63.85 64.203C63.0612 63.4309 63.0381 62.1651 63.8197 61.3666Z"
                    fill="white" />
                <path
                    d="M56.1722 53.881C56.9443 53.0922 58.2101 53.0691 59.0086 53.8506C59.7974 54.6227 59.8111 55.8982 59.039 56.687C58.2574 57.4855 56.9914 57.4895 56.2026 56.7174C55.4041 55.9358 55.3907 54.6795 56.1722 53.881Z"
                    fill="white" />
                <path
                    d="M48.515 46.3859C49.2871 45.5971 50.5529 45.574 51.3513 46.3555C52.1402 47.1276 52.1538 48.403 51.3817 49.1919C50.6002 49.9903 49.3438 50.0038 48.5454 49.2223C47.7469 48.4407 47.7334 47.1844 48.515 46.3859Z"
                    fill="white" />
                <path
                    d="M40.8665 38.9001C41.6387 38.1112 42.9044 38.0881 43.7029 38.8697C44.4917 39.6418 44.5054 40.9172 43.7333 41.706C42.9518 42.5045 41.6858 42.5085 40.8969 41.7364C40.0985 40.9549 40.085 39.6985 40.8665 38.9001Z"
                    fill="white" />
                <path
                    d="M33.2005 31.3955C33.9726 30.6067 35.2481 30.593 36.0369 31.3652C36.8257 32.1373 36.8394 33.4127 36.0673 34.2015C35.2857 35 34.0197 35.004 33.2309 34.2319C32.4421 33.4598 32.419 32.194 33.2005 31.3955Z"
                    fill="white" />
                <path
                    d="M25.5423 23.9004C26.3144 23.1116 27.5995 23.1073 28.3883 23.8794C29.1771 24.6516 29.1908 25.927 28.4187 26.7158C27.6372 27.5143 26.3712 27.5183 25.5823 26.7462C24.7935 25.9741 24.7608 24.6989 25.5423 23.9004Z"
                    fill="white" />
                <path
                    d="M17.8949 16.4146C18.667 15.6257 19.9424 15.6121 20.7312 16.3842C21.5201 17.1563 21.5337 18.4317 20.7616 19.2206C19.9801 20.019 18.7141 20.0231 17.9252 19.2509C17.1364 18.4788 17.1133 17.213 17.8949 16.4146Z"
                    fill="white" />
                <path
                    d="M10.2367 8.91934C11.0088 8.1305 12.2842 8.11684 13.0826 8.89837C13.8715 9.67049 13.8851 10.9459 13.113 11.7347C12.3315 12.5332 11.0655 12.5372 10.2767 11.7651C9.4782 10.9836 9.45512 9.7178 10.2367 8.91934Z"
                    fill="white" />
                <path
                    d="M2.5892 1.4335C3.36131 0.644661 4.62711 0.621582 5.42557 1.40311C6.2144 2.17523 6.22807 3.45065 5.45595 4.23948C4.67442 5.03794 3.40842 5.04199 2.61958 4.26987C1.82112 3.48834 1.80766 2.23196 2.5892 1.4335Z"
                    fill="white" />
            </svg>
        </div>
        <div class="auth-content ticket-form-wrapper">
            
            <?php echo $__env->make('layouts.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <div class="row login-row">
                <div class="top-bg">
                    <svg width="66" height="129" viewBox="0 0 66 129" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M65.4557 123.878C64.6742 123.079 63.4082 123.075 62.6194 123.847C61.8305 124.619 61.8169 125.895 62.589 126.684C63.3705 127.482 64.6365 127.486 65.4253 126.714C66.2142 125.942 66.2373 124.676 65.4557 123.878Z"
                            fill="white"></path>
                        <path
                            d="M57.8095 116.066C57.0374 115.277 55.762 115.264 54.9731 116.036C54.1843 116.808 54.1706 118.083 54.9427 118.872C55.7243 119.671 56.9997 119.684 57.7885 118.912C58.5679 118.13 58.5816 116.855 57.8095 116.066Z"
                            fill="white"></path>
                        <path
                            d="M65.4574 108.58C64.6853 107.791 63.4099 107.777 62.6211 108.549C61.8322 109.322 61.8186 110.597 62.5907 111.386C63.3722 112.184 64.6476 112.198 65.4365 111.426C66.2255 110.635 66.2296 109.369 65.4574 108.58Z"
                            fill="white"></path>
                        <path
                            d="M50.1636 108.255C49.3915 107.466 48.0971 107.452 47.3178 108.215C46.529 108.987 46.5153 110.262 47.2969 111.061C48.069 111.849 49.3444 111.863 50.1332 111.091C50.9221 110.319 50.9357 109.043 50.1636 108.255Z"
                            fill="white"></path>
                        <path
                            d="M57.8113 100.769C57.0392 99.9803 55.7544 99.957 54.9655 100.729C54.1767 101.501 54.163 102.777 54.9446 103.575C55.7167 104.364 56.9921 104.378 57.781 103.606C58.5794 102.824 58.5835 101.558 57.8113 100.769Z"
                            fill="white"></path>
                        <path
                            d="M65.469 93.2741C64.6969 92.4852 63.4121 92.4619 62.6233 93.234C61.8344 94.0062 61.8208 95.2816 62.6023 96.08C63.3744 96.8689 64.6402 96.892 65.4387 96.1104C66.2371 95.3289 66.2412 94.0629 65.469 93.2741Z"
                            fill="white"></path>
                        <path
                            d="M42.5087 100.433C41.7272 99.6349 40.4516 99.6403 39.6723 100.403C38.8835 101.175 38.8698 102.451 39.642 103.239C40.4141 104.028 41.6989 104.051 42.4877 103.279C43.2766 102.507 43.2902 101.232 42.5087 100.433Z"
                            fill="white"></path>
                        <path
                            d="M50.1567 92.948C49.3751 92.1496 48.1091 92.1455 47.3203 92.9176C46.5314 93.6898 46.5178 94.9652 47.2899 95.754C48.062 96.5428 49.3468 96.5661 50.1357 95.794C50.9341 95.0125 50.9382 93.7465 50.1567 92.948Z"
                            fill="white"></path>
                        <path
                            d="M57.8141 85.4529C57.0326 84.6544 55.7666 84.6504 54.9778 85.4225C54.1889 86.1946 54.1753 87.4701 54.9474 88.2589C55.7195 89.0477 56.9947 89.0804 57.7932 88.2989C58.5916 87.5174 58.5957 86.2514 57.8141 85.4529Z"
                            fill="white"></path>
                        <path
                            d="M65.4621 77.9666C64.6805 77.1681 63.4242 77.1547 62.6257 77.9362C61.8369 78.7083 61.8232 79.9837 62.5953 80.7726C63.3674 81.5614 64.6523 81.5847 65.4411 80.8126C66.2396 80.031 66.2436 78.765 65.4621 77.9666Z"
                            fill="white"></path>
                        <path
                            d="M34.8627 92.6219C34.0812 91.8234 32.8056 91.8288 32.0263 92.5915C31.2375 93.3636 31.2238 94.639 31.996 95.4278C32.7681 96.2167 34.0435 96.2303 34.8323 95.4582C35.6212 94.6861 35.6442 93.4203 34.8627 92.6219Z"
                            fill="white"></path>
                        <path
                            d="M42.5104 85.1365C41.7289 84.338 40.4629 84.334 39.674 85.1061C38.8852 85.8782 38.8715 87.1536 39.6437 87.9425C40.4158 88.7313 41.6912 88.745 42.48 87.9729C43.2785 87.1913 43.2919 85.935 42.5104 85.1365Z"
                            fill="white"></path>
                        <path
                            d="M50.1681 77.6414C49.3866 76.8429 48.1206 76.8389 47.3318 77.611C46.5429 78.3831 46.5293 79.6585 47.3014 80.4474C48.0735 81.2362 49.3393 81.2593 50.1377 80.4778C50.9362 79.6962 50.9497 78.4398 50.1681 77.6414Z"
                            fill="white"></path>
                        <path
                            d="M57.8158 70.1551C57.0343 69.3566 55.7779 69.3431 54.9795 70.1247C54.1906 70.8968 54.177 72.1722 54.9491 72.961C55.7212 73.7499 56.9966 73.7635 57.7855 72.9914C58.5839 72.2099 58.5974 70.9535 57.8158 70.1551Z"
                            fill="white"></path>
                        <path
                            d="M65.4833 62.6511C64.7018 61.8527 63.4358 61.8487 62.6469 62.6208C61.8581 63.3929 61.8444 64.6683 62.6166 65.4571C63.3887 66.246 64.6641 66.2596 65.4529 65.4875C66.2418 64.7154 66.2648 63.4496 65.4833 62.6511Z"
                            fill="white"></path>
                        <path
                            d="M27.2172 84.8103C26.4451 84.0215 25.1697 84.0078 24.3808 84.7799C23.592 85.5521 23.5783 86.8275 24.3504 87.6163C25.132 88.4148 26.4074 88.4284 27.1962 87.6563C27.9757 86.8746 27.9893 85.5992 27.2172 84.8103Z"
                            fill="white"></path>
                        <path
                            d="M34.8652 77.325C34.093 76.5361 32.8176 76.5225 32.0288 77.2946C31.2399 78.0667 31.2263 79.3421 32.0078 80.1406C32.7799 80.9294 34.0553 80.9431 34.8442 80.171C35.6332 79.3798 35.6373 78.1138 34.8652 77.325Z"
                            fill="white"></path>
                        <path
                            d="M42.5219 69.8299C41.7498 69.041 40.4744 69.0274 39.6855 69.7995C38.8967 70.5716 38.883 71.847 39.6645 72.6455C40.4367 73.4343 41.7025 73.4574 42.5009 72.6759C43.29 71.8847 43.294 70.6187 42.5219 69.8299Z"
                            fill="white"></path>
                        <path
                            d="M50.1706 62.3435C49.3985 61.5547 48.1327 61.5316 47.3342 62.3131C46.5454 63.0853 46.5317 64.3607 47.3132 65.1591C48.0853 65.948 49.3608 65.9616 50.1496 65.1895C50.9386 64.3984 50.9427 63.1324 50.1706 62.3435Z"
                            fill="white"></path>
                        <path
                            d="M57.8371 54.8396C57.065 54.0508 55.7895 54.0371 55.0007 54.8092C54.2119 55.5814 54.1982 56.8568 54.9797 57.6552C55.7519 58.4441 57.0273 58.4577 57.8161 57.6856C58.5955 56.9039 58.6092 55.6285 57.8371 54.8396Z"
                            fill="white"></path>
                        <path
                            d="M65.4948 47.3445C64.7227 46.5557 63.4376 46.5514 62.6488 47.3235C61.86 48.0957 61.8463 49.3711 62.6278 50.1695C63.3999 50.9584 64.6754 50.972 65.4642 50.1999C66.2532 49.4088 66.2669 48.1333 65.4948 47.3445Z"
                            fill="white"></path>
                        <path
                            d="M19.5711 76.9996C18.7896 76.2012 17.5142 76.1875 16.7253 76.9596C15.9365 77.7317 15.9228 79.0072 16.7043 79.8056C17.4765 80.5945 18.7519 80.6081 19.5407 79.836C20.3296 79.0639 20.3432 77.7885 19.5711 76.9996Z"
                            fill="white"></path>
                        <path
                            d="M27.219 69.5133C26.4375 68.7149 25.1621 68.7012 24.3733 69.4733C23.5844 70.2454 23.5708 71.5208 24.3523 72.3193C25.1244 73.1081 26.3998 73.1218 27.1887 72.3497C27.9871 71.5681 27.9912 70.3021 27.219 69.5133Z"
                            fill="white"></path>
                        <path
                            d="M34.8768 62.0182C34.0952 61.2197 32.8198 61.2061 32.031 61.9782C31.2421 62.7503 31.2285 64.0257 32.01 64.8242C32.7821 65.613 34.0479 65.6361 34.8464 64.8546C35.6448 64.073 35.6489 62.807 34.8768 62.0182Z"
                            fill="white"></path>
                        <path
                            d="M42.5245 54.5319C41.7429 53.7334 40.4771 53.7103 39.6787 54.4919C38.8898 55.264 38.8762 56.5394 39.6577 57.3378C40.4298 58.1267 41.7052 58.1403 42.4941 57.3682C43.2925 56.5867 43.2966 55.3207 42.5245 54.5319Z"
                            fill="white"></path>
                        <path
                            d="M50.1912 47.028C49.4097 46.2295 48.1343 46.2158 47.3454 46.988C46.5566 47.7601 46.5429 49.0355 47.3245 49.8339C48.0966 50.6228 49.372 50.6364 50.1608 49.8643C50.9497 49.0922 50.9633 47.8168 50.1912 47.028Z"
                            fill="white"></path>
                        <path
                            d="M57.8489 39.5328C57.0674 38.7344 55.7824 38.7301 54.9935 39.5023C54.2047 40.2744 54.191 41.5498 54.9726 42.3482C55.7447 43.1371 57.0201 43.1507 57.8089 42.3786C58.6074 41.5971 58.621 40.3217 57.8489 39.5328Z"
                            fill="white"></path>
                        <path
                            d="M65.4966 32.0465C64.7151 31.2481 63.4397 31.2344 62.6509 32.0065C61.862 32.7786 61.8483 34.054 62.6299 34.8525C63.402 35.6413 64.6774 35.655 65.4663 34.8829C66.2551 34.1108 66.2688 32.8354 65.4966 32.0465Z"
                            fill="white"></path>
                        <path
                            d="M11.9157 69.1785C11.1436 68.3897 9.86816 68.376 9.07932 69.1481C8.29048 69.9202 8.27682 71.1956 9.04894 71.9845C9.82105 72.7733 11.0965 72.787 11.8853 72.0149C12.6741 71.2427 12.6972 69.977 11.9157 69.1785Z"
                            fill="white"></path>
                        <path
                            d="M19.5636 61.6922C18.7915 60.9033 17.5161 60.8897 16.7273 61.6618C15.9384 62.4339 15.9248 63.7093 16.6969 64.4982C17.469 65.287 18.7444 65.3007 19.5333 64.5285C20.3317 63.747 20.3452 62.4906 19.5636 61.6922Z"
                            fill="white"></path>
                        <path
                            d="M27.2211 54.197C26.449 53.4082 25.1736 53.3945 24.3847 54.1667C23.5959 54.9388 23.5822 56.2142 24.3544 57.003C25.1265 57.7919 26.3923 57.815 27.1907 57.0334C27.9892 56.2519 28.0026 54.9955 27.2211 54.197Z"
                            fill="white"></path>
                        <path
                            d="M34.8691 46.7117C34.0969 45.9229 32.8311 45.8998 32.0327 46.6813C31.2438 47.4534 31.2302 48.7288 32.0023 49.5177C32.7744 50.3065 34.0498 50.3202 34.8387 49.5481C35.6371 48.7665 35.6506 47.5102 34.8691 46.7117Z"
                            fill="white"></path>
                        <path
                            d="M42.5363 39.2068C41.7642 38.418 40.4888 38.4043 39.6999 39.1764C38.9111 39.9485 38.8974 41.224 39.6695 42.0128C40.4417 42.8016 41.7171 42.8153 42.5059 42.0432C43.2947 41.2711 43.3178 40.0053 42.5363 39.2068Z"
                            fill="white"></path>
                        <path
                            d="M50.194 31.7117C49.4219 30.9229 48.1369 30.9186 47.348 31.6907C46.5592 32.4628 46.5455 33.7383 47.3176 34.5271C48.0897 35.3159 49.3652 35.3296 50.154 34.5575C50.9525 33.776 50.9755 32.5102 50.194 31.7117Z"
                            fill="white"></path>
                        <path
                            d="M57.8417 24.2263C57.0696 23.4375 55.7942 23.4238 55.0053 24.196C54.2165 24.9681 54.2028 26.2435 54.975 27.0323C55.7471 27.8212 57.0225 27.8348 57.8113 27.0627C58.6002 26.2906 58.6232 25.0248 57.8417 24.2263Z"
                            fill="white"></path>
                        <path
                            d="M65.4994 16.7312C64.7273 15.9424 63.4519 15.9287 62.6534 16.7103C61.8646 17.4824 61.8509 18.7578 62.6231 19.5466C63.3952 20.3355 64.6802 20.3397 65.4594 19.577C66.2579 18.7955 66.281 17.5297 65.4994 16.7312Z"
                            fill="white"></path>
                        <path
                            d="M4.27018 61.367C3.49806 60.5781 2.22265 60.5645 1.43381 61.3366C0.644973 62.1087 0.631312 63.3841 1.40343 64.173C2.18496 64.9714 3.45096 64.9755 4.2398 64.2033C5.02863 63.4312 5.05171 62.1654 4.27018 61.367Z"
                            fill="white"></path>
                        <path
                            d="M11.9181 53.8806C11.146 53.0918 9.88022 53.0687 9.08176 53.8503C8.29292 54.6224 8.27926 55.8978 9.05137 56.6866C9.83291 57.4851 11.0989 57.4891 11.8877 56.717C12.6862 55.9355 12.6997 54.6791 11.9181 53.8806Z"
                            fill="white"></path>
                        <path
                            d="M19.5751 46.3855C18.803 45.5967 17.5372 45.5736 16.7387 46.3551C15.9499 47.1273 15.9362 48.4027 16.7084 49.1915C17.4899 49.99 18.7463 50.0034 19.5447 49.2219C20.3432 48.4404 20.3566 47.184 19.5751 46.3855Z"
                            fill="white"></path>
                        <path
                            d="M27.2235 38.9002C26.4514 38.1113 25.1856 38.0883 24.3872 38.8698C23.5983 39.6419 23.5847 40.9173 24.3568 41.7062C25.1383 42.5046 26.4043 42.5087 27.1932 41.7365C27.9916 40.955 28.0051 39.6986 27.2235 38.9002Z"
                            fill="white"></path>
                        <path
                            d="M34.8903 31.3953C34.1182 30.6065 32.8428 30.5928 32.0539 31.3649C31.2651 32.137 31.2514 33.4124 32.0235 34.2013C32.8051 34.9997 34.0711 35.0038 34.8599 34.2317C35.6487 33.4595 35.6718 32.1938 34.8903 31.3953Z"
                            fill="white"></path>
                        <path
                            d="M42.5478 23.9002C41.7757 23.1113 40.4906 23.1071 39.7018 23.8792C38.9129 24.6513 38.8993 25.9267 39.6714 26.7156C40.4529 27.514 41.7189 27.5181 42.5078 26.746C43.2966 25.9738 43.3293 24.6986 42.5478 23.9002Z"
                            fill="white"></path>
                        <path
                            d="M50.1957 16.4148C49.4236 15.626 48.1482 15.6123 47.3593 16.3844C46.5705 17.1566 46.5568 18.432 47.329 19.2208C48.1105 20.0193 49.3765 20.0233 50.1653 19.2512C50.9542 18.4791 50.9772 17.2133 50.1957 16.4148Z"
                            fill="white"></path>
                        <path
                            d="M57.8534 8.91971C57.0813 8.13087 55.8059 8.1172 55.0074 8.89874C54.2186 9.67085 54.2049 10.9463 54.9771 11.7351C55.7586 12.5336 57.0246 12.5376 57.8134 11.7655C58.6119 10.984 58.635 9.71816 57.8534 8.91971Z"
                            fill="white"></path>
                        <path
                            d="M65.5011 1.43338C64.729 0.644539 63.4632 0.62146 62.6648 1.40299C61.8759 2.17511 61.8623 3.45052 62.6344 4.23936C63.4159 5.03782 64.6819 5.04186 65.4708 4.26975C66.2692 3.48822 66.2827 2.23184 65.5011 1.43338Z"
                            fill="white"></path>
                    </svg>
                </div>
                <div class="col-lg-6 col-12">
                    <div class="login-img">
                        <svg width="752" height="752" viewBox="0 0 752 752" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="376" cy="376" r="376" fill="white" fill-opacity="0.1" />
                            <circle cx="376" cy="376" r="331.93" fill="white" fill-opacity="0.1" />
                            <path
                                d="M72.6475 630.068L151.767 629.725L230.887 629.599L389.126 629.363L547.365 629.597L626.484 629.722L705.604 630.068L626.484 630.413L547.365 630.538L389.126 630.774L230.887 630.536L151.767 630.412L72.6475 630.068Z"
                                fill="white" fill-opacity="0.7" />
                            <path
                                d="M239.612 266.863C258.085 248.622 258.195 220.604 253.186 196.292C252.35 192.234 252.064 187.854 249.509 184.603C246.955 181.354 242.007 179.681 238.645 182.026C235.857 183.971 235.139 187.723 233.942 190.928C232.349 195.193 229.536 198.979 225.931 201.708C223.562 203.5 220.488 204.875 217.679 203.898C213.826 202.557 212.58 197.764 211.911 193.699C210.665 186.124 209.419 178.548 208.173 170.975C207.504 166.912 206.808 162.763 204.888 159.127C202.967 155.489 199.565 152.386 195.518 151.965C191.47 151.544 187.076 154.587 186.938 158.699C186.881 160.411 187.511 162.07 187.687 163.774C187.862 165.478 187.396 167.478 185.875 168.221C184.336 168.974 182.515 168.1 181.098 167.119C176.207 163.736 172.462 158.941 168.907 154.145C165.352 149.347 161.854 144.412 157.288 140.591C152.723 136.769 146.857 134.125 140.987 134.79C135.116 135.455 129.534 140.103 129.041 146.062C128.546 152.036 132.877 157.273 137.303 161.286C143.868 167.238 151.284 172.228 159.244 176.047C160.679 176.737 162.234 177.481 162.98 178.901C164.324 181.457 162.22 184.583 159.699 185.929C156.845 187.455 153.508 187.701 150.407 188.615C147.305 189.528 144.114 191.511 143.428 194.707C142.474 199.141 146.687 202.898 150.589 205.162C158.402 209.698 166.98 212.87 175.831 214.498C179.004 215.08 182.311 215.503 185.078 217.189C187.845 218.876 189.923 222.277 188.956 225.385C187.989 228.496 184.411 230.05 181.184 230.004C177.958 229.958 174.867 228.739 171.693 228.123C165.755 226.971 158.615 228.587 155.865 234.019C154.059 237.589 154.606 242.038 156.439 245.613C158.272 249.188 161.237 252.03 164.309 254.594C175.044 263.557 187.934 270.046 201.644 272.322C215.353 274.599 227.554 273.764 239.612 266.863Z"
                                fill="white" fill-opacity="0.12" />
                            <path
                                d="M133.955 139.491C133.948 139.503 134.104 139.61 134.415 139.81C134.761 140.026 135.22 140.313 135.805 140.678C137.029 141.436 138.834 142.555 141.118 144.058C145.691 147.052 152.176 151.623 159.485 158.144C163.149 161.391 167.016 165.114 171.096 169.187C175.169 173.27 179.493 177.658 183.867 182.443C188.24 187.225 192.682 192.392 196.849 198.082C198.945 200.917 200.894 203.927 202.884 206.994C204.866 210.062 206.876 213.176 208.912 216.326C217.007 228.954 224.331 241.246 230.056 252.921C235.803 264.581 239.918 275.593 242.515 285.077C245.138 294.561 246.285 302.471 246.814 307.942C247.064 310.681 247.215 312.815 247.266 314.262C247.304 314.954 247.333 315.499 247.355 315.908C247.379 316.278 247.398 316.47 247.411 316.47C247.424 316.469 247.432 316.28 247.434 315.906C247.429 315.497 247.427 314.951 247.421 314.257C247.419 312.805 247.315 310.667 247.11 307.915C246.668 302.424 245.599 294.472 243.033 284.935C240.492 275.399 236.412 264.322 230.681 252.608C224.973 240.882 217.65 228.548 209.547 215.911C207.51 212.759 205.497 209.645 203.513 206.576C201.526 203.517 199.555 200.482 197.444 197.635C193.246 191.918 188.775 186.742 184.376 181.962C179.979 177.177 175.631 172.798 171.537 168.734C167.431 164.676 163.534 160.966 159.836 157.735C152.46 151.244 145.903 146.724 141.275 143.805C138.963 142.337 137.133 141.259 135.883 140.543C135.281 140.205 134.811 139.939 134.456 139.74C134.13 139.565 133.962 139.479 133.955 139.491Z"
                                fill="white" fill-opacity="0.12" />
                            <path
                                d="M197.225 197.645C197.277 197.644 197.309 197.005 197.325 195.845C197.347 194.686 197.322 193.011 197.261 190.94C197.145 186.799 196.788 181.087 196.371 174.791C195.954 168.492 195.679 162.79 195.626 158.66C195.593 156.596 195.583 154.922 195.592 153.768C195.593 152.612 195.57 151.97 195.518 151.966C195.466 151.964 195.39 152.6 195.298 153.755C195.199 154.909 195.127 156.585 195.092 158.657C195.008 162.803 195.198 168.532 195.615 174.837C196.042 181.048 196.429 186.669 196.725 190.963C196.847 192.903 196.946 194.539 197.028 195.851C197.106 197.006 197.172 197.646 197.225 197.645Z"
                                fill="white" fill-opacity="0.12" />
                            <path
                                d="M143.361 196.81C143.369 196.862 144.126 196.822 145.486 196.704C146.845 196.594 148.811 196.425 151.248 196.295C156.117 195.994 162.857 195.814 170.301 195.939C177.748 196.079 184.482 196.493 189.345 196.932C191.779 197.134 193.743 197.352 195.102 197.493C196.46 197.641 197.215 197.697 197.224 197.645C197.231 197.592 196.49 197.436 195.14 197.198C193.79 196.966 191.83 196.667 189.397 196.393C184.534 195.814 177.782 195.313 170.312 195.172C162.845 195.047 156.082 195.312 151.207 195.754C148.768 195.955 146.804 196.206 145.451 196.409C144.097 196.617 143.355 196.756 143.361 196.81Z"
                                fill="white" fill-opacity="0.12" />
                            <path
                                d="M229.873 251.761C229.899 251.767 229.984 251.528 230.122 251.064C230.276 250.512 230.464 249.838 230.692 249.022C231.18 247.248 231.817 244.661 232.563 241.456C234.059 235.046 235.848 226.127 237.688 216.258C239.53 206.385 241.233 197.461 242.594 191.03C243.264 187.902 243.817 185.329 244.227 183.416C244.4 182.587 244.543 181.904 244.659 181.341C244.75 180.866 244.786 180.613 244.761 180.605C244.735 180.6 244.65 180.84 244.512 181.305C244.357 181.857 244.17 182.529 243.941 183.345C243.454 185.119 242.817 187.706 242.07 190.911C240.573 197.321 238.786 206.24 236.944 216.113C235.103 225.983 233.4 234.905 232.04 241.338C231.368 244.466 230.817 247.04 230.407 248.951C230.234 249.781 230.091 250.466 229.974 251.026C229.884 251.502 229.847 251.754 229.873 251.761Z"
                                fill="white" fill-opacity="0.12" />
                            <path
                                d="M156.692 241.261C156.69 241.287 156.944 241.344 157.43 241.427C158.003 241.516 158.706 241.625 159.559 241.757C161.523 242.042 164.174 242.427 167.399 242.895C174.017 243.858 183.144 245.291 193.225 246.889C203.311 248.488 212.459 249.839 219.1 250.664C222.42 251.078 225.11 251.386 226.973 251.56C227.834 251.635 228.543 251.697 229.119 251.749C229.611 251.784 229.871 251.788 229.874 251.762C229.876 251.736 229.622 251.679 229.136 251.595C228.565 251.507 227.861 251.398 227.007 251.266C225.043 250.981 222.394 250.597 219.17 250.128C212.551 249.166 203.424 247.732 193.338 246.134C183.255 244.534 174.108 243.184 167.467 242.358C164.147 241.945 161.458 241.636 159.593 241.463C158.732 241.388 158.025 241.324 157.447 241.274C156.955 241.239 156.696 241.233 156.692 241.261Z"
                                fill="white" fill-opacity="0.12" />
                            <path
                                d="M647.56 197.767C647.56 197.767 634.333 191.247 623.162 222.323C611.99 253.4 608.491 270.949 608.491 270.949C608.491 270.949 605.335 277.564 600.627 274.1C595.918 270.636 588.726 260.025 581.844 262.974C574.707 266.031 573.317 274.605 576.271 286.571C579.225 298.537 584.733 324.99 585.223 327.384C585.703 329.733 584.787 333.402 581.202 331.555C577.618 329.709 555.961 310.988 547.693 321.795C539.424 332.603 553.13 364.585 554.56 368.11C555.991 371.636 555.475 373.284 553.858 374.406C552.239 375.529 545.555 368.55 539.177 363.477C532.799 358.405 524.515 353.641 520.267 360.276C516.019 366.912 517.577 392.015 546.407 429.455L560.902 445.929L582.579 441.946C628.449 430.597 645.297 411.922 646.105 404.085C646.911 396.248 637.463 394.818 629.314 394.817C621.166 394.817 611.588 396.116 611.021 394.23C610.453 392.344 611.076 390.732 614.39 388.865C617.704 386.997 648.342 370.502 648.598 356.896C648.856 343.291 620.253 344.46 616.298 343.672C612.343 342.884 613.911 339.444 615.75 337.903C617.623 336.335 638.403 319.063 648.163 311.537C657.923 304.013 662.174 296.438 658.492 289.601C654.942 283.01 642.708 286.834 636.867 286.614C631.026 286.394 632.674 279.253 632.674 279.253C632.674 279.253 640.861 263.341 651.466 232.067C662.071 200.792 647.283 197.653 647.283 197.653"
                                fill="white" fill-opacity="0.12" />
                            <path
                                d="M637.507 225.58C637.507 225.58 637.453 225.81 637.317 226.246C637.17 226.708 636.962 227.351 636.697 228.18C636.126 229.902 635.302 232.396 634.246 235.596C632.11 242.033 628.954 251.325 625.011 262.794C617.132 285.732 605.981 317.325 593.557 352.179C581.127 387.044 569.905 418.613 561.911 441.509C557.932 452.941 554.71 462.201 552.472 468.632C551.363 471.813 550.498 474.292 549.901 476.005C549.607 476.825 549.38 477.461 549.215 477.917C549.057 478.346 548.96 478.561 548.96 478.561C548.96 478.561 549.013 478.331 549.149 477.895C549.297 477.433 549.504 476.79 549.77 475.961C550.339 474.239 551.163 471.745 552.221 468.547C554.355 462.111 557.512 452.818 561.456 441.351C569.334 418.413 580.485 386.816 592.915 351.951C605.341 317.097 616.562 285.531 624.556 262.636C628.534 251.204 631.758 241.942 633.996 235.512C635.105 232.331 635.97 229.851 636.568 228.137C636.862 227.317 637.091 226.682 637.254 226.226C637.409 225.795 637.507 225.58 637.507 225.58Z"
                                fill="white" fill-opacity="0.12" />
                            <path
                                d="M591.307 278.221C591.35 278.203 591.61 278.705 592.043 279.627C592.481 280.549 593.073 281.901 593.791 283.576C595.22 286.932 597.073 291.615 599.025 296.821C600.931 301.963 602.655 306.61 603.973 310.166C604.577 311.766 605.087 313.115 605.497 314.199C605.861 315.149 606.043 315.686 606 315.704C605.957 315.724 605.693 315.223 605.253 314.303C604.819 313.379 604.224 312.027 603.524 310.344C602.13 306.974 600.338 302.267 598.387 297.062C596.444 291.938 594.688 287.305 593.344 283.759C592.731 282.162 592.214 280.816 591.798 279.732C591.442 278.776 591.264 278.239 591.307 278.221Z"
                                fill="white" fill-opacity="0.12" />
                            <path
                                d="M608.049 315.838C607.975 315.665 617.463 311.417 629.24 306.352C641.021 301.286 650.628 297.32 650.702 297.493C650.776 297.665 641.289 301.912 629.508 306.978C617.733 312.043 608.123 316.01 608.049 315.838Z"
                                fill="white" fill-opacity="0.12" />
                            <path
                                d="M586.55 368.508C586.546 368.462 587.115 368.365 588.146 368.231C589.318 368.087 590.78 367.906 592.517 367.692C596.205 367.232 601.296 366.573 606.887 365.643C612.482 364.724 617.515 363.716 621.154 362.958C622.868 362.603 624.31 362.303 625.466 362.063C626.486 361.857 627.055 361.765 627.067 361.811C627.078 361.856 626.53 362.036 625.528 362.321C624.527 362.606 623.07 362.993 621.261 363.428C617.643 364.309 612.61 365.395 606.999 366.317C601.393 367.251 596.278 367.834 592.57 368.173C590.715 368.335 589.213 368.449 588.172 368.497C587.13 368.549 586.554 368.555 586.55 368.508Z"
                                fill="white" fill-opacity="0.12" />
                            <path
                                d="M563.919 337.818C563.957 337.789 564.313 338.186 564.926 338.927C565.618 339.792 566.467 340.854 567.47 342.106C569.595 344.808 571.655 349.65 575.657 352.75C578.825 356.932 581.66 360.74 583.686 363.517C584.62 364.821 585.412 365.927 586.056 366.827C586.605 367.618 586.89 368.069 586.852 368.097C586.814 368.126 586.458 367.729 585.845 366.988C585.153 366.124 584.304 365.061 583.301 363.809C581.177 361.107 578.28 357.345 575.113 353.162C571.947 348.983 569.111 345.174 567.085 342.398C566.151 341.094 565.359 339.989 564.715 339.088C564.167 338.296 563.882 337.846 563.919 337.818Z"
                                fill="white" fill-opacity="0.12" />
                            <path
                                d="M539.032 381.905C539.069 381.877 539.52 382.388 540.306 383.338C541.159 384.397 542.259 385.762 543.581 387.401C546.323 390.85 550.072 395.643 554.181 400.961C558.29 406.282 561.981 411.122 564.625 414.646C565.877 416.338 566.92 417.747 567.728 418.841C568.448 419.84 568.829 420.407 568.792 420.435C568.754 420.464 568.303 419.953 567.518 419.003C566.665 417.944 565.564 416.58 564.243 414.941C561.501 411.493 557.751 406.7 553.64 401.379C549.532 396.06 545.842 391.221 543.199 387.697C541.947 386.004 540.903 384.596 540.095 383.502C539.375 382.5 538.994 381.934 539.032 381.905Z"
                                fill="white" fill-opacity="0.12" />
                            <path
                                d="M568.341 419.312C568.334 419.265 569.052 419.124 570.355 418.908C571.778 418.68 573.634 418.384 575.872 418.025C580.528 417.274 586.955 416.211 594.017 414.839C601.083 413.477 607.445 412.075 612.045 411.029C614.254 410.527 616.088 410.111 617.493 409.794C618.781 409.507 619.499 409.37 619.511 409.415C619.522 409.461 618.827 409.685 617.558 410.05C616.289 410.416 614.445 410.917 612.157 411.498C607.582 412.666 601.224 414.144 594.147 415.509C587.073 416.884 580.622 417.873 575.943 418.503C573.603 418.811 571.707 419.042 570.392 419.173C569.076 419.306 568.346 419.358 568.341 419.312Z"
                                fill="white" fill-opacity="0.12" />
                            <path
                                d="M653.802 643.104C653.802 643.29 527.668 643.441 372.108 643.441C216.494 643.441 90.3857 643.289 90.3857 643.104C90.3857 642.917 216.493 642.767 372.108 642.767C527.666 642.765 653.802 642.917 653.802 643.104Z"
                                fill="white" fill-opacity="0.7" />
                            <path
                                d="M537.784 496H268.167C259.239 496 252 489.93 252 482.44V165.671C252 158.183 259.239 152.111 268.167 152.111H537.784C546.712 152.111 553.951 158.183 553.951 165.671V482.44C553.951 489.93 546.712 496 537.784 496Z"
                                fill="#0CAF60" />
                            <path class="theme-color" opacity="0.8"
                                d="M537.784 496H268.167C259.239 496 252 489.93 252 482.44V165.671C252 158.183 259.239 152.111 268.167 152.111H537.784C546.712 152.111 553.951 158.183 553.951 165.671V482.44C553.951 489.93 546.712 496 537.784 496Z"
                                fill="white" />
                            <path
                                d="M443.912 238.855C443.912 251.497 438.14 262.793 429.078 270.262C422.064 276.013 413.085 279.489 403.278 279.489C393.492 279.489 384.513 276.034 377.499 270.262C368.438 262.814 362.645 251.517 362.645 238.855C362.645 216.428 380.851 198.242 403.278 198.242C425.726 198.242 443.912 216.428 443.912 238.855Z"
                                fill="#407BFF" />
                            <path class="theme-color"
                                d="M443.912 238.855C443.912 251.497 438.14 262.793 429.078 270.262C422.064 276.013 413.085 279.489 403.278 279.489C393.492 279.489 384.513 276.034 377.499 270.262C368.438 262.814 362.645 251.517 362.645 238.855C362.645 216.428 380.851 198.242 403.278 198.242C425.726 198.242 443.912 216.428 443.912 238.855Z"
                                fill="#78BF9C" />
                            <path
                                d="M403.28 249.589C411.316 249.589 417.831 243.074 417.831 235.038C417.831 227.002 411.316 220.488 403.28 220.488C395.244 220.488 388.729 227.002 388.729 235.038C388.729 243.074 395.244 249.589 403.28 249.589Z"
                                fill="white" />
                            <path
                                d="M429.077 270.262C422.064 276.013 413.085 279.489 403.278 279.489C393.492 279.489 384.513 276.034 377.499 270.262C381.306 259.11 389.147 250.876 398.561 248.786C400.092 248.455 401.664 248.269 403.278 248.269C404.892 248.269 406.464 248.455 407.995 248.786C417.429 250.876 425.25 259.11 429.077 270.262Z"
                                fill="white" />
                            <path
                                d="M485.131 329.756H321.427C312.088 329.756 304.516 322.183 304.516 312.844C304.516 303.505 312.088 295.933 321.427 295.933H485.131C494.47 295.933 502.042 303.505 502.042 312.844C502.042 322.183 494.472 329.756 485.131 329.756Z"
                                fill="white" />
                            <path
                                d="M485.131 377.722H321.427C312.088 377.722 304.516 370.149 304.516 360.81C304.516 351.471 312.088 343.899 321.427 343.899H485.131C494.47 343.899 502.042 351.471 502.042 360.81C502.042 370.149 494.472 377.722 485.131 377.722Z"
                                fill="white" />
                            <circle cx="322.594" cy="313.571" r="3.49481" fill="#999999" />
                            <circle cx="333.778" cy="313.571" r="3.49481" fill="#999999" />
                            <circle cx="344.962" cy="313.571" r="3.49481" fill="#999999" />
                            <circle cx="356.145" cy="313.571" r="3.49481" fill="#999999" />
                            <circle cx="367.328" cy="313.571" r="3.49481" fill="#999999" />
                            <circle cx="378.511" cy="313.571" r="3.49481" fill="#999999" />
                            <circle cx="389.695" cy="313.571" r="3.49481" fill="#999999" />
                            <circle cx="400.879" cy="313.571" r="3.49481" fill="#999999" />
                            <circle cx="412.061" cy="313.571" r="3.49481" fill="#999999" />
                            <circle cx="423.245" cy="313.571" r="3.49481" fill="#999999" />
                            <circle cx="434.428" cy="313.571" r="3.49481" fill="#999999" />
                            <circle cx="322.594" cy="361.1" r="3.49481" fill="#999999" />
                            <circle cx="333.778" cy="361.1" r="3.49481" fill="#999999" />
                            <circle cx="344.962" cy="361.1" r="3.49481" fill="#999999" />
                            <circle cx="356.145" cy="361.1" r="3.49481" fill="#999999" />
                            <circle cx="367.328" cy="361.1" r="3.49481" fill="#999999" />
                            <circle cx="378.511" cy="361.1" r="3.49481" fill="#999999" />
                            <path opacity="0.2"
                                d="M469.348 306.655V319.465H486.962V306.655H469.348ZM484.088 308.051L478.157 312.216L472.224 308.051H484.088ZM470.703 318.069V308.672L478.155 313.904L485.607 308.672V318.069H470.703Z"
                                fill="black" />
                            <g opacity="0.2">
                                <path
                                    d="M482.304 359.181V357.814C482.304 356.094 480.905 354.695 479.185 354.695H477.487C475.767 354.695 474.368 356.094 474.368 357.814V359.181H471.804V368.531H485.275V359.181H482.304ZM475.595 357.813C475.595 356.768 476.444 355.92 477.488 355.92H479.186C480.231 355.92 481.079 356.768 481.079 357.813V359.18H475.595V357.813ZM484.049 367.303H473.029V360.406H484.049V367.303Z"
                                    fill="black" />
                                <path
                                    d="M478.185 364.23V365.34H478.892V364.23C479.094 364.108 479.237 363.896 479.237 363.642C479.237 363.257 478.925 362.945 478.539 362.945C478.154 362.945 477.842 363.257 477.842 363.642C477.842 363.896 477.982 364.108 478.185 364.23Z"
                                    fill="black" />
                            </g>
                            <path class="theme-color"
                                d="M484.339 449.09H320.635C311.296 449.09 303.724 441.52 303.724 432.179C303.724 422.84 311.296 415.268 320.635 415.268H484.339C493.678 415.268 501.25 422.84 501.25 432.179C501.25 441.52 493.68 449.09 484.339 449.09Z"
                                fill="#0CAF60" />
                            <rect x="359.641" y="425.053" width="88.0691" height="12.5813" rx="5.5" fill="white" />
                            <rect class="theme-color" x="418.354" y="384.513" width="72.692" height="5.59169" rx="2"
                                fill="#0CAF60" fill-opacity="0.4" />
                            <path
                                d="M118.397 627.309L116.716 636.841L118.134 637.155C124.454 638.492 150.363 643.51 154.823 642.877C159.799 642.169 140.853 634.72 140.853 634.72L141.447 630.693L118.397 627.309Z"
                                fill="#FFA21D" />
                            <g opacity="0.5">
                                <path
                                    d="M125.121 637.952C125.09 635.972 124.293 634.012 122.933 632.572C121.574 631.132 119.768 630.204 117.792 630.059L116.79 636.515L125.121 637.952Z"
                                    fill="white" />
                            </g>
                            <g opacity="0.5">
                                <path
                                    d="M150.058 638.701C150.058 638.701 156.631 641.747 155.598 642.747C154.565 643.748 128.192 639.661 116.716 636.841L116.832 636.331L147.555 641.359C147.555 641.359 148.705 638.549 150.058 638.701Z"
                                    fill="white" />
                            </g>
                            <path
                                d="M116.472 636.261C116.47 636.271 116.604 636.306 116.862 636.366C117.201 636.44 117.572 636.52 117.992 636.611C119.125 636.836 120.518 637.115 122.162 637.441C125.689 638.118 130.572 638.989 135.987 639.832C141.403 640.675 146.321 641.331 149.885 641.758C151.551 641.946 152.962 642.104 154.11 642.234C154.538 642.274 154.915 642.31 155.261 642.344C155.524 642.366 155.663 642.373 155.664 642.364C155.665 642.353 155.528 642.329 155.267 642.287C154.924 642.238 154.547 642.185 154.123 642.125C152.979 641.971 151.571 641.783 149.91 641.56C146.352 641.082 141.442 640.395 136.03 639.554C130.619 638.71 125.733 637.872 122.199 637.246C120.549 636.953 119.151 636.705 118.013 636.503C117.59 636.432 117.214 636.368 116.872 636.31C116.612 636.267 116.474 636.25 116.472 636.261Z"
                                fill="#263238" />
                            <path
                                d="M147.493 641.717C147.577 641.74 147.797 640.749 148.588 639.834C149.362 638.906 150.305 638.527 150.269 638.448C150.262 638.376 149.206 638.658 148.373 639.651C147.528 640.633 147.422 641.723 147.493 641.717Z"
                                fill="#263238" />
                            <path
                                d="M141.214 637.203C141.272 637.255 141.66 636.909 142.08 636.429C142.498 635.951 142.791 635.521 142.731 635.469C142.673 635.417 142.286 635.763 141.866 636.242C141.446 636.722 141.154 637.151 141.214 637.203Z"
                                fill="#263238" />
                            <path
                                d="M139.497 635.925C139.54 635.991 139.943 635.803 140.395 635.508C140.849 635.212 141.182 634.919 141.139 634.853C141.096 634.787 140.694 634.974 140.241 635.271C139.787 635.566 139.454 635.859 139.497 635.925Z"
                                fill="#263238" />
                            <path
                                d="M138.652 633.561C138.639 633.639 139.167 633.79 139.832 633.902C140.497 634.013 141.048 634.039 141.06 633.963C141.073 633.885 140.544 633.733 139.878 633.622C139.214 633.512 138.665 633.485 138.652 633.561Z"
                                fill="#263238" />
                            <path
                                d="M138.484 631.961C138.448 632.025 138.995 632.382 139.768 632.561C140.542 632.743 141.19 632.666 141.186 632.59C141.186 632.509 140.568 632.458 139.833 632.285C139.097 632.116 138.52 631.888 138.484 631.961Z"
                                fill="#263238" />
                            <path
                                d="M142.309 635.309C142.302 635.34 142.861 635.499 143.795 635.53C144.26 635.545 144.818 635.521 145.429 635.426C145.735 635.368 146.049 635.338 146.392 635.194C146.554 635.119 146.738 635.006 146.832 634.79C146.928 634.577 146.847 634.309 146.698 634.161C145.393 633.206 143.848 633.784 143.208 634.436C142.859 634.765 142.672 635.11 142.57 635.351C142.472 635.596 142.454 635.741 142.469 635.746C142.519 635.773 142.66 635.177 143.342 634.585C143.677 634.295 144.158 634.037 144.737 633.958C145.286 633.884 146.039 633.958 146.488 634.352C146.697 634.563 146.562 634.826 146.276 634.941C146.007 635.061 145.676 635.109 145.385 635.168C144.793 635.274 144.251 635.318 143.795 635.329C142.881 635.35 142.316 635.264 142.309 635.309Z"
                                fill="#263238" />
                            <path
                                d="M142.682 635.443C142.7 635.462 142.979 635.118 143.013 634.439C143.027 634.105 142.967 633.699 142.775 633.292C142.564 632.922 142.297 632.416 141.657 632.343C141.306 632.334 141.078 632.699 141.093 632.957C141.08 633.222 141.162 633.463 141.242 633.66C141.406 634.064 141.609 634.404 141.805 634.667C142.2 635.193 142.541 635.425 142.562 635.399C142.593 635.366 142.308 635.087 141.971 634.554C141.803 634.287 141.628 633.955 141.487 633.566C141.332 633.22 141.28 632.636 141.662 632.627C142.039 632.649 142.361 633.076 142.542 633.408C142.726 633.766 142.801 634.131 142.813 634.439C142.832 635.061 142.634 635.424 142.682 635.443Z"
                                fill="#263238" />
                            <path
                                d="M117.923 630.013C117.92 630.066 118.594 630.052 119.619 630.337C120.635 630.611 122.008 631.259 123.104 632.448C124.199 633.639 124.731 635.061 124.921 636.096C125.121 637.141 125.051 637.812 125.104 637.813C125.121 637.815 125.156 637.65 125.177 637.348C125.199 637.046 125.195 636.603 125.118 636.064C124.974 634.992 124.453 633.499 123.312 632.257C122.169 631.017 120.724 630.376 119.667 630.144C119.136 630.023 118.695 629.982 118.392 629.979C118.09 629.975 117.923 629.996 117.923 630.013Z"
                                fill="#263238" />
                            <path
                                d="M128.375 636.151C128.354 636.222 129.822 636.701 131.696 637.007C133.57 637.318 135.113 637.334 135.116 637.26C135.121 637.177 133.598 637.036 131.741 636.727C129.885 636.425 128.397 636.071 128.375 636.151Z"
                                fill="#263238" />
                            <path
                                d="M123.85 635.443C123.785 635.491 123.924 635.781 124.023 636.152C124.13 636.521 124.161 636.841 124.241 636.849C124.316 636.861 124.416 636.503 124.297 636.077C124.179 635.648 123.908 635.395 123.85 635.443Z"
                                fill="#263238" />
                            <path
                                d="M122.472 633.054C122.408 633.1 122.52 633.364 122.722 633.643C122.923 633.923 123.138 634.112 123.202 634.065C123.265 634.02 123.154 633.757 122.951 633.477C122.751 633.198 122.535 633.009 122.472 633.054Z"
                                fill="#263238" />
                            <path
                                d="M120.181 631.707C120.185 631.787 120.492 631.832 120.813 632.005C121.137 632.169 121.351 632.395 121.42 632.352C121.489 632.32 121.345 631.961 120.944 631.753C120.546 631.543 120.169 631.631 120.181 631.707Z"
                                fill="#263238" />
                            <path
                                d="M118.514 630.98C118.476 631.047 118.59 631.187 118.77 631.291C118.95 631.394 119.127 631.424 119.166 631.357C119.205 631.289 119.091 631.149 118.911 631.046C118.732 630.941 118.553 630.912 118.514 630.98Z"
                                fill="#263238" />
                            <path
                                d="M239.959 635.458L240.826 645.098L242.276 645.029C248.726 644.67 275.047 642.75 279.188 640.973C283.805 638.99 263.572 636.747 263.572 636.747L263.095 632.703L239.959 635.458Z"
                                fill="#FFA21D" />
                            <g opacity="0.5">
                                <path
                                    d="M249.229 643.977C248.682 642.073 247.402 640.39 245.712 639.354C244.023 638.319 242.039 637.895 240.094 638.271L240.813 644.764L249.229 643.977Z"
                                    fill="white" />
                            </g>
                            <g opacity="0.5">
                                <path
                                    d="M273.497 638.187C273.497 638.187 280.638 639.41 279.902 640.646C279.166 641.881 252.641 644.825 240.826 645.098L240.806 644.575L271.775 641.407C271.775 641.407 272.152 638.394 273.497 638.187Z"
                                    fill="white" />
                            </g>
                            <path
                                d="M240.439 644.602C240.441 644.612 240.579 644.611 240.844 644.6C241.191 644.584 241.57 644.564 241.999 644.542C243.152 644.464 244.569 644.368 246.242 644.256C249.823 643.989 254.764 643.553 260.21 642.955C265.657 642.353 270.577 641.703 274.129 641.184C275.785 640.93 277.19 640.715 278.332 640.54C278.754 640.467 279.129 640.404 279.471 640.346C279.732 640.298 279.866 640.268 279.865 640.259C279.864 640.25 279.725 640.26 279.462 640.289C279.117 640.331 278.74 640.378 278.315 640.431C277.169 640.582 275.762 640.767 274.1 640.986C270.542 641.454 265.622 642.073 260.178 642.673C254.734 643.272 249.799 643.739 246.224 644.057C244.554 644.205 243.14 644.331 241.989 644.433C241.562 644.475 241.185 644.511 240.839 644.545C240.576 644.572 240.438 644.591 240.439 644.602Z"
                                fill="#263238" />
                            <path
                                d="M271.809 641.769C271.896 641.77 271.851 640.754 272.374 639.665C272.88 638.568 273.691 637.956 273.634 637.89C273.609 637.821 272.662 638.369 272.118 639.545C271.559 640.714 271.74 641.793 271.809 641.769Z"
                                fill="#263238" />
                            <path
                                d="M264.569 639.051C264.639 639.086 264.923 638.649 265.203 638.079C265.483 637.507 265.652 637.016 265.581 636.983C265.511 636.948 265.227 637.383 264.947 637.955C264.667 638.525 264.498 639.017 264.569 639.051Z"
                                fill="#263238" />
                            <path
                                d="M262.577 638.266C262.635 638.317 262.975 638.032 263.335 637.628C263.695 637.224 263.94 636.854 263.882 636.802C263.824 636.751 263.484 637.036 263.124 637.44C262.764 637.843 262.519 638.212 262.577 638.266Z"
                                fill="#263238" />
                            <path
                                d="M261.145 636.205C261.152 636.283 261.703 636.292 262.373 636.226C263.045 636.158 263.582 636.042 263.575 635.964C263.567 635.886 263.016 635.877 262.346 635.943C261.675 636.009 261.137 636.126 261.145 636.205Z"
                                fill="#263238" />
                            <path
                                d="M260.564 634.703C260.546 634.775 261.167 634.976 261.96 634.947C262.754 634.921 263.359 634.676 263.336 634.606C263.314 634.527 262.705 634.639 261.951 634.664C261.196 634.693 260.581 634.623 260.564 634.703Z"
                                fill="#263238" />
                            <path
                                d="M265.131 636.937C265.132 636.968 265.713 636.975 266.623 636.762C267.076 636.656 267.608 636.486 268.173 636.236C268.453 636.1 268.748 635.988 269.041 635.76C269.177 635.645 269.326 635.488 269.358 635.256C269.395 635.026 269.248 634.787 269.066 634.685C267.557 634.104 266.217 635.064 265.769 635.861C265.518 636.271 265.426 636.652 265.391 636.911C265.36 637.173 265.381 637.318 265.398 637.319C265.452 637.332 265.434 636.721 265.937 635.97C266.186 635.602 266.581 635.228 267.12 635C267.63 634.785 268.376 634.66 268.913 634.923C269.169 635.072 269.107 635.361 268.862 635.548C268.634 635.733 268.327 635.865 268.062 635.999C267.519 636.255 267.008 636.441 266.569 636.569C265.695 636.827 265.126 636.891 265.131 636.937Z"
                                fill="#263238" />
                            <path
                                d="M265.526 636.968C265.55 636.983 265.727 636.577 265.583 635.913C265.511 635.588 265.346 635.21 265.055 634.867C264.754 634.565 264.365 634.147 263.728 634.244C263.387 634.327 263.261 634.739 263.344 634.984C263.4 635.242 263.542 635.455 263.672 635.623C263.935 635.972 264.22 636.245 264.477 636.449C264.995 636.854 265.385 636.988 265.398 636.958C265.42 636.919 265.072 636.723 264.606 636.296C264.376 636.082 264.12 635.807 263.882 635.469C263.642 635.176 263.439 634.625 263.805 634.515C264.175 634.437 264.597 634.768 264.859 635.04C265.13 635.337 265.298 635.67 265.389 635.964C265.572 636.56 265.476 636.963 265.526 636.968Z"
                                fill="#263238" />
                            <path
                                d="M240.208 638.192C240.218 638.243 240.866 638.054 241.93 638.062C242.983 638.062 244.477 638.329 245.847 639.19C247.216 640.054 248.099 641.286 248.554 642.236C249.02 643.193 249.128 643.859 249.179 643.846C249.196 643.844 249.185 643.675 249.127 643.377C249.07 643.079 248.95 642.653 248.734 642.152C248.316 641.156 247.423 639.851 245.996 638.949C244.568 638.05 243.006 637.808 241.927 637.86C241.382 637.882 240.946 637.957 240.653 638.035C240.36 638.113 240.204 638.175 240.208 638.192Z"
                                fill="#263238" />
                            <path
                                d="M251.901 641.388C251.9 641.461 253.441 641.542 255.331 641.347C257.221 641.158 258.714 640.771 258.698 640.698C258.681 640.618 257.175 640.878 255.302 641.065C253.429 641.258 251.901 641.305 251.901 641.388Z"
                                fill="#263238" />
                            <path
                                d="M247.347 641.885C247.297 641.949 247.507 642.192 247.701 642.524C247.9 642.852 248.014 643.154 248.093 643.14C248.168 643.131 248.172 642.759 247.945 642.379C247.719 641.998 247.392 641.823 247.347 641.885Z"
                                fill="#263238" />
                            <path
                                d="M245.394 639.94C245.345 640.001 245.521 640.226 245.789 640.443C246.056 640.659 246.313 640.786 246.362 640.725C246.411 640.664 246.235 640.44 245.967 640.222C245.7 640.006 245.443 639.879 245.394 639.94Z"
                                fill="#263238" />
                            <path
                                d="M242.831 639.236C242.856 639.313 243.164 639.276 243.519 639.358C243.876 639.432 244.14 639.595 244.195 639.536C244.253 639.486 244.02 639.177 243.579 639.082C243.14 638.985 242.799 639.168 242.831 639.236Z"
                                fill="#263238" />
                            <path
                                d="M241.032 638.971C241.011 639.046 241.159 639.151 241.36 639.204C241.561 639.257 241.741 639.239 241.761 639.164C241.781 639.089 241.634 638.984 241.433 638.93C241.232 638.876 241.052 638.894 241.032 638.971Z"
                                fill="#263238" />
                            <path
                                d="M246.728 269.865C244.868 259.948 233.914 254.438 229.636 245.3C227.971 241.744 227.379 237.742 225.546 234.27C221.619 226.833 211.7 223.236 203.918 226.425L203.235 227.488C207.656 236.788 212.077 243.175 216.496 252.476C218.045 255.734 219.615 259.068 220.022 262.652C220.429 266.237 219.468 270.182 216.69 272.484C214.469 274.324 211.442 274.878 209.048 276.486C205.393 278.942 203.702 283.69 204.162 288.069C204.621 292.449 206.956 296.456 209.924 299.709C212.776 302.835 217.296 305.512 221.055 303.571C222.953 302.591 224.131 300.667 225.532 299.054C228.406 295.747 232.378 293.641 235.915 291.055C242.673 286.114 248.271 278.092 246.728 269.865Z"
                                fill="#263238" />
                            <path
                                d="M342.031 315.926C339.549 318.19 326 329.566 326 329.566L312.565 317.338C312.915 316.335 316.201 310.695 316.583 309.275C316.911 308.055 317.017 306.788 316.919 305.529C316.799 304.003 316.557 301.981 316.08 300.915C315.49 299.597 316.811 298.248 317.95 298.898C319.089 299.548 320.802 303.142 320.75 307.792C320.697 312.442 338.952 301.768 341.55 304.378L342.031 315.926Z"
                                fill="#FFBE9D" />
                            <path
                                d="M226.491 297.661L271.083 351.023L312.021 314.001L329.877 331.422C329.877 331.422 278.487 387.965 270.647 387.566C262.808 387.168 236.179 369.557 236.179 369.557L226.491 297.661Z"
                                fill="#FFA21D" />
                            <path
                                d="M327.69 289.721C327.32 289.597 326.92 289.784 326.776 290.144L314.662 320.701C314.43 321.27 314.683 321.921 315.236 322.185L329.63 329.046C330.223 329.329 330.933 329.062 331.194 328.458L344.815 296.78C345.082 296.159 344.764 295.444 344.124 295.225L327.69 289.721Z"
                                fill="#263238" />
                            <path d="M327.298 291.926L316.155 319.193L331.232 326.016L342.646 297.106L327.298 291.926Z"
                                fill="#F5F5F5" />
                            <path
                                d="M322.951 339.37C322.898 339.439 321.668 338.608 319.785 337.123C317.902 335.639 315.383 333.483 312.76 330.929C310.138 328.374 307.915 325.91 306.383 324.067C304.85 322.224 303.987 321.016 304.054 320.962C304.131 320.898 305.124 321.997 306.742 323.752C308.361 325.508 310.625 327.905 313.231 330.446C315.839 332.984 318.294 335.184 320.091 336.756C321.887 338.328 323.011 339.291 322.951 339.37Z"
                                fill="#263238" />
                            <path
                                d="M310.143 319.22C310.226 319.293 309.677 319.733 309.736 320.681C309.767 321.129 309.959 321.684 310.404 322.016C310.831 322.359 311.525 322.364 312.105 322.032C312.685 321.699 313.029 321.097 312.948 320.554C312.884 320.004 312.502 319.557 312.131 319.304C311.342 318.776 310.685 319.028 310.664 318.921C310.65 318.888 310.778 318.764 311.083 318.693C311.383 318.619 311.863 318.637 312.371 318.892C312.861 319.149 313.418 319.659 313.563 320.466C313.725 321.281 313.216 322.187 312.441 322.617C311.679 323.069 310.639 323.052 310.017 322.502C309.394 321.97 309.235 321.232 309.259 320.679C309.296 320.112 309.521 319.688 309.736 319.465C309.95 319.24 310.122 319.19 310.143 319.22Z"
                                fill="#263238" />
                            <path
                                d="M269.328 366.607C269.249 366.628 268.926 365.762 268.671 364.295C268.413 362.832 268.273 360.758 268.526 358.493C268.786 356.227 269.386 354.237 269.966 352.868C270.544 351.496 271.052 350.725 271.124 350.762C271.323 350.846 269.674 354.14 269.197 358.568C268.67 362.99 269.541 366.569 269.328 366.607Z"
                                fill="#263238" />
                            <path
                                d="M275.678 366.203C275.61 366.249 275.007 365.52 274.236 364.203C273.465 362.89 272.564 360.966 271.911 358.725C271.263 356.482 270.993 354.374 270.941 352.853C270.887 351.329 271.006 350.39 271.089 350.392C271.303 350.385 271.263 354.149 272.559 358.537C273.813 362.936 275.862 366.093 275.678 366.203Z"
                                fill="#263238" />
                            <path d="M327.559 297.009L320.187 315.344L331.231 319.862L338.928 301.121L327.559 297.009Z"
                                fill="#EBEBEB" />
                            <path
                                d="M329.794 317.13L323.27 314.403C322.786 314.201 322.558 313.646 322.76 313.163L322.886 312.863C323.088 312.38 323.643 312.152 324.126 312.354L330.65 315.081C331.134 315.283 331.362 315.838 331.16 316.321L331.035 316.62C330.833 317.103 330.277 317.331 329.794 317.13Z"
                                fill="#FFA21D" />
                            <path d="M336.549 303.111L328.364 300.029L327.914 301.224L336.099 304.305L336.549 303.111Z"
                                fill="#455A64" />
                            <path d="M335.432 307.236L326.381 303.828L325.499 306.169L334.55 309.577L335.432 307.236Z"
                                fill="#E0E0E0" />
                            <path d="M333.939 311L324.888 307.592L324.006 309.932L333.057 313.34L333.939 311Z"
                                fill="#E0E0E0" />
                            <path
                                d="M341.55 304.378C339.467 304.72 336.923 304.927 334.839 305.269C334.249 305.366 333.634 305.473 333.156 305.831C332.677 306.189 332.391 306.882 332.682 307.403C333.016 307.998 333.836 308.05 334.516 308.028C336.048 307.979 337.581 307.928 339.115 307.879C337.16 308.046 335.185 308.217 333.328 308.846C332.463 309.139 331.502 309.713 331.484 310.624C331.468 311.409 332.229 312.035 333.005 312.148C333.782 312.261 335.418 312.185 335.418 312.185C335.418 312.185 338.566 312.231 338.702 312.642C336.738 312.627 334.14 313.052 332.178 313.227C331.642 313.275 331.396 314.009 331.267 314.532C331.139 315.056 331.34 315.692 331.835 315.906C332.076 316.01 332.347 316.003 332.609 315.996C335.149 315.917 337.689 315.839 340.229 315.76"
                                fill="#FFBE9D" />
                            <path
                                d="M210.715 294.478C210.715 294.478 219.988 293.388 226.491 297.661C232.371 301.525 252.966 360.576 252.171 378.097C251.377 395.619 253.602 426.512 257.207 439.247C260.813 451.98 263.54 562.406 235.125 614.951L182.319 607.537L198.823 465.723L197.137 337.066L210.715 294.478Z"
                                fill="#FFA21D" />
                            <g opacity="0.3">
                                <path
                                    d="M207.679 294.478C207.679 294.478 216.952 293.388 223.455 297.661C229.335 301.525 249.93 360.576 249.135 378.097C248.341 395.619 250.566 426.512 254.172 439.247C257.777 451.98 260.504 562.406 232.089 614.951L183.822 607.537L195.787 465.723L194.101 337.066L207.679 294.478Z"
                                    fill="black" />
                            </g>
                            <path
                                d="M188.254 291.762C188.254 291.762 159.212 288.627 166.979 330.144L174.442 373.821L221.864 402.51C228.27 404.238 222.824 372.653 232.469 358.107C236.085 352.653 236.398 348.569 236.085 346.053C236.997 336.535 229.371 330.593 228.285 320.963C227.093 307.018 227.146 299.293 221.08 297.735L188.254 291.762Z"
                                fill="#455A64" />
                            <path
                                d="M228.832 317.651C228.974 317.655 227.92 320.008 228.825 323.772C229.244 325.635 230.145 327.735 231.367 329.967C232.556 332.211 234.075 334.618 235.069 337.456C237.097 343.152 236.48 348.822 235.271 352.494C234.672 354.353 233.972 355.776 233.423 356.715C232.865 357.649 232.501 358.129 232.469 358.107C232.338 358.038 233.748 356.046 234.815 352.355C235.883 348.718 236.4 343.204 234.432 337.68C233.473 334.934 231.988 332.537 230.818 330.256C229.616 327.99 228.729 325.801 228.359 323.87C227.97 321.943 228.049 320.319 228.284 319.25C228.392 318.712 228.526 318.306 228.634 318.041C228.743 317.776 228.81 317.643 228.832 317.651Z"
                                fill="#263238" />
                            <path
                                d="M214.291 294.75C213.611 287.606 213.024 280.072 213.024 280.072C213.024 280.072 222.075 277.638 222.799 265.445C223.49 253.818 219.974 233.568 219.974 233.568V232.542C206.2 228.444 189.893 228.608 181.493 240.136L187.981 298.072C188.734 304.798 195.117 309.507 202.312 308.646C209.58 307.777 214.94 301.557 214.291 294.75Z"
                                fill="#FFBE9D" />
                            <path
                                d="M219.962 248.276C220.071 249.086 219.475 249.847 218.63 249.975C217.788 250.103 217.015 249.554 216.906 248.742C216.798 247.932 217.394 247.172 218.236 247.042C219.081 246.914 219.853 247.466 219.962 248.276Z"
                                fill="#263238" />
                            <path
                                d="M219.957 246.581C219.786 246.8 218.534 246.052 216.878 246.219C215.222 246.363 214.089 247.335 213.889 247.15C213.792 247.068 213.952 246.687 214.443 246.249C214.926 245.813 215.779 245.353 216.811 245.256C217.844 245.16 218.748 245.454 219.286 245.794C219.834 246.136 220.042 246.482 219.957 246.581Z"
                                fill="#263238" />
                            <path
                                d="M202.734 250.513C202.843 251.323 202.247 252.084 201.402 252.212C200.559 252.34 199.787 251.791 199.678 250.979C199.569 250.169 200.165 249.409 201.008 249.279C201.853 249.151 202.625 249.703 202.734 250.513Z"
                                fill="#263238" />
                            <path
                                d="M202.729 248.884C202.558 249.103 201.305 248.355 199.65 248.522C197.993 248.666 196.861 249.638 196.661 249.453C196.564 249.371 196.721 248.99 197.215 248.552C197.698 248.116 198.549 247.656 199.582 247.559C200.615 247.463 201.52 247.757 202.058 248.097C202.603 248.439 202.813 248.785 202.729 248.884Z"
                                fill="#263238" />
                            <path
                                d="M209.951 260.579C209.934 260.485 210.946 260.205 212.595 259.828C213.013 259.743 213.406 259.62 213.449 259.324C213.519 259.009 213.296 258.57 213.043 258.098C212.544 257.113 212.023 256.082 211.475 254.999C209.286 250.584 207.657 246.936 207.836 246.85C208.015 246.763 209.934 250.273 212.122 254.688C212.65 255.778 213.157 256.816 213.639 257.812C213.847 258.277 214.176 258.795 214.022 259.45C213.939 259.778 213.651 260.037 213.386 260.137C213.123 260.246 212.886 260.274 212.678 260.308C211.007 260.563 209.966 260.672 209.951 260.579Z"
                                fill="#263238" />
                            <path
                                d="M213.025 280.072C213.025 280.072 205 281.387 196.525 277.365C196.525 277.365 201.238 285.227 213.143 282.922L213.025 280.072Z"
                                fill="#EB996E" />
                            <path
                                d="M209.644 264.64C208.97 263.911 207.884 263.582 206.859 263.795C206.147 263.943 205.455 264.362 205.076 264.99C204.696 265.619 204.687 266.459 205.139 266.978C205.648 267.563 206.597 267.616 207.366 267.314C208.134 267.011 208.764 266.424 209.359 265.842C209.523 265.681 209.692 265.513 209.784 265.305C209.876 265.098 209.875 264.837 209.72 264.688"
                                fill="#FFA21D" />
                            <path
                                d="M205.187 262.205C205.456 262.162 205.636 263.961 207.3 265.086C208.963 266.215 210.86 265.825 210.899 266.075C210.935 266.185 210.506 266.466 209.699 266.568C208.908 266.673 207.724 266.533 206.705 265.844C205.689 265.154 205.182 264.149 205.049 263.417C204.906 262.672 205.063 262.207 205.187 262.205Z"
                                fill="#263238" />
                            <path
                                d="M157.415 457.984L139.004 533.868C139.004 533.868 117.04 624.751 116.35 627.146L115.654 629.978L146.595 632.309L200.168 463.729L157.415 457.984Z"
                                fill="#263238" />
                            <path
                                d="M213.105 511.254C218.113 535.46 236.472 636.98 236.472 636.98L267.847 633.762L250.002 504.276C249.718 500.896 249.034 497.561 247.96 494.343L218.627 406.409L163.431 371.323C162.884 371.352 154.495 393.981 155.704 409.697C156.244 416.722 158.764 423.452 162.746 429.265C166.256 434.387 171.142 441.528 172.233 443.176C173.98 445.812 213.105 511.254 213.105 511.254Z"
                                fill="#263238" />
                            <path
                                d="M150.371 401.803C148.856 407.27 147.603 412.802 146.632 418.393C143.102 438.72 134.136 488.198 128.322 501.28C120.951 517.866 108.972 580.527 112.658 592.045C116.343 603.564 196.513 615.083 196.513 615.083C196.513 615.083 201.12 539.982 205.727 521.092C210.335 502.201 220.011 460.734 221.392 436.315C222.775 411.896 222.313 369.508 214.48 343.245C206.647 316.983 188.632 289.403 188.632 289.403C188.632 289.403 173.238 293.646 167.993 299.752C167.993 299.752 161.586 307.607 161.456 315.081C161.328 322.555 157.91 358.109 155.586 378.765C154.919 384.695 152.315 394.787 150.371 401.803Z"
                                fill="#FFA21D" />
                            <path
                                d="M221.458 435.083C221.447 435.083 221.431 434.956 221.413 434.708C221.396 434.422 221.374 434.06 221.347 433.608C221.298 432.592 221.229 431.175 221.141 429.375C220.924 425.706 220.729 420.368 219.649 413.893C219.087 410.665 218.248 407.156 216.842 403.577C215.472 399.979 213.351 396.428 210.663 393.031C207.998 389.614 204.845 386.308 201.788 382.672C200.262 380.854 198.763 378.946 197.398 376.895C196.04 374.833 194.881 372.595 193.988 370.219C192.192 365.502 191.622 360.261 193.189 355.643C193.912 353.302 195.433 351.408 196.571 349.493C197.138 348.527 197.661 347.539 197.914 346.509C198.045 345.995 198.08 345.476 198.037 344.973C197.95 344.48 197.815 343.991 197.519 343.581C196.989 342.727 196.066 342.212 195.102 341.851C194.135 341.478 193.111 341.212 192.141 340.762C191.162 340.337 190.295 339.609 189.713 338.734C189.13 337.851 188.831 336.847 188.671 335.87C188.366 333.899 188.572 331.995 188.821 330.212C189.078 328.435 189.324 326.729 189.56 325.099C190.512 318.624 191.285 313.367 191.828 309.676C192.105 307.896 192.323 306.493 192.478 305.488C192.555 305.041 192.616 304.683 192.665 304.4C192.71 304.155 192.74 304.031 192.751 304.034C192.762 304.035 192.756 304.163 192.732 304.411C192.701 304.696 192.662 305.056 192.613 305.507C192.488 306.517 192.311 307.924 192.088 309.713C191.596 313.411 190.896 318.677 190.032 325.165C189.81 326.797 189.578 328.505 189.337 330.284C189.102 332.048 188.921 333.915 189.223 335.779C189.381 336.702 189.665 337.627 190.194 338.415C190.728 339.198 191.474 339.829 192.389 340.223C193.295 340.639 194.306 340.898 195.319 341.283C196.318 341.651 197.399 342.227 198.04 343.243C198.386 343.722 198.561 344.313 198.66 344.898C198.716 345.491 198.672 346.09 198.531 346.658C198.252 347.798 197.704 348.827 197.126 349.823C195.949 351.811 194.495 353.624 193.815 355.857C192.322 360.281 192.861 365.366 194.621 369.983C196.329 374.671 199.267 378.642 202.294 382.249C205.324 385.867 208.476 389.19 211.153 392.649C213.851 396.082 216.001 399.721 217.363 403.372C218.767 407.009 219.584 410.558 220.12 413.813C221.146 420.341 221.268 425.688 221.404 429.363C221.438 431.166 221.463 432.585 221.483 433.602C221.483 434.056 221.482 434.419 221.482 434.705C221.478 434.954 221.47 435.081 221.458 435.083Z"
                                fill="#263238" />
                            <path
                                d="M211.234 445.344C211.207 445.317 211.307 445.134 211.617 444.935C211.92 444.738 212.463 444.556 213.133 444.668C213.78 444.755 214.627 445.266 214.867 446.203C215.113 447.083 214.844 448.249 213.887 448.871C212.906 449.454 211.74 449.176 211.062 448.562C210.33 447.926 210.262 446.929 210.489 446.317C210.703 445.672 211.122 445.278 211.44 445.106C211.764 444.929 211.974 444.932 211.985 444.97C212.048 445.058 211.214 445.333 210.949 446.445C210.825 446.972 210.929 447.663 211.47 448.094C211.982 448.531 212.882 448.7 213.53 448.299C214.175 447.895 214.425 447.015 214.263 446.36C214.121 445.682 213.554 445.272 213.029 445.136C211.924 444.849 211.282 445.443 211.234 445.344Z"
                                fill="#263238" />
                            <path
                                d="M202.651 490.007C202.624 489.98 202.724 489.797 203.034 489.597C203.337 489.4 203.88 489.219 204.55 489.33C205.197 489.417 206.044 489.929 206.284 490.866C206.53 491.746 206.261 492.911 205.304 493.533C204.322 494.117 203.157 493.839 202.479 493.224C201.747 492.587 201.679 491.591 201.906 490.979C202.12 490.334 202.539 489.94 202.857 489.767C203.181 489.591 203.391 489.594 203.402 489.631C203.465 489.719 202.631 489.994 202.366 491.106C202.242 491.633 202.346 492.324 202.889 492.754C203.401 493.191 204.3 493.358 204.948 492.959C205.593 492.555 205.843 491.675 205.681 491.02C205.539 490.341 204.973 489.932 204.448 489.796C203.341 489.512 202.699 490.105 202.651 490.007Z"
                                fill="#263238" />
                            <path
                                d="M202.38 434.131C202.385 434.122 202.385 434.257 202.364 434.567C202.336 434.889 202.297 435.309 202.249 435.839C202.123 436.998 201.945 438.635 201.716 440.721C201.219 444.957 200.475 451.083 199.338 458.626C198.767 462.396 198.095 466.521 197.178 470.92C196.701 473.116 196.224 475.389 195.304 477.661C195.169 477.941 195.089 478.234 194.906 478.506C194.714 478.78 194.516 479.051 194.259 479.248C193.784 479.692 193.222 480.002 192.657 480.281C191.518 480.828 190.306 481.194 189.074 481.513C184.118 482.683 178.806 483.062 173.321 483.298C167.827 483.478 162.147 483.518 156.31 483.096C156.074 483.076 155.834 483.048 155.592 483.014C155.254 482.989 154.928 482.687 154.812 482.446C154.541 481.942 154.473 481.455 154.406 480.974C154.292 480.014 154.297 479.073 154.323 478.14C154.388 476.275 154.565 474.443 154.774 472.637C155.198 469.025 155.754 465.513 156.333 462.103C157.506 455.283 158.789 448.875 160.055 442.995L160.101 442.782L160.317 442.764C173.156 441.657 183.708 439.354 190.989 437.436C194.634 436.476 197.472 435.619 199.404 435.026C200.353 434.735 201.097 434.508 201.643 434.341C202.145 434.192 202.39 434.118 202.38 434.131C202.375 434.138 202.306 434.165 202.177 434.214C202.022 434.271 201.838 434.341 201.61 434.426C201.11 434.608 200.418 434.878 199.464 435.197C197.547 435.846 194.721 436.756 191.083 437.767C183.815 439.786 173.25 442.178 160.371 443.347L160.633 443.116C159.397 448.99 158.135 455.403 156.98 462.209C156.408 465.614 155.859 469.119 155.441 472.711C155.235 474.506 155.06 476.327 154.998 478.158C154.972 479.071 154.971 479.994 155.077 480.887C155.132 481.325 155.22 481.783 155.397 482.104C155.505 482.269 155.55 482.323 155.694 482.344C155.917 482.375 156.143 482.402 156.376 482.42C162.14 482.838 167.835 482.805 173.299 482.633C178.758 482.409 184.057 482.039 188.927 480.905C190.134 480.598 191.316 480.242 192.393 479.73C193.47 479.196 194.424 478.562 194.765 477.41C195.646 475.261 196.149 472.97 196.631 470.798C197.568 466.425 198.265 462.309 198.867 458.549C200.063 451.025 200.878 444.91 201.456 440.686C201.737 438.608 201.957 436.977 202.113 435.821C202.189 435.295 202.249 434.878 202.294 434.558C202.342 434.297 202.376 434.14 202.38 434.131Z"
                                fill="#263238" />
                            <path
                                d="M201.548 443.584C201.568 443.627 201.016 443.908 200.001 444.381C198.99 444.863 197.493 445.487 195.619 446.191C191.872 447.602 186.545 449.199 180.507 450.21C174.465 451.209 168.906 451.425 164.904 451.302C162.902 451.244 161.284 451.139 160.172 451.01C159.059 450.891 158.447 450.804 158.451 450.758C158.455 450.711 159.075 450.711 160.19 450.749C161.305 450.797 162.918 450.829 164.91 450.825C168.893 450.824 174.401 450.535 180.396 449.543C186.388 448.539 191.692 447.029 195.46 445.74C197.345 445.098 198.862 444.545 199.901 444.138C200.942 443.742 201.529 443.543 201.548 443.584Z"
                                fill="#263238" />
                            <path
                                d="M128.82 407.031C128.82 407.031 128.848 406.821 128.932 406.419C129.026 405.99 129.157 405.4 129.324 404.641C129.699 403.052 130.238 400.761 130.93 397.825C132.357 391.914 134.521 383.385 137.33 372.882C138.753 367.633 140.309 361.887 141.981 355.719C143.672 349.557 145.442 342.958 147.555 336.08C149.705 329.219 152.172 322.052 155.545 314.965C157.227 311.423 159.126 307.903 161.297 304.479C162.375 302.769 163.5 301.044 164.878 299.486C166.235 297.924 167.836 296.49 169.773 295.56C171.695 294.618 174.001 294.394 176.034 295.077C178.068 295.747 179.771 297.119 181.048 298.742C183.637 302.078 184.277 306.28 184.655 310.136C185.317 317.931 185.956 325.45 186.564 332.614C187.76 346.932 188.837 359.829 189.743 370.671C190.621 381.484 191.333 390.243 191.828 396.333C192.057 399.34 192.236 401.686 192.361 403.314C192.412 404.089 192.453 404.693 192.482 405.131C192.506 405.54 192.501 405.751 192.501 405.751C192.501 405.751 192.459 405.544 192.414 405.136C192.368 404.699 192.306 404.098 192.226 403.325C192.072 401.7 191.851 399.358 191.567 396.357C191.022 390.271 190.238 381.518 189.268 370.713C188.321 359.874 187.195 346.982 185.945 332.667C185.325 325.507 184.673 317.992 183.998 310.201C183.624 306.372 182.97 302.297 180.52 299.157C179.309 297.617 177.7 296.334 175.828 295.718C173.959 295.094 171.86 295.293 170.062 296.171C168.25 297.038 166.705 298.409 165.386 299.929C164.046 301.443 162.939 303.135 161.864 304.838C159.709 308.234 157.821 311.729 156.144 315.248C152.782 322.289 150.311 329.424 148.15 336.264C146.025 343.12 144.236 349.711 142.522 355.868C140.821 362.027 139.238 367.764 137.791 373.007C134.924 383.491 132.69 392 131.187 397.889C130.443 400.811 129.861 403.091 129.458 404.672C129.262 405.425 129.111 406.009 129 406.434C128.892 406.832 128.82 407.031 128.82 407.031Z"
                                fill="#455A64" />
                            <path
                                d="M125.64 402.562C125.134 404.582 115.711 458.202 115.711 458.202L185.813 460.471L195.464 404.868L125.64 402.562Z"
                                fill="#263238" />
                            <path
                                d="M194.743 405.89C194.756 405.91 194.538 406.074 194.112 406.368C193.686 406.665 193.049 407.088 192.221 407.619C190.562 408.679 188.137 410.175 185.073 411.909C182.01 413.642 178.319 415.636 174.11 417.637C171.993 418.622 169.803 419.667 167.38 420.541C164.94 421.342 162.273 421.745 159.558 421.683C154.1 421.564 149.103 419.865 144.886 417.89C140.654 415.855 137.238 413.346 134.496 411.139C131.755 408.919 129.686 406.954 128.268 405.59C127.565 404.901 127.023 404.362 126.665 403.986C126.306 403.612 126.126 403.408 126.142 403.392C126.157 403.375 126.37 403.547 126.758 403.888C127.199 404.281 127.758 404.781 128.446 405.396C129.916 406.699 132.028 408.605 134.791 410.764C137.554 412.911 140.97 415.356 145.149 417.326C149.327 419.247 154.25 420.893 159.569 421.007C162.217 421.068 164.803 420.68 167.17 419.913C169.512 419.078 171.743 418.034 173.843 417.073C178.048 415.113 181.753 413.166 184.839 411.49C187.924 409.812 190.383 408.382 192.081 407.392C192.879 406.927 193.526 406.549 194.036 406.25C194.487 405.996 194.73 405.869 194.743 405.89Z"
                                fill="#455A64" />
                            <path
                                d="M190.454 408.281C190.638 408.314 188.759 419.991 186.258 434.361C183.756 448.736 181.579 460.36 181.396 460.327C181.212 460.295 183.091 448.62 185.593 434.245C188.094 419.875 190.271 408.249 190.454 408.281Z"
                                fill="#455A64" />
                            <path
                                d="M157.477 419.58C157.289 421.32 157.102 423.061 156.916 424.8C156.856 425.35 156.799 425.915 156.942 426.449C157.086 426.983 157.477 427.487 158.02 427.597C158.65 427.724 159.282 427.277 159.582 426.708C159.881 426.139 159.92 425.474 159.955 424.832C160.055 422.968 160.155 421.101 160.254 419.236C159.487 419.242 158.719 419.248 157.951 419.253"
                                fill="#455A64" />
                            <path
                                d="M171.923 296.481C177.614 294.574 182.376 301.959 183.029 307.926C183.538 312.568 183.888 319.376 183.419 328.611C182.383 349.033 173.144 368.574 173.144 368.574L231.776 377.338L229.624 399.891L155.48 391.936C144.5 390.758 137.292 379.868 140.538 369.313C147.165 347.771 157.989 316.707 160.428 311.553C163.705 304.622 164.075 299.11 171.923 296.481Z"
                                fill="#FFA21D" />
                            <path
                                d="M152.689 391.405C152.69 391.394 152.819 391.406 153.071 391.437C153.352 391.476 153.719 391.527 154.185 391.59C155.2 391.742 156.64 391.956 158.486 392.23C162.239 392.751 167.699 393.521 174.555 394.316C188.261 395.936 207.524 397.859 229.65 399.563L229.299 399.86C229.981 392.683 230.7 385.115 231.44 377.339L231.443 377.307L231.726 377.672C209.7 374.356 189.36 371.292 173.111 368.845L172.789 368.797L172.888 368.494C176.705 356.697 179.622 346.942 181.357 340.075C182.232 336.645 182.843 333.947 183.225 332.106C183.408 331.212 183.549 330.513 183.653 330.005C183.751 329.531 183.822 329.29 183.822 329.29C183.822 329.29 183.805 329.54 183.733 330.018C183.655 330.497 183.558 331.211 183.382 332.136C183.049 333.989 182.487 336.703 181.655 340.149C180.008 347.047 177.162 356.839 173.404 368.657L173.181 368.306C189.439 370.717 209.79 373.736 231.83 377.005L232.144 377.052L232.114 377.37L232.111 377.403C231.366 385.179 230.642 392.746 229.953 399.922L229.922 400.243L229.601 400.219C207.463 398.48 188.204 396.471 174.503 394.735C167.651 393.884 162.195 393.048 158.451 392.456C156.612 392.134 155.177 391.883 154.166 391.705C153.705 391.617 153.339 391.549 153.062 391.495C152.812 391.445 152.686 391.415 152.689 391.405Z"
                                fill="#263238" />
                            <path
                                d="M218.076 398.951C217.89 398.935 218.225 393.695 218.822 387.251C219.419 380.805 220.055 375.595 220.241 375.612C220.426 375.629 220.092 380.867 219.495 387.313C218.897 393.758 218.262 398.97 218.076 398.951Z"
                                fill="#263238" />
                            <path
                                d="M225.537 379.448C225.536 379.408 225.69 379.345 225.978 379.395C226.26 379.441 226.673 379.637 226.987 380.075C227.305 380.483 227.486 381.264 227.083 381.925C226.717 382.558 225.916 383.049 225.021 382.885C224.139 382.69 223.589 381.941 223.468 381.231C223.326 380.486 223.692 379.829 224.082 379.496C224.919 378.788 225.662 379.032 225.618 379.099C225.631 379.205 224.988 379.191 224.421 379.831C224.151 380.141 223.952 380.613 224.078 381.109C224.187 381.602 224.611 382.112 225.156 382.224C225.698 382.335 226.288 382.018 226.553 381.602C226.84 381.184 226.779 380.687 226.584 380.33C226.175 379.583 225.514 379.548 225.537 379.448Z"
                                fill="#263238" />
                            <path d="M244.412 370.756L247.091 398.537H260.629L263.872 370.756H244.412Z" fill="#EBEBEB" />
                            <path
                                d="M244.412 367.166C244.412 367.166 243.284 368.294 243.144 370.832H265.142C265.142 370.832 265.564 368.576 263.873 367.166H244.412Z"
                                fill="#455A64" />
                            <path d="M246.92 364.62L246.176 367.369L262.78 367.494L261.685 364.589L246.92 364.62Z"
                                fill="#455A64" />
                            <path
                                d="M244.134 377.71C244.134 377.968 245.745 391.693 245.745 391.693H262.296L263.872 377.71H244.134Z"
                                fill="#455A64" />
                            <path
                                d="M245.164 375.257L244.738 379.903L260.766 380.28C260.766 380.28 260.766 385.684 259.144 387.305C259.144 387.305 260.766 390.548 258.964 392.35C257.163 394.151 256.082 393.611 256.082 393.611C256.082 393.611 256.802 397.213 255.001 398.114C253.2 399.015 229.842 397.62 229.842 397.62L231.276 382.583L236.498 382.119C236.677 377.153 241.834 374.672 245.164 375.257Z"
                                fill="#FFBE9D" />
                            <path
                                d="M224.893 233.68C223.966 231.038 222.222 228.622 219.793 227.231C218.164 226.298 216.219 225.895 214.367 226.117C214.372 226.104 214.38 226.092 214.385 226.079L214.352 225.689C212.608 222.562 209.168 221.887 205.617 222.479C202.086 223.067 198.57 225.67 195.409 227.353C191.131 229.632 187.039 232.242 182.953 234.848C179.559 237.014 176.078 239.26 173.736 242.535C171.277 245.974 170.284 250.428 171.052 254.586C171.889 259.127 174.697 263.736 173.033 268.042C171.924 270.914 169.105 272.714 167.253 275.174C164.364 279.01 164.139 284.756 167.008 288.606C168.895 291.138 171.792 292.666 174.428 294.404C178.62 297.169 182.368 300.645 186.878 302.853C191.389 305.061 197.096 305.787 201.25 302.964C205.527 300.058 206.893 294.207 206.131 289.093C205.368 283.978 202.902 279.309 200.922 274.531C198.344 268.315 196.552 261.772 195.601 255.108C195.221 252.449 195.008 249.587 196.276 247.218C197.412 245.093 199.544 243.729 201.471 242.282C206.004 238.877 209.798 234.512 212.591 229.58C213.405 231.945 215.158 234.054 217.029 235.795C219.644 238.232 222.59 240.314 225.758 241.968C225.981 239.183 225.819 236.323 224.893 233.68Z"
                                fill="#263238" />
                            <path class="theme-color"
                                d="M567.231 521.101C567.64 522.118 567.817 523.226 567.746 524.319C568.003 523.028 568.502 521.786 569.207 520.673C569.471 520.258 569.889 519.811 570.367 519.933C570.845 520.055 570.998 520.654 571.016 521.148C571.064 522.503 570.753 523.867 570.126 525.067C571 523.958 572.149 523.068 573.441 522.498C573.671 522.397 573.947 522.309 574.16 522.442C574.408 522.597 574.415 522.952 574.374 523.242C574.048 525.52 572.436 527.569 570.3 528.423L569.599 528.525C568.105 528.114 566.779 527.125 565.958 525.81C565.138 524.496 564.831 522.87 565.118 521.348C565.227 520.767 565.556 520.092 566.147 520.082C566.675 520.071 567.033 520.611 567.231 521.101Z"
                                fill="#0CAF60" />
                            <path class="theme-color"
                                d="M582.974 552.542C581.344 551.366 578.28 550.242 576.301 549.853C577.7 545.074 577.782 539.915 576.489 535.106C575.978 533.205 575.242 531.326 573.999 529.799C572.756 528.271 570.952 527.122 568.988 527.001C566.868 526.87 564.836 527.97 563.42 529.58L560.958 535.275C560.816 536.106 560.709 536.941 560.663 537.777C560.358 543.284 561.622 548.865 564.259 553.708C561.692 556.538 558.913 561.417 559.751 567.07H588.994C589.503 561.647 587.438 555.765 582.974 552.542Z"
                                fill="#AFE2C9" />
                            <path
                                d="M562.956 555.526C562.944 555.517 563.021 555.408 563.177 555.209C563.343 555.018 563.552 554.701 563.902 554.368C564.557 553.66 565.635 552.741 567.144 551.89C568.649 551.035 570.626 550.312 572.912 550.048C575.188 549.78 577.785 550.035 580.244 551.071C582.686 552.148 584.657 553.86 586.024 555.7C587.402 557.543 588.233 559.477 588.645 561.158C589.062 562.841 589.134 564.255 589.069 565.217C589.066 565.7 588.98 566.07 588.955 566.321C588.918 566.572 588.892 566.702 588.877 566.7C588.746 566.708 589.246 564.541 588.343 561.24C587.902 559.603 587.06 557.73 585.7 555.949C584.35 554.17 582.43 552.521 580.07 551.479C577.692 550.479 575.177 550.215 572.958 550.455C570.729 550.689 568.788 551.363 567.296 552.166C564.273 553.776 563.04 555.626 562.956 555.526Z"
                                fill="#263238" />
                            <path
                                d="M560.512 539.874C560.454 539.872 560.412 539.133 560.459 537.936C560.513 536.745 560.657 535.07 561.246 533.311C561.837 531.549 562.838 530.135 563.749 529.33C564.656 528.51 565.381 528.248 565.397 528.289C565.437 528.355 564.781 528.711 563.967 529.554C563.149 530.385 562.236 531.756 561.666 533.452C561.097 535.15 560.903 536.783 560.77 537.959C560.646 539.14 560.576 539.876 560.512 539.874Z"
                                fill="#263238" />
                            <path
                                d="M577.426 563.349C577.345 563.251 578.632 562.068 580.157 560.556C581.686 559.048 582.883 557.775 582.981 557.858C583.073 557.933 582.016 559.347 580.469 560.872C578.927 562.401 577.501 563.442 577.426 563.349Z"
                                fill="#263238" />
                            <path
                                d="M574.16 561.647C574.041 561.618 574.253 560.32 574.635 558.746C575.016 557.173 575.422 555.921 575.542 555.95C575.66 555.979 575.449 557.278 575.066 558.851C574.686 560.424 574.28 561.675 574.16 561.647Z"
                                fill="#263238" />
                            <path
                                d="M565.481 558.4C565.579 558.334 566.431 559.463 567.145 561.043C567.864 562.622 568.152 564.006 568.038 564.037C567.916 564.072 567.445 562.771 566.74 561.226C566.043 559.68 565.374 558.468 565.481 558.4Z"
                                fill="#263238" />
                            <path
                                d="M574.871 544.743C574.773 544.669 575.658 543.333 576.848 541.759C578.039 540.185 579.084 538.969 579.181 539.043C579.279 539.117 578.393 540.453 577.203 542.027C576.012 543.602 574.968 544.817 574.871 544.743Z"
                                fill="#263238" />
                            <path
                                d="M572.799 535.597C572.698 535.527 573.7 533.888 575.038 531.936C576.376 529.983 577.542 528.457 577.643 528.527C577.744 528.596 576.743 530.235 575.405 532.188C574.067 534.14 572.9 535.666 572.799 535.597Z"
                                fill="#263238" />
                            <path
                                d="M569.513 537.998C569.635 537.991 569.822 539.377 569.929 541.095C570.036 542.814 570.025 544.213 569.902 544.22C569.78 544.228 569.593 542.841 569.486 541.123C569.379 539.404 569.391 538.005 569.513 537.998Z"
                                fill="#263238" />
                            <path
                                d="M556.374 542.157C556.43 542.051 558.326 542.934 560.524 544.277C562.725 545.617 564.378 546.898 564.309 546.995C564.237 547.099 562.48 545.988 560.292 544.655C558.108 543.321 556.316 542.269 556.374 542.157Z"
                                fill="#263238" />
                            <g opacity="0.3">
                                <path
                                    d="M566.904 550.03C568.322 549.199 570.004 548.942 571.645 548.86C573.349 548.776 575.255 548.949 576.408 550.206V550.267C572.315 549.975 567.542 551.375 564.399 554.014C564.374 552.369 565.486 550.862 566.904 550.03Z"
                                    fill="black" />
                            </g>
                            <path class="theme-color"
                                d="M580.802 492.597C581.636 492.373 582.519 492.338 583.367 492.497C582.381 492.173 581.456 491.668 580.654 491.011C580.354 490.766 580.044 490.396 580.184 490.035C580.324 489.671 580.807 489.609 581.195 489.642C582.258 489.732 583.296 490.103 584.176 490.707C583.391 489.919 582.804 488.936 582.479 487.872C582.421 487.683 582.379 487.459 582.503 487.306C582.647 487.126 582.926 487.154 583.148 487.214C584.899 487.683 586.349 489.136 586.814 490.887L586.828 491.444C586.366 492.573 585.468 493.517 584.363 494.035C583.259 494.552 581.958 494.639 580.794 494.272C580.351 494.132 579.854 493.811 579.901 493.348C579.944 492.935 580.399 492.705 580.802 492.597Z"
                                fill="#0CAF60" />
                            <path class="theme-color"
                                d="M639.779 455.22C639.931 456.069 639.891 456.952 639.662 457.784C640.067 456.829 640.649 455.95 641.371 455.206C641.64 454.928 642.034 454.649 642.382 454.819C642.731 454.989 642.753 455.476 642.687 455.859C642.509 456.912 642.052 457.915 641.376 458.74C642.228 458.024 643.255 457.521 644.343 457.288C644.536 457.247 644.764 457.222 644.906 457.358C645.073 457.517 645.021 457.792 644.944 458.01C644.33 459.715 642.76 461.038 640.975 461.355L640.419 461.322C639.333 460.767 638.468 459.792 638.044 458.648C637.621 457.504 637.643 456.202 638.107 455.073C638.283 454.642 638.645 454.174 639.101 454.26C639.513 454.337 639.704 454.809 639.779 455.22Z"
                                fill="#0CAF60" />
                            <path class="theme-color"
                                d="M598.724 531.689C599.158 531.706 599.562 531.756 599.977 531.795C600.736 523.441 598.203 514.959 600.755 506.973L600.416 507.408C597.342 507.811 594.144 507.69 591.248 506.586C588.351 505.482 585.782 503.315 584.617 500.441C583.452 497.568 583.886 493.998 586.03 491.759C588.923 488.738 594.015 488.896 597.643 490.979C601.143 492.987 603.596 496.359 605.905 499.681C607.119 498.727 608.457 497.932 609.899 497.384C605.868 491.835 601.969 486.007 600.698 479.303C599.307 471.968 602.047 463.278 608.855 460.216C614.652 457.609 621.922 459.965 626.009 464.835C626.329 465.216 626.6 465.629 626.884 466.032L626.748 465.637C627.759 463.091 629.744 460.911 632.261 459.832C634.778 458.751 637.806 458.837 640.175 460.212C642.544 461.586 644.145 464.267 644.064 467.004C643.972 470.091 641.803 472.882 639.028 474.234C636.368 475.531 633.256 475.633 630.35 475.036C630.722 477.613 630.707 480.264 630.307 482.827C629.398 488.661 626.796 494.089 623.706 499.136C624.558 499.714 625.37 500.353 626.082 501.1C631.336 506.6 631.674 515.433 628.921 522.524C626.167 529.615 618.711 534.845 613.538 540.422L613.532 540.418C615.756 544.182 616.925 548.676 617.506 552.894C619.305 549.132 623.32 546.437 627.519 546.468C629.777 546.484 632.306 547.488 633.004 549.635C633.619 551.527 632.583 553.576 631.238 555.041C628.106 558.455 622.498 560.014 617.996 558.919L617.94 557.538C618.224 562.958 617.712 567.07 617.712 567.07H584.344C584.341 567.071 575.423 530.826 598.724 531.689Z"
                                fill="#AFE2C9" />
                            <path d="M546.09 581.066H625.047V567.072H546.09V581.066Z" fill="#6B5F0A" />
                            <path d="M619.146 578.289L609.544 620.107H562.487L551.982 578.289H619.146Z" fill="#6B5F0A" />
                            <path
                                d="M546.135 581.083C546.135 581.236 563.944 581.36 585.908 581.36C607.88 581.36 625.686 581.236 625.686 581.083C625.686 580.93 607.88 580.805 585.908 580.805C563.944 580.805 546.135 580.93 546.135 581.083Z"
                                fill="#263238" />
                            <path
                                d="M592.531 533.067C592.524 533.053 592.681 532.965 592.988 532.808C593.289 532.636 593.758 532.441 594.374 532.214C595.607 531.778 597.516 531.397 599.868 531.58C602.209 531.768 604.987 532.572 607.6 534.288C610.215 535.999 612.541 538.648 614.242 541.801C615.947 544.965 616.921 548.281 617.422 551.338C617.91 554.403 617.956 557.197 617.958 559.529C617.945 561.863 617.871 563.747 617.824 565.05C617.798 565.663 617.777 566.159 617.759 566.549C617.74 566.893 617.723 567.072 617.707 567.071C617.692 567.071 617.679 566.891 617.669 566.548C617.664 566.158 617.657 565.66 617.65 565.047C617.649 563.686 617.645 561.816 617.643 559.53C617.602 557.206 617.522 554.428 617.017 551.404C616.502 548.392 615.526 545.12 613.851 542.012C612.179 538.914 609.911 536.315 607.373 534.628C604.835 532.936 602.128 532.115 599.839 531.893C597.538 531.673 595.658 531.998 594.426 532.378C593.188 532.759 592.556 533.119 592.531 533.067Z"
                                fill="#263238" />
                            <path
                                d="M599.591 515.352C599.576 515.353 599.558 515.217 599.537 514.955C599.526 514.696 599.473 514.31 599.491 513.813C599.481 512.819 599.594 511.374 599.985 509.635C600.383 507.902 601.073 505.862 602.303 503.837C602.902 502.818 603.647 501.814 604.541 500.882C605.425 499.945 606.466 499.076 607.665 498.405C608.857 497.724 610.127 497.25 611.391 496.972C612.661 496.715 613.912 496.648 615.096 496.698C617.466 496.834 619.538 497.441 621.174 498.139C622.814 498.838 624.054 499.583 624.867 500.153C625.283 500.423 625.576 500.678 625.785 500.834C625.99 500.997 626.092 501.088 626.083 501.1C626.06 501.131 625.61 500.818 624.773 500.298C623.938 499.776 622.686 499.082 621.055 498.43C619.429 497.777 617.388 497.216 615.077 497.106C613.924 497.069 612.71 497.143 611.483 497.396C610.261 497.673 609.038 498.131 607.886 498.79C606.728 499.437 605.719 500.276 604.855 501.182C603.982 502.083 603.248 503.058 602.653 504.049C601.43 506.017 600.721 508.01 600.289 509.708C599.866 511.412 599.706 512.834 599.663 513.817C599.618 514.801 599.631 515.349 599.591 515.352Z"
                                fill="#263238" />
                            <path
                                d="M630.604 480.044C630.54 480.048 630.437 479.02 630.321 477.364C630.256 476.538 630.173 475.557 629.991 474.483C629.817 473.4 629.543 472.254 629.044 471.097C628.08 468.774 626.902 466.8 625.995 465.422C625.083 464.041 624.391 463.283 624.442 463.235C624.463 463.215 624.661 463.382 624.99 463.716C625.31 464.057 625.759 464.566 626.253 465.242C627.237 466.592 628.473 468.561 629.456 470.929C629.964 472.106 630.245 473.33 630.395 474.42C630.557 475.518 630.61 476.516 630.635 477.349C630.671 479.014 630.663 480.04 630.604 480.044Z"
                                fill="#263238" />
                            <path
                                d="M626.292 555.077C626.373 554.984 627.392 555.738 628.566 556.759C629.742 557.781 630.63 558.684 630.55 558.777C630.47 558.87 629.452 558.116 628.276 557.094C627.1 556.073 626.211 555.17 626.292 555.077Z"
                                fill="#263238" />
                            <path
                                d="M629.1 552.289C629.088 552.167 630.354 551.944 631.929 551.79C633.503 551.636 634.789 551.61 634.801 551.732C634.813 551.854 633.547 552.078 631.972 552.232C630.398 552.386 629.111 552.412 629.1 552.289Z"
                                fill="#263238" />
                            <path
                                d="M626.98 547.366C626.891 547.274 627.699 546.372 628.567 545.173C629.44 543.977 630.049 542.932 630.164 542.988C630.271 543.036 629.827 544.2 628.926 545.434C628.03 546.671 627.059 547.453 626.98 547.366Z"
                                fill="#263238" />
                            <path
                                d="M623.233 545.106C623.353 545.133 623.121 546.582 622.717 548.338C622.312 550.096 621.887 551.499 621.768 551.472C621.648 551.445 621.88 549.997 622.284 548.239C622.689 546.482 623.113 545.078 623.233 545.106Z"
                                fill="#263238" />
                            <path
                                d="M620.741 556.387C620.659 556.295 621.186 555.687 621.919 555.028C622.652 554.368 623.312 553.907 623.395 553.999C623.477 554.09 622.949 554.698 622.216 555.358C621.483 556.018 620.822 556.477 620.741 556.387Z"
                                fill="#263238" />
                            <path
                                d="M609.14 554.202C609.052 554.117 609.693 553.306 610.571 552.389C611.449 551.473 612.233 550.798 612.322 550.884C612.41 550.969 611.77 551.78 610.891 552.697C610.012 553.613 609.228 554.287 609.14 554.202Z"
                                fill="#263238" />
                            <path
                                d="M606.623 543.487C606.518 543.422 606.997 542.45 607.693 541.314C608.389 540.178 609.037 539.309 609.141 539.374C609.246 539.437 608.767 540.411 608.071 541.547C607.376 542.683 606.727 543.552 606.623 543.487Z"
                                fill="#263238" />
                            <path
                                d="M599.229 534.764C599.351 534.763 599.467 536.008 599.487 537.546C599.507 539.085 599.425 540.332 599.302 540.334C599.179 540.335 599.063 539.09 599.043 537.552C599.023 536.014 599.106 534.765 599.229 534.764Z"
                                fill="#263238" />
                            <path
                                d="M583.725 537.721C583.831 537.65 584.742 538.861 585.93 540.295C587.113 541.733 588.129 542.858 588.039 542.948C587.957 543.034 586.788 542.037 585.588 540.578C584.384 539.122 583.627 537.784 583.725 537.721Z"
                                fill="#263238" />
                            <path
                                d="M581.74 552.948C581.763 552.827 583 552.965 584.502 553.255C586.004 553.546 587.204 553.878 587.18 553.998C587.156 554.118 585.92 553.981 584.417 553.69C582.915 553.401 581.716 553.068 581.74 552.948Z"
                                fill="#263238" />
                            <path
                                d="M597.822 558.253C597.711 558.218 598.076 556.804 598.89 555.206C599.699 553.604 600.623 552.473 600.717 552.543C600.822 552.616 600.078 553.838 599.286 555.407C598.489 556.972 597.943 558.295 597.822 558.253Z"
                                fill="#263238" />
                            <path
                                d="M592.459 550.947C592.337 550.95 592.215 549.942 592.186 548.697C592.158 547.451 592.236 546.439 592.358 546.436C592.48 546.433 592.603 547.44 592.63 548.686C592.658 549.933 592.582 550.945 592.459 550.947Z"
                                fill="#263238" />
                            <path
                                d="M609.767 563.828C609.656 563.789 609.968 562.676 610.71 561.473C611.447 560.267 612.298 559.486 612.383 559.567C612.478 559.653 611.8 560.539 611.087 561.706C610.37 562.867 609.886 563.875 609.767 563.828Z"
                                fill="#263238" />
                            <path
                                d="M591.407 564.884C591.295 564.933 590.758 563.965 590.209 562.719C589.66 561.473 589.305 560.424 589.417 560.375C589.529 560.325 590.066 561.294 590.616 562.541C591.165 563.785 591.519 564.835 591.407 564.884Z"
                                fill="#263238" />
                            <path
                                d="M619.949 530.934C619.953 530.812 621.323 530.758 623.009 530.813C624.695 530.868 626.057 531.013 626.054 531.135C626.05 531.258 624.681 531.313 622.995 531.256C621.308 531.201 619.946 531.057 619.949 530.934Z"
                                fill="#263238" />
                            <path
                                d="M626.598 519.542C626.528 519.442 627.841 518.389 629.533 517.19C631.225 515.99 632.655 515.099 632.725 515.199C632.796 515.299 631.483 516.352 629.791 517.552C628.099 518.751 626.67 519.642 626.598 519.542Z"
                                fill="#263238" />
                            <path
                                d="M625.914 504.909C625.862 504.791 626.999 504.198 628.307 503.326C629.619 502.461 630.609 501.645 630.697 501.738C630.78 501.82 629.902 502.805 628.552 503.696C627.207 504.593 625.957 505.017 625.914 504.909Z"
                                fill="#263238" />
                            <path
                                d="M618.449 499.735C618.331 499.706 618.62 498.108 619.096 496.167C619.572 494.225 620.054 492.675 620.174 492.704C620.293 492.733 620.004 494.33 619.528 496.272C619.052 498.214 618.568 499.765 618.449 499.735Z"
                                fill="#263238" />
                            <path
                                d="M605.982 496.046C606.089 495.987 606.739 496.949 607.433 498.195C608.128 499.441 608.603 500.5 608.496 500.559C608.389 500.619 607.74 499.657 607.045 498.41C606.35 497.166 605.875 496.106 605.982 496.046Z"
                                fill="#263238" />
                            <path
                                d="M595.244 520.738C595.328 520.638 596.748 521.727 598.619 522.877C600.486 524.036 602.095 524.819 602.043 524.938C602 525.045 600.286 524.433 598.386 523.255C596.482 522.083 595.168 520.824 595.244 520.738Z"
                                fill="#263238" />
                            <path
                                d="M612.654 526.29C612.59 526.185 613.548 525.478 614.794 524.71C616.041 523.942 617.104 523.403 617.167 523.508C617.232 523.613 616.274 524.319 615.027 525.088C613.781 525.856 612.718 526.395 612.654 526.29Z"
                                fill="#263238" />
                            <path
                                d="M615.581 514.479C615.491 514.381 616.617 513.276 617.664 511.663C618.723 510.058 619.284 508.583 619.41 508.627C619.519 508.654 619.131 510.241 618.035 511.905C616.949 513.577 615.649 514.569 615.581 514.479Z"
                                fill="#263238" />
                            <path
                                d="M609.855 511.815C609.733 511.809 609.693 510.528 609.766 508.953C609.839 507.378 609.998 506.105 610.121 506.111C610.243 506.117 610.283 507.399 610.21 508.974C610.136 510.549 609.979 511.821 609.855 511.815Z"
                                fill="#263238" />
                            <path
                                d="M606.701 523.487C606.578 523.501 606.329 522.206 606.143 520.594C605.958 518.982 605.905 517.665 606.027 517.651C606.149 517.637 606.398 518.932 606.584 520.544C606.771 522.154 606.823 523.472 606.701 523.487Z"
                                fill="#263238" />
                            <path
                                d="M597.876 488.325C598.003 488.307 598.293 489.799 598.808 491.591C599.315 493.385 599.856 494.804 599.74 494.857C599.634 494.908 598.899 493.544 598.381 491.713C597.855 489.884 597.76 488.338 597.876 488.325Z"
                                fill="#263238" />
                            <path
                                d="M591.652 508.825C591.592 508.712 592.8 507.972 594.203 506.946C595.61 505.925 596.685 505.002 596.773 505.094C596.857 505.176 595.902 506.261 594.464 507.306C593.032 508.352 591.704 508.929 591.652 508.825Z"
                                fill="#263238" />
                            <path
                                d="M583.199 502.529C583.191 502.402 584.6 502.228 586.31 501.898C588.022 501.573 589.394 501.215 589.434 501.336C589.473 501.446 588.139 502.002 586.394 502.334C584.65 502.67 583.204 502.648 583.199 502.529Z"
                                fill="#263238" />
                            <path
                                d="M591.423 495.499C591.489 495.396 592.285 495.787 593.201 496.373C594.117 496.96 594.806 497.518 594.739 497.622C594.673 497.725 593.877 497.333 592.961 496.748C592.045 496.161 591.356 495.603 591.423 495.499Z"
                                fill="#263238" />
                            <path
                                d="M587.316 487.905C587.388 487.813 588.381 488.475 589.338 489.579C590.301 490.679 590.82 491.754 590.717 491.811C590.608 491.877 589.935 490.936 589.003 489.87C588.077 488.8 587.236 488.004 587.316 487.905Z"
                                fill="#263238" />
                            <path
                                d="M581.726 495.141C581.774 495.023 583.031 495.437 584.601 495.857C586.169 496.281 587.465 496.554 587.447 496.68C587.433 496.798 586.086 496.719 584.485 496.286C582.884 495.858 581.679 495.25 581.726 495.141Z"
                                fill="#263238" />
                            <path
                                d="M620.475 485.405C620.377 485.325 621.601 483.671 622.997 481.56C624.401 479.452 625.45 477.682 625.563 477.742C625.668 477.796 624.785 479.676 623.368 481.806C621.957 483.936 620.566 485.48 620.475 485.405Z"
                                fill="#263238" />
                            <path
                                d="M617.989 476.543C617.867 476.527 617.962 475.045 618.201 473.235C618.439 471.423 618.731 469.967 618.852 469.984C618.973 470 618.879 471.48 618.64 473.292C618.402 475.104 618.11 476.56 617.989 476.543Z"
                                fill="#263238" />
                            <path
                                d="M609.383 477.921C609.513 477.896 609.876 479.601 610.727 481.552C611.564 483.509 612.559 484.941 612.451 485.018C612.366 485.092 611.183 483.743 610.319 481.728C609.443 479.719 609.271 477.932 609.383 477.921Z"
                                fill="#263238" />
                            <path
                                d="M599.267 480.065C599.369 479.984 600.627 481.468 602.37 483.099C604.105 484.739 605.662 485.903 605.588 486.01C605.527 486.106 603.832 485.089 602.065 483.422C600.294 481.763 599.174 480.133 599.267 480.065Z"
                                fill="#263238" />
                            <path
                                d="M603.171 461.693C603.299 461.672 603.69 463.539 604.385 465.777C605.071 468.018 605.8 469.78 605.683 469.834C605.579 469.886 604.657 468.184 603.96 465.908C603.255 463.634 603.056 461.708 603.171 461.693Z"
                                fill="#263238" />
                            <path
                                d="M614.827 455.649C614.949 455.642 615.138 457.106 615.249 458.919C615.359 460.733 615.35 462.209 615.227 462.216C615.104 462.223 614.916 460.759 614.806 458.946C614.695 457.132 614.704 455.656 614.827 455.649Z"
                                fill="#263238" />
                            <path
                                d="M638.885 471.186C638.916 471.062 640.022 471.258 641.39 471.367C642.759 471.482 643.88 471.468 643.893 471.595C643.907 471.711 642.768 471.927 641.355 471.81C639.94 471.696 638.852 471.298 638.885 471.186Z"
                                fill="#263238" />
                            <path
                                d="M638.171 465.118C638.113 465.01 639.656 464.079 641.613 463.04C643.573 462 645.208 461.245 645.265 461.354C645.323 461.462 643.781 462.392 641.821 463.432C639.864 464.472 638.228 465.227 638.171 465.118Z"
                                fill="#263238" />
                            <path
                                d="M631.666 465.336C631.549 465.299 631.879 463.916 632.402 462.248C632.926 460.58 633.445 459.257 633.563 459.293C633.679 459.33 633.35 460.712 632.827 462.381C632.302 464.049 631.784 465.372 631.666 465.336Z"
                                fill="#263238" />
                            <g opacity="0.3">
                                <path
                                    d="M613.451 540.452C613.387 537.287 611.634 534.049 609.005 532.284C606.376 530.519 601.644 530.345 599.782 531.668C602.537 531.639 605.658 532.82 607.873 534.458C610.089 536.097 611.96 538.136 613.451 540.452Z"
                                    fill="black" />
                            </g>
                            <g opacity="0.3">
                                <path
                                    d="M623.745 499.736C622.6 497.245 620.089 495.279 617.391 494.786C614.694 494.293 610.874 495.791 609.854 497.484C612.032 496.508 614.919 496.369 617.244 496.904C619.57 497.44 621.761 498.411 623.745 499.736Z"
                                    fill="black" />
                            </g>
                            <g opacity="0.3">
                                <path
                                    d="M630.561 475.522C631.628 473.68 631.794 471.342 630.997 469.368C630.2 467.394 628.653 466.422 626.605 465.84C628.7 468.874 630.346 471.956 630.506 475.64"
                                    fill="black" />
                            </g>
                            <path
                                d="M588.437 534.982C588.461 535.014 588.087 535.304 587.537 535.952C586.989 536.598 586.244 537.585 585.518 538.914C584.18 541.61 582.968 545.717 582.621 550.338C582.263 554.971 582.752 559.185 583.209 562.194C583.444 563.701 583.671 564.915 583.827 565.755C583.987 566.595 584.061 567.062 584.029 567.071C583.996 567.079 583.86 566.625 583.642 565.796C583.428 564.966 583.149 563.759 582.869 562.25C582.322 559.241 581.772 554.993 582.135 550.299C582.491 545.608 583.763 541.475 585.218 538.744C585.998 537.408 586.796 536.439 587.398 535.822C588 535.203 588.421 534.959 588.437 534.982Z"
                                fill="#263238" />
                            <path
                                d="M625.044 567.071C625.044 567.079 624.963 567.086 624.804 567.093C624.62 567.099 624.388 567.106 624.1 567.115C623.447 567.126 622.542 567.139 621.391 567.157C619.004 567.173 615.609 567.198 611.428 567.227C602.987 567.244 591.382 567.267 578.562 567.292C565.922 567.267 554.465 567.245 546.087 567.228L546.246 567.07C546.23 571.374 546.217 574.867 546.207 577.322C546.193 578.508 546.182 579.44 546.174 580.11C546.166 580.408 546.159 580.646 546.154 580.835C546.147 580.998 546.14 581.081 546.132 581.081C546.124 581.081 546.117 580.998 546.109 580.835C546.103 580.645 546.095 580.407 546.084 580.11C546.072 579.44 546.055 578.508 546.033 577.324C546.009 574.869 545.973 571.375 545.93 567.071L545.929 566.912H546.089C554.466 566.896 565.923 566.873 578.563 566.849C591.382 566.874 602.989 566.897 611.43 566.913C615.611 566.943 619.005 566.967 621.392 566.984C622.542 567.001 623.448 567.016 624.101 567.025C624.389 567.034 624.622 567.041 624.805 567.047C624.963 567.055 625.044 567.064 625.044 567.071Z"
                                fill="#DADADA" />
                        </svg>
                    </div>

                </div>
                <div class="col-lg-6 col-12">
                    <div class="login-form-wrp">
                        <h2 class="mb-4 text-center"><?php echo e(__('Login')); ?></h2>
                        <?php if(session()->has('create_user')): ?>
                            <div class="alert alert-success w-100 mx-auto">
                                <span> <?php echo e(session()->get('create_user')); ?></span>
                            </div>
                        <?php endif; ?>
                        <?php if(session('error')): ?>
                            <div class="alert alert-danger w-100 mx-auto">
                                <span> <?php echo e(session('error')); ?></span>
                            </div>
                        <?php endif; ?>
                        <?php if(session()->has('info')): ?>
                            <div class="alert alert-success w-100 mx-auto">
                                <span> <?php echo e(session()->get('info')); ?></span>
                            </div>
                        <?php endif; ?>
                        <?php if(session()->has('status')): ?>
                            <div class="alert alert-info w-100 mx-auto">
                                <span> <?php echo e(session()->get('status')); ?></span>
                            </div>
                        <?php endif; ?>
                        <div class="login-form">

                            <form method="POST" class="needs-validation create-form" novalidate
                                action="<?php echo e(route('login')); ?>" id="form_data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="form-group mb-3 col-12">
                                        <label for="email" class="form-label d-flex"><?php echo e(__('Email')); ?></label>
                                        <input type="email"
                                            class="form-control <?php echo e($errors->has('email') ? 'is-invalid' : ''); ?>" id="email"
                                            name="email" placeholder="<?php echo e(__('Enter your email')); ?>" required=""
                                            value="<?php echo e(old('email')); ?>">
                                        <div class="invalid-feedback d-block">
                                            <?php echo e($errors->first('email')); ?>

                                        </div>
                                    </div>

                                    <div class="form-group mb-3 col-12">
                                        <label class="form-label d-flex"><?php echo e(__('Password')); ?></label>
                                        <input type="password"
                                            class="form-control <?php echo e($errors->has('password') ? ' is-invalid' : ''); ?>"
                                            id="password" name="password" placeholder="<?php echo e(__('Enter Password')); ?>"
                                            required="" value="<?php echo e(old('password')); ?>">
                                        <div class="invalid-feedback d-block">
                                            <?php echo e($errors->first('password')); ?>

                                        </div>
                                    </div>

                                    <div class="form-group col-12">
                                        <div class="d-flex flex-wrap align-items-center justify-content-between">

                                            <span><a href="<?php echo e(route('password.request', $lang)); ?>"
                                                    tabindex="0"><?php echo e(__('Forgot your password?')); ?></a></span>
                                        </div>
                                    </div>

                                    <?php if(isset($settings['RECAPTCHA_MODULE']) && $settings['RECAPTCHA_MODULE'] == 'yes'): ?>
                                                                    <?php if(
                                                                        isset($settings['google_recaptcha_version']) &&
                                                                        $settings['google_recaptcha_version'] == 'v2-checkbox'
                                                                    ): ?>
                                                                                                    <div class="form-group mb-4">
                                                                                                        <?php echo NoCaptcha::display(); ?>

                                                                                                        <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                                            <span class="small text-danger" role="alert">
                                                                                                                <strong><?php echo e($message); ?></strong>
                                                                                                            </span>
                                                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                                                    </div>
                                                                    <?php else: ?>
                                                                        <div class="form-group mb-4">
                                                                            <input type="hidden" id="g-recaptcha-response" name="g-recaptcha-response"
                                                                                class="form-control">
                                                                            <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                <span class="error small text-danger" role="alert">
                                                                                    <strong><?php echo e($message); ?></strong>
                                                                                </span>
                                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                        </div>
                                                                    <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                                <div class="text-center ticket-btn-wrapper pt-3">
                                    <div class="d-block ">
                                        <button class="btn btn-primary login-do-btn"
                                            id="login_button"><?php echo e(__('Login')); ?></button>
                                    </div>
                                </div>
                                <?php if(moduleIsActive('CustomerLogin')): ?>

                                    <p class="my-4 text-center"><?php echo e(__('Don')); ?>'<?php echo e(__('t have an account? ')); ?><a
                                            href="<?php echo e(route('register', $lang)); ?>"
                                            tabindex="0"><?php echo e(__('Customer Registration')); ?></a>
                                    </p>

                                <?php endif; ?>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
    <script>
        $(document).ready(function () {
            $("#form_data").submit(function (e) {
                $(".login_button").attr("disabled", true);
                return true;
            });
        });
    </script>

    <?php if(isset($settings['RECAPTCHA_MODULE']) && $settings['RECAPTCHA_MODULE'] == 'yes'): ?>
        <?php if(isset($settings['google_recaptcha_version']) && $settings['google_recaptcha_version'] == 'v2-checkbox'): ?>
            <?php echo NoCaptcha::renderJs(); ?>

        <?php else: ?>
            <script src="https://www.google.com/recaptcha/api.js?render=<?php echo e($settings['NOCAPTCHA_SITEKEY']); ?>"></script>
            <script>
                $(document).ready(function () {
                    grecaptcha.ready(function () {
                        grecaptcha.execute('<?php echo e($settings['
                                    NOCAPTCHA_SITEKEY ']); ?>', {
                            action: 'submit'
                        }).then(function (token) {
                            $('#g-recaptcha-response').val(token);
                        });
                    });
                });
            </script>
        <?php endif; ?>
    <?php endif; ?>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.auth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/sevenonesix/public_html/ticket.buffalorepair.net/resources/views/auth/login.blade.php ENDPATH**/ ?>