<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Manage Users')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Users')); ?></li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('multiple-action-button'); ?>
    <?php if (app('laratrust')->hasPermission('user create')) : ?>
    <a href="<?php echo e(route('admin.users.create')); ?>" class="me-2">
        <div class="btn btn-sm btn-primary btn-icon" data-bs-toggle="tooltip" data-bs-placement="top"
            title="<?php echo e(__('Create User')); ?>">
            <i class="ti ti-plus text-white"></i>
        </div>
    </a>
    <?php endif; // app('laratrust')->permission ?>
    <?php if (app('laratrust')->hasPermission('userlog manage')) : ?>
    <a href="<?php echo e(route('userlog')); ?>" class="btn btn-sm btn-primary btn-icon" title="<?php echo e(__('User Login History')); ?>"
        data-bs-toggle="tooltip" data-bs-placement="top">
        <i class="ti ti-user-check"></i>
    </a>
    <?php endif; // app('laratrust')->permission ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table id="pc-dt-simple" class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col"><?php echo e(__('Picture')); ?></th>
                                    <th scope="col"><?php echo e(__('Name')); ?></th>
                                    <th scope="col"><?php echo e(__('Email')); ?></th>
                                    <th scope="col"><?php echo e(__('Role')); ?></th>
                                    <?php if(moduleIsActive('OutOfOffice')): ?>
                                        <th scope="col"><?php echo e(__('Available')); ?></th>
                                    <?php endif; ?>
                                    <th scope="col" class="text-end me-3"><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <th scope="row"><?php echo e(++$index); ?></th>
                                        <td>
                                            <a href="<?php echo e(!empty($user->avatar) && checkFile($user->avatar) ? getFile($user->avatar) : getFile('uploads/users-avatar/avatar.png')); ?>"
                                                target="_blank">
                                                <img src="<?php echo e(!empty($user->avatar) && checkFile($user->avatar) ? getFile($user->avatar) : getFile('uploads/users-avatar/avatar.png')); ?>"
                                                    class="rounded border-2 border border-primary" width="35" id="blah3"
                                                    style="border-color: #0CAF60 !important; ">
                                            </a>
                                        </td>
                                        <td><?php echo e($user->name); ?></td>
                                        <td><?php echo e($user->email); ?></td>
                                        <td>
                                            <span class="badge bg-primary p-2 text-center role-badge">
                                                <?php echo e($user->type); ?>

                                            </span>
                                        </td>
                                        <?php if(isset($isUserActive) && $isUserActive): ?>
                                            <td>
                                                <?php if(isset($user->is_available) && $user->is_available == '1'): ?>
                                                    <span class="badge bg-primary p-2 role-badge">
                                                        <?php echo e(__('Available')); ?>

                                                    </span>
                                                <?php else: ?>
                                                    <span class="badge bg-danger p-2 role-badge">
                                                        <?php echo e(__('Unavailable')); ?>

                                                    </span>
                                                <?php endif; ?>
                                            </td>
                                        <?php endif; ?>
                                        <td class="text-end me-3">
                                            <?php if (app('laratrust')->hasPermission('user login manage')) : ?>
                                            <?php if($user->is_enable_login == 1): ?>
                                                <div class="action-btn me-2">
                                                    <a href="<?php echo e(route('users.login', \Crypt::encrypt($user->id))); ?>"
                                                        class="mx-3 btn btn-sm d-inline-flex align-items-center bg-danger"
                                                        data-bs-toggle="tooltip" data-bs-original-title="<?php echo e(__('Login Disable')); ?>">
                                                        <span class="text-white"><i class="ti ti-road-sign"></i></a>
                                                </div>
                                            <?php elseif($user->is_enable_login == 0 && $user->password == null): ?>
                                                <div class="action-btn me-2">
                                                    <a href="#" data-url="<?php echo e(route('user.reset', \Crypt::encrypt($user->id))); ?>"
                                                        data-ajax-popup="true" data-size="md"
                                                        class="mx-3 bg-secondary btn btn-sm d-inline-flex align-items-center login_enable"
                                                        data-title="<?php echo e(__('New Password')); ?>" data-bs-toggle="tooltip"
                                                        data-bs-original-title="<?php echo e(__('New Password')); ?>"> <span
                                                            class="text-white"><i class="ti ti-road-sign"></i></a>
                                                </div>
                                            <?php else: ?>
                                                <div class="action-btn me-2">
                                                    <a href="<?php echo e(route('users.login', \Crypt::encrypt($user->id))); ?>"
                                                        class="mx-3 bg-success btn btn-sm d-inline-flex align-items-center login_enable"
                                                        data-bs-toggle="tooltip" data-bs-original-title="<?php echo e(__('Login Enable')); ?>">
                                                        <span class="text-white"> <i class="ti ti-road-sign"></i>
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                            <?php endif; // app('laratrust')->permission ?>
                                            <?php if (app('laratrust')->hasPermission('user reset password')) : ?>
                                            <div class="action-btn me-2">
                                                <a href="#" class="mx-3 bg-warning btn btn-sm d-inline-flex align-items-center"
                                                    data-size="md"
                                                    data-url="<?php echo e(route('user.reset', \Crypt::encrypt($user->id))); ?>"
                                                    data-ajax-popup="true" data-title="<?php echo e(__('Reset Password')); ?>"
                                                    data-toggle="tooltip" title="<?php echo e(__('Reset Password')); ?>">
                                                    <span class="text-white"> <i class="ti ti-key"></i> </span>
                                                </a>
                                            </div>
                                            <?php endif; // app('laratrust')->permission ?>
                                            <?php if (app('laratrust')->hasPermission('user edit')) : ?>
                                            <div class="action-btn me-2">
                                                <a href="<?php echo e(route('admin.users.edit', $user->id)); ?>"
                                                    class="mx-3 bg-info btn btn-sm d-inline-flex align-items-center"
                                                    data-toggle="tooltip" title="<?php echo e(__('Edit')); ?>"> <span class="text-white"> <i
                                                            class="ti ti-pencil"></i></span></a>
                                            </div>
                                            <?php endif; // app('laratrust')->permission ?>
                                            <?php if (app('laratrust')->hasPermission('user delete')) : ?>
                                            <div class="action-btn">
                                                <form method="POST" action="<?php echo e(route('admin.users.destroy', $user->id)); ?>"
                                                    id="delete-form-<?php echo e($user->id); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <input name="_method" type="hidden" value="DELETE">

                                                    <a class="mx-3 bg-danger btn btn-sm  align-items-center bs-pass-para show_confirm"
                                                        data-bs-toggle="tooltip" title="" data-bs-original-title="Delete"
                                                        aria-label="Delete" data-confirm="<?php echo e(__('Are You Sure?')); ?>"
                                                        data-text="<?php echo e(__('This action can not be undone. Do you want to continue?')); ?>"
                                                        data-confirm-yes="delete-form-<?php echo e($user->id); ?>"><i
                                                            class="ti ti-trash text-white text-white"></i></a>
                                                </form>
                                            </div>
                                            <?php endif; // app('laratrust')->permission ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/sevenonesix/public_html/ticket.buffalorepair.net/resources/views/admin/users/index.blade.php ENDPATH**/ ?>