<?php
    config([
        'captcha.secret' => isset($settings['NOCAPTCHA_SECRET']) ? $settings['NOCAPTCHA_SECRET'] : '',
        'captcha.sitekey' => isset($settings['NOCAPTCHA_SITEKEY']) ? $settings['NOCAPTCHA_SITEKEY'] : '',
        'options' => [
            'timeout' => 30,
        ],
    ]);
?>

<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Create Ticket')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('css-page'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/floating_chat.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/summernote/summernote-bs4.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <?php if(moduleIsActive('OfficeHours')): ?>
        <?php echo $__env->yieldPushContent('add_homepage'); ?>
    <?php else: ?>
        <div class="auth-wrapper login-page">
            <div class="bottom-bg">
                <svg width="69" height="129" viewBox="0 0 69 129" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M2.6351 123.878C3.41663 123.079 4.68262 123.075 5.47146 123.847C6.2603 124.619 6.27396 125.895 5.50185 126.684C4.72031 127.482 3.45432 127.486 2.66548 126.714C1.87664 125.942 1.85356 124.676 2.6351 123.878Z"
                        fill="white" />
                    <path
                        d="M10.2806 116.066C11.0527 115.277 12.3281 115.263 13.117 116.035C13.9058 116.808 13.9195 118.083 13.1474 118.872C12.3658 119.67 11.0904 119.684 10.3016 118.912C9.52215 118.13 9.50849 116.855 10.2806 116.066Z"
                        fill="white" />
                    <path
                        d="M2.63314 108.58C3.40526 107.792 4.68067 107.778 5.46951 108.55C6.25835 109.322 6.27201 110.597 5.4999 111.386C4.71837 112.185 3.44295 112.198 2.65411 111.426C1.86507 110.635 1.86103 109.369 2.63314 108.58Z"
                        fill="white" />
                    <path
                        d="M17.9265 108.255C18.6986 107.466 19.993 107.452 20.7722 108.215C21.5611 108.987 21.5747 110.262 20.7932 111.061C20.0211 111.849 18.7457 111.863 17.9568 111.091C17.168 110.319 17.1543 109.043 17.9265 108.255Z"
                        fill="white" />
                    <path
                        d="M10.279 100.769C11.0511 99.98 12.3359 99.9567 13.1248 100.729C13.9136 101.501 13.9273 102.776 13.1458 103.575C12.3736 104.364 11.0982 104.377 10.3094 103.605C9.51092 102.824 9.50688 101.558 10.279 100.769Z"
                        fill="white" />
                    <path
                        d="M2.62177 93.2737C3.39389 92.4848 4.67872 92.4616 5.46756 93.2337C6.25639 94.0058 6.27006 95.2812 5.48853 96.0797C4.71641 96.8685 3.45061 96.8916 2.65215 96.1101C1.85369 95.3285 1.84965 94.0625 2.62177 93.2737Z"
                        fill="white" />
                    <path
                        d="M25.5814 100.433C26.3629 99.6349 27.6385 99.6403 28.4178 100.403C29.2066 101.175 29.2203 102.451 28.4481 103.239C27.676 104.028 26.3912 104.051 25.6024 103.279C24.8135 102.507 24.7999 101.232 25.5814 100.433Z"
                        fill="white" />
                    <path
                        d="M17.9339 92.9479C18.7155 92.1494 19.9815 92.1454 20.7703 92.9175C21.5591 93.6896 21.5728 94.965 20.8007 95.7539C20.0286 96.5427 18.7437 96.566 17.9549 95.7939C17.1564 95.0124 17.1524 93.7464 17.9339 92.9479Z"
                        fill="white" />
                    <path
                        d="M10.2757 85.4527C11.0573 84.6542 12.3232 84.6502 13.1121 85.4223C13.9009 86.1944 13.9146 87.4698 13.1425 88.2586C12.3704 89.0475 11.0951 89.0802 10.2967 88.2987C9.49823 87.5171 9.49419 86.2511 10.2757 85.4527Z"
                        fill="white" />
                    <path
                        d="M2.62826 77.9668C3.40979 77.1684 4.66617 77.1549 5.46463 77.9364C6.25346 78.7086 6.26713 79.984 5.49502 80.7728C4.7229 81.5616 3.43807 81.5849 2.64923 80.8128C1.85077 80.0313 1.84673 78.7653 2.62826 77.9668Z"
                        fill="white" />
                    <path
                        d="M33.2279 92.6221C34.0094 91.8236 35.285 91.829 36.0642 92.5917C36.8531 93.3638 36.8667 94.6392 36.0946 95.4281C35.3225 96.2169 34.0471 96.2306 33.2583 95.4585C32.4694 94.6863 32.4463 93.4206 33.2279 92.6221Z"
                        fill="white" />
                    <path
                        d="M25.5794 85.1361C26.361 84.3377 27.627 84.3336 28.4158 85.1057C29.2046 85.8779 29.2183 87.1533 28.4462 87.9421C27.6741 88.731 26.3987 88.7446 25.6098 87.9725C24.8114 87.191 24.7979 85.9346 25.5794 85.1361Z"
                        fill="white" />
                    <path
                        d="M17.9222 77.641C18.7037 76.8426 19.9697 76.8385 20.7586 77.6106C21.5474 78.3827 21.5611 79.6582 20.789 80.447C20.0168 81.2358 18.751 81.2589 17.9526 80.4774C17.1541 79.6959 17.1407 78.4395 17.9222 77.641Z"
                        fill="white" />
                    <path
                        d="M10.2747 70.1555C11.0563 69.3571 12.3127 69.3436 13.1111 70.1252C13.8999 70.8973 13.9136 72.1727 13.1415 72.9615C12.3694 73.7504 11.094 73.764 10.3051 72.9919C9.50667 72.2104 9.49321 70.954 10.2747 70.1555Z"
                        fill="white" />
                    <path
                        d="M2.60678 62.6507C3.38831 61.8522 4.65431 61.8482 5.44315 62.6203C6.23198 63.3924 6.24565 64.6678 5.47353 65.4566C4.70141 66.2455 3.426 66.2592 2.63716 65.487C1.84832 64.7149 1.82524 63.4491 2.60678 62.6507Z"
                        fill="white" />
                    <path
                        d="M40.8734 84.8107C41.6455 84.0219 42.9209 84.0082 43.7097 84.7803C44.4986 85.5524 44.5122 86.8278 43.7401 87.6167C42.9586 88.4151 41.6832 88.4288 40.8943 87.6567C40.1149 86.8749 40.1013 85.5995 40.8734 84.8107Z"
                        fill="white" />
                    <path
                        d="M33.2249 77.3249C33.9971 76.536 35.2725 76.5224 36.0613 77.2945C36.8501 78.0666 36.8638 79.342 36.0823 80.1405C35.3102 80.9293 34.0347 80.943 33.2459 80.1708C32.4569 79.3797 32.4528 78.1137 33.2249 77.3249Z"
                        fill="white" />
                    <path
                        d="M25.5687 69.8296C26.3408 69.0408 27.6162 69.0271 28.4051 69.7992C29.1939 70.5713 29.2076 71.8468 28.426 72.6452C27.6539 73.4341 26.3881 73.4571 25.5897 72.6756C24.8006 71.8845 24.7966 70.6185 25.5687 69.8296Z"
                        fill="white" />
                    <path
                        d="M17.9203 62.3439C18.6924 61.5551 19.9582 61.532 20.7566 62.3135C21.5455 63.0856 21.5591 64.361 20.7776 65.1595C20.0055 65.9483 18.7301 65.962 17.9412 65.1899C17.1522 64.3987 17.1481 63.1327 17.9203 62.3439Z"
                        fill="white" />
                    <path
                        d="M10.2533 54.8394C11.0254 54.0505 12.3008 54.0369 13.0896 54.809C13.8785 55.5811 13.8921 56.8565 13.1106 57.655C12.3385 58.4438 11.0631 58.4575 10.2742 57.6854C9.49481 56.9036 9.48114 55.6282 10.2533 54.8394Z"
                        fill="white" />
                    <path
                        d="M2.59505 47.3441C3.36717 46.5553 4.65221 46.5511 5.44104 47.3232C6.22988 48.0953 6.24355 49.3707 5.46201 50.1692C4.6899 50.958 3.41448 50.9717 2.62564 50.1996C1.8366 49.4084 1.82294 48.133 2.59505 47.3441Z"
                        fill="white" />
                    <path
                        d="M48.5192 76.9993C49.3008 76.2008 50.5762 76.1871 51.365 76.9593C52.1539 77.7314 52.1675 79.0068 51.386 79.8053C50.6139 80.5941 49.3385 80.6078 48.5496 79.8356C47.7608 79.0635 47.7471 77.7881 48.5192 76.9993Z"
                        fill="white" />
                    <path
                        d="M40.8708 69.5133C41.6523 68.7149 42.9277 68.7012 43.7166 69.4733C44.5054 70.2454 44.5191 71.5208 43.7376 72.3193C42.9654 73.1081 41.69 73.1218 40.9012 72.3497C40.1027 71.5681 40.0987 70.3021 40.8708 69.5133Z"
                        fill="white" />
                    <path
                        d="M33.2136 62.0182C33.9951 61.2197 35.2705 61.2061 36.0594 61.9782C36.8482 62.7503 36.8619 64.0257 36.0803 64.8242C35.3082 65.613 34.0424 65.6361 33.244 64.8546C32.4455 64.073 32.4415 62.807 33.2136 62.0182Z"
                        fill="white" />
                    <path
                        d="M25.5661 54.5324C26.3476 53.7339 27.6134 53.7108 28.4119 54.4923C29.2007 55.2645 29.2144 56.5399 28.4329 57.3383C27.6607 58.1272 26.3853 58.1408 25.5965 57.3687C24.798 56.5872 24.794 55.3212 25.5661 54.5324Z"
                        fill="white" />
                    <path
                        d="M17.8991 47.0278C18.6806 46.2294 19.9561 46.2157 20.7449 46.9878C21.5337 47.7599 21.5474 49.0354 20.7659 49.8338C19.9938 50.6227 18.7183 50.6363 17.9295 49.8642C17.1407 49.0921 17.127 47.8167 17.8991 47.0278Z"
                        fill="white" />
                    <path
                        d="M10.2419 39.5327C11.0234 38.7343 12.3085 38.73 13.0973 39.5021C13.8861 40.2742 13.8998 41.5497 13.1183 42.3481C12.3461 43.137 11.0707 43.1506 10.2819 42.3785C9.48344 41.597 9.46977 40.3216 10.2419 39.5327Z"
                        fill="white" />
                    <path
                        d="M2.59345 32.0469C3.37498 31.2484 4.6504 31.2348 5.43924 32.0069C6.22808 32.779 6.24174 34.0544 5.46021 34.8529C4.68809 35.6417 3.41268 35.6554 2.62384 34.8832C1.835 34.1111 1.82133 32.8357 2.59345 32.0469Z"
                        fill="white" />
                    <path
                        d="M56.1742 69.1783C56.9463 68.3894 58.2217 68.3757 59.0105 69.1479C59.7994 69.92 59.813 71.1954 59.0409 71.9842C58.2688 72.7731 56.9934 72.7867 56.2045 72.0146C55.4157 71.2425 55.3926 69.9767 56.1742 69.1783Z"
                        fill="white" />
                    <path
                        d="M48.5267 61.6924C49.2988 60.9036 50.5742 60.8899 51.3631 61.662C52.1519 62.4341 52.1656 63.7096 51.3935 64.4984C50.6213 65.2872 49.3459 65.3009 48.5571 64.5288C47.7586 63.7472 47.7452 62.4909 48.5267 61.6924Z"
                        fill="white" />
                    <path
                        d="M40.8695 54.1972C41.6416 53.4083 42.917 53.3947 43.7058 54.1668C44.4947 54.9389 44.5083 56.2143 43.7362 57.0032C42.9641 57.792 41.6983 57.8151 40.8999 57.0335C40.1014 56.252 40.0879 54.9956 40.8695 54.1972Z"
                        fill="white" />
                    <path
                        d="M33.221 46.7113C33.9931 45.9225 35.2589 45.8994 36.0574 46.6809C36.8462 47.4531 36.8599 48.7285 36.0878 49.5173C35.3157 50.3062 34.0403 50.3198 33.2514 49.5477C32.453 48.7662 32.4395 47.5098 33.221 46.7113Z"
                        fill="white" />
                    <path
                        d="M25.554 39.2069C26.3262 38.4181 27.6016 38.4044 28.3904 39.1766C29.1792 39.9487 29.1929 41.2241 28.4208 42.0129C27.6487 42.8018 26.3733 42.8154 25.5844 42.0433C24.7956 41.2712 24.7725 40.0054 25.554 39.2069Z"
                        fill="white" />
                    <path
                        d="M17.8968 31.7117C18.6689 30.9229 19.954 30.9186 20.7428 31.6907C21.5316 32.4628 21.5453 33.7383 20.7732 34.5271C20.0011 35.3159 18.7257 35.3296 17.9368 34.5575C17.1384 33.776 17.1153 32.5102 17.8968 31.7117Z"
                        fill="white" />
                    <path
                        d="M10.2484 24.2259C11.0205 23.437 12.2959 23.4234 13.0847 24.1955C13.8736 24.9676 13.8872 26.243 13.1151 27.0318C12.343 27.8207 11.0676 27.8343 10.2788 27.0622C9.48992 26.2901 9.46684 25.0243 10.2484 24.2259Z"
                        fill="white" />
                    <path
                        d="M2.59115 16.7307C3.36327 15.9419 4.63868 15.9282 5.43714 16.7098C6.22598 17.4819 6.23964 18.7573 5.46752 19.5461C4.69541 20.335 3.41037 20.3392 2.63115 19.5765C1.83269 18.795 1.80962 17.5292 2.59115 16.7307Z"
                        fill="white" />
                    <path
                        d="M63.8197 61.3666C64.5918 60.5778 65.8672 60.5641 66.656 61.3362C67.4449 62.1083 67.4585 63.3837 66.6864 64.1726C65.9049 64.971 64.6389 64.9751 63.85 64.203C63.0612 63.4309 63.0381 62.1651 63.8197 61.3666Z"
                        fill="white" />
                    <path
                        d="M56.1722 53.881C56.9443 53.0922 58.2101 53.0691 59.0086 53.8506C59.7974 54.6227 59.8111 55.8982 59.039 56.687C58.2574 57.4855 56.9914 57.4895 56.2026 56.7174C55.4041 55.9358 55.3907 54.6795 56.1722 53.881Z"
                        fill="white" />
                    <path
                        d="M48.515 46.3859C49.2871 45.5971 50.5529 45.574 51.3513 46.3555C52.1402 47.1276 52.1538 48.403 51.3817 49.1919C50.6002 49.9903 49.3438 50.0038 48.5454 49.2223C47.7469 48.4407 47.7334 47.1844 48.515 46.3859Z"
                        fill="white" />
                    <path
                        d="M40.8665 38.9001C41.6387 38.1112 42.9044 38.0881 43.7029 38.8697C44.4917 39.6418 44.5054 40.9172 43.7333 41.706C42.9518 42.5045 41.6858 42.5085 40.8969 41.7364C40.0985 40.9549 40.085 39.6985 40.8665 38.9001Z"
                        fill="white" />
                    <path
                        d="M33.2005 31.3955C33.9726 30.6067 35.2481 30.593 36.0369 31.3652C36.8257 32.1373 36.8394 33.4127 36.0673 34.2015C35.2857 35 34.0197 35.004 33.2309 34.2319C32.4421 33.4598 32.419 32.194 33.2005 31.3955Z"
                        fill="white" />
                    <path
                        d="M25.5423 23.9004C26.3144 23.1116 27.5995 23.1073 28.3883 23.8794C29.1771 24.6516 29.1908 25.927 28.4187 26.7158C27.6372 27.5143 26.3712 27.5183 25.5823 26.7462C24.7935 25.9741 24.7608 24.6989 25.5423 23.9004Z"
                        fill="white" />
                    <path
                        d="M17.8949 16.4146C18.667 15.6257 19.9424 15.6121 20.7312 16.3842C21.5201 17.1563 21.5337 18.4317 20.7616 19.2206C19.9801 20.019 18.7141 20.0231 17.9252 19.2509C17.1364 18.4788 17.1133 17.213 17.8949 16.4146Z"
                        fill="white" />
                    <path
                        d="M10.2367 8.91934C11.0088 8.1305 12.2842 8.11684 13.0826 8.89837C13.8715 9.67049 13.8851 10.9459 13.113 11.7347C12.3315 12.5332 11.0655 12.5372 10.2767 11.7651C9.4782 10.9836 9.45512 9.7178 10.2367 8.91934Z"
                        fill="white" />
                    <path
                        d="M2.5892 1.4335C3.36131 0.644661 4.62711 0.621582 5.42557 1.40311C6.2144 2.17523 6.22807 3.45065 5.45595 4.23948C4.67442 5.03794 3.40842 5.04199 2.61958 4.26987C1.82112 3.48834 1.80766 2.23196 2.5892 1.4335Z"
                        fill="white" />
                </svg>
            </div>
            <div class="auth-content ticket-form-wrapper">
                
                <?php echo $__env->make('layouts.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                <div class="row login-row">
                    <div class="top-bg">
                        <svg width="66" height="129" viewBox="0 0 66 129" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M65.4557 123.878C64.6742 123.079 63.4082 123.075 62.6194 123.847C61.8305 124.619 61.8169 125.895 62.589 126.684C63.3705 127.482 64.6365 127.486 65.4253 126.714C66.2142 125.942 66.2373 124.676 65.4557 123.878Z"
                                fill="white"></path>
                            <path
                                d="M57.8095 116.066C57.0374 115.277 55.762 115.264 54.9731 116.036C54.1843 116.808 54.1706 118.083 54.9427 118.872C55.7243 119.671 56.9997 119.684 57.7885 118.912C58.5679 118.13 58.5816 116.855 57.8095 116.066Z"
                                fill="white"></path>
                            <path
                                d="M65.4574 108.58C64.6853 107.791 63.4099 107.777 62.6211 108.549C61.8322 109.322 61.8186 110.597 62.5907 111.386C63.3722 112.184 64.6476 112.198 65.4365 111.426C66.2255 110.635 66.2296 109.369 65.4574 108.58Z"
                                fill="white"></path>
                            <path
                                d="M50.1636 108.255C49.3915 107.466 48.0971 107.452 47.3178 108.215C46.529 108.987 46.5153 110.262 47.2969 111.061C48.069 111.849 49.3444 111.863 50.1332 111.091C50.9221 110.319 50.9357 109.043 50.1636 108.255Z"
                                fill="white"></path>
                            <path
                                d="M57.8113 100.769C57.0392 99.9803 55.7544 99.957 54.9655 100.729C54.1767 101.501 54.163 102.777 54.9446 103.575C55.7167 104.364 56.9921 104.378 57.781 103.606C58.5794 102.824 58.5835 101.558 57.8113 100.769Z"
                                fill="white"></path>
                            <path
                                d="M65.469 93.2741C64.6969 92.4852 63.4121 92.4619 62.6233 93.234C61.8344 94.0062 61.8208 95.2816 62.6023 96.08C63.3744 96.8689 64.6402 96.892 65.4387 96.1104C66.2371 95.3289 66.2412 94.0629 65.469 93.2741Z"
                                fill="white"></path>
                            <path
                                d="M42.5087 100.433C41.7272 99.6349 40.4516 99.6403 39.6723 100.403C38.8835 101.175 38.8698 102.451 39.642 103.239C40.4141 104.028 41.6989 104.051 42.4877 103.279C43.2766 102.507 43.2902 101.232 42.5087 100.433Z"
                                fill="white"></path>
                            <path
                                d="M50.1567 92.948C49.3751 92.1496 48.1091 92.1455 47.3203 92.9176C46.5314 93.6898 46.5178 94.9652 47.2899 95.754C48.062 96.5428 49.3468 96.5661 50.1357 95.794C50.9341 95.0125 50.9382 93.7465 50.1567 92.948Z"
                                fill="white"></path>
                            <path
                                d="M57.8141 85.4529C57.0326 84.6544 55.7666 84.6504 54.9778 85.4225C54.1889 86.1946 54.1753 87.4701 54.9474 88.2589C55.7195 89.0477 56.9947 89.0804 57.7932 88.2989C58.5916 87.5174 58.5957 86.2514 57.8141 85.4529Z"
                                fill="white"></path>
                            <path
                                d="M65.4621 77.9666C64.6805 77.1681 63.4242 77.1547 62.6257 77.9362C61.8369 78.7083 61.8232 79.9837 62.5953 80.7726C63.3674 81.5614 64.6523 81.5847 65.4411 80.8126C66.2396 80.031 66.2436 78.765 65.4621 77.9666Z"
                                fill="white"></path>
                            <path
                                d="M34.8627 92.6219C34.0812 91.8234 32.8056 91.8288 32.0263 92.5915C31.2375 93.3636 31.2238 94.639 31.996 95.4278C32.7681 96.2167 34.0435 96.2303 34.8323 95.4582C35.6212 94.6861 35.6442 93.4203 34.8627 92.6219Z"
                                fill="white"></path>
                            <path
                                d="M42.5104 85.1365C41.7289 84.338 40.4629 84.334 39.674 85.1061C38.8852 85.8782 38.8715 87.1536 39.6437 87.9425C40.4158 88.7313 41.6912 88.745 42.48 87.9729C43.2785 87.1913 43.2919 85.935 42.5104 85.1365Z"
                                fill="white"></path>
                            <path
                                d="M50.1681 77.6414C49.3866 76.8429 48.1206 76.8389 47.3318 77.611C46.5429 78.3831 46.5293 79.6585 47.3014 80.4474C48.0735 81.2362 49.3393 81.2593 50.1377 80.4778C50.9362 79.6962 50.9497 78.4398 50.1681 77.6414Z"
                                fill="white"></path>
                            <path
                                d="M57.8158 70.1551C57.0343 69.3566 55.7779 69.3431 54.9795 70.1247C54.1906 70.8968 54.177 72.1722 54.9491 72.961C55.7212 73.7499 56.9966 73.7635 57.7855 72.9914C58.5839 72.2099 58.5974 70.9535 57.8158 70.1551Z"
                                fill="white"></path>
                            <path
                                d="M65.4833 62.6511C64.7018 61.8527 63.4358 61.8487 62.6469 62.6208C61.8581 63.3929 61.8444 64.6683 62.6166 65.4571C63.3887 66.246 64.6641 66.2596 65.4529 65.4875C66.2418 64.7154 66.2648 63.4496 65.4833 62.6511Z"
                                fill="white"></path>
                            <path
                                d="M27.2172 84.8103C26.4451 84.0215 25.1697 84.0078 24.3808 84.7799C23.592 85.5521 23.5783 86.8275 24.3504 87.6163C25.132 88.4148 26.4074 88.4284 27.1962 87.6563C27.9757 86.8746 27.9893 85.5992 27.2172 84.8103Z"
                                fill="white"></path>
                            <path
                                d="M34.8652 77.325C34.093 76.5361 32.8176 76.5225 32.0288 77.2946C31.2399 78.0667 31.2263 79.3421 32.0078 80.1406C32.7799 80.9294 34.0553 80.9431 34.8442 80.171C35.6332 79.3798 35.6373 78.1138 34.8652 77.325Z"
                                fill="white"></path>
                            <path
                                d="M42.5219 69.8299C41.7498 69.041 40.4744 69.0274 39.6855 69.7995C38.8967 70.5716 38.883 71.847 39.6645 72.6455C40.4367 73.4343 41.7025 73.4574 42.5009 72.6759C43.29 71.8847 43.294 70.6187 42.5219 69.8299Z"
                                fill="white"></path>
                            <path
                                d="M50.1706 62.3435C49.3985 61.5547 48.1327 61.5316 47.3342 62.3131C46.5454 63.0853 46.5317 64.3607 47.3132 65.1591C48.0853 65.948 49.3608 65.9616 50.1496 65.1895C50.9386 64.3984 50.9427 63.1324 50.1706 62.3435Z"
                                fill="white"></path>
                            <path
                                d="M57.8371 54.8396C57.065 54.0508 55.7895 54.0371 55.0007 54.8092C54.2119 55.5814 54.1982 56.8568 54.9797 57.6552C55.7519 58.4441 57.0273 58.4577 57.8161 57.6856C58.5955 56.9039 58.6092 55.6285 57.8371 54.8396Z"
                                fill="white"></path>
                            <path
                                d="M65.4948 47.3445C64.7227 46.5557 63.4376 46.5514 62.6488 47.3235C61.86 48.0957 61.8463 49.3711 62.6278 50.1695C63.3999 50.9584 64.6754 50.972 65.4642 50.1999C66.2532 49.4088 66.2669 48.1333 65.4948 47.3445Z"
                                fill="white"></path>
                            <path
                                d="M19.5711 76.9996C18.7896 76.2012 17.5142 76.1875 16.7253 76.9596C15.9365 77.7317 15.9228 79.0072 16.7043 79.8056C17.4765 80.5945 18.7519 80.6081 19.5407 79.836C20.3296 79.0639 20.3432 77.7885 19.5711 76.9996Z"
                                fill="white"></path>
                            <path
                                d="M27.219 69.5133C26.4375 68.7149 25.1621 68.7012 24.3733 69.4733C23.5844 70.2454 23.5708 71.5208 24.3523 72.3193C25.1244 73.1081 26.3998 73.1218 27.1887 72.3497C27.9871 71.5681 27.9912 70.3021 27.219 69.5133Z"
                                fill="white"></path>
                            <path
                                d="M34.8768 62.0182C34.0952 61.2197 32.8198 61.2061 32.031 61.9782C31.2421 62.7503 31.2285 64.0257 32.01 64.8242C32.7821 65.613 34.0479 65.6361 34.8464 64.8546C35.6448 64.073 35.6489 62.807 34.8768 62.0182Z"
                                fill="white"></path>
                            <path
                                d="M42.5245 54.5319C41.7429 53.7334 40.4771 53.7103 39.6787 54.4919C38.8898 55.264 38.8762 56.5394 39.6577 57.3378C40.4298 58.1267 41.7052 58.1403 42.4941 57.3682C43.2925 56.5867 43.2966 55.3207 42.5245 54.5319Z"
                                fill="white"></path>
                            <path
                                d="M50.1912 47.028C49.4097 46.2295 48.1343 46.2158 47.3454 46.988C46.5566 47.7601 46.5429 49.0355 47.3245 49.8339C48.0966 50.6228 49.372 50.6364 50.1608 49.8643C50.9497 49.0922 50.9633 47.8168 50.1912 47.028Z"
                                fill="white"></path>
                            <path
                                d="M57.8489 39.5328C57.0674 38.7344 55.7824 38.7301 54.9935 39.5023C54.2047 40.2744 54.191 41.5498 54.9726 42.3482C55.7447 43.1371 57.0201 43.1507 57.8089 42.3786C58.6074 41.5971 58.621 40.3217 57.8489 39.5328Z"
                                fill="white"></path>
                            <path
                                d="M65.4966 32.0465C64.7151 31.2481 63.4397 31.2344 62.6509 32.0065C61.862 32.7786 61.8483 34.054 62.6299 34.8525C63.402 35.6413 64.6774 35.655 65.4663 34.8829C66.2551 34.1108 66.2688 32.8354 65.4966 32.0465Z"
                                fill="white"></path>
                            <path
                                d="M11.9157 69.1785C11.1436 68.3897 9.86816 68.376 9.07932 69.1481C8.29048 69.9202 8.27682 71.1956 9.04894 71.9845C9.82105 72.7733 11.0965 72.787 11.8853 72.0149C12.6741 71.2427 12.6972 69.977 11.9157 69.1785Z"
                                fill="white"></path>
                            <path
                                d="M19.5636 61.6922C18.7915 60.9033 17.5161 60.8897 16.7273 61.6618C15.9384 62.4339 15.9248 63.7093 16.6969 64.4982C17.469 65.287 18.7444 65.3007 19.5333 64.5285C20.3317 63.747 20.3452 62.4906 19.5636 61.6922Z"
                                fill="white"></path>
                            <path
                                d="M27.2211 54.197C26.449 53.4082 25.1736 53.3945 24.3847 54.1667C23.5959 54.9388 23.5822 56.2142 24.3544 57.003C25.1265 57.7919 26.3923 57.815 27.1907 57.0334C27.9892 56.2519 28.0026 54.9955 27.2211 54.197Z"
                                fill="white"></path>
                            <path
                                d="M34.8691 46.7117C34.0969 45.9229 32.8311 45.8998 32.0327 46.6813C31.2438 47.4534 31.2302 48.7288 32.0023 49.5177C32.7744 50.3065 34.0498 50.3202 34.8387 49.5481C35.6371 48.7665 35.6506 47.5102 34.8691 46.7117Z"
                                fill="white"></path>
                            <path
                                d="M42.5363 39.2068C41.7642 38.418 40.4888 38.4043 39.6999 39.1764C38.9111 39.9485 38.8974 41.224 39.6695 42.0128C40.4417 42.8016 41.7171 42.8153 42.5059 42.0432C43.2947 41.2711 43.3178 40.0053 42.5363 39.2068Z"
                                fill="white"></path>
                            <path
                                d="M50.194 31.7117C49.4219 30.9229 48.1369 30.9186 47.348 31.6907C46.5592 32.4628 46.5455 33.7383 47.3176 34.5271C48.0897 35.3159 49.3652 35.3296 50.154 34.5575C50.9525 33.776 50.9755 32.5102 50.194 31.7117Z"
                                fill="white"></path>
                            <path
                                d="M57.8417 24.2263C57.0696 23.4375 55.7942 23.4238 55.0053 24.196C54.2165 24.9681 54.2028 26.2435 54.975 27.0323C55.7471 27.8212 57.0225 27.8348 57.8113 27.0627C58.6002 26.2906 58.6232 25.0248 57.8417 24.2263Z"
                                fill="white"></path>
                            <path
                                d="M65.4994 16.7312C64.7273 15.9424 63.4519 15.9287 62.6534 16.7103C61.8646 17.4824 61.8509 18.7578 62.6231 19.5466C63.3952 20.3355 64.6802 20.3397 65.4594 19.577C66.2579 18.7955 66.281 17.5297 65.4994 16.7312Z"
                                fill="white"></path>
                            <path
                                d="M4.27018 61.367C3.49806 60.5781 2.22265 60.5645 1.43381 61.3366C0.644973 62.1087 0.631312 63.3841 1.40343 64.173C2.18496 64.9714 3.45096 64.9755 4.2398 64.2033C5.02863 63.4312 5.05171 62.1654 4.27018 61.367Z"
                                fill="white"></path>
                            <path
                                d="M11.9181 53.8806C11.146 53.0918 9.88022 53.0687 9.08176 53.8503C8.29292 54.6224 8.27926 55.8978 9.05137 56.6866C9.83291 57.4851 11.0989 57.4891 11.8877 56.717C12.6862 55.9355 12.6997 54.6791 11.9181 53.8806Z"
                                fill="white"></path>
                            <path
                                d="M19.5751 46.3855C18.803 45.5967 17.5372 45.5736 16.7387 46.3551C15.9499 47.1273 15.9362 48.4027 16.7084 49.1915C17.4899 49.99 18.7463 50.0034 19.5447 49.2219C20.3432 48.4404 20.3566 47.184 19.5751 46.3855Z"
                                fill="white"></path>
                            <path
                                d="M27.2235 38.9002C26.4514 38.1113 25.1856 38.0883 24.3872 38.8698C23.5983 39.6419 23.5847 40.9173 24.3568 41.7062C25.1383 42.5046 26.4043 42.5087 27.1932 41.7365C27.9916 40.955 28.0051 39.6986 27.2235 38.9002Z"
                                fill="white"></path>
                            <path
                                d="M34.8903 31.3953C34.1182 30.6065 32.8428 30.5928 32.0539 31.3649C31.2651 32.137 31.2514 33.4124 32.0235 34.2013C32.8051 34.9997 34.0711 35.0038 34.8599 34.2317C35.6487 33.4595 35.6718 32.1938 34.8903 31.3953Z"
                                fill="white"></path>
                            <path
                                d="M42.5478 23.9002C41.7757 23.1113 40.4906 23.1071 39.7018 23.8792C38.9129 24.6513 38.8993 25.9267 39.6714 26.7156C40.4529 27.514 41.7189 27.5181 42.5078 26.746C43.2966 25.9738 43.3293 24.6986 42.5478 23.9002Z"
                                fill="white"></path>
                            <path
                                d="M50.1957 16.4148C49.4236 15.626 48.1482 15.6123 47.3593 16.3844C46.5705 17.1566 46.5568 18.432 47.329 19.2208C48.1105 20.0193 49.3765 20.0233 50.1653 19.2512C50.9542 18.4791 50.9772 17.2133 50.1957 16.4148Z"
                                fill="white"></path>
                            <path
                                d="M57.8534 8.91971C57.0813 8.13087 55.8059 8.1172 55.0074 8.89874C54.2186 9.67085 54.2049 10.9463 54.9771 11.7351C55.7586 12.5336 57.0246 12.5376 57.8134 11.7655C58.6119 10.984 58.635 9.71816 57.8534 8.91971Z"
                                fill="white"></path>
                            <path
                                d="M65.5011 1.43338C64.729 0.644539 63.4632 0.62146 62.6648 1.40299C61.8759 2.17511 61.8623 3.45052 62.6344 4.23936C63.4159 5.03782 64.6819 5.04186 65.4708 4.26975C66.2692 3.48822 66.2827 2.23184 65.5011 1.43338Z"
                                fill="white"></path>
                        </svg>
                    </div>

                    <div class="col-lg-6 col-12">
                        <div class="login-img">
                            <svg width="752" height="752" viewBox="0 0 752 752" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <circle cx="376" cy="376" r="376" fill="white" fill-opacity="0.1" />
                                <circle cx="376" cy="376" r="331.93" fill="white" fill-opacity="0.1" />
                                <path d="M523.769 29.0674H521.572V146.529H523.769V29.0674Z" fill="white" />
                                <path d="M528.779 136.734H516.563V144.993H528.779V136.734Z" fill="#382424" />
                                <path d="M528.779 139.481H516.563V144.993H528.779V139.481Z" fill="#584343" />
                                <path
                                    d="M524.818 208.819C529.875 207.629 533.009 202.566 531.82 197.51C530.63 192.453 525.567 189.319 520.511 190.508C515.454 191.698 512.32 196.761 513.509 201.817C514.699 206.874 519.762 210.008 524.818 208.819Z"
                                    fill="#FFC727" />
                                <path
                                    d="M553.285 199.662H492.067L503.155 180.009L512.198 143.532H533.155L542.199 180.009L553.285 199.662Z"
                                    fill="#382424" />
                                <path d="M390.371 0H387.874V111.541H390.371V0Z" fill="white" />
                                <path d="M396.066 100.408H382.182V109.796H396.066V100.408Z" fill="#382424" />
                                <path d="M396.066 103.531H382.182V109.796H396.066V103.531Z" fill="#584343" />
                                <path
                                    d="M399.818 171.929C399.818 177.833 395.032 182.618 389.129 182.618C383.225 182.618 378.44 177.833 378.44 171.929C378.44 166.026 383.225 161.24 389.129 161.24C395.032 161.24 399.818 166.024 399.818 171.929Z"
                                    fill="#FFC727" />
                                <path
                                    d="M423.916 171.929H354.34L366.94 149.593L377.22 108.133H401.037L411.316 149.593L423.916 171.929Z"
                                    fill="#382424" />
                                <path d="M266.149 16.8777H263.891V96.9999H266.149V16.8777Z" fill="white" />
                                <path d="M271.3 86.9329H258.744V95.422H271.3V86.9329Z" fill="#382424" />
                                <path d="M271.3 89.7562H258.744V95.4221H271.3V89.7562Z" fill="#584343" />
                                <path
                                    d="M274.692 151.61C274.692 156.948 270.364 161.277 265.025 161.277C259.687 161.277 255.358 156.95 255.358 151.61C255.358 146.271 259.687 141.943 265.025 141.943C270.365 141.943 274.692 146.271 274.692 151.61Z"
                                    fill="#FFC727" />
                                <path
                                    d="M296.486 151.61H233.567L244.962 131.412L254.256 93.9196H275.796L285.091 131.412L296.486 151.61Z"
                                    fill="#382424" />
                                <path
                                    d="M152.424 342.987C152.424 344.955 150.828 346.551 148.86 346.551C146.891 346.551 145.295 344.956 145.295 342.987C145.295 341.019 146.891 339.422 148.86 339.422C150.828 339.424 152.424 341.019 152.424 342.987Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M166.976 342.987C166.976 344.955 165.381 346.551 163.411 346.551C161.443 346.551 159.847 344.956 159.847 342.987C159.847 341.019 161.442 339.422 163.411 339.422C165.381 339.424 166.976 341.019 166.976 342.987Z"
                                    fill="#EBEBEB" />
                                <path
                                    d="M181.532 342.987C181.532 344.955 179.937 346.551 177.967 346.551C175.999 346.551 174.402 344.956 174.402 342.987C174.402 341.019 175.999 339.422 177.967 339.422C179.935 339.424 181.532 341.019 181.532 342.987Z"
                                    fill="#13D979" />
                                <path
                                    d="M72.6475 630.068L151.767 629.725L230.887 629.599L389.126 629.363L547.365 629.597L626.484 629.722L705.604 630.068L626.484 630.413L547.365 630.538L389.126 630.774L230.887 630.536L151.767 630.412L72.6475 630.068Z"
                                    fill="#060606" />
                                <path d="M321.287 615.128H141.151V630.048H321.287V615.128Z" fill="#455A64" />
                                <path d="M664.293 615.128H321.286V630.048H664.293V615.128Z" fill="#37474F" />
                                <path d="M484.184 615.126H141.149L94.3926 395.153H437.428L484.184 615.126Z" fill="#060606" />
                                <path d="M249.495 601.238H152.087L111.234 409.041H208.642L249.495 601.238Z" fill="white" />
                                <path
                                    d="M150.047 481.229C149.399 481.693 148.647 482.047 147.793 482.264C145.587 482.833 143.159 482.396 141.024 481.225C138.937 480.084 137.126 478.243 136.085 475.968C133.984 471.362 135.813 466.72 140.18 465.598C144.542 464.472 149.784 467.292 151.889 471.897C153.579 475.604 152.719 479.332 150.047 481.229Z"
                                    fill="#C7C7C7" />
                                <path
                                    d="M146.386 472.952C146.693 474.394 145.773 475.562 144.33 475.562C142.888 475.562 141.471 474.393 141.164 472.952C140.858 471.51 141.778 470.342 143.22 470.342C144.663 470.342 146.079 471.51 146.386 472.952Z"
                                    fill="white" />
                                <path
                                    d="M149.818 480.152L150.047 481.229C149.4 481.693 148.647 482.046 147.793 482.264C145.587 482.833 143.16 482.396 141.025 481.225L140.797 480.152C140.268 477.666 141.856 475.641 144.349 475.641C146.842 475.641 149.289 477.667 149.818 480.152Z"
                                    fill="white" />
                                <path d="M196.643 468.721H157.568L156.852 465.352H195.926L196.643 468.721Z" fill="#C7C7C7" />
                                <path d="M212.26 474.89H158.879L158.468 472.952H211.849L212.26 474.89Z" fill="#C7C7C7" />
                                <path d="M213.151 479.077H159.77L159.358 477.137H212.739L213.151 479.077Z" fill="#C7C7C7" />
                                <path class="theme-color"
                                    d="M155.747 508.054C155.099 508.516 154.347 508.871 153.493 509.089C151.287 509.657 148.859 509.22 146.724 508.05C144.637 506.909 142.826 505.068 141.785 502.794C139.684 498.189 141.514 493.546 145.88 492.424C150.242 491.298 155.484 494.118 157.589 498.723C159.28 502.428 158.419 506.156 155.747 508.054Z"
                                    fill="#13D979" />
                                <path
                                    d="M152.087 499.776C152.393 501.217 151.473 502.387 150.031 502.387C148.588 502.387 147.171 501.217 146.865 499.776C146.558 498.334 147.478 497.166 148.921 497.166C150.363 497.165 151.781 498.334 152.087 499.776Z"
                                    fill="white" />
                                <path
                                    d="M155.518 506.976L155.747 508.054C155.1 508.516 154.348 508.871 153.494 509.089C151.288 509.657 148.86 509.22 146.725 508.05L146.497 506.976C145.968 504.491 147.556 502.466 150.049 502.466C152.542 502.466 154.989 504.492 155.518 506.976Z"
                                    fill="white" />
                                <path d="M202.343 495.546H163.269L162.552 492.176H201.627L202.343 495.546Z" fill="#C7C7C7" />
                                <path d="M217.961 501.715H164.582L164.169 499.776H217.55L217.961 501.715Z" fill="#C7C7C7" />
                                <path d="M218.852 505.902H165.471L165.059 503.962H218.439L218.852 505.902Z" fill="#C7C7C7" />
                                <path
                                    d="M161.448 534.879C160.8 535.342 160.048 535.696 159.194 535.914C156.988 536.482 154.56 536.045 152.425 534.874C150.338 533.733 148.527 531.892 147.486 529.617C145.385 525.012 147.215 520.37 151.581 519.247C155.943 518.121 161.185 520.941 163.29 525.546C164.982 529.252 164.122 532.981 161.448 534.879Z"
                                    fill="#455A64" />
                                <path
                                    d="M157.79 526.601C158.096 528.043 157.176 529.211 155.734 529.211C154.291 529.211 152.875 528.042 152.568 526.601C152.261 525.159 153.181 523.991 154.624 523.991C156.066 523.99 157.483 525.159 157.79 526.601Z"
                                    fill="white" />
                                <path
                                    d="M161.219 533.801L161.448 534.879C160.801 535.342 160.048 535.696 159.194 535.914C156.988 536.482 154.561 536.045 152.425 534.874L152.198 533.801C151.67 531.315 153.257 529.291 155.75 529.291C158.243 529.291 160.692 531.317 161.219 533.801Z"
                                    fill="white" />
                                <path d="M208.046 522.37H168.97L168.255 519.001H207.329L208.046 522.37Z" fill="#C7C7C7" />
                                <path d="M223.664 528.54H170.283L169.87 526.601H223.251L223.664 528.54Z" fill="#C7C7C7" />
                                <path d="M224.553 532.726H171.172L170.761 530.786H224.142L224.553 532.726Z" fill="#C7C7C7" />
                                <path
                                    d="M167.15 561.703C166.503 562.167 165.75 562.521 164.896 562.738C162.69 563.307 160.263 562.87 158.128 561.699C156.04 560.558 154.229 558.717 153.188 556.442C151.087 551.837 152.917 547.194 157.283 546.072C161.646 544.946 166.887 547.766 168.993 552.371C170.684 556.077 169.823 559.806 167.15 561.703Z"
                                    fill="#060606" />
                                <path
                                    d="M163.49 553.424C163.797 554.867 162.876 556.035 161.434 556.035C159.992 556.035 158.575 554.865 158.268 553.424C157.961 551.982 158.882 550.814 160.324 550.814C161.766 550.814 163.183 551.984 163.49 553.424Z"
                                    fill="white" />
                                <path
                                    d="M166.922 560.626L167.151 561.703C166.503 562.167 165.751 562.521 164.897 562.738C162.691 563.307 160.263 562.87 158.128 561.699L157.9 560.626C157.372 558.14 158.959 556.115 161.452 556.115C163.945 556.115 166.393 558.14 166.922 560.626Z"
                                    fill="white" />
                                <path d="M213.747 549.195H174.673L173.956 545.824H213.03L213.747 549.195Z" fill="#C7C7C7" />
                                <path d="M229.365 555.364H175.985L175.573 553.424H228.954L229.365 555.364Z" fill="#C7C7C7" />
                                <path d="M230.257 559.55H176.876L176.463 557.611H229.844L230.257 559.55Z" fill="#C7C7C7" />
                                <path
                                    d="M172.851 588.527C172.204 588.99 171.451 589.344 170.597 589.562C168.392 590.13 165.964 589.693 163.829 588.522C161.742 587.381 159.93 585.54 158.89 583.267C156.788 578.661 158.618 574.019 162.985 572.896C167.347 571.771 172.588 574.59 174.694 579.196C176.385 582.902 175.524 586.629 172.851 588.527Z"
                                    fill="#C7C7C7" />
                                <path
                                    d="M169.193 580.249C169.5 581.691 168.579 582.859 167.137 582.859C165.695 582.859 164.278 581.69 163.971 580.249C163.664 578.807 164.585 577.639 166.027 577.639C167.469 577.639 168.886 578.808 169.193 580.249Z"
                                    fill="white" />
                                <path
                                    d="M172.623 587.451L172.852 588.528C172.204 588.992 171.452 589.345 170.598 589.563C168.392 590.131 165.964 589.695 163.829 588.524L163.602 587.451C163.073 584.965 164.661 582.94 167.154 582.94C169.646 582.94 172.094 584.965 172.623 587.451Z"
                                    fill="white" />
                                <path d="M219.449 576.02H180.375L179.659 572.649H218.733L219.449 576.02Z" fill="#C7C7C7" />
                                <path d="M235.068 582.189H181.687L181.274 580.249H234.655L235.068 582.189Z" fill="#C7C7C7" />
                                <path d="M235.958 586.375H182.577L182.164 584.436H235.545L235.958 586.375Z" fill="#C7C7C7" />
                                <path
                                    d="M135.378 435.477C134.975 435.765 134.506 435.986 133.975 436.122C132.602 436.475 131.091 436.204 129.762 435.475C128.462 434.766 127.335 433.619 126.688 432.203C125.38 429.337 126.519 426.447 129.237 425.749C131.952 425.047 135.215 426.803 136.526 429.67C137.578 431.976 137.042 434.296 135.378 435.477Z"
                                    fill="#C7C7C7" />
                                <path
                                    d="M133.103 430.324C133.294 431.222 132.721 431.949 131.823 431.949C130.925 431.949 130.043 431.222 129.852 430.324C129.661 429.426 130.234 428.7 131.132 428.7C132.03 428.7 132.912 429.426 133.103 430.324Z"
                                    fill="white" />
                                <path
                                    d="M135.237 434.806L135.38 435.477C134.977 435.765 134.507 435.986 133.977 436.122C132.604 436.475 131.092 436.204 129.763 435.475L129.622 434.808C129.292 433.261 130.281 432 131.833 432C133.385 431.998 134.909 433.26 135.237 434.806Z"
                                    fill="white" />
                                <path
                                    d="M202.263 432.113C202.21 431.863 202.369 431.66 202.62 431.66C202.87 431.66 203.115 431.863 203.168 432.113C203.222 432.363 203.062 432.565 202.812 432.565C202.562 432.565 202.317 432.362 202.263 432.113Z"
                                    fill="#C7C7C7" />
                                <path
                                    d="M201.882 430.324C201.83 430.075 201.988 429.872 202.238 429.872C202.487 429.872 202.733 430.074 202.786 430.324C202.839 430.575 202.68 430.777 202.429 430.777C202.179 430.777 201.936 430.575 201.882 430.324Z"
                                    fill="#C7C7C7" />
                                <path
                                    d="M201.504 428.536C201.45 428.287 201.61 428.083 201.86 428.083C202.11 428.083 202.355 428.285 202.409 428.536C202.461 428.786 202.302 428.988 202.052 428.988C201.802 428.988 201.556 428.786 201.504 428.536Z"
                                    fill="#C7C7C7" />
                                <path d="M195.691 431.467H190.53L189.811 428.084H194.973L195.691 431.467Z" fill="#C7C7C7" />
                                <path d="M190.53 431.467L190.764 432.565L191.647 431.467H190.53Z" fill="#C7C7C7" />
                                <path d="M194.184 428.988H190.987L190.919 428.673H194.116L194.184 428.988Z" fill="white" />
                                <path d="M194.325 429.658H191.129L191.062 429.343H194.259L194.325 429.658Z" fill="white" />
                                <path d="M194.468 430.33H191.271L191.204 430.015H194.401L194.468 430.33Z" fill="white" />
                                <path d="M428.702 419.437H113.444L111.234 409.041H426.492L428.702 419.437Z" fill="#37474F" />
                                <path
                                    d="M120.603 414.239C120.905 415.663 119.996 416.817 118.572 416.817C117.148 416.817 115.748 415.663 115.446 414.239C115.143 412.815 116.052 411.661 117.476 411.661C118.9 411.661 120.3 412.815 120.603 414.239Z"
                                    fill="#C7C7C7" />
                                <path
                                    d="M131.129 414.239C131.432 415.663 130.522 416.817 129.098 416.817C127.675 416.817 126.275 415.663 125.972 414.239C125.67 412.815 126.579 411.661 128.003 411.661C129.427 411.661 130.826 412.815 131.129 414.239Z"
                                    fill="white" />
                                <path
                                    d="M141.657 414.239C141.96 415.663 141.051 416.817 139.627 416.817C138.203 416.817 136.803 415.663 136.5 414.239C136.198 412.815 137.107 411.661 138.531 411.661C139.955 411.661 141.355 412.815 141.657 414.239Z"
                                    fill="#13D979" />
                                <path d="M428.703 419.437H210.852L249.496 601.238H467.346L428.703 419.437Z" fill="#EBEBEB" />
                                <path d="M448.527 592.473H267.621L265.368 581.878H446.275L448.527 592.473Z" fill="white" />
                                <path class="theme-color"
                                    d="M444.913 587.308C445.22 588.751 444.299 589.921 442.863 589.921C441.427 589.921 440.001 588.751 439.694 587.308C439.388 585.873 440.317 584.702 441.754 584.702C443.189 584.703 444.607 585.873 444.913 587.308Z"
                                    fill="#13D979" />
                                <path
                                    d="M441.504 585.802L443.435 587.311L442.145 588.818L441.736 588.463L442.722 587.311L441.247 586.157L441.504 585.802Z"
                                    fill="white" />
                                <path d="M270.145 590.336H269.45L268.106 584.016H268.801L270.145 590.336Z" fill="#060606" />
                                <path
                                    d="M455.626 592.549C455.506 592.549 455.388 592.452 455.363 592.333L454.821 589.789C454.796 589.669 454.872 589.571 454.992 589.571C455.113 589.571 455.23 589.669 455.255 589.789L455.796 592.333C455.822 592.452 455.746 592.549 455.626 592.549Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M457.013 592.549H454.23C454.11 592.549 453.992 592.452 453.967 592.333C453.941 592.213 454.018 592.117 454.138 592.117H456.921C457.041 592.117 457.158 592.214 457.184 592.333C457.209 592.452 457.131 592.549 457.013 592.549Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M455.523 583.668L456.31 587.364C456.519 588.353 455.888 589.154 454.899 589.154C454.196 589.154 453.5 588.747 453.082 588.157C452.912 587.918 452.789 587.65 452.728 587.364L451.942 583.668C451.731 582.68 452.363 581.878 453.352 581.878C453.847 581.878 454.336 582.079 454.729 582.401C455.099 582.707 455.382 583.121 455.502 583.58C455.511 583.61 455.518 583.638 455.523 583.668Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M455.077 590.006C454.404 590.006 453.717 589.752 453.129 589.284C452.505 588.789 452.078 588.122 451.926 587.405L451.595 585.847C451.569 585.727 451.646 585.629 451.766 585.629C451.886 585.629 452.003 585.727 452.029 585.847L452.36 587.405C452.487 588.002 452.842 588.558 453.361 588.97C453.88 589.383 454.492 589.597 455.084 589.569C456.213 589.518 456.927 588.514 456.675 587.33L456.36 585.846C456.334 585.725 456.411 585.628 456.531 585.628C456.651 585.628 456.769 585.725 456.794 585.846L457.109 587.33C457.415 588.767 456.573 589.94 455.195 590.003C455.157 590.004 455.117 590.006 455.077 590.006Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M262.651 587.152C263.286 590.078 261.431 592.46 258.508 592.473C255.585 592.486 252.701 590.124 252.066 587.199C251.431 584.273 253.286 581.891 256.209 581.878C259.132 581.865 262.016 584.227 262.651 587.152Z"
                                    fill="white" />
                                <path
                                    d="M255.351 586.136C255.44 586.547 255.179 586.884 254.768 586.885C254.356 586.886 253.951 586.554 253.86 586.143C253.771 585.731 254.033 585.395 254.444 585.393C254.856 585.392 255.261 585.724 255.351 586.136Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M260.404 586.113C260.493 586.524 260.233 586.861 259.82 586.862C259.409 586.864 259.003 586.531 258.914 586.12C258.825 585.709 259.086 585.372 259.498 585.371C259.909 585.369 260.315 585.702 260.404 586.113Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M258.205 585.897C258.263 586.164 258.224 586.408 258.111 586.602C257.961 586.858 257.681 587.024 257.326 587.025C256.972 587.026 256.622 586.864 256.36 586.609C256.164 586.417 256.018 586.172 255.96 585.907L258.205 585.897Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M258.11 586.602C257.96 586.858 257.68 587.024 257.325 587.025C256.972 587.026 256.621 586.864 256.359 586.609C256.543 586.407 256.826 586.283 257.164 586.281C257.503 586.28 257.838 586.401 258.11 586.602Z"
                                    fill="#DBDBDB" />
                                <path
                                    d="M136.488 453.661L135.828 454.258L133.959 452.33L133.274 451.625C133.372 451.584 133.464 451.526 133.544 451.452C133.7 451.311 133.796 451.129 133.837 450.928L134.563 451.676L136.488 453.661Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M133.972 449.124C133.049 448.182 131.662 448.004 130.873 448.726C130.084 449.449 130.194 450.799 131.116 451.741C131.944 452.588 133.149 452.817 133.956 452.33C134.048 452.275 134.135 452.212 134.214 452.138C134.361 452.002 134.477 451.847 134.562 451.676C134.935 450.928 134.723 449.891 133.972 449.124ZM133.544 451.452C133.463 451.526 133.372 451.584 133.273 451.625C132.796 451.834 132.148 451.681 131.69 451.215C131.138 450.651 131.072 449.843 131.544 449.411C132.016 448.978 132.845 449.085 133.398 449.65C133.768 450.029 133.92 450.516 133.836 450.928C133.795 451.129 133.698 451.312 133.544 451.452Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M141.159 452.604C141.202 452.531 141.303 452.523 141.38 452.581C141.823 452.888 142.532 453.244 143.194 453.236C143.638 453.236 144.01 453.105 144.244 452.899C144.483 452.697 144.58 452.426 144.519 452.144C144.457 451.852 144.272 451.633 143.956 451.442C143.639 451.259 143.204 451.122 142.689 451.027H142.674C142.182 450.939 141.741 450.81 141.382 450.597C141.024 450.393 140.749 450.088 140.669 449.706C140.587 449.321 140.727 448.984 140.998 448.752C141.269 448.519 141.67 448.382 142.15 448.382C142.818 448.382 143.391 448.709 143.847 448.971C143.929 449.022 143.971 449.117 143.939 449.198C143.911 449.271 143.813 449.293 143.731 449.241C143.273 448.977 142.779 448.702 142.218 448.702C141.803 448.702 141.458 448.823 141.241 449.007C141.026 449.198 140.935 449.444 140.991 449.706C141.052 449.961 141.208 450.152 141.499 450.326C141.791 450.501 142.197 450.625 142.674 450.713H142.687C143.217 450.808 143.699 450.952 144.083 451.178C144.464 451.397 144.762 451.732 144.848 452.142C144.934 452.55 144.779 452.913 144.491 453.161C144.201 453.408 143.774 453.562 143.265 453.562C142.483 453.554 141.724 453.161 141.232 452.825C141.152 452.772 141.122 452.669 141.159 452.604Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M145.742 451.781C145.531 450.79 146.133 449.989 147.095 449.989C148.011 449.989 148.894 450.718 149.164 451.652L149.166 451.659L149.169 451.68C149.19 451.775 149.124 451.841 149.029 451.841H146.103C146.305 452.621 147.042 453.21 147.778 453.21C148.251 453.21 148.634 452.963 148.79 452.561C148.821 452.473 148.928 452.458 149.01 452.503C149.102 452.561 149.153 452.662 149.121 452.75C148.919 453.24 148.455 453.56 147.851 453.56C146.891 453.558 145.948 452.756 145.742 451.781ZM146.053 451.498H148.752C148.494 450.829 147.823 450.339 147.166 450.339C146.498 450.337 146.04 450.819 146.053 451.498Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M153.082 450.165L153.767 453.386C153.787 453.479 153.726 453.56 153.63 453.56C153.535 453.56 153.438 453.479 153.419 453.386L153.305 452.853C153.09 453.277 152.661 453.56 152.117 453.56C151.178 453.56 150.256 452.75 150.05 451.775C149.842 450.799 150.42 449.991 151.359 449.991C151.906 449.991 152.452 450.268 152.847 450.69L152.734 450.167C152.712 450.062 152.777 449.991 152.873 449.991C152.966 449.989 153.062 450.06 153.082 450.165ZM153.077 451.773C152.906 450.971 152.166 450.331 151.431 450.331C150.703 450.331 150.226 450.973 150.398 451.773C150.568 452.574 151.315 453.21 152.042 453.21C152.777 453.21 153.247 452.574 153.077 451.773Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M154.599 450.172C154.577 450.069 154.642 449.996 154.743 449.996C154.831 449.996 154.926 450.069 154.949 450.172L155.115 450.958C155.123 450.93 155.13 450.9 155.147 450.87C155.327 450.449 155.703 449.996 156.387 449.996C156.483 449.996 156.578 450.069 156.601 450.172C156.621 450.268 156.558 450.348 156.462 450.348C155.996 450.348 155.731 450.608 155.553 450.932C155.381 451.252 155.319 451.614 155.301 451.76C155.291 451.79 155.295 451.803 155.297 451.818L155.63 453.386C155.65 453.487 155.587 453.56 155.499 453.56C155.398 453.56 155.302 453.487 155.28 453.386L154.599 450.172Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M157.7 451.766C157.489 450.775 158.138 449.989 159.157 449.989C159.58 449.989 160.01 450.133 160.375 450.382C160.459 450.432 160.497 450.543 160.448 450.623C160.405 450.688 160.306 450.709 160.214 450.653C159.915 450.449 159.571 450.331 159.228 450.331C158.4 450.331 157.882 450.98 158.05 451.768C158.22 452.57 159.011 453.21 159.842 453.21C160.184 453.21 160.48 453.092 160.693 452.896C160.76 452.838 160.867 452.858 160.94 452.926C161.022 453.006 161.032 453.117 160.957 453.182C160.708 453.414 160.339 453.56 159.917 453.56C158.897 453.558 157.913 452.772 157.7 451.766Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M164.658 451.395C164.526 450.769 163.925 450.346 163.298 450.346C162.679 450.346 162.26 450.769 162.395 451.395L162.818 453.386L162.823 453.406C162.825 453.423 162.821 453.431 162.821 453.438C162.818 453.453 162.82 453.461 162.814 453.468C162.801 453.509 162.771 453.541 162.724 453.554C162.724 453.554 162.719 453.562 162.711 453.562H162.696H162.674C162.623 453.562 162.567 453.541 162.522 453.504C162.503 453.481 162.492 453.468 162.481 453.447C162.47 453.425 162.466 453.41 162.462 453.389L162.039 451.399L162.026 451.341L161.452 448.638C161.432 448.543 161.495 448.462 161.589 448.462C161.692 448.462 161.789 448.543 161.809 448.638L162.208 450.518C162.408 450.198 162.775 449.994 163.225 449.994C164.047 449.994 164.84 450.578 165.016 451.401L165.438 453.391C165.459 453.485 165.397 453.565 165.294 453.565C165.201 453.565 165.102 453.485 165.083 453.391L164.658 451.395Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M168.513 451.766C168.301 450.775 168.95 449.989 169.968 449.989C170.391 449.989 170.823 450.133 171.188 450.382C171.27 450.432 171.309 450.543 171.26 450.623C171.217 450.688 171.118 450.709 171.027 450.653C170.727 450.449 170.383 450.331 170.041 450.331C169.212 450.331 168.694 450.98 168.862 451.768C169.033 452.57 169.824 453.21 170.654 453.21C170.997 453.21 171.292 453.092 171.506 452.896C171.573 452.838 171.679 452.858 171.751 452.926C171.833 453.006 171.842 453.117 171.769 453.182C171.52 453.414 171.15 453.56 170.727 453.56C169.708 453.558 168.726 452.772 168.513 451.766Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M175.469 451.395C175.336 450.769 174.736 450.346 174.109 450.346C173.49 450.346 173.071 450.769 173.205 451.395L173.628 453.386L173.634 453.406C173.638 453.423 173.632 453.431 173.632 453.438C173.628 453.453 173.63 453.461 173.624 453.468C173.611 453.509 173.581 453.541 173.535 453.554C173.535 453.554 173.529 453.562 173.522 453.562H173.507H173.484C173.434 453.562 173.378 453.541 173.333 453.504C173.314 453.481 173.303 453.468 173.292 453.447C173.28 453.425 173.277 453.41 173.273 453.389L172.85 451.399L172.837 451.341L172.263 448.638C172.242 448.543 172.306 448.462 172.399 448.462C172.502 448.462 172.599 448.543 172.62 448.638L173.018 450.518C173.22 450.198 173.585 449.994 174.036 449.994C174.857 449.994 175.65 450.578 175.826 451.401L176.249 453.391C176.269 453.485 176.208 453.565 176.105 453.565C176.011 453.565 175.912 453.485 175.893 453.391L175.469 451.395Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M180.334 450.165L181.019 453.386C181.039 453.479 180.978 453.56 180.882 453.56C180.787 453.56 180.69 453.479 180.671 453.386L180.557 452.853C180.342 453.277 179.913 453.56 179.369 453.56C178.43 453.56 177.508 452.75 177.302 451.775C177.094 450.799 177.672 449.991 178.611 449.991C179.158 449.991 179.704 450.268 180.098 450.69L179.986 450.167C179.964 450.062 180.029 449.991 180.125 449.991C180.216 449.989 180.312 450.06 180.334 450.165ZM180.327 451.773C180.156 450.971 179.416 450.331 178.681 450.331C177.953 450.331 177.476 450.973 177.648 451.773C177.818 452.574 178.565 453.21 179.292 453.21C180.027 453.21 180.497 452.574 180.327 451.773Z"
                                    fill="#A6A6A6" />
                                <path
                                    d="M183.098 450.165C183.116 450.252 183.047 450.339 182.959 450.339H182.501L183.053 452.941C183.09 453.116 183.283 453.204 183.371 453.204C183.459 453.204 183.573 453.3 183.593 453.388C183.612 453.474 183.535 453.562 183.447 453.562C183.092 453.562 182.767 453.3 182.69 452.942L182.138 450.34H181.695C181.519 450.34 181.5 450.254 181.483 450.166C181.465 450.079 181.446 449.991 181.62 449.991H182.063L181.783 448.664C181.764 448.576 181.833 448.489 181.919 448.489C182.015 448.489 182.127 448.576 182.146 448.664L182.426 449.991H182.884C182.972 449.989 183.079 450.077 183.098 450.165Z"
                                    fill="#A6A6A6" />
                                <path d="M219.348 459.238H121.94V459.591H219.348V459.238Z" fill="#A6A6A6" />
                                <path d="M215.821 442.64H118.413V442.994H215.821V442.64Z" fill="#A6A6A6" />
                                <path d="M373.102 405.98H569.146V324.034H373.102V405.978V405.98Z" fill="#FFC727" />
                                <path d="M569.146 348.201V324.034H594.313L569.146 348.201Z" fill="#FFC727" />
                                <path d="M554.198 338.203H388.051V339.76H554.198V338.203Z" fill="white" />
                                <path d="M506.237 346.612H388.051V348.169H506.237V346.612Z" fill="white" />
                                <path d="M535.199 363.428H388.051V364.985H535.199V363.428Z" fill="white" />
                                <path d="M554.198 371.837H388.051V373.394H554.198V371.837Z" fill="white" />
                                <path d="M554.198 380.246H388.051V381.803H554.198V380.246Z" fill="white" />
                                <path d="M490.197 388.654H388.051V390.211H490.197V388.654Z" fill="white" />
                                <path d="M542.343 173H346.298V242.138H542.343V173Z" fill="white" />
                                <path d="M346.325 197.169V173H321.159L346.325 197.169Z" fill="white" />
                                <path d="M489.076 185.768H361.546V187.325H489.076V185.768Z" fill="#060606" />
                                <path d="M527.693 194.177H361.546V195.734H527.693V194.177Z" fill="#060606" />
                                <path d="M527.693 202.586H361.546V204.143H527.693V202.586Z" fill="#060606" />
                                <path d="M509.396 210.994H361.546V212.551H509.396V210.994Z" fill="#060606" />
                                <path d="M527.693 219.403H361.546V220.96H527.693V219.403Z" fill="#060606" />
                                <path d="M467.354 227.812H361.546V229.369H467.354V227.812Z" fill="#060606" />
                                <path d="M542.343 253.326H346.298V304.604H542.343V253.326Z" fill="white" />
                                <path d="M346.325 277.495V253.326H321.159L346.325 277.495Z" fill="white" />
                                <path d="M527.28 266.094H361.546V267.651H527.28V266.094Z" fill="#060606" />
                                <path d="M486.47 274.503H361.546V276.06H486.47V274.503Z" fill="#060606" />
                                <path d="M505.542 282.912H361.546V284.469H505.542V282.912Z" fill="#060606" />
                                <path d="M457.779 291.321H361.546V292.877H457.779V291.321Z" fill="#060606" />
                                <path d="M542.343 421.908H346.298V469.211H542.343V421.908Z" fill="white" />
                                <path d="M346.297 446.077V421.908H321.131L346.297 446.077Z" fill="white" />
                                <path d="M514.843 434.678H361.544V436.235H514.843V434.678Z" fill="#060606" />
                                <path d="M475.151 443.085H361.544V444.642H475.151V443.085Z" fill="#060606" />
                                <path d="M504.192 451.494H361.544V453.051H504.192V451.494Z" fill="#060606" />
                                <path
                                    d="M647.425 371.293C672.433 371.293 692.706 351.02 692.706 326.011C692.706 301.003 672.433 280.73 647.425 280.73C622.417 280.73 602.144 301.003 602.144 326.011C602.144 351.02 622.417 371.293 647.425 371.293Z"
                                    fill="#A6A6A6" />
                                <mask id="mask0_836_4582" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="602" y="264"
                                    width="91" height="108">
                                    <path
                                        d="M692.713 326.013C692.713 339.928 686.452 352.354 676.575 360.664C673.251 363.466 669.521 365.785 665.482 367.544C665.018 367.756 664.535 367.95 664.033 368.144C663.781 368.24 663.511 368.356 663.259 368.434C660.728 369.399 658.08 370.115 655.335 370.579C652.765 371.062 650.118 371.294 647.411 371.294C645.826 371.294 644.243 371.216 642.696 371.043C642.02 370.985 641.362 370.907 640.687 370.791C639.895 370.675 639.101 370.539 638.31 370.365C638.058 370.327 637.826 370.269 637.594 370.211C636.396 369.959 635.217 369.651 634.058 369.303C632.802 368.898 631.565 368.472 630.347 367.97C630.251 367.932 630.154 367.894 630.058 367.834C629.826 367.756 629.594 367.66 629.382 367.544C627.874 366.907 626.425 366.173 625.014 365.361C611.351 357.573 602.133 342.866 602.133 326.014C602.133 311.751 608.742 299.016 619.043 290.725C619.506 288.986 619.99 287.325 620.53 285.798C612.704 280.482 616.162 270.453 617.554 268.328C619.003 266.087 623.835 271.362 623.835 271.362C623.835 271.362 625.4 265.101 627.197 264.714C628.994 264.308 630.27 268.424 630.27 268.424C630.27 268.424 643.663 266.027 655.219 268.076C666.758 270.125 670.758 282.667 670.758 282.667C670.758 282.667 676.769 284.89 678.12 289.528C678.332 290.223 678.294 291.325 678.082 292.678C687.069 300.965 692.713 312.832 692.713 326.013Z"
                                        fill="white" />
                                </mask>
                                <g mask="url(#mask0_836_4582)">
                                    <path class="theme-color"
                                        d="M634.462 356.029L638.478 374.172L667.77 352.526L678.269 362.208C678.269 362.208 654.743 389.648 635.661 389.648C625.641 389.648 623.682 366.67 623.682 366.67L634.462 356.029Z"
                                        fill="#13D979" />
                                    <path
                                        d="M639.057 376.667C646.419 378.955 660.059 368.407 665.775 359.489C666.164 358.875 665.654 352.109 665.422 343.859C665.3 338.85 665.285 333.272 665.637 328.18C665.715 327.135 633.166 333.727 633.166 333.727C633.166 333.727 635.566 344.618 634.897 353.491C634.833 354.232 634.711 354.917 634.532 355.565C634.515 355.66 634.478 355.774 634.461 355.907C633.541 359.831 631.941 374.45 639.057 376.667Z"
                                        fill="#DD6A57" />
                                    <path
                                        d="M663.765 328.156C661.543 337.028 654.546 357.222 637.734 356.43C636.535 356.372 635.453 356.237 634.468 356.025C634.487 355.889 634.506 355.773 634.526 355.677C634.719 355.039 634.835 354.343 634.893 353.609V353.493C635.145 350.247 634.971 346.729 634.661 343.58C634.12 338.169 633.174 333.839 633.174 333.839L633.194 333.819L633.406 333.684C635.879 333.182 657.234 328.892 663.765 328.156Z"
                                        fill="#060606" />
                                    <path
                                        d="M668.397 287.643C672.34 298.836 667.744 331.848 659.988 339.495C648.746 350.581 629.646 352.406 620.052 338.734C610.752 325.481 617.502 282.562 626.23 275.543C639.084 265.203 662.573 271.109 668.397 287.643Z"
                                        fill="#DD6A57" />
                                    <path
                                        d="M665.485 315.281C657.752 314.107 658.331 299.838 658.331 299.838C658.331 299.838 645.369 295.694 644.919 285.407C644.919 285.407 631.119 291.589 621.737 286.524C612.355 281.459 616.098 270.556 617.551 268.321C619.005 266.085 623.842 271.354 623.842 271.354C623.842 271.354 625.41 265.103 627.202 264.707C628.993 264.312 630.266 268.424 630.266 268.424C630.266 268.424 643.672 266.032 655.214 268.078C666.755 270.125 670.762 282.657 670.762 282.657C670.762 282.657 676.765 284.891 678.129 289.529C679.494 294.167 670.413 316.029 665.485 315.281Z"
                                        fill="#060606" />
                                    <path
                                        d="M636.628 310.514C636.656 310.432 636.788 310.643 636.772 310.735C636.403 312.95 636.354 315.549 638.267 316.559C638.326 316.59 638.305 316.702 638.231 316.68C635.822 316.005 635.924 312.554 636.628 310.514Z"
                                        fill="#060606" />
                                    <path
                                        d="M638.927 308.458C642.542 308.666 641.859 315.881 638.51 315.688C635.214 315.498 635.897 308.283 638.927 308.458Z"
                                        fill="#060606" />
                                    <path
                                        d="M623.654 309.656C623.646 309.568 623.469 309.745 623.463 309.837C623.322 312.078 622.785 314.621 620.692 315.173C620.627 315.19 620.623 315.303 620.699 315.3C623.2 315.184 623.881 311.801 623.654 309.656Z"
                                        fill="#060606" />
                                    <path
                                        d="M621.88 307.132C618.311 306.518 617.347 313.701 620.654 314.269C623.908 314.829 624.872 307.645 621.88 307.132Z"
                                        fill="#060606" />
                                    <path
                                        d="M642.086 305.429C641.128 305.089 640.299 304.615 639.386 304.181C638.355 303.69 637.482 303.406 636.874 302.382C636.548 301.834 636.791 300.926 637.294 300.558C638.468 299.703 639.879 299.99 641.145 300.528C642.518 301.114 643.425 301.917 644.12 303.236C644.791 304.514 643.35 305.878 642.086 305.429Z"
                                        fill="#060606" />
                                    <path
                                        d="M619.433 303.235C620.449 303.167 621.375 302.934 622.372 302.763C623.497 302.569 624.413 302.531 625.276 301.709C625.74 301.269 625.75 300.33 625.364 299.84C624.466 298.699 623.029 298.594 621.665 298.772C620.184 298.965 619.093 299.492 618.069 300.575C617.076 301.623 618.094 303.324 619.433 303.235Z"
                                        fill="#060606" />
                                    <path
                                        d="M636.731 331.455C636.145 331.927 635.543 332.598 634.725 332.589C633.941 332.581 633.063 332.144 632.377 331.799C632.309 331.765 632.23 331.833 632.269 331.905C632.769 332.818 633.938 333.47 634.991 333.387C636.021 333.306 636.603 332.479 636.937 331.577C636.982 331.449 636.815 331.386 636.731 331.455Z"
                                        fill="#060606" />
                                    <path
                                        d="M635.029 324.672C633.571 326.481 631.617 327.346 629.586 327.521C628.678 327.605 627.741 327.537 626.833 327.356C626.653 327.333 626.475 327.294 626.317 327.241C626.156 327.205 626.01 327.169 625.835 327.114C625.577 327.048 625.457 326.817 625.439 326.566L625.44 326.549C625.45 326.467 625.459 326.402 625.486 326.322C625.486 326.322 625.486 326.322 625.487 326.305L625.511 326.109C625.647 324.382 626.092 321.781 626.092 321.781C625.429 322.03 622.068 323.131 622.214 322.237C623.449 314.837 624.822 306.606 627.615 299.502C627.696 299.263 628.065 299.359 628.018 299.602C627.112 306.763 624.954 313.715 623.929 320.893C624.993 320.613 626.74 320.07 627.639 320.183C627.877 320.279 626.689 325.195 626.69 325.976C626.69 325.976 626.686 326.008 626.696 326.059C629.551 326.737 631.824 326.095 634.839 324.449C635.021 324.34 635.181 324.508 635.029 324.672Z"
                                        fill="#060606" />
                                    <path
                                        d="M627.96 326.871C627.96 326.871 629.365 329.033 631.419 329.908C632.174 330.233 633.001 330.393 633.887 330.214C635.709 329.852 635.854 328.21 635.612 326.782C635.417 325.608 634.941 324.578 634.941 324.578C634.941 324.578 632.172 326.868 627.96 326.871Z"
                                        fill="#060606" />
                                    <path
                                        d="M631.419 329.908C632.174 330.233 633.001 330.393 633.888 330.214C635.709 329.852 635.855 328.21 635.613 326.782C633.678 326.861 631.696 328.05 631.419 329.908Z"
                                        fill="#FF99BA" />
                                    <path
                                        d="M662.53 314.639C662.53 314.639 669.705 303.872 674.575 306.408C679.444 308.943 674.214 324.435 668.615 326.663C663.015 328.892 660.851 323.749 660.851 323.749L662.53 314.639Z"
                                        fill="#DD6A57" />
                                    <path
                                        d="M672.964 310.931C673.054 310.921 673.075 311.047 672.996 311.082C669.072 312.775 667.07 316.494 665.696 320.333C666.841 318.841 668.426 318.002 670.42 319.36C670.525 319.432 670.43 319.595 670.317 319.573C668.686 319.262 667.523 319.569 666.456 320.893C665.701 321.83 665.197 323.004 664.665 324.08C664.488 324.437 663.843 324.262 663.969 323.852C663.979 323.822 663.989 323.79 663.999 323.76C663.79 318.714 667.555 311.56 672.964 310.931Z"
                                        fill="#060606" />
                                    <path
                                        d="M634.837 353.734L638.763 372.505L665.787 348.376L672.514 355.957C672.514 355.957 646.162 394.126 645.998 392.415L638.04 376.25L626.95 387.687L631.401 359.287L634.837 353.734Z"
                                        fill="white" />
                                    <path
                                        d="M631.159 359.551C631.203 359.39 631.486 359.304 631.478 359.503C631.236 365.297 627.537 381.929 627.606 386.22C627.622 386.205 627.64 386.186 627.654 386.171C628.117 385.676 637.938 376.102 638.038 376.25C639.754 378.812 645.592 390.582 645.995 391.656C649.731 386.155 667.059 363.544 671.284 357.802C671.406 357.636 671.66 357.769 671.567 357.962C668.438 364.357 646.525 394.044 646.242 393.965C646.051 394.116 638.796 379.617 637.918 376.872C636.261 378.954 626.36 389.745 626.318 389.048C626.034 384.354 629.574 365.367 631.159 359.551Z"
                                        fill="#060606" />
                                </g>
                                <path
                                    d="M301.243 519.589C319.233 501.6 319.233 472.432 301.243 454.443C283.253 436.453 254.086 436.453 236.096 454.443C218.106 472.432 218.106 501.6 236.096 519.589C254.086 537.579 283.253 537.579 301.243 519.589Z"
                                    fill="#A6A6A6" />
                                <mask id="mask1_836_4582" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="222" y="429"
                                    width="93" height="105">
                                    <path
                                        d="M314.748 487.017C314.748 504.168 305.373 519.121 291.463 527.037C284.75 530.879 276.949 533.079 268.664 533.079C259.545 533.079 251.025 530.416 243.874 525.833C231.074 517.639 222.602 503.311 222.602 487.017C222.602 470.144 231.675 455.399 245.215 447.367C247.345 440.492 252.9 433.943 265.26 430.84C289.472 424.8 294.841 442.251 295.35 444.15C295.372 444.173 295.372 444.197 295.372 444.22C295.372 444.22 295.372 444.22 295.372 444.242C295.395 444.265 295.395 444.289 295.395 444.312C296.183 446.372 296.899 448.664 297.547 451.14C308.035 459.566 314.748 472.504 314.748 487.017Z"
                                        fill="white" />
                                </mask>
                                <g mask="url(#mask1_836_4582)">
                                    <path class="theme-color"
                                        d="M281.861 517.555L277.776 536.013L249.924 516.884L243.008 527.093C243.008 527.093 261.23 551.757 280.642 551.757C290.836 551.757 292.83 528.381 292.83 528.381L281.861 517.555Z"
                                        fill="#13D979" />
                                    <path
                                        d="M277.187 538.551C269.697 540.878 255.822 530.148 250.006 521.075C249.611 520.452 250.13 513.569 250.365 505.174C250.488 500.079 250.505 494.405 250.146 489.225C250.067 488.162 253.822 489.865 253.822 489.865L260.638 491.02L283.179 494.867C283.179 494.867 280.737 505.946 281.419 514.973C281.484 515.726 281.607 516.423 281.789 517.082C281.808 517.18 281.843 517.296 281.861 517.432C282.799 521.423 284.425 536.296 277.187 538.551Z"
                                        fill="#EB9481" />
                                    <path
                                        d="M281.789 517.205C281.808 517.303 281.843 517.419 281.861 517.555C280.855 517.769 279.752 517.905 278.534 517.963C256.626 518.991 251.967 491.366 251.967 491.366L260.639 491.143L283.181 494.99C283.181 494.99 280.739 506.069 281.42 515.096C281.484 515.849 281.607 516.546 281.789 517.205Z"
                                        fill="#060606" />
                                    <path
                                        d="M247.336 447.985C243.326 459.372 248 492.957 255.89 500.736C267.328 512.014 286.759 513.872 296.518 499.962C305.979 486.479 299.112 442.817 290.233 435.676C277.157 425.156 253.26 431.164 247.336 447.985Z"
                                        fill="#EB9481" />
                                    <path
                                        d="M279.655 471.252C279.625 471.169 279.492 471.384 279.508 471.475C279.882 473.729 279.933 476.373 277.986 477.4C277.925 477.431 277.948 477.546 278.022 477.524C280.473 476.837 280.372 473.328 279.655 471.252Z"
                                        fill="#060606" />
                                    <path
                                        d="M277.315 469.159C273.638 469.371 274.333 476.711 277.74 476.515C281.094 476.323 280.398 468.981 277.315 469.159Z"
                                        fill="#060606" />
                                    <path
                                        d="M292.852 470.378C292.861 470.289 293.04 470.469 293.046 470.562C293.189 472.843 293.737 475.431 295.865 475.99C295.932 476.007 295.936 476.123 295.858 476.119C293.314 476.003 292.622 472.56 292.852 470.378Z"
                                        fill="#060606" />
                                    <path
                                        d="M294.656 467.811C298.287 467.187 299.267 474.494 295.904 475.071C292.594 475.641 291.613 468.334 294.656 467.811Z"
                                        fill="#060606" />
                                    <path
                                        d="M274.1 466.078C275.076 465.732 275.918 465.25 276.847 464.809C277.897 464.309 278.783 464.02 279.402 462.979C279.735 462.42 279.487 461.497 278.975 461.124C277.782 460.253 276.345 460.545 275.059 461.094C273.662 461.691 272.738 462.507 272.033 463.848C271.348 465.148 272.813 466.534 274.1 466.078Z"
                                        fill="#060606" />
                                    <path
                                        d="M297.145 463.846C296.111 463.776 295.171 463.54 294.156 463.365C293.011 463.168 292.079 463.129 291.201 462.293C290.73 461.845 290.719 460.89 291.112 460.391C292.025 459.23 293.487 459.124 294.874 459.304C296.38 459.5 297.49 460.036 298.532 461.138C299.543 462.207 298.508 463.938 297.145 463.846Z"
                                        fill="#060606" />
                                    <path
                                        d="M279.548 492.555C280.144 493.036 280.756 493.717 281.587 493.709C282.385 493.7 283.278 493.255 283.977 492.906C284.046 492.872 284.127 492.941 284.086 493.013C283.578 493.942 282.388 494.607 281.317 494.521C280.271 494.439 279.677 493.597 279.338 492.68C279.292 492.549 279.462 492.486 279.548 492.555Z"
                                        fill="#060606" />
                                    <path
                                        d="M280.938 486.508C283.261 488.378 291.01 488.377 291.031 488.121L290.4 482.688C291.071 482.949 294.471 484.107 294.333 483.196C293.163 475.668 291.864 467.294 289.111 460.049C289.033 459.806 288.656 459.899 288.701 460.147C289.538 467.427 291.649 474.511 292.608 481.81C291.529 481.513 289.763 480.942 288.848 481.047C288.606 481.142 289.754 486.147 289.744 486.939C289.744 486.939 285.965 487.27 281.409 485.819C280.514 485.536 280.323 486.013 280.938 486.508Z"
                                        fill="#060606" />
                                    <path
                                        d="M251.415 475.104C254.302 474.38 256.99 464.975 257.092 455.854C257.157 449.982 259.497 442.577 266.04 440.364C270.393 438.892 277.971 442.48 282.3 441.421C286.63 440.364 287.432 437.893 289.998 437.957C292.402 438.018 295.4 444.316 295.4 444.316C295.4 444.316 290.841 424.444 265.27 430.836C238.331 437.571 243.755 460.636 246.341 468.037C248.336 473.749 251.415 475.104 251.415 475.104Z"
                                        fill="#060606" />
                                    <path
                                        d="M253.303 475.447C253.303 475.447 246.004 464.495 241.051 467.074C236.098 469.653 241.417 485.412 247.114 487.68C252.811 489.946 255.012 484.715 255.012 484.715L253.303 475.447Z"
                                        fill="#EB9481" />
                                    <path
                                        d="M242.688 471.676C242.596 471.666 242.575 471.795 242.654 471.829C246.646 473.551 248.682 477.334 250.081 481.239C248.915 479.722 247.303 478.868 245.274 480.249C245.168 480.321 245.265 480.488 245.379 480.467C247.038 480.15 248.221 480.463 249.306 481.809C250.073 482.762 250.587 483.958 251.128 485.051C251.309 485.416 251.963 485.238 251.835 484.819C251.825 484.788 251.814 484.757 251.804 484.726C252.022 479.593 248.19 472.315 242.688 471.676Z"
                                        fill="#060606" />
                                </g>
                                <path
                                    d="M261.538 301.646C288.002 301.646 309.456 280.192 309.456 253.728C309.456 227.263 288.002 205.809 261.538 205.809C235.073 205.809 213.619 227.263 213.619 253.728C213.619 280.192 235.073 301.646 261.538 301.646Z"
                                    fill="white" />
                                <path
                                    d="M311.707 290.218H307.628C307.205 284.995 303.897 277.013 304.743 281.041C305.389 284.076 305.365 287.954 305.265 290.218H236.084C235.288 282.359 238.791 269.452 238.791 269.452C234.786 275.942 233.245 285.145 232.672 290.218H226.137C225.464 285.518 227.127 277.509 227.127 277.509C225.336 280.668 224.266 286.587 223.77 290.218H216.334C216.059 282.359 218.72 272.038 224.987 262.688C230.011 255.177 223.794 250.8 223.918 236.177C224.043 216.729 237.398 209.269 239.611 207.23C269.802 179.253 297.208 205.215 300.142 223.693C302.977 241.772 297.779 244.16 306.185 260.574C312.528 272.909 311.707 290.218 311.707 290.218Z"
                                    fill="#060606" />
                                <path
                                    d="M230.337 300.369C230.396 300.426 230.471 300.454 230.531 300.511C240.574 307.344 260.404 319.379 271.002 315.56C279.162 312.619 283.937 304.225 284.487 301.555C280.205 297.728 274.105 294.252 271.386 292.44C255.735 282.044 241.629 288.281 230.337 300.369Z"
                                    fill="#455A64" />
                                <path
                                    d="M245.457 294.44C246.164 296.758 258.419 311.285 269.144 310.062C272.637 309.657 271.279 290.498 271.279 290.498L271.503 289.061L274.611 268.94L250.326 255.554L246.829 253.801C246.829 253.801 246.341 259.362 245.804 266.292C245.777 266.613 245.75 266.935 245.726 267.279C245.685 267.671 245.643 268.04 245.621 268.406C245.527 269.441 245.436 270.497 245.368 271.551C245.313 272.352 245.255 273.133 245.227 273.977C245.177 274.824 245.146 275.645 245.097 276.492C244.788 284.848 245.17 293.455 245.457 294.44Z"
                                    fill="#AD6359" />
                                <path
                                    d="M245.803 266.292C252.536 281.69 265.569 287.28 271.502 289.06L274.61 268.939L250.325 255.553L246.828 253.8C246.828 253.8 246.341 259.362 245.803 266.292Z"
                                    fill="#060606" />
                                <path
                                    d="M299.485 235.453C305.093 270.742 284.59 278.085 276.978 279.285C270.07 280.375 246.407 283.209 237.182 248.688C227.958 214.167 242.593 200.405 258.263 197.076C273.933 193.749 293.877 200.164 299.485 235.453Z"
                                    fill="#AD6359" />
                                <path
                                    d="M240.067 251.167C248.909 250.117 249.223 222.651 249.224 219.278C249.334 221.402 249.955 232.649 250.849 233.025C251.076 233.113 252.051 232.823 253.589 232.269L253.612 232.264C253.51 230.993 253.497 229.61 253.6 228.225C253.62 227.597 253.947 229.555 254.488 231.952C254.979 231.772 255.509 231.56 256.088 231.36C255.82 228.949 255.72 225.945 256.225 222.758C256.397 221.679 257.076 226.423 258.435 230.505C264.414 228.346 273.069 225.446 281.307 224.488C283.51 224.222 285.422 224.09 287.117 224.031C286.854 220.718 286.18 217.22 286.487 217.959C287.4 220.063 287.997 222.191 288.382 224C289.301 223.977 290.153 223.969 290.918 223.981C290.758 219.281 287.914 212.001 288.758 213.081C291.99 217.272 293.569 221.812 294.23 224.227C297.473 224.581 298.407 225.132 298.426 224.297C298.456 222.789 295.543 209.849 284.551 201.096C272.603 191.583 250.279 190.791 239.151 207.903C239.151 207.903 229.444 215.452 228.723 226.379C227.994 237.284 234.958 251.766 240.067 251.167Z"
                                    fill="#060606" />
                                <path
                                    d="M284.753 256.01C284.753 256.01 283.548 258.57 281.448 259.829C280.675 260.295 279.801 260.594 278.81 260.532C276.775 260.411 276.37 258.648 276.42 257.06C276.457 255.755 276.82 254.563 276.82 254.563C276.82 254.563 280.173 256.639 284.753 256.01Z"
                                    fill="white" />
                                <path
                                    d="M292.121 231.118C291.277 231.094 290.502 230.931 289.672 230.822C288.733 230.699 287.973 230.696 287.23 230.045C286.833 229.694 286.793 228.918 287.096 228.499C287.803 227.523 288.991 227.391 290.126 227.494C291.359 227.605 292.281 228.007 293.165 228.871C294.022 229.705 293.234 231.149 292.121 231.118Z"
                                    fill="#060606" />
                                <path
                                    d="M269.202 234.039C270.029 233.868 270.763 233.574 271.563 233.321C272.466 233.035 273.215 232.901 273.831 232.129C274.162 231.714 274.064 230.942 273.692 230.583C272.827 229.746 271.634 229.821 270.534 230.121C269.339 230.446 268.502 231.002 267.782 232.007C267.083 232.981 268.111 234.264 269.202 234.039Z"
                                    fill="#060606" />
                                <path
                                    d="M274.73 242.604C274.702 242.513 274.555 242.739 274.568 242.838C274.914 245.248 274.906 248.064 272.807 249.112C272.742 249.145 272.762 249.265 272.843 249.245C275.47 248.571 275.445 244.831 274.73 242.604Z"
                                    fill="#060606" />
                                <path
                                    d="M272.29 240.319C268.367 240.457 268.933 248.291 272.567 248.162C276.141 248.036 275.577 240.203 272.29 240.319Z"
                                    fill="#060606" />
                                <path
                                    d="M270.784 240.845C270.132 241.337 269.518 242.168 268.7 242.308C267.752 242.471 266.972 241.703 266.292 240.959C266.221 240.881 266.159 240.955 266.164 241.059C266.251 242.563 266.939 244.06 268.564 244.169C270.047 244.266 271.004 242.862 271.27 241.325C271.318 241.041 271.045 240.645 270.784 240.845Z"
                                    fill="#060606" />
                                <path
                                    d="M288.208 240.402C288.221 240.309 288.405 240.505 288.409 240.604C288.488 243.036 288.989 245.81 291.237 246.475C291.306 246.495 291.308 246.618 291.226 246.612C288.519 246.407 287.893 242.719 288.208 240.402Z"
                                    fill="#060606" />
                                <path
                                    d="M290.213 237.727C294.099 237.179 294.909 244.992 291.309 245.499C287.766 245.998 286.955 238.186 290.213 237.727Z"
                                    fill="#060606" />
                                <path
                                    d="M291.893 238.072C292.553 238.422 293.242 239.111 293.984 239.083C294.844 239.05 295.39 238.14 295.851 237.273C295.899 237.184 295.967 237.242 295.981 237.345C296.177 238.834 295.844 240.44 294.44 240.876C293.158 241.273 292.064 240.091 291.555 238.641C291.46 238.373 291.629 237.93 291.893 238.072Z"
                                    fill="#060606" />
                                <path
                                    d="M275.623 261.134C276.221 261.688 276.822 262.456 277.707 262.507C278.555 262.555 279.536 262.146 280.304 261.825C280.381 261.793 280.46 261.873 280.413 261.947C279.806 262.897 278.494 263.516 277.36 263.35C276.255 263.187 275.685 262.249 275.391 261.25C275.35 261.11 275.535 261.053 275.623 261.134Z"
                                    fill="#060606" />
                                <path
                                    d="M285.022 251.52C285.022 251.52 285.826 255.099 285.971 256.807C285.984 256.967 285.577 257.077 285 257.161C284.973 257.172 284.957 257.185 284.933 257.168C281.957 257.892 278.833 257.105 276.793 254.796C276.66 254.639 276.862 254.444 277.028 254.539C279.417 256.004 281.943 256.22 284.621 256.041C284.701 255.557 283.039 249.958 283.309 249.914C284.236 249.756 286.128 250.236 287.261 250.467C285.802 242.963 283.152 235.754 281.811 228.262C281.769 227.993 282.149 227.88 282.248 228.113C285.561 235.471 287.429 244.07 289.134 251.78C289.355 252.74 285.731 251.754 285.022 251.52Z"
                                    fill="#060606" />
                                <path class="theme-color"
                                    d="M270.668 254.733C265.918 254.702 261.598 251.465 260.405 246.647C258.995 240.949 262.481 235.167 268.177 233.756C273.876 232.344 279.656 235.83 281.069 241.527V241.529C282.479 247.224 278.993 253.008 273.296 254.42C272.415 254.636 271.534 254.738 270.668 254.733ZM270.795 234.866C270.044 234.86 269.28 234.948 268.52 235.138C263.585 236.359 260.565 241.37 261.785 246.305C263.009 251.239 268.021 254.265 272.953 253.037C277.887 251.814 280.908 246.804 279.687 241.87C278.652 237.698 274.911 234.893 270.795 234.866Z"
                                    fill="#13D979" />
                                <path class="theme-color"
                                    d="M294.933 251.913C290.86 251.886 287.193 247.691 286.58 242.172C286.271 239.387 286.774 236.672 287.996 234.528C289.257 232.31 291.136 230.958 293.283 230.72C295.438 230.477 297.559 231.391 299.278 233.278C300.939 235.104 302.024 237.642 302.332 240.426C302.978 246.259 299.972 251.396 295.631 251.879C295.395 251.902 295.165 251.915 294.933 251.913ZM293.98 232.106C293.8 232.105 293.621 232.115 293.441 232.134C291.76 232.321 290.264 233.421 289.232 235.232C288.16 237.117 287.719 239.527 287.994 242.015C288.557 247.069 291.898 250.863 295.474 250.462C299.036 250.068 301.478 245.635 300.92 240.583C300.644 238.094 299.687 235.84 298.226 234.235C296.97 232.857 295.483 232.116 293.98 232.106Z"
                                    fill="#13D979" />
                                <path class="theme-color"
                                    d="M280.849 242.793L279.819 241.81C281.274 240.286 284.784 238.062 287.674 240.54L286.748 241.621C284.162 239.395 280.983 242.654 280.849 242.793Z"
                                    fill="#13D979" />
                                <path class="theme-color"
                                    d="M234.015 250.741L232.688 250.23C232.926 249.611 235.103 244.153 238.203 243.291C241.104 242.493 260.259 242.167 261.072 242.154L261.094 243.576C255.603 243.664 240.824 244.039 238.585 244.662C236.536 245.232 234.594 249.244 234.015 250.741Z"
                                    fill="#13D979" />
                                <path
                                    d="M243.222 250.509C243.222 250.509 234.652 239.937 229.801 243.07C224.951 246.203 231.947 261.913 238.03 263.699C244.113 265.483 245.875 259.884 245.875 259.884L243.222 250.509Z"
                                    fill="#AD6359" />
                                <path
                                    d="M231.92 247.524C231.824 247.523 231.815 247.657 231.9 247.685C236.176 249.074 238.636 252.77 240.453 256.657C239.107 255.208 237.365 254.485 235.411 256.101C235.308 256.186 235.424 256.349 235.54 256.316C237.217 255.83 238.465 256.039 239.712 257.32C240.596 258.228 241.238 259.409 241.901 260.482C242.122 260.84 242.778 260.592 242.607 260.175C242.594 260.144 242.579 260.113 242.566 260.082C242.292 254.774 237.647 247.651 231.92 247.524Z"
                                    fill="#060606" />
                                <mask id="mask2_836_4582" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="213" y="194"
                                    width="99" height="108">
                                    <path
                                        d="M311.716 290.214H307.625C307.216 284.999 303.903 277.023 304.742 281.051C305.396 284.078 305.375 287.964 305.273 290.214H292.594C288.832 293.425 284.557 296.062 279.915 297.985C277.236 299.109 274.413 299.989 271.51 300.583C268.299 301.278 264.945 301.646 261.53 301.646C257.543 301.646 253.657 301.155 249.956 300.235C245.149 299.048 240.65 297.147 236.54 294.611C234.392 293.323 232.367 291.85 230.465 290.214H226.15C225.966 288.945 225.945 287.454 226.027 285.939C225.597 285.449 225.188 284.978 224.78 284.487C224.33 286.553 224.002 288.619 223.777 290.214H216.332C216.19 285.816 216.946 280.642 218.746 275.305C215.453 268.822 213.613 261.5 213.613 253.729C213.613 240.231 219.196 228.022 228.194 219.309C232.326 211.988 238.215 208.511 239.607 207.223C239.626 207.202 239.648 207.182 239.667 207.162C248.645 194.135 264.332 192.069 276.295 196.506C276.397 196.547 276.5 196.567 276.602 196.608C289.466 201.046 298.526 213.501 300.141 223.686C300.242 224.401 300.346 225.097 300.448 225.771C306.112 233.644 309.446 243.298 309.446 253.727C309.446 257.613 308.975 261.376 308.096 264.995C312.349 276.654 311.716 290.214 311.716 290.214Z"
                                        fill="white" />
                                </mask>
                                <g mask="url(#mask2_836_4582)">
                                    <path
                                        d="M284.494 301.564C283.941 304.222 279.156 312.628 270.996 315.552C260.403 319.377 240.566 307.351 230.524 300.52C230.461 300.46 230.401 300.419 230.34 300.378C232.324 298.251 234.389 296.308 236.537 294.61C240.648 297.145 245.147 299.048 249.953 300.233C253.655 301.154 257.541 301.644 261.528 301.644C264.943 301.644 268.297 301.277 271.508 300.581C274.412 299.987 277.235 299.109 279.913 297.984C281.508 299.109 283.103 300.317 284.494 301.564Z"
                                        fill="#455A64" />
                                    <path
                                        d="M271.508 300.583C271.407 305.266 270.834 309.867 269.136 310.052C262.203 310.849 254.635 305.062 249.952 300.236C253.654 301.157 257.54 301.647 261.527 301.647C264.943 301.646 268.297 301.277 271.508 300.583Z"
                                        fill="#DD6A57" />
                                </g>
                                <path
                                    d="M241.135 341.448L240.846 421.425L114.809 421.006C111.472 420.993 108.76 418.261 108.772 414.924L108.853 392.353C115.117 392.376 120.229 387.33 120.252 381.036C120.275 374.771 115.2 369.66 108.935 369.637L109.017 347.095C109.029 343.729 111.761 341.017 115.098 341.029L241.135 341.448Z"
                                    fill="white" />
                                <path class="theme-color"
                                    d="M233.439 419.16C233.438 419.16 233.438 419.16 233.437 419.16L114.821 418.755C113.802 418.75 112.847 418.349 112.131 417.627C111.416 416.904 111.025 415.948 111.03 414.932L111.102 394.99C111.104 394.671 111.328 394.397 111.641 394.332C117.912 393.045 122.482 387.456 122.507 381.042C122.533 374.633 118.002 369.015 111.735 367.683C111.423 367.617 111.2 367.341 111.201 367.022L111.273 347.105C111.273 346.077 111.675 345.11 112.406 344.383C113.121 343.671 114.066 343.28 115.067 343.28C115.074 343.28 115.081 343.28 115.087 343.28L233.702 343.693C233.881 343.693 234.052 343.765 234.178 343.892C234.304 344.019 234.374 344.191 234.374 344.369L234.113 418.489C234.112 418.86 233.81 419.16 233.439 419.16ZM112.449 395.533L112.378 414.938C112.375 415.594 112.627 416.212 113.089 416.678C113.551 417.145 114.169 417.404 114.827 417.407L232.767 417.809L233.023 345.039L115.082 344.628C114.463 344.65 113.821 344.877 113.356 345.339C112.882 345.81 112.621 346.439 112.621 347.108L112.551 366.489C119.161 368.152 123.883 374.187 123.855 381.047C123.829 387.911 119.064 393.916 112.449 395.533Z"
                                    fill="#0CAF60" />
                                <path
                                    d="M305.284 354.801C305.284 357.009 307.063 358.801 309.271 358.814H309.375L309.349 364.178H309.31C307.089 364.165 305.297 365.944 305.284 368.164C305.284 370.372 307.063 372.164 309.271 372.177H309.323L309.31 377.541C307.089 377.528 305.297 379.307 305.284 381.528C305.284 383.735 307.063 385.527 309.271 385.54L309.258 390.904C307.063 390.917 305.297 392.696 305.284 394.891C305.284 397.085 307.037 398.865 309.232 398.903L309.206 404.267C307.037 404.306 305.297 406.072 305.284 408.254C305.284 410.436 307.011 412.202 309.18 412.267L309.154 420.279C309.141 421.02 308.544 421.617 307.804 421.617L240.848 421.435L241.133 341.464L308.089 341.646C308.83 341.646 309.427 342.256 309.427 342.996L309.401 350.814H309.31C307.089 350.801 305.297 352.581 305.284 354.801Z"
                                    fill="#060606" />
                                <g clip-path="url(#clip0_836_4582)">
                                    <path class="theme-color"
                                        d="M258.462 381.778L255.624 384.867C254.835 385.727 254.493 386.88 254.687 388.031L256.137 396.655C256.284 397.527 256.857 398.256 257.671 398.603C258.485 398.951 259.408 398.861 260.139 398.363L263.344 396.185C260.756 392.098 259.089 387.168 258.462 381.778ZM285.041 396.936L288.087 399.331C288.782 399.878 289.697 400.031 290.533 399.741C290.874 399.623 291.186 399.435 291.45 399.189C291.821 398.843 292.081 398.396 292.198 397.903L294.241 389.4C294.514 388.266 294.253 387.092 293.525 386.18L290.908 382.902C289.91 388.236 287.906 393.038 285.041 396.936ZM282.177 395.978C282.275 395.887 282.365 395.788 282.447 395.681C283.676 394.079 284.697 392.359 285.535 390.573L263.291 389.803C264.004 391.642 264.903 393.429 266.018 395.112C266.458 395.775 267.196 396.181 267.991 396.208L280.403 396.638C281.063 396.661 281.702 396.421 282.177 395.978ZM287.671 365.966C285.407 357.895 280.144 352.045 277.479 349.484C276.566 348.607 275.141 348.557 274.17 349.37C273.629 349.822 273.1 350.29 272.585 350.772C269.568 353.587 265.22 358.498 262.863 365.107C260.989 370.36 260.088 378.916 262.344 386.952C262.402 386.947 262.46 386.944 262.518 386.946L286.504 387.777C286.562 387.779 286.62 387.785 286.677 387.794C289.483 379.934 289.177 371.336 287.671 365.966ZM268.074 368.938C268.209 365.041 271.488 361.981 275.385 362.116C277.273 362.181 279.022 362.977 280.31 364.358C281.599 365.739 282.273 367.539 282.207 369.427C282.14 371.375 281.286 373.115 279.962 374.35C278.638 375.585 276.844 376.316 274.896 376.249C273.008 376.184 271.259 375.387 269.97 374.006C268.682 372.625 268.008 370.825 268.074 368.938Z"
                                        fill="#0CAF60" />
                                    <path class="theme-color"
                                        d="M274.994 373.422C277.332 373.503 279.3 371.667 279.381 369.329C279.42 368.196 279.016 367.116 278.243 366.288C277.47 365.459 276.42 364.981 275.288 364.942C274.119 364.902 273.042 365.34 272.248 366.082C271.454 366.823 270.941 367.866 270.901 369.035C270.862 370.168 271.266 371.248 272.039 372.076C272.812 372.905 273.861 373.383 274.994 373.422ZM268.785 408.724C269.049 408.478 269.22 408.13 269.233 407.739L269.459 401.214C269.486 400.433 268.875 399.778 268.095 399.751C267.314 399.724 266.659 400.335 266.632 401.116L266.406 407.642C266.379 408.422 266.99 409.077 267.771 409.104C267.956 409.11 268.142 409.08 268.316 409.015C268.489 408.95 268.649 408.851 268.785 408.724ZM274.075 399.959C273.295 399.931 272.64 400.542 272.613 401.323L272.178 413.869C272.151 414.65 272.762 415.304 273.543 415.331C273.933 415.345 274.292 415.199 274.556 414.952C274.821 414.705 274.992 414.357 275.005 413.967L275.439 401.421C275.466 400.64 274.856 399.986 274.075 399.959ZM278.593 401.53L278.367 408.056C278.34 408.836 278.951 409.491 279.732 409.518C280.122 409.532 280.481 409.386 280.745 409.139C281.01 408.892 281.18 408.544 281.194 408.154L281.42 401.628C281.447 400.847 280.836 400.193 280.055 400.166C279.275 400.139 278.62 400.75 278.593 401.53Z"
                                        fill="#0CAF60" />
                                </g>
                                <path
                                    d="M245.139 341.567C245.132 343.777 243.33 345.563 241.12 345.555C238.911 345.547 237.125 343.753 237.133 341.544C237.141 339.327 238.935 337.548 241.152 337.556C243.361 337.564 245.147 339.358 245.139 341.567Z"
                                    fill="white" />
                                <path
                                    d="M245.139 354.931C245.132 357.14 243.33 358.927 241.12 358.919C238.911 358.911 237.125 357.117 237.133 354.908C237.141 352.691 238.935 350.912 241.152 350.92C243.361 350.928 245.147 352.722 245.139 354.931Z"
                                    fill="white" />
                                <path
                                    d="M245.139 368.295C245.132 370.505 243.33 372.291 241.12 372.283C238.911 372.275 237.125 370.481 237.133 368.272C237.141 366.055 238.935 364.276 241.152 364.284C243.361 364.292 245.147 366.086 245.139 368.295Z"
                                    fill="white" />
                                <path
                                    d="M245.139 381.661C245.132 383.87 243.33 385.656 241.12 385.648C238.911 385.641 237.125 383.847 237.133 381.637C237.141 379.42 238.935 377.642 241.152 377.65C243.361 377.657 245.147 379.452 245.139 381.661Z"
                                    fill="white" />
                                <path
                                    d="M245.139 395.024C245.132 397.233 243.33 399.02 241.12 399.012C238.911 399.004 237.125 397.21 237.133 395.001C237.141 392.783 238.935 391.005 241.152 391.013C243.361 391.021 245.147 392.815 245.139 395.024Z"
                                    fill="white" />
                                <path
                                    d="M245.139 408.389C245.132 410.598 243.33 412.384 241.12 412.376C238.911 412.368 237.125 410.575 237.133 408.365C237.141 406.148 238.935 404.37 241.152 404.378C243.361 404.386 245.147 406.18 245.139 408.389Z"
                                    fill="white" />
                                <path class="theme-color"
                                    d="M222.516 379.913H132.566C132.193 379.913 131.892 379.611 131.892 379.239C131.892 378.866 132.194 378.564 132.566 378.564H222.516C222.889 378.564 223.191 378.866 223.191 379.239C223.191 379.611 222.889 379.913 222.516 379.913Z"
                                    fill="#0CAF60" />
                                <path class="theme-color"
                                    d="M222.516 389.252H132.566C132.193 389.252 131.892 388.95 131.892 388.578C131.892 388.206 132.194 387.904 132.566 387.904H222.516C222.889 387.904 223.191 388.206 223.191 388.578C223.191 388.95 222.889 389.252 222.516 389.252Z"
                                    fill="#0CAF60" />
                                <path class="theme-color"
                                    d="M222.516 398.592H132.566C132.193 398.592 131.892 398.29 131.892 397.918C131.892 397.546 132.194 397.244 132.566 397.244H222.516C222.889 397.244 223.191 397.546 223.191 397.918C223.191 398.29 222.889 398.592 222.516 398.592Z"
                                    fill="#0CAF60" />
                                <path class="theme-color"
                                    d="M199.749 407.931H132.566C132.193 407.931 131.892 407.629 131.892 407.257C131.892 406.885 132.194 406.583 132.566 406.583H199.749C200.121 406.583 200.423 406.885 200.423 407.257C200.423 407.63 200.121 407.931 199.749 407.931Z"
                                    fill="#0CAF60" />
                                <path
                                    d="M150.633 368.272C150.491 368.13 150.42 367.955 150.42 367.747V358.34H147.07C146.874 358.34 146.709 358.275 146.578 358.143C146.447 358.012 146.381 357.848 146.381 357.651C146.381 357.454 146.447 357.287 146.578 357.15C146.709 357.013 146.874 356.945 147.07 356.945H155.246C155.443 356.945 155.609 357.013 155.746 357.15C155.883 357.287 155.951 357.454 155.951 357.651C155.951 357.848 155.883 358.012 155.746 358.143C155.609 358.275 155.443 358.34 155.246 358.34H151.913V367.747C151.913 367.955 151.839 368.13 151.692 368.272C151.544 368.414 151.366 368.486 151.158 368.486C150.95 368.486 150.775 368.414 150.633 368.272Z"
                                    fill="#FFA21D" />
                                <path
                                    d="M157.968 368.272C157.826 368.13 157.755 367.955 157.755 367.747V357.618C157.755 357.41 157.826 357.232 157.968 357.085C158.11 356.937 158.285 356.863 158.494 356.863C158.701 356.863 158.879 356.937 159.027 357.085C159.175 357.233 159.249 357.41 159.249 357.618V367.747C159.249 367.955 159.175 368.13 159.027 368.272C158.879 368.414 158.701 368.486 158.494 368.486C158.285 368.486 158.11 368.415 157.968 368.272Z"
                                    fill="#FFA21D" />
                                <path
                                    d="M164.541 367.854C163.671 367.378 162.987 366.694 162.49 365.802C161.991 364.91 161.742 363.867 161.742 362.675C161.742 361.482 161.991 360.439 162.49 359.547C162.987 358.655 163.671 357.971 164.541 357.495C165.411 357.019 166.393 356.781 167.488 356.781C168.232 356.781 168.897 356.869 169.482 357.044C170.068 357.219 170.651 357.471 171.231 357.799C171.472 357.93 171.592 358.138 171.592 358.423C171.592 358.587 171.532 358.732 171.411 358.858C171.291 358.984 171.132 359.046 170.935 359.046C170.826 359.046 170.727 359.025 170.64 358.981C170.158 358.729 169.688 358.538 169.228 358.407C168.768 358.275 168.237 358.21 167.636 358.21C166.694 358.21 165.893 358.404 165.231 358.792C164.568 359.181 164.071 359.711 163.737 360.384C163.403 361.058 163.236 361.821 163.236 362.675C163.236 363.528 163.403 364.292 163.737 364.965C164.071 365.638 164.568 366.169 165.231 366.557C165.893 366.946 166.694 367.14 167.636 367.14C168.237 367.14 168.768 367.074 169.228 366.943C169.688 366.811 170.158 366.62 170.64 366.368C170.727 366.325 170.826 366.303 170.935 366.303C171.132 366.303 171.291 366.363 171.411 366.483C171.532 366.604 171.592 366.752 171.592 366.926C171.592 367.211 171.472 367.419 171.231 367.55C170.651 367.879 170.068 368.13 169.482 368.306C168.897 368.48 168.232 368.568 167.488 368.568C166.393 368.568 165.411 368.33 164.541 367.854Z"
                                    fill="#FFA21D" />
                                <path
                                    d="M174.061 368.272C173.918 368.13 173.848 367.955 173.848 367.747V357.618C173.848 357.41 173.918 357.232 174.061 357.084C174.203 356.937 174.378 356.863 174.586 356.863C174.794 356.863 174.972 356.937 175.12 357.084C175.267 357.232 175.342 357.41 175.342 357.618V362.838L180.956 357.125C181.109 356.95 181.295 356.863 181.514 356.863C181.7 356.863 181.861 356.926 181.998 357.051C182.135 357.177 182.203 357.333 182.203 357.519C182.203 357.738 182.143 357.908 182.023 358.028L178.231 361.804L182.581 367.287C182.701 367.44 182.761 367.599 182.761 367.763C182.772 367.96 182.707 368.13 182.564 368.272C182.422 368.414 182.247 368.485 182.039 368.485C181.787 368.485 181.59 368.387 181.448 368.19L177.213 362.789L175.341 364.676V367.747C175.341 367.955 175.267 368.13 175.12 368.272C174.972 368.414 174.794 368.485 174.586 368.485C174.378 368.485 174.203 368.414 174.061 368.272Z"
                                    fill="#FFA21D" />
                                <path
                                    d="M185.059 368.191C184.916 368.048 184.846 367.873 184.846 367.665V357.701C184.846 357.493 184.916 357.315 185.059 357.167C185.201 357.019 185.376 356.945 185.584 356.945H192.167C192.364 356.945 192.531 357.014 192.668 357.151C192.804 357.288 192.873 357.454 192.873 357.651C192.873 357.848 192.804 358.013 192.668 358.144C192.531 358.275 192.364 358.341 192.167 358.341H186.34V361.969H191.576C191.773 361.969 191.94 362.037 192.077 362.174C192.213 362.311 192.282 362.478 192.282 362.675C192.282 362.872 192.213 363.036 192.077 363.167C191.94 363.298 191.773 363.364 191.576 363.364H186.34V367.008H192.167C192.364 367.008 192.531 367.077 192.668 367.214C192.804 367.351 192.873 367.517 192.873 367.715C192.873 367.912 192.804 368.076 192.668 368.207C192.531 368.338 192.364 368.404 192.167 368.404H185.584C185.376 368.404 185.201 368.333 185.059 368.191Z"
                                    fill="#FFA21D" />
                                <path
                                    d="M198.191 368.272C198.049 368.13 197.978 367.955 197.978 367.747V358.34H194.629C194.432 358.34 194.268 358.275 194.136 358.143C194.005 358.012 193.939 357.848 193.939 357.651C193.939 357.454 194.005 357.287 194.136 357.15C194.268 357.013 194.432 356.945 194.629 356.945H202.804C203.001 356.945 203.168 357.013 203.305 357.15C203.442 357.287 203.51 357.454 203.51 357.651C203.51 357.848 203.442 358.012 203.305 358.143C203.168 358.275 203.001 358.34 202.804 358.34H199.472V367.747C199.472 367.955 199.398 368.13 199.25 368.272C199.102 368.414 198.924 368.486 198.717 368.486C198.509 368.486 198.334 368.415 198.191 368.272Z"
                                    fill="#FFA21D" />
                                <path
                                    d="M605.592 394.613C614.605 407.461 619.859 422.913 620.545 438.592C621.007 449.162 619.585 460.427 624.601 469.743C631.797 483.107 647.369 482.653 652.137 497.063C654.211 503.331 650.388 517.124 649.357 523.645C648.186 531.057 652.719 537.28 651.548 544.691C650.475 551.486 645.391 556.334 639.283 559.498C633.85 562.312 628.827 562.387 623.174 560.046C612.403 555.588 603.438 550.881 595.764 542.106C584.99 529.787 581.735 512.729 579.894 496.467C575.836 460.613 576.658 424.211 582.334 388.578"
                                    fill="#060606" />
                                <path
                                    d="M628.625 561.562C628.625 561.562 628.742 561.525 628.972 561.475C629.202 561.42 629.549 561.367 629.99 561.233C630.876 560.999 632.177 560.576 633.712 559.746C635.238 558.92 637.044 557.705 638.627 555.804C639.409 554.856 640.125 553.722 640.549 552.396C640.954 551.069 641.136 549.577 641.221 548.029C641.374 544.913 640.899 541.505 640.191 537.902C639.498 534.296 638.557 530.447 638.331 526.281C638.223 524.205 638.313 522.046 638.781 519.909C639.223 517.765 639.998 515.672 640.801 513.567C641.609 511.464 642.461 509.338 643.078 507.111C643.661 504.888 644.02 502.528 643.629 500.197C643.29 497.864 642.333 495.681 641.051 493.774C639.769 491.855 638.178 490.2 636.544 488.667C633.26 485.603 629.706 483.072 626.671 480.23C620.545 474.589 616.419 468.169 613.812 462.478C612.513 459.623 611.516 456.956 610.852 454.552C610.471 453.365 610.253 452.223 609.98 451.191C609.776 450.146 609.589 449.189 609.421 448.327C609.168 446.591 608.984 445.244 608.934 444.321C608.899 443.876 608.872 443.529 608.853 443.275C608.837 443.039 608.839 442.917 608.839 442.917C608.839 442.917 608.865 443.037 608.895 443.271C608.924 443.524 608.965 443.869 609.016 444.312C609.093 445.231 609.303 446.572 609.58 448.299C609.759 449.156 609.956 450.107 610.173 451.146C610.457 452.171 610.684 453.306 611.075 454.486C611.757 456.872 612.769 459.52 614.079 462.353C616.706 468 620.832 474.362 626.93 479.948C629.948 482.762 633.508 485.286 636.821 488.369C638.469 489.913 640.083 491.586 641.393 493.542C642.704 495.487 643.691 497.733 644.04 500.136C644.441 502.54 644.071 504.963 643.477 507.217C642.85 509.477 641.991 511.614 641.182 513.712C640.377 515.811 639.607 517.884 639.169 519.99C638.706 522.088 638.612 524.208 638.714 526.261C638.926 530.379 639.849 534.219 640.529 537.836C641.225 541.451 641.688 544.89 641.515 548.042C641.418 549.614 641.228 551.106 640.801 552.477C640.354 553.841 639.611 554.993 638.807 555.951C637.179 557.871 635.34 559.075 633.788 559.887C632.227 560.702 630.91 561.103 630.012 561.313C629.111 561.528 628.625 561.562 628.625 561.562Z"
                                    fill="#455A64" />
                                <path class="theme-color"
                                    d="M480.659 589.96L518.797 571.845C518.797 571.845 533.651 499.727 536.459 494.31C539.267 488.894 551.007 484.215 551.007 484.215L549.04 581.872L545.556 604.399L491.769 609.495L480.659 589.96Z"
                                    fill="#0CAF60" />
                                <path
                                    d="M448.105 607.044C447.895 607.036 446.834 607.7 447.723 609.374C448.612 611.049 455.069 616.586 456.969 614.657C458.87 612.729 455.967 610.375 455.967 610.375L448.105 607.044Z"
                                    fill="#FFBE9D" />
                                <path
                                    d="M456.244 610.451C456.244 610.451 464.042 611.434 467.046 612.576C470.307 613.815 474.278 612.971 476.951 611.159C479.624 609.347 481.182 607.711 481.182 607.711L491.132 607.555C491.132 607.555 495.908 602.604 493.072 595.227C492.578 593.94 492.044 592.922 490.793 591.343C489.611 590.066 487.745 589.029 484.52 588.472L472.7 591.025C472.7 591.025 454.387 589.716 451.132 591.255C451.132 591.255 447.041 593.682 445.774 594.7C445.297 595.083 443.847 599.743 446.826 602.165C446.826 602.165 444.233 604.228 445.638 606.077L446.311 606.898C446.311 606.898 444.567 609.155 445.462 610.137C446.357 611.12 454.193 615.713 456.995 614.617C459.797 613.522 457.478 610.926 456.244 610.451Z"
                                    fill="#FFBE9D" />
                                <path
                                    d="M448.784 598.138C448.793 598.116 449.135 598.248 449.753 598.483C450.37 598.719 451.267 599.052 452.391 599.41C452.953 599.589 453.573 599.772 454.244 599.948C454.911 600.131 455.642 600.274 456.398 600.519C457.146 600.768 457.954 601.12 458.546 601.815C459.107 602.484 459.488 603.483 459.12 604.43C458.94 604.895 458.563 605.25 458.152 605.47C457.734 605.686 457.285 605.788 456.85 605.833C455.972 605.917 455.146 605.805 454.365 605.702C452.802 605.464 451.441 605.045 450.323 604.649C449.204 604.253 448.321 603.879 447.711 603.619C447.103 603.357 446.772 603.199 446.78 603.178C446.789 603.156 447.136 603.275 447.758 603.501C448.381 603.725 449.275 604.066 450.397 604.431C451.517 604.797 452.871 605.188 454.408 605.406C455.174 605.5 455.995 605.6 456.816 605.517C457.225 605.473 457.635 605.375 458.001 605.185C458.357 604.991 458.671 604.693 458.818 604.309C459.129 603.533 458.81 602.628 458.302 602.022C457.783 601.402 457.024 601.051 456.304 600.806C455.574 600.561 454.844 600.406 454.172 600.21C453.5 600.021 452.88 599.824 452.319 599.63C451.197 599.242 450.309 598.874 449.704 598.602C449.099 598.329 448.775 598.158 448.784 598.138Z"
                                    fill="#EB996E" />
                                <path
                                    d="M449.487 592.5C449.497 592.479 449.837 592.611 450.45 592.85C451.065 593.086 451.954 593.428 453.07 593.799C454.185 594.172 455.526 594.575 457.036 594.937C457.781 595.127 458.641 595.28 459.349 595.872C459.695 596.165 459.959 596.595 460.028 597.068C460.102 597.539 460.018 598.024 459.826 598.459C459.434 599.349 458.609 599.919 457.785 600.196C456.95 600.482 456.083 600.502 455.299 600.393C453.721 600.157 452.422 599.591 451.301 599.236C450.229 598.861 449.342 598.55 448.666 598.314C448.046 598.089 447.707 597.954 447.714 597.933C447.721 597.911 448.074 598.005 448.706 598.193C449.389 598.404 450.288 598.682 451.374 599.017C452.503 599.345 453.82 599.886 455.337 600.095C456.093 600.192 456.906 600.165 457.682 599.894C458.446 599.634 459.187 599.107 459.529 598.327C459.888 597.559 459.769 596.614 459.14 596.111C458.534 595.592 457.71 595.42 456.966 595.227C455.448 594.846 454.106 594.418 452.995 594.016C451.883 593.614 451.003 593.238 450.402 592.966C449.801 592.692 449.478 592.519 449.487 592.5Z"
                                    fill="#EB996E" />
                                <path
                                    d="M453.247 594.112C453.152 594.111 453.101 593.394 452.892 592.545C452.691 591.693 452.412 591.031 452.496 590.988C452.569 590.944 452.996 591.571 453.21 592.468C453.427 593.365 453.332 594.117 453.247 594.112Z"
                                    fill="#EB996E" />
                                <path
                                    d="M480.767 594.344L473.815 591.665C473.815 591.665 454.51 582.655 454.183 583.143C453.857 583.631 452.81 583.577 453.039 585.931C453.268 588.285 464.518 593.03 464.874 593.846C465.23 594.662 464.636 598.785 468.791 601.737C472.946 604.69 475.944 604.754 475.944 604.754"
                                    fill="#FFBE9D" />
                                <path
                                    d="M475.947 604.754C475.947 604.76 475.891 604.764 475.782 604.76C475.673 604.755 475.511 604.743 475.301 604.713C474.881 604.654 474.264 604.528 473.495 604.28C472.727 604.033 471.81 603.654 470.801 603.107C469.803 602.547 468.668 601.882 467.6 600.887C466.53 599.903 465.655 598.484 465.23 596.823C465.007 595.998 464.928 595.1 464.819 594.227C464.806 594.116 464.781 594.017 464.751 593.928C464.728 593.868 464.656 593.812 464.569 593.742C464.396 593.613 464.2 593.494 464.005 593.377C463.61 593.144 463.198 592.921 462.78 592.697C461.105 591.805 459.324 590.903 457.526 589.87C456.627 589.354 455.724 588.805 454.845 588.18C454.41 587.862 453.979 587.527 453.587 587.13C453.389 586.934 453.21 586.711 453.057 586.459C452.99 586.324 452.922 586.189 452.897 586.025C452.862 585.869 452.87 585.742 452.855 585.598C452.833 585.043 452.851 584.447 453.153 583.918C453.301 583.655 453.548 583.457 453.767 583.303C453.877 583.225 453.974 583.152 454.033 583.073C454.054 583.053 454.017 583.08 454.1 583.006C454.19 582.951 454.206 582.97 454.236 582.963C454.304 582.958 454.326 582.97 454.372 582.973C454.446 582.988 454.516 583.004 454.582 583.023C455.628 583.345 456.585 583.766 457.546 584.16C459.454 584.964 461.276 585.777 463.01 586.556C466.477 588.118 469.581 589.559 472.184 590.779C472.836 591.077 473.452 591.39 474.041 591.639C474.641 591.875 475.21 592.099 475.741 592.308C476.796 592.727 477.708 593.087 478.463 593.387C479.189 593.681 479.762 593.912 480.178 594.081C480.358 594.157 480.503 594.219 480.621 594.269C480.72 594.314 480.771 594.338 480.768 594.344C480.766 594.349 480.712 594.334 480.609 594.3C480.488 594.258 480.339 594.206 480.155 594.142C479.733 593.988 479.152 593.775 478.416 593.505C477.654 593.219 476.735 592.875 475.671 592.477C475.136 592.275 474.564 592.059 473.96 591.831C473.354 591.583 472.744 591.282 472.087 590.988C469.461 589.802 466.345 588.394 462.887 586.83C461.151 586.059 459.327 585.254 457.422 584.455C456.47 584.065 455.494 583.641 454.497 583.336C454.435 583.318 454.375 583.305 454.318 583.294C454.298 583.292 454.253 583.283 454.255 583.287C454.251 583.276 454.256 583.311 454.245 583.262C454.224 583.202 454.249 583.21 454.233 583.182C454.228 583.173 454.22 583.165 454.21 583.159C454.429 583.307 454.265 583.208 454.312 583.244L454.292 583.268C454.19 583.404 454.064 583.489 453.957 583.567C453.738 583.722 453.553 583.873 453.433 584.085C453.189 584.507 453.156 585.055 453.181 585.583C453.198 585.868 453.211 586.086 453.342 586.3C453.471 586.513 453.633 586.718 453.82 586.903C454.189 587.276 454.609 587.605 455.035 587.917C455.896 588.532 456.792 589.078 457.685 589.594C459.471 590.625 461.247 591.531 462.922 592.432C463.341 592.66 463.754 592.885 464.155 593.124C464.355 593.245 464.553 593.365 464.745 593.511C464.833 593.582 464.955 593.669 465.018 593.819C465.062 593.946 465.088 594.066 465.101 594.179C465.21 595.091 465.278 595.943 465.491 596.754C465.894 598.372 466.726 599.749 467.759 600.72C468.786 601.698 469.909 602.379 470.888 602.945C471.878 603.502 472.78 603.894 473.535 604.158C474.29 604.424 474.897 604.567 475.311 604.647C475.517 604.687 475.677 604.71 475.784 604.725C475.892 604.741 475.948 604.749 475.947 604.754Z"
                                    fill="#EB996E" />
                                <path
                                    d="M454.652 605.663C454.658 605.644 454.928 605.697 455.391 605.878C455.852 606.058 456.507 606.379 457.211 606.93C457.559 607.211 457.928 607.531 458.264 607.951C458.583 608.362 458.909 608.917 458.825 609.576C458.741 610.239 458.174 610.762 457.538 610.967C456.881 611.188 456.169 611.084 455.515 610.903C452.928 610.116 450.677 609.165 449.114 608.334C448.334 607.919 447.724 607.545 447.314 607.27C446.904 606.995 446.69 606.825 446.702 606.808C446.715 606.787 446.952 606.921 447.38 607.161C447.808 607.403 448.431 607.744 449.219 608.129C450.79 608.9 453.048 609.813 455.601 610.589C456.229 610.764 456.879 610.851 457.437 610.664C457.996 610.487 458.457 610.052 458.527 609.533C458.607 609.012 458.343 608.508 458.049 608.115C457.747 607.718 457.392 607.39 457.066 607.108C455.719 605.997 454.62 605.725 454.652 605.663Z"
                                    fill="#EB996E" />
                                <g opacity="0.3">
                                    <path
                                        d="M545.285 604.423C539.038 583.356 533.529 556.219 527.283 535.151C525 554.603 527.858 580.28 531.438 599.534C531.858 601.79 532.05 604.002 533.8 605.487L545.285 604.423Z"
                                        fill="#060606" />
                                </g>
                                <path
                                    d="M535.052 589.96C534.968 589.98 534.704 588.585 533.857 586.481C533.442 585.427 532.836 584.219 532.065 582.937C531.269 581.671 530.296 580.34 529.129 579.068C527.947 577.809 526.692 576.739 525.488 575.852C524.267 574.989 523.107 574.295 522.085 573.803C520.051 572.802 518.679 572.436 518.705 572.354C518.713 572.327 519.056 572.409 519.673 572.583C519.983 572.665 520.358 572.778 520.781 572.949C521.204 573.115 521.699 573.279 522.211 573.539C523.262 574.003 524.455 574.682 525.708 575.543C526.944 576.426 528.229 577.506 529.431 578.787C530.619 580.081 531.6 581.442 532.39 582.74C533.155 584.053 533.744 585.293 534.128 586.376C534.349 586.906 534.476 587.411 534.61 587.846C534.749 588.28 534.835 588.663 534.893 588.978C535.023 589.606 535.079 589.954 535.052 589.96Z"
                                    fill="#060606" />
                                <path class="theme-color"
                                    d="M546.964 483.233C546.964 483.233 526.986 527.858 526.986 536.051C526.986 544.244 541.955 601.169 541.955 601.169C541.813 603.428 541.231 614.774 541.231 614.774L625.148 615.062L626.426 597.024L619.875 579.833L626.419 531.239C626.419 531.239 630.824 503.024 631.216 495.134C631.706 485.26 598.262 473.817 599.173 472.45L593.398 464.719L560.31 491.585L553.773 472.703L545.939 480.106L546.964 483.233Z"
                                    fill="#0CAF60" />
                                <path class="theme-color"
                                    d="M601.919 495.103C592.837 510.471 576.213 538.477 576.213 538.477L546.427 572.439C546.427 572.439 544.478 589.698 548.375 594.987C552.273 600.276 558.954 603.896 558.954 603.896C558.954 603.896 566.818 603.896 576.806 595.545C586.792 587.193 614.352 552.674 614.352 552.674L623.817 541.261C623.817 541.261 635.098 513.538 632.993 499.428C632.181 493.988 629.866 491.725 626.774 489.231C619.009 482.965 606.995 486.513 601.919 495.103Z"
                                    fill="#0CAF60" />
                                <path
                                    d="M627.315 531.626C627.322 531.629 627.275 531.736 627.178 531.941C627.07 532.162 626.923 532.462 626.737 532.846C626.342 533.637 625.735 534.795 624.907 536.258C623.264 539.191 620.709 543.335 617.366 548.33C615.693 550.826 613.82 553.534 611.768 556.411C609.736 559.304 607.37 562.252 605.446 565.717C603.471 569.15 601.775 572.967 599.666 576.753C597.558 580.537 595.069 584.295 592.096 587.808C589.116 591.31 585.746 594.365 582.062 596.677C578.391 599.007 574.386 600.515 570.445 601.175C566.503 601.856 562.619 601.635 559.188 600.698C557.466 600.246 555.877 599.552 554.429 598.768C552.975 597.99 551.654 597.1 550.507 596.113C549.348 595.142 548.351 594.087 547.549 592.985C546.715 591.905 546.104 590.764 545.593 589.68C544.615 587.482 544.203 585.433 543.991 583.766C543.822 582.088 543.813 580.778 543.856 579.894C543.88 579.468 543.899 579.135 543.914 578.889C543.929 578.663 543.941 578.547 543.948 578.547C543.955 578.548 543.957 578.664 543.956 578.891C543.952 579.136 543.946 579.469 543.939 579.896C543.923 580.778 543.959 582.082 544.151 583.746C544.386 585.399 544.817 587.423 545.803 589.584C546.318 590.65 546.929 591.768 547.759 592.826C548.556 593.906 549.547 594.938 550.694 595.888C551.83 596.853 553.14 597.724 554.58 598.486C556.014 599.253 557.578 599.927 559.278 600.366C562.661 601.274 566.491 601.48 570.381 600.798C574.271 600.134 578.218 598.641 581.845 596.332C585.486 594.041 588.822 591.014 591.78 587.537C594.731 584.051 597.21 580.314 599.311 576.554C601.414 572.791 603.118 568.976 605.115 565.526C607.064 562.04 609.453 559.083 611.489 556.21C613.551 553.345 615.435 550.649 617.123 548.165C620.494 543.197 623.082 539.081 624.766 536.177C625.615 534.729 626.243 533.586 626.662 532.808C626.865 532.432 627.023 532.139 627.139 531.922C627.249 531.723 627.309 531.623 627.315 531.626Z"
                                    fill="#060606" />
                                <path
                                    d="M544.937 570.907C544.972 570.967 544.513 571.226 543.966 571.836C543.421 572.433 542.815 573.441 542.698 574.671C542.587 575.901 542.998 577.004 543.425 577.691C543.851 578.39 544.255 578.73 544.209 578.781C544.186 578.819 543.702 578.554 543.182 577.853C542.665 577.169 542.164 575.985 542.286 574.633C542.414 573.281 543.125 572.21 543.757 571.632C544.396 571.036 544.92 570.866 544.937 570.907Z"
                                    fill="#060606" />
                                <path
                                    d="M550.411 579.923C550.417 579.91 550.577 579.948 550.878 580.031C551.029 580.07 551.211 580.132 551.432 580.182C551.663 580.225 551.92 580.271 552.203 580.324C553.362 580.513 555.103 580.491 557.115 579.867C559.114 579.226 561.353 577.995 563.439 576.15C565.527 574.305 567.404 571.845 569.366 569.272C571.32 566.692 573.293 564.264 575.473 562.445C576.553 561.538 577.614 560.734 578.497 559.87C579.38 559.013 580.088 558.084 580.485 557.132C581.231 555.174 580.73 553.336 580.026 552.442C579.292 551.517 578.553 551.426 578.59 551.369C578.594 551.356 578.753 551.397 579.053 551.502C579.336 551.638 579.763 551.868 580.152 552.341C580.93 553.254 581.508 555.155 580.758 557.237C580.354 558.257 579.633 559.223 578.738 560.113C577.845 561.008 576.782 561.829 575.72 562.735C573.589 564.54 571.649 566.942 569.695 569.522C567.733 572.094 565.835 574.568 563.691 576.435C561.554 578.297 559.256 579.528 557.201 580.145C555.133 580.748 553.347 580.723 552.176 580.481C551.891 580.415 551.634 580.355 551.401 580.3C551.18 580.236 550.999 580.16 550.852 580.109C550.557 580 550.406 579.937 550.411 579.923Z"
                                    fill="#060606" />
                                <path
                                    d="M605.958 490.384C605.969 490.393 605.854 490.558 605.625 490.864C605.368 491.198 605.029 491.639 604.607 492.187C603.701 493.318 602.453 495.004 600.934 497.1C597.923 501.314 594.059 507.348 590.334 514.322C586.588 521.286 583.484 527.745 581.111 532.358C579.931 534.668 578.961 536.529 578.261 537.8C577.925 538.406 577.657 538.892 577.452 539.261C577.262 539.593 577.158 539.764 577.145 539.757C577.132 539.751 577.213 539.566 577.378 539.222C577.565 538.844 577.811 538.346 578.118 537.726C578.784 536.386 579.711 534.518 580.849 532.228C583.154 527.585 586.216 521.104 589.97 514.127C593.702 507.14 597.618 501.109 600.696 496.929C602.249 494.85 603.535 493.188 604.481 492.087C604.928 491.558 605.287 491.134 605.56 490.811C605.81 490.522 605.947 490.374 605.958 490.384Z"
                                    fill="#060606" />
                                <g opacity="0.3">
                                    <path
                                        d="M543.951 578.548C547.826 580.648 552.079 580.425 556.404 579.576C560.729 578.727 564.734 576.331 567.526 572.921C566.774 576.697 565.157 580.387 562.402 583.078C559.647 585.767 555.659 587.332 551.872 586.639C548.086 585.945 544.264 582.385 543.951 578.548Z"
                                        fill="#060606" />
                                </g>
                                <g opacity="0.3">
                                    <path
                                        d="M580.589 555.615C583.026 559.348 583.896 564.069 582.949 568.425C586.231 563.4 587.002 557.039 586.119 551.103C585.236 545.167 582.825 539.569 580.137 534.202C580.137 534.202 577.174 539.205 577.147 539.757C577.004 542.645 578.067 548.085 578.625 550.923C580.117 552.329 580.823 554.521 580.432 556.533"
                                        fill="#060606" />
                                </g>
                                <g opacity="0.3">
                                    <path
                                        d="M557.079 599.34C564.977 605.496 576.696 605.787 585.338 600.728C593.661 595.856 598.784 587.085 603.54 578.696C610.903 565.71 619.887 549.65 625.146 535.68C625.146 535.68 610.402 555.796 605.958 564.467C602.605 571.008 600.032 575.32 595.903 581.402C587.606 593.622 572.581 600.94 557.845 599.94"
                                        fill="#060606" />
                                </g>
                                <path
                                    d="M541.23 614.773C541.222 614.773 541.218 614.688 541.218 614.524C541.222 614.33 541.226 614.091 541.231 613.8C541.256 613.124 541.289 612.202 541.331 611.046C541.442 608.628 541.598 605.238 541.784 601.161L541.791 601.217C540.363 596.451 538.694 590.668 536.967 584.421C534.677 576.141 532.744 568.607 531.444 563.13C530.795 560.391 530.289 558.17 529.972 556.628C529.821 555.887 529.701 555.296 529.61 554.852C529.533 554.445 529.498 554.229 529.512 554.226C529.525 554.223 529.587 554.432 529.692 554.833C529.801 555.273 529.947 555.858 530.129 556.591C530.516 558.16 531.06 560.359 531.728 563.059C533.1 568.515 535.076 576.033 537.366 584.309C539.092 590.554 540.735 596.343 542.119 601.119L542.128 601.148L542.126 601.175C541.879 605.251 541.674 608.64 541.527 611.056C541.446 612.209 541.381 613.131 541.334 613.805C541.308 614.095 541.287 614.333 541.27 614.526C541.253 614.691 541.239 614.774 541.23 614.773Z"
                                    fill="#060606" />
                                <path
                                    d="M625.185 488.754C625.161 488.817 624.326 488.522 622.947 488.18C621.57 487.836 619.633 487.49 617.47 487.422C615.306 487.36 613.352 487.59 611.956 487.851C610.559 488.109 609.709 488.355 609.689 488.289C609.68 488.262 609.884 488.174 610.262 488.038C610.638 487.896 611.196 487.732 611.896 487.565C613.293 487.227 615.28 486.946 617.482 487.008C619.683 487.077 621.65 487.476 623.024 487.897C623.712 488.106 624.259 488.304 624.627 488.467C624.996 488.626 625.195 488.727 625.185 488.754Z"
                                    fill="#060606" />
                                <path
                                    d="M598.601 474.102C598.613 474.109 598.54 474.251 598.389 474.514C598.211 474.814 597.988 475.191 597.713 475.654C597.116 476.638 596.23 478.048 595.11 479.774C592.862 483.219 589.645 487.913 585.841 492.909C582.779 496.937 579.815 500.551 577.386 503.382L577.216 503.581L577.109 503.345C575.955 500.814 575 498.719 574.307 497.198C573.998 496.496 573.749 495.928 573.556 495.49C573.388 495.096 573.307 494.883 573.322 494.876C573.337 494.869 573.449 495.067 573.646 495.448C573.859 495.877 574.136 496.431 574.478 497.118C575.203 498.623 576.203 500.698 577.411 503.203L577.134 503.167C579.52 500.306 582.457 496.68 585.513 492.659C589.311 487.67 592.559 483.011 594.867 479.612C595.988 477.939 596.907 476.569 597.578 475.567C597.879 475.121 598.124 474.758 598.319 474.47C598.492 474.221 598.589 474.094 598.601 474.102Z"
                                    fill="#060606" />
                                <path
                                    d="M617.92 602.249C617.807 602.237 618.171 598.112 618.733 593.037C619.296 587.96 619.844 583.856 619.958 583.869C620.072 583.881 619.708 588.005 619.144 593.082C618.582 598.157 618.034 602.262 617.92 602.249Z"
                                    fill="#060606" />
                                <path
                                    d="M560.398 601.169C560.512 601.157 560.936 604.257 561.345 608.092C561.754 611.929 561.994 615.049 561.881 615.061C561.767 615.073 561.343 611.973 560.934 608.136C560.524 604.301 560.285 601.181 560.398 601.169Z"
                                    fill="#060606" />
                                <path
                                    d="M602.846 510.397C602.741 509.74 601.832 509.379 601.305 509.786L601.251 509.83C600.755 510.274 600.944 511.234 601.57 511.457C602.197 511.679 602.95 511.054 602.846 510.397Z"
                                    fill="white" />
                                <path
                                    d="M594.559 490.2C594.455 489.542 593.545 489.181 593.018 489.588L592.965 489.632C592.469 490.076 592.658 491.036 593.284 491.259C593.911 491.481 594.664 490.857 594.559 490.2Z"
                                    fill="white" />
                                <path
                                    d="M575.542 506.463C575.438 505.806 574.528 505.445 574.001 505.851L573.948 505.896C573.452 506.339 573.64 507.299 574.266 507.523C574.893 507.746 575.646 507.12 575.542 506.463Z"
                                    fill="white" />
                                <path
                                    d="M554.984 498.296C554.88 497.639 553.97 497.278 553.443 497.684L553.39 497.729C552.894 498.172 553.082 499.132 553.709 499.356C554.335 499.579 555.088 498.953 554.984 498.296Z"
                                    fill="white" />
                                <path
                                    d="M551.347 490.245C551.242 489.588 550.333 489.227 549.806 489.633L549.752 489.678C549.256 490.121 549.445 491.081 550.071 491.305C550.698 491.528 551.451 490.903 551.347 490.245Z"
                                    fill="white" />
                                <path
                                    d="M552.926 480.943C552.822 480.286 551.912 479.925 551.385 480.331L551.331 480.375C550.836 480.819 551.024 481.779 551.65 482.002C552.277 482.225 553.031 481.599 552.926 480.943Z"
                                    fill="white" />
                                <path
                                    d="M541.542 493.738C541.438 493.081 540.528 492.72 540.001 493.127L539.948 493.171C539.452 493.614 539.64 494.575 540.266 494.798C540.893 495.02 541.646 494.395 541.542 493.738Z"
                                    fill="white" />
                                <path
                                    d="M567.912 497.428C567.808 496.771 566.898 496.41 566.371 496.816L566.318 496.861C565.822 497.304 566.01 498.264 566.636 498.487C567.264 498.71 568.017 498.084 567.912 497.428Z"
                                    fill="white" />
                                <path
                                    d="M545.586 514.012C545.482 513.354 544.572 512.993 544.045 513.4L543.992 513.444C543.496 513.888 543.684 514.848 544.31 515.071C544.937 515.293 545.69 514.668 545.586 514.012Z"
                                    fill="white" />
                                <path
                                    d="M525.147 561.712C525.043 561.055 524.133 560.694 523.606 561.1L523.553 561.145C523.057 561.588 523.246 562.549 523.872 562.772C524.499 562.994 525.251 562.369 525.147 561.712Z"
                                    fill="white" />
                                <path
                                    d="M532.44 534.201C532.336 533.544 531.426 533.183 530.899 533.59L530.846 533.634C530.35 534.077 530.539 535.038 531.165 535.261C531.792 535.483 532.544 534.858 532.44 534.201Z"
                                    fill="white" />
                                <path
                                    d="M586.193 485.892C586.089 485.235 585.179 484.874 584.652 485.28L584.599 485.325C584.103 485.768 584.291 486.728 584.918 486.952C585.545 487.175 586.297 486.549 586.193 485.892Z"
                                    fill="white" />
                                <path
                                    d="M611.849 540.673C611.745 540.016 610.835 539.655 610.308 540.061L610.255 540.106C609.759 540.549 609.948 541.509 610.574 541.733C611.2 541.955 611.954 541.33 611.849 540.673Z"
                                    fill="white" />
                                <path
                                    d="M621.845 493.531C621.74 492.874 620.831 492.513 620.304 492.919L620.25 492.964C619.754 493.407 619.943 494.367 620.569 494.59C621.196 494.814 621.949 494.188 621.845 493.531Z"
                                    fill="white" />
                                <path
                                    d="M617.92 524.403C617.816 523.746 616.906 523.385 616.379 523.791L616.326 523.836C615.83 524.279 616.018 525.239 616.644 525.463C617.271 525.685 618.025 525.06 617.92 524.403Z"
                                    fill="white" />
                                <path
                                    d="M595.503 546.695C595.399 546.038 594.489 545.677 593.962 546.083L593.909 546.128C593.413 546.571 593.601 547.531 594.227 547.754C594.854 547.977 595.607 547.352 595.503 546.695Z"
                                    fill="white" />
                                <path
                                    d="M596.447 528.139C596.343 527.482 595.433 527.121 594.906 527.527L594.853 527.572C594.357 528.015 594.545 528.975 595.172 529.198C595.798 529.421 596.551 528.796 596.447 528.139Z"
                                    fill="white" />
                                <path
                                    d="M609.971 493.692C609.866 493.035 608.957 492.674 608.43 493.08L608.376 493.125C607.88 493.568 608.069 494.528 608.695 494.751C609.322 494.974 610.075 494.349 609.971 493.692Z"
                                    fill="white" />
                                <path
                                    d="M591.763 475.713C591.658 475.056 590.749 474.695 590.222 475.101L590.168 475.145C589.672 475.589 589.861 476.549 590.487 476.772C591.114 476.995 591.867 476.369 591.763 475.713Z"
                                    fill="white" />
                                <path
                                    d="M591.104 504.696C591 504.038 590.09 503.678 589.563 504.084L589.51 504.128C589.014 504.572 589.203 505.532 589.829 505.755C590.455 505.978 591.209 505.353 591.104 504.696Z"
                                    fill="white" />
                                <path
                                    d="M567.862 593.11C567.758 592.453 566.848 592.092 566.321 592.498L566.268 592.543C565.772 592.986 565.96 593.946 566.587 594.17C567.214 594.393 567.967 593.768 567.862 593.11Z"
                                    fill="white" />
                                <path
                                    d="M541.197 578.571C541.093 577.914 540.183 577.553 539.656 577.959L539.603 578.004C539.107 578.447 539.295 579.407 539.922 579.631C540.549 579.854 541.302 579.229 541.197 578.571Z"
                                    fill="white" />
                                <path
                                    d="M519.64 585.698C519.535 585.04 518.625 584.68 518.099 585.086L518.045 585.13C517.549 585.574 517.738 586.534 518.364 586.757C518.991 586.98 519.744 586.354 519.64 585.698Z"
                                    fill="white" />
                                <path
                                    d="M517.335 597.976C517.231 597.319 516.321 596.958 515.794 597.364L515.741 597.408C515.245 597.852 515.433 598.812 516.059 599.035C516.686 599.259 517.439 598.633 517.335 597.976Z"
                                    fill="white" />
                                <path
                                    d="M537.546 602.089C537.442 601.432 536.532 601.071 536.005 601.477L535.952 601.521C535.456 601.965 535.644 602.925 536.27 603.148C536.896 603.371 537.65 602.745 537.546 602.089Z"
                                    fill="white" />
                                <path
                                    d="M530.786 574.593C530.682 573.935 529.772 573.575 529.245 573.981L529.192 574.025C528.696 574.469 528.884 575.429 529.51 575.652C530.138 575.875 530.891 575.25 530.786 574.593Z"
                                    fill="white" />
                                <path
                                    d="M555.583 581.579C555.479 580.922 554.569 580.561 554.042 580.967L553.989 581.012C553.493 581.455 553.681 582.415 554.307 582.639C554.934 582.862 555.687 582.236 555.583 581.579Z"
                                    fill="white" />
                                <path
                                    d="M614.531 574.546C614.427 573.889 613.517 573.528 612.99 573.934L612.937 573.979C612.441 574.422 612.629 575.382 613.256 575.606C613.882 575.829 614.635 575.203 614.531 574.546Z"
                                    fill="white" />
                                <path
                                    d="M578.058 609.496C577.953 608.839 577.043 608.478 576.517 608.884L576.463 608.929C575.967 609.372 576.156 610.332 576.782 610.556C577.409 610.778 578.162 610.153 578.058 609.496Z"
                                    fill="white" />
                                <path
                                    d="M593.616 590.041C593.512 589.384 592.602 589.023 592.075 589.429L592.022 589.474C591.526 589.917 591.714 590.877 592.341 591.1C592.968 591.324 593.72 590.698 593.616 590.041Z"
                                    fill="white" />
                                <path
                                    d="M602.856 605.863C602.752 605.206 601.842 604.845 601.315 605.251L601.262 605.296C600.766 605.739 600.955 606.699 601.581 606.923C602.208 607.146 602.96 606.521 602.856 605.863Z"
                                    fill="white" />
                                <path
                                    d="M577.145 523.003C577.041 522.345 576.131 521.985 575.604 522.391L575.551 522.435C575.055 522.879 575.244 523.839 575.87 524.062C576.497 524.285 577.25 523.66 577.145 523.003Z"
                                    fill="white" />
                                <path
                                    d="M598.063 563.396C597.959 562.738 597.049 562.377 596.522 562.784L596.469 562.828C595.973 563.272 596.162 564.232 596.788 564.455C597.415 564.678 598.167 564.053 598.063 563.396Z"
                                    fill="white" />
                                <path
                                    d="M591.281 578.697C591.177 578.04 590.267 577.679 589.74 578.085L589.687 578.13C589.191 578.573 589.379 579.533 590.006 579.756C590.633 579.979 591.386 579.354 591.281 578.697Z"
                                    fill="white" />
                                <path
                                    d="M613.591 590.985C613.487 590.328 612.577 589.967 612.05 590.373L611.996 590.418C611.501 590.861 611.689 591.821 612.315 592.044C612.941 592.268 613.695 591.642 613.591 590.985Z"
                                    fill="white" />
                                <path
                                    d="M552.547 608.727C552.443 608.069 551.533 607.709 551.006 608.115L550.953 608.159C550.457 608.603 550.645 609.563 551.271 609.786C551.898 610.009 552.651 609.384 552.547 608.727Z"
                                    fill="white" />
                                <path
                                    d="M501.682 604.086C501.577 603.429 500.667 603.068 500.141 603.474L500.087 603.518C499.591 603.962 499.78 604.922 500.406 605.145C501.033 605.369 501.786 604.742 501.682 604.086Z"
                                    fill="white" />
                                <path
                                    d="M546.474 595.731C546.369 595.074 545.459 594.713 544.933 595.119L544.879 595.164C544.383 595.607 544.572 596.567 545.198 596.791C545.825 597.014 546.578 596.388 546.474 595.731Z"
                                    fill="white" />
                                <path
                                    d="M503.569 586.642C503.465 585.985 502.555 585.624 502.028 586.03L501.975 586.074C501.479 586.518 501.667 587.478 502.294 587.701C502.921 587.924 503.673 587.298 503.569 586.642Z"
                                    fill="white" />
                                <path
                                    d="M575.261 557.795C575.157 557.138 574.247 556.777 573.72 557.183L573.666 557.228C573.17 557.671 573.359 558.631 573.985 558.854C574.612 559.078 575.365 558.452 575.261 557.795Z"
                                    fill="white" />
                                <path
                                    d="M560.257 514.012C560.153 513.354 559.243 512.993 558.716 513.4L558.662 513.444C558.167 513.888 558.355 514.848 558.981 515.071C559.608 515.293 560.361 514.668 560.257 514.012Z"
                                    fill="white" />
                                <path
                                    d="M556.507 551.981C556.403 551.324 555.493 550.963 554.966 551.369L554.912 551.413C554.417 551.857 554.605 552.817 555.231 553.04C555.858 553.263 556.612 552.638 556.507 551.981Z"
                                    fill="white" />
                                <path
                                    d="M550.404 539.595C550.3 538.938 549.39 538.577 548.863 538.984L548.81 539.028C548.314 539.472 548.502 540.432 549.129 540.655C549.756 540.878 550.509 540.253 550.404 539.595Z"
                                    fill="white" />
                                <path
                                    d="M577.398 578.525C577.294 577.868 576.384 577.507 575.857 577.913L575.804 577.958C575.308 578.401 575.497 579.361 576.123 579.585C576.75 579.808 577.502 579.183 577.398 578.525Z"
                                    fill="white" />
                                <path
                                    d="M558.37 570.887C558.266 570.23 557.356 569.869 556.829 570.275L556.776 570.32C556.28 570.763 556.468 571.723 557.094 571.947C557.721 572.169 558.474 571.544 558.37 570.887Z"
                                    fill="white" />
                                <path
                                    d="M566.515 528.961C566.41 528.303 565.5 527.943 564.974 528.349L564.92 528.393C564.424 528.837 564.613 529.797 565.239 530.02C565.866 530.243 566.619 529.617 566.515 528.961Z"
                                    fill="white" />
                                <path
                                    d="M537.546 558.647C537.442 557.99 536.532 557.629 536.005 558.035L535.952 558.08C535.456 558.523 535.644 559.483 536.27 559.707C536.896 559.93 537.65 559.305 537.546 558.647Z"
                                    fill="white" />
                                <path
                                    d="M582.26 545.022C582.156 544.364 581.246 544.004 580.719 544.41L580.666 544.454C580.17 544.898 580.359 545.858 580.985 546.081C581.611 546.304 582.365 545.678 582.26 545.022Z"
                                    fill="white" />
                                <path
                                    d="M623.732 509.452C623.628 508.795 622.718 508.434 622.191 508.84L622.138 508.885C621.642 509.328 621.831 510.289 622.457 510.512C623.083 510.735 623.836 510.11 623.732 509.452Z"
                                    fill="white" />
                                <path
                                    d="M606.893 482.52C606.789 481.863 605.879 481.502 605.352 481.908L605.299 481.952C604.803 482.396 604.992 483.356 605.618 483.579C606.245 483.803 606.998 483.177 606.893 482.52Z"
                                    fill="white" />
                                <path
                                    d="M574.257 485.892C574.153 485.235 573.243 484.874 572.716 485.28L572.662 485.325C572.167 485.768 572.355 486.728 572.981 486.952C573.607 487.175 574.361 486.549 574.257 485.892Z"
                                    fill="white" />
                                <path
                                    d="M540.978 389.214C534.718 393.198 532.22 401.544 533.414 406.477C534.016 408.963 535.144 411.465 534.651 413.975C534.226 416.143 532.667 417.878 531.5 419.756C527.608 426.016 528.297 434.777 533.12 440.351C537.943 445.925 546.514 447.867 553.269 444.915"
                                    fill="#060606" />
                                <path
                                    d="M537.27 421.788C522.044 388.298 558.263 371.472 578.027 377.054C596.601 382.3 604.523 391.544 607.579 403.967C610.637 416.395 610.49 429.854 605.62 441.691C603.219 447.527 598.894 453.457 592.625 454.186"
                                    fill="#060606" />
                                <path
                                    d="M555.1 503.573C554.837 487.572 554.651 465.592 554.646 465.683C554.646 465.683 540.892 463.399 538.042 445.454C536.625 436.53 537.073 421.897 537.827 409.936C538.505 399.171 545.638 385.961 556.366 387.096L589.861 395.563C593.12 395.908 595.573 398.688 595.509 401.964L593.327 471.248"
                                    fill="#FFBE9D" />
                                <path
                                    d="M543.825 420.899C543.767 422.107 544.743 423.151 546.004 423.233C547.261 423.316 548.329 422.406 548.386 421.199C548.442 419.992 547.467 418.947 546.21 418.864C544.949 418.781 543.881 419.691 543.825 420.899Z"
                                    fill="#060606" />
                                <path
                                    d="M567.577 420.9C567.519 422.107 568.495 423.151 569.755 423.233C571.012 423.316 572.08 422.406 572.138 421.198C572.194 419.991 571.219 418.946 569.962 418.863C568.701 418.781 567.633 419.692 567.577 420.9Z"
                                    fill="#060606" />
                                <path
                                    d="M541.334 416.718C541.609 417.028 543.395 415.796 545.87 415.885C548.343 415.939 550.117 417.272 550.396 416.978C550.532 416.848 550.26 416.297 549.488 415.695C548.729 415.095 547.419 414.494 545.878 414.448C544.336 414.405 543.02 414.93 542.255 415.486C541.474 416.046 541.198 416.579 541.334 416.718Z"
                                    fill="#060606" />
                                <path
                                    d="M564.827 417.307C565.115 417.606 566.855 416.308 569.33 416.304C571.803 416.263 573.627 417.529 573.894 417.225C574.025 417.09 573.735 416.55 572.938 415.977C572.157 415.407 570.825 414.854 569.283 414.868C567.74 414.884 566.445 415.458 565.702 416.042C564.944 416.629 564.688 417.173 564.827 417.307Z"
                                    fill="#060606" />
                                <path
                                    d="M556.356 436.379C556.367 436.238 554.827 435.973 552.333 435.653C551.701 435.588 551.102 435.463 550.996 435.031C550.847 434.574 551.111 433.892 551.418 433.156C552.012 431.626 552.635 430.022 553.288 428.341C555.885 421.485 557.765 415.847 557.488 415.745C557.212 415.643 554.881 421.117 552.284 427.974C551.659 429.664 551.061 431.276 550.493 432.818C550.254 433.536 549.842 434.351 550.165 435.3C550.335 435.772 550.799 436.115 551.205 436.225C551.61 436.348 551.966 436.355 552.279 436.374C554.788 436.508 556.346 436.52 556.356 436.379Z"
                                    fill="#060606" />
                                <path
                                    d="M554.652 465.685C554.652 465.685 566.725 466.464 578.686 459.274C578.686 459.274 572.613 471.759 554.652 470.08V465.685Z"
                                    fill="#EB996E" />
                                <path
                                    d="M564.235 413.789C564.479 414.462 566.952 414.142 569.857 414.493C572.77 414.784 575.112 415.635 575.498 415.031C575.67 414.742 575.262 414.109 574.314 413.456C573.376 412.806 571.877 412.187 570.132 411.993C568.388 411.802 566.79 412.079 565.733 412.509C564.667 412.94 564.13 413.469 564.235 413.789Z"
                                    fill="#060606" />
                                <path
                                    d="M541.913 410.494C542.349 411.057 544.055 410.473 546.107 410.446C548.157 410.347 549.895 410.823 550.296 410.235C550.472 409.949 550.197 409.387 549.438 408.854C548.691 408.323 547.44 407.89 546.029 407.932C544.62 407.977 543.398 408.487 542.685 409.063C541.96 409.641 541.721 410.22 541.913 410.494Z"
                                    fill="#060606" />
                                <path
                                    d="M592.449 425.592C592.712 425.465 602.054 421.333 602.164 432.077C602.273 442.821 591.464 440.715 591.442 440.406C591.42 440.098 592.449 425.592 592.449 425.592Z"
                                    fill="#FFBE9D" />
                                <path
                                    d="M594.675 436.303C594.721 436.268 594.863 436.432 595.181 436.574C595.491 436.712 596.022 436.805 596.58 436.589C597.711 436.16 598.648 434.348 598.681 432.412C598.698 431.433 598.484 430.504 598.129 429.737C597.793 428.954 597.279 428.411 596.707 428.315C596.137 428.189 595.735 428.536 595.608 428.839C595.467 429.141 595.538 429.355 595.48 429.374C595.45 429.401 595.248 429.197 595.33 428.752C595.372 428.538 595.495 428.283 595.746 428.074C596.002 427.862 596.38 427.751 596.778 427.79C597.607 427.839 598.361 428.594 598.75 429.436C599.185 430.282 599.449 431.326 599.429 432.424C599.383 434.59 598.295 436.627 596.746 437.092C595.993 437.296 595.36 437.075 595.031 436.825C594.697 436.563 594.638 436.323 594.675 436.303Z"
                                    fill="#EB996E" />
                                <path
                                    d="M552.798 381.8C546.821 384.889 544.36 397.118 546.833 403.375C549.307 409.632 555.971 412.689 562.544 414.129C569.116 415.569 575.56 415.739 582.042 413.936C582.493 418.295 585.106 422.769 589.335 423.919C594.934 425.442 600.578 420.314 601.824 414.648C603.07 408.98 601.202 403.144 599.358 397.643"
                                    fill="#060606" />
                                <path
                                    d="M600.204 420.786C600.229 420.82 599.935 421.099 599.376 421.569C598.814 422.037 597.99 422.705 596.898 423.438C595.805 424.162 594.424 424.968 592.721 425.459C591.04 425.946 588.981 426.122 587.019 425.376C585.062 424.631 583.616 423.149 582.704 421.646C581.778 420.124 581.363 418.56 581.157 417.259C580.956 415.95 580.958 414.88 580.989 414.148C581.023 413.414 581.089 413.013 581.129 413.015C581.246 413.012 581.119 414.648 581.589 417.182C581.843 418.437 582.289 419.924 583.188 421.343C584.078 422.751 585.446 424.116 587.238 424.795C589.031 425.479 590.954 425.343 592.566 424.908C594.195 424.47 595.557 423.732 596.661 423.067C598.855 421.696 600.14 420.698 600.204 420.786Z"
                                    fill="#060606" />
                                <path
                                    d="M557.093 443.281C557.454 444.195 557.822 445.123 558.427 445.897C559.032 446.672 559.917 447.285 560.898 447.332C561.944 447.382 562.953 446.763 563.536 445.893C564.119 445.024 564.318 443.94 564.271 442.894C564.229 441.948 563.796 440.82 562.856 440.708C562.465 440.662 562.079 440.813 561.714 440.961C560.068 441.628 558.42 442.296 556.773 442.964"
                                    fill="#EB996E" />
                                <path
                                    d="M559.062 447.346C559.088 447.191 560.172 447.632 561.698 447.02C562.436 446.723 563.244 446.135 563.69 445.211C564.135 444.297 564.223 443.06 563.755 441.979C563.646 441.708 563.483 441.46 563.324 441.24C563.129 441.035 563.165 441.044 562.952 441.076C562.751 441.13 562.426 441.283 562.16 441.387C561.885 441.499 561.614 441.609 561.349 441.717C560.291 442.145 559.333 442.519 558.525 442.821C556.907 443.425 555.882 443.744 555.835 443.631C555.787 443.519 556.725 442.998 558.28 442.247C559.058 441.871 559.99 441.438 561.03 440.969C561.291 440.852 561.558 440.732 561.829 440.612C562.118 440.493 562.338 440.364 562.731 440.24C562.925 440.186 563.198 440.155 563.464 440.261C563.725 440.367 563.888 440.544 564.009 440.692C564.23 440.986 564.425 441.288 564.565 441.629C565.146 442.979 565.006 444.474 564.414 445.582C563.81 446.714 562.78 447.349 561.907 447.609C561.018 447.884 560.252 447.818 559.766 447.693C559.273 447.562 559.042 447.396 559.062 447.346Z"
                                    fill="#060606" />
                                <path
                                    d="M604.483 418.239C603.382 418.161 594.509 419.31 595.207 435.805C595.86 451.211 606.668 447.818 610.117 442.018C613.384 436.523 615.272 418.996 604.483 418.239Z"
                                    fill="#455A64" />
                                <path
                                    d="M609.968 420.188C609.956 420.188 609.942 420.039 609.926 419.754C609.913 419.433 609.896 419.016 609.874 418.497C609.842 417.358 609.798 415.771 609.743 413.799C609.662 409.747 609.549 404.12 609.419 397.622L609.617 397.818C608.154 397.82 606.616 397.822 605.043 397.824L605.248 397.614C605.281 398.842 605.316 400.137 605.352 401.452C605.505 407.642 605.648 413.406 605.768 418.231L605.771 418.372L605.634 418.404C603.576 418.887 601.948 420.083 600.922 421.438C599.877 422.793 599.357 424.234 599.04 425.417C598.724 426.609 598.616 427.578 598.555 428.234C598.526 428.563 598.51 428.816 598.501 428.987C598.491 429.158 598.485 429.246 598.476 429.246C598.467 429.247 598.454 429.158 598.447 428.987C598.439 428.815 598.437 428.56 598.45 428.228C598.477 427.564 598.553 426.584 598.845 425.368C599.139 424.162 599.638 422.684 600.696 421.268C601.732 419.855 603.422 418.583 605.553 418.066L605.42 418.24C605.281 413.416 605.115 407.652 604.937 401.463C604.903 400.148 604.869 398.853 604.836 397.625L604.831 397.413H605.041C606.615 397.416 608.153 397.417 609.616 397.42H609.813L609.815 397.615C609.887 404.115 609.949 409.743 609.993 413.795C610 415.768 610.004 417.355 610.008 418.495C610.003 419.014 609.998 419.43 609.995 419.752C609.989 420.038 609.98 420.188 609.968 420.188Z"
                                    fill="#455A64" />
                                <path
                                    d="M604.481 397.618C604.481 397.618 599.842 386.757 588.783 381.398C583.426 378.803 579.419 377.464 575.536 376.487C575.536 376.487 581.987 374.955 592.427 379.6C597.171 381.71 601.949 384.459 605.109 388.578C607.117 391.194 609.623 396.308 609.619 397.619L604.481 397.618Z"
                                    fill="#455A64" />
                                <path
                                    d="M575.856 529.121C575.852 529.117 575.918 529.043 576.054 528.904C576.186 528.763 576.397 528.565 576.654 528.286C577.176 527.736 577.923 526.898 578.799 525.741C579.677 524.587 580.662 523.097 581.697 521.292C582.734 519.488 583.809 517.363 584.981 514.987C587.325 510.237 590.038 504.478 592.844 497.88C594.25 494.583 595.68 491.076 597.105 487.386C597.457 486.461 597.813 485.527 598.174 484.584C598.53 483.64 598.897 482.668 599.451 481.767C599.995 480.864 600.786 480.066 601.759 479.573C602.242 479.325 602.783 479.136 603.375 479.162C603.67 479.186 603.971 479.284 604.219 479.468C604.474 479.652 604.628 479.921 604.756 480.183L604.782 480.236L604.768 480.299C604.689 480.662 604.574 481.033 604.341 481.358C604.112 481.686 603.74 481.926 603.349 482.008C602.556 482.17 601.8 481.918 601.132 481.601C599.696 481.003 598.844 479.301 599.169 477.751C599.318 476.971 599.804 476.26 600.458 475.81C601.111 475.357 601.913 475.12 602.717 475.166C603.503 475.217 604.365 475.537 604.802 476.316C605.027 476.697 605.003 477.259 604.72 477.612C604.455 477.972 604.093 478.188 603.713 478.349C602.369 478.882 600.754 478.411 599.904 477.269C599.478 476.697 599.3 475.955 599.388 475.264C599.461 474.57 599.761 473.912 600.214 473.391C600.666 472.869 601.297 472.489 602.003 472.402C602.696 472.332 603.435 472.526 603.935 473.066C604.187 473.332 604.326 473.71 604.315 474.081C604.312 474.46 604.121 474.82 603.857 475.06C603.325 475.543 602.595 475.717 601.914 475.584C601.205 475.434 600.695 474.901 600.366 474.34C600.037 473.765 599.875 473.131 599.784 472.506C599.625 471.266 599.643 469.96 600.206 468.8C600.509 468.24 600.928 467.717 601.561 467.461C602.181 467.214 602.862 467.279 603.448 467.521C604.016 467.769 604.583 468.285 604.612 468.992C604.663 469.681 604.179 470.296 603.605 470.545C603.036 470.817 602.337 470.829 601.776 470.518C601.22 470.219 600.841 469.686 600.647 469.123C600.436 468.565 600.45 467.922 600.539 467.384C600.611 466.827 600.713 466.27 600.906 465.734C601.09 465.204 601.414 464.677 601.87 464.33C602.313 463.977 602.818 463.719 603.366 463.586C603.632 463.53 603.939 463.476 604.241 463.577C604.529 463.672 604.767 463.842 604.969 464.04C605.167 464.241 605.33 464.476 605.436 464.744C605.544 465.004 605.584 465.335 605.463 465.622C605.228 466.226 604.557 466.422 604.042 466.409C603.497 466.416 602.974 466.199 602.549 465.909C601.697 465.305 601.148 464.371 600.953 463.408C600.741 462.446 600.849 461.426 601.287 460.577C601.516 460.159 601.795 459.769 602.18 459.484C602.557 459.198 602.997 459.018 603.45 458.936C603.901 458.864 604.388 458.893 604.802 459.126C605.208 459.356 605.508 459.786 605.531 460.253C605.562 461.197 604.831 461.939 604.033 462.16C603.179 462.385 602.359 461.923 601.872 461.348C601.367 460.761 601.105 460.027 601.057 459.314C600.989 457.867 601.558 456.65 601.835 455.509C602.158 454.367 602.454 453.321 602.72 452.38C603.254 450.517 603.671 449.062 603.959 448.056C604.101 447.576 604.212 447.204 604.291 446.935C604.368 446.683 604.418 446.557 604.418 446.557C604.418 446.557 604.396 446.691 604.332 446.947C604.262 447.219 604.164 447.595 604.039 448.08C603.768 449.091 603.377 450.552 602.876 452.425C602.62 453.369 602.336 454.417 602.026 455.562C601.755 456.713 601.208 457.939 601.288 459.299C601.338 459.964 601.59 460.651 602.06 461.186C602.506 461.714 603.259 462.107 603.965 461.906C604.655 461.721 605.297 461.027 605.254 460.275C605.236 459.907 604.992 459.56 604.662 459.376C604.326 459.187 603.903 459.158 603.499 459.226C603.095 459.301 602.695 459.466 602.361 459.723C602.026 459.972 601.765 460.338 601.56 460.717C601.163 461.495 601.062 462.445 601.266 463.339C601.45 464.237 601.966 465.093 602.738 465.635C603.13 465.899 603.568 466.078 604.044 466.071C604.502 466.08 604.999 465.902 605.144 465.497C605.305 465.113 605.048 464.616 604.722 464.286C604.553 464.119 604.349 463.981 604.136 463.911C603.933 463.84 603.693 463.878 603.447 463.93C602.476 464.181 601.554 464.841 601.248 465.858C601.07 466.353 600.972 466.888 600.903 467.43C600.818 467.984 600.814 468.492 600.998 468.999C601.17 469.493 601.499 469.943 601.956 470.186C602.398 470.432 602.972 470.425 603.442 470.199C603.917 469.986 604.266 469.52 604.228 469.012C604.214 468.507 603.783 468.092 603.294 467.877C602.796 467.671 602.203 467.621 601.706 467.825C601.216 468.015 600.816 468.486 600.559 468.978C600.054 470.012 600.024 471.265 600.181 472.448C600.268 473.041 600.423 473.629 600.715 474.137C601.003 474.634 601.456 475.079 601.995 475.186C602.54 475.297 603.171 475.139 603.575 474.764C604.005 474.402 604.008 473.74 603.629 473.338C603.258 472.928 602.619 472.745 602.045 472.808C601.468 472.88 600.915 473.203 600.521 473.66C599.72 474.56 599.488 476.036 600.234 477.022C600.952 478.006 602.412 478.429 603.554 477.963C603.876 477.83 604.193 477.632 604.38 477.369C604.574 477.11 604.587 476.792 604.434 476.508C604.114 475.921 603.381 475.615 602.689 475.577C601.282 475.48 599.814 476.448 599.568 477.831C599.288 479.195 600.024 480.704 601.306 481.233C601.927 481.534 602.63 481.744 603.255 481.612C603.898 481.495 604.249 480.871 604.369 480.223L604.381 480.338C604.196 479.887 603.819 479.587 603.345 479.561C602.873 479.538 602.382 479.696 601.937 479.927C601.034 480.385 600.302 481.116 599.782 481.973C599.254 482.829 598.891 483.777 598.534 484.72C598.171 485.663 597.812 486.598 597.457 487.522C596.023 491.214 594.58 494.72 593.162 498.016C590.33 504.612 587.587 510.362 585.209 515.101C584.021 517.47 582.926 519.591 581.869 521.392C580.812 523.193 579.805 524.677 578.906 525.824C577.11 528.126 575.856 529.121 575.856 529.121Z"
                                    fill="white" />
                                <path
                                    d="M614.112 410.504C614.04 410.519 614.145 409.379 613.389 407.565C612.655 405.785 610.849 403.37 607.684 401.851C606.113 401.11 604.231 400.641 602.185 400.506C600.138 400.372 597.934 400.568 595.663 401.005C591.107 401.842 586.324 403.809 580.967 404.617C578.283 404.968 575.624 404.951 573.097 404.608C570.569 404.254 568.202 403.537 566.023 402.69C561.691 400.902 558.197 398.407 555.723 395.886C553.235 393.374 551.626 390.968 550.733 389.212C550.48 388.789 550.294 388.392 550.147 388.041C549.999 387.701 549.87 387.409 549.762 387.161C549.669 386.941 549.594 386.763 549.533 386.617C549.484 386.494 549.462 386.43 549.468 386.427C549.474 386.424 549.509 386.483 549.572 386.601C549.643 386.741 549.73 386.914 549.838 387.127C549.957 387.368 550.096 387.655 550.259 387.986C550.416 388.33 550.612 388.719 550.875 389.134C551.806 390.857 553.439 393.216 555.929 395.678C558.406 398.148 561.879 400.589 566.166 402.336C568.322 403.162 570.66 403.862 573.154 404.207C575.647 404.54 578.264 404.552 580.909 404.207C586.194 403.413 590.985 401.458 595.594 400.629C597.89 400.199 600.126 400.013 602.21 400.164C604.291 400.316 606.209 400.81 607.812 401.587C611.032 403.174 612.837 405.673 613.538 407.504C613.919 408.425 614.017 409.199 614.091 409.711C614.102 409.95 614.11 410.145 614.118 410.302C614.121 410.436 614.119 410.503 614.112 410.504Z"
                                    fill="#455A64" />
                                <path
                                    d="M602.121 393.377C602.122 393.391 601.925 393.426 601.551 393.478C601.176 393.529 600.624 393.611 599.917 393.734C598.5 393.969 596.471 394.421 593.975 395.042C591.482 395.66 588.492 396.41 585.089 396.763C581.693 397.124 577.907 397.093 574.006 396.523C570.101 395.958 566.466 394.916 563.298 393.643C560.131 392.367 557.416 390.892 555.262 389.47C554.195 388.746 553.236 388.077 552.432 387.444C551.644 386.789 550.935 386.261 550.412 385.764C549.912 385.293 549.51 384.915 549.204 384.627C548.931 384.364 548.792 384.221 548.802 384.211C548.812 384.2 548.97 384.323 549.261 384.566C549.58 384.838 549.997 385.196 550.518 385.642C551.055 386.119 551.775 386.626 552.573 387.259C553.386 387.872 554.352 388.52 555.422 389.224C559.725 391.976 566.296 395.009 574.066 396.112C577.933 396.677 581.683 396.719 585.052 396.383C588.425 396.054 591.404 395.339 593.91 394.756C596.416 394.171 598.465 393.761 599.895 393.573C600.608 393.474 601.166 393.418 601.544 393.394C601.92 393.369 602.12 393.363 602.121 393.377Z"
                                    fill="#455A64" />
                                <path
                                    d="M603.302 446.625C603.296 446.639 603.19 446.607 602.991 446.535C602.795 446.455 602.507 446.327 602.167 446.109C601.485 445.683 600.576 444.885 599.841 443.627C599.096 442.377 598.602 440.683 598.414 438.79C598.23 436.895 598.23 434.807 598.407 432.625C598.591 430.444 598.959 428.384 599.428 426.548C599.89 424.715 600.444 423.07 601.202 421.829C601.949 420.582 602.853 419.781 603.542 419.362C603.886 419.148 604.172 419.018 604.37 418.944C604.569 418.871 604.677 418.845 604.682 418.857C604.697 418.893 604.275 419.041 603.631 419.495C602.988 419.944 602.147 420.75 601.455 421.976C600.751 423.197 600.236 424.814 599.798 426.639C599.355 428.462 599.002 430.501 598.82 432.659C598.645 434.815 598.635 436.89 598.795 438.752C598.958 440.611 599.41 442.257 600.096 443.481C600.775 444.715 601.621 445.518 602.258 445.974C602.896 446.438 603.319 446.587 603.302 446.625Z"
                                    fill="#060606" />
                                <path
                                    d="M568.492 448.91L560.341 450.509C559.113 450.75 557.921 449.95 557.681 448.721L557.622 448.421C557.381 447.192 558.181 446.001 559.409 445.76L567.56 444.16C568.789 443.92 569.98 444.72 570.221 445.948L570.28 446.249C570.521 447.477 569.721 448.668 568.492 448.91Z"
                                    fill="#455A64" />
                                <path
                                    d="M569.117 445.384L606.824 433.554C607.757 433.262 608.752 433.777 609.05 434.708C609.36 435.674 608.799 436.703 607.82 436.968L569.262 447.385L569.117 445.384Z"
                                    fill="#455A64" />
                                <path
                                    d="M596.99 440.185C596.982 440.157 597.427 440.002 598.239 439.745C599.121 439.477 600.283 439.123 601.687 438.695C603.133 438.249 604.909 437.778 606.788 437.162C607.242 436.986 607.682 436.75 608.023 436.402C608.35 436.063 608.563 435.574 608.554 435.091C608.554 434.606 608.245 434.17 607.775 434.01C607.303 433.853 606.739 433.923 606.199 434.058C601.816 435.469 597.851 436.744 594.894 437.696C593.492 438.129 592.332 438.487 591.45 438.76C590.634 439.002 590.179 439.123 590.17 439.096C590.161 439.069 590.599 438.896 591.4 438.606C592.27 438.302 593.417 437.901 594.802 437.417C597.689 436.437 601.647 435.081 606.097 433.657C606.673 433.516 607.297 433.42 607.912 433.622C608.532 433.82 608.972 434.458 608.96 435.08C608.965 435.696 608.709 436.263 608.306 436.678C607.903 437.083 607.408 437.336 606.926 437.518C604.977 438.135 603.239 438.561 601.768 438.977C600.349 439.353 599.175 439.664 598.284 439.9C597.458 440.109 596.998 440.212 596.99 440.185Z"
                                    fill="#060606" />
                                <path
                                    d="M535.331 411.301C536.622 415.833 532.016 419.718 530.394 424.143C528.826 428.421 530.161 433.215 532.091 437.342C534.021 441.469 536.562 445.385 537.55 449.833C539.988 460.8 530.071 472.615 531.96 483.689C532.648 487.723 534.272 491.933 535.681 495.775C537.09 499.617 536.991 503.131 535.681 507.007C533.538 513.35 529.899 516.34 527.336 522.526C526.026 525.689 526.129 529.232 526.195 532.655C526.261 536.078 526.236 539.647 524.714 542.713C523.191 545.779 519.704 548.149 516.397 547.261C519.858 551.329 526.247 552.545 530.959 550.033C535.307 547.715 537.74 543.006 539.822 538.54C549.9 516.913 555.231 515.088 554.954 491.23C554.937 489.694 554.649 465.799 554.649 465.799C554.649 465.799 550.875 464.793 548.7 463.291C537.442 455.522 537.032 441.675 537.121 430.944"
                                    fill="#060606" />
                                <path
                                    d="M557.861 483.689V492.693C557.861 492.693 550.935 528.015 548.857 547.639C546.78 567.262 546.429 572.439 546.429 572.439C546.429 572.439 551.397 580.19 561.786 567.031C572.175 553.872 574.022 551.794 578.178 551.563C578.178 551.563 573.099 496.386 573.33 494.309C573.56 492.231 575.177 490.384 575.177 490.384L557.861 483.689Z"
                                    fill="#FFBE9D" />
                                <path
                                    d="M571.483 463.372C571.483 463.372 560.171 478.379 559.248 480.457C558.324 482.534 557.862 483.689 557.862 483.689L575.177 490.384L592.031 471.914L598.264 455.523L596.417 436.13C596.417 436.13 592.723 435.9 592.031 439.131C591.338 442.363 591.569 445.364 591.569 445.364L586.396 441.209L578.063 438.669C578.063 438.669 576.101 441.902 579.333 443.517C582.565 445.134 583.489 445.134 583.489 445.134L586.397 450.213L585.126 455.903L579.233 450.377C578.05 449.269 576.247 449.156 574.936 450.11L571.129 452.878L567.56 451.283L560.634 457.37L557.863 459.909C557.863 459.909 559.71 463.371 563.404 461.756C567.098 460.139 567.098 460.139 567.098 460.139L571.483 463.372Z"
                                    fill="#FFBE9D" />
                                <path
                                    d="M557.862 486.727C557.862 486.727 557.847 486.564 557.858 486.246C557.868 485.928 557.896 485.455 557.971 484.837C558.049 484.22 558.169 483.457 558.404 482.575C558.661 481.704 558.952 480.669 559.619 479.667C562.206 475.69 566.284 470.158 571.367 463.285L571.397 463.489C570.026 462.484 568.542 461.395 567.003 460.265L567.158 460.283C566.411 460.611 565.65 460.946 564.875 461.287C564.096 461.611 563.335 462.026 562.442 462.235C561.564 462.436 560.576 462.371 559.74 461.928C558.892 461.509 558.208 460.82 557.708 459.99L557.641 459.878L557.744 459.781C560.722 456.987 564.032 454.159 567.433 451.142L567.535 451.051L567.654 451.121C568.606 451.683 569.661 452.307 570.728 452.937L570.524 452.942C571.706 452.165 572.906 451.375 574.122 450.574C574.743 450.175 575.313 449.769 575.989 449.368C576.713 448.998 577.643 449.077 578.303 449.571C580.589 451.502 582.929 453.479 585.311 455.491L584.981 455.602C585.363 453.891 585.776 452.038 586.193 450.168L586.215 450.314C585.296 448.709 584.306 446.98 583.307 445.236L583.486 445.34C582.937 445.281 582.521 445.115 582.051 444.953C581.595 444.785 581.143 444.594 580.692 444.393C580.24 444.193 579.792 443.975 579.343 443.754C579.118 443.643 578.894 443.496 578.668 443.368C578.47 443.193 578.236 443.059 578.069 442.844C577.538 442.282 577.229 441.489 577.268 440.722C577.286 439.951 577.515 439.229 577.883 438.561L577.96 438.422L578.12 438.471C580.935 439.33 583.714 440.178 586.452 441.012L586.49 441.024L586.521 441.049C588.267 442.452 589.991 443.838 591.693 445.206L591.365 445.379C591.256 443.287 591.401 441.227 591.805 439.233C591.979 438.214 592.585 437.209 593.489 436.676C594.382 436.124 595.407 435.915 596.427 435.934L596.593 435.937L596.61 436.11C597.259 443.004 597.87 449.499 598.436 455.505L598.44 455.545L598.426 455.584C596.116 461.626 594.021 467.105 592.163 471.964L592.154 471.989L592.135 472.009C586.594 478.041 582.135 482.896 579.049 486.254C577.513 487.914 576.32 489.203 575.5 490.088C575.099 490.515 574.791 490.842 574.572 491.075C574.361 491.296 574.246 491.402 574.246 491.402C574.246 491.402 574.341 491.277 574.542 491.047C574.754 490.808 575.052 490.471 575.44 490.033C576.247 489.136 577.422 487.829 578.933 486.149C581.996 482.77 586.423 477.886 591.924 471.816L591.896 471.861C593.737 466.996 595.811 461.51 598.1 455.459L598.09 455.537C597.511 449.532 596.886 443.039 596.222 436.146L596.404 436.322C595.482 436.306 594.495 436.509 593.701 437.008C592.889 437.495 592.364 438.357 592.197 439.311C591.803 441.262 591.663 443.31 591.77 445.346L591.794 445.803L591.441 445.519C589.739 444.153 588.013 442.768 586.266 441.366L586.335 441.401C583.596 440.568 580.816 439.721 578.001 438.864L578.238 438.773C577.915 439.358 577.693 440.051 577.684 440.727C577.651 441.409 577.914 442.068 578.375 442.56C578.514 442.749 578.731 442.867 578.904 443.024C579.114 443.142 579.308 443.271 579.529 443.38C579.973 443.6 580.416 443.815 580.862 444.012C581.736 444.394 582.674 444.799 583.487 444.924L583.618 444.944L583.666 445.028C584.664 446.772 585.654 448.502 586.572 450.107L586.612 450.176L586.595 450.254C586.177 452.124 585.762 453.977 585.379 455.687L585.306 456.015L585.05 455.797C582.677 453.788 580.346 451.815 578.069 449.886C577.527 449.48 576.76 449.413 576.164 449.717C575.572 450.068 574.941 450.509 574.338 450.896C573.121 451.695 571.919 452.483 570.736 453.258L570.636 453.324L570.533 453.263C569.467 452.631 568.413 452.005 567.462 451.441L567.683 451.421C564.278 454.43 560.961 457.249 557.979 460.033L558.015 459.824C558.464 460.573 559.12 461.243 559.892 461.621C560.659 462.03 561.553 462.091 562.373 461.908C563.19 461.724 563.966 461.312 564.746 460.989C565.523 460.651 566.285 460.319 567.034 459.993L567.116 459.957L567.189 460.01C568.722 461.145 570.201 462.24 571.568 463.251L571.686 463.338L571.599 463.455C566.489 470.301 562.372 475.812 559.754 479.748C559.09 480.719 558.787 481.743 558.521 482.602C558.276 483.475 558.143 484.232 558.052 484.844C557.964 485.457 557.923 485.928 557.899 486.245C557.875 486.565 557.862 486.727 557.862 486.727Z"
                                    fill="#EB996E" />
                                <path
                                    d="M579.29 466.847C579.207 466.834 579.513 465.622 579.639 463.655C579.68 462.68 579.624 461.483 579.093 460.319C578.566 459.153 577.524 458.139 576.336 457.222C573.939 455.373 571.628 453.883 569.927 452.857C569.131 452.389 568.454 451.99 567.898 451.663C567.417 451.382 567.154 451.22 567.167 451.194C567.18 451.169 567.468 451.283 567.973 451.52C568.478 451.757 569.199 452.122 570.073 452.605C571.821 453.57 574.172 455.029 576.59 456.896C577.795 457.826 578.891 458.898 579.441 460.162C579.991 461.422 580.01 462.679 579.932 463.674C579.848 464.68 579.666 465.472 579.541 466.016C579.409 466.557 579.317 466.853 579.29 466.847Z"
                                    fill="#EB996E" />
                                <path
                                    d="M591.406 459.644C591.343 459.628 591.511 458.843 591.7 457.567C591.89 456.292 592.07 454.518 592.056 452.553C592.037 450.588 591.826 448.817 591.615 447.545C591.404 446.272 591.224 445.49 591.286 445.473C591.333 445.459 591.615 446.217 591.902 447.489C592.189 448.76 592.45 450.555 592.469 452.549C592.484 454.544 592.254 456.342 591.988 457.617C591.722 458.895 591.454 459.657 591.406 459.644Z"
                                    fill="#EB996E" />
                                <defs>
                                    <clipPath id="clip0_836_4582">
                                        <rect width="48.2713" height="48.2713" fill="white"
                                            transform="translate(240.591 380.624) rotate(-43.0167)" />
                                    </clipPath>
                                </defs>
                            </svg>

                        </div>

                    </div>
                    <div class="col-lg-6 col-12">
                        <div class="login-form-wrp">
                            <?php if(Session::has('create_ticket')): ?>
                                <div class="alert alert-success text-center">
                                    <?php echo session('create_ticket'); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(Session::has('error')): ?>
                                <div class="alert alert-danger">
                                    <?php echo session('error'); ?>

                                </div>
                            <?php endif; ?>
                            <h2 class="mb-4 text-center"><?php echo e(__('Create Ticket')); ?></h2>
                            <div class="login-form">
                                <form method="post" action="<?php echo e(route('home.store')); ?>" class="create-form mb-0 needs-validation"
                                    enctype="multipart/form-data" novalidate>
                                    <?php echo csrf_field(); ?>

                                    <div class="text-start row">
                                        <?php if(!$customFields->isEmpty()): ?>
                                            <?php echo $__env->make('admin.customFields.formBuilder', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                        <?php endif; ?>

                                        <?php if(isset($settings['RECAPTCHA_MODULE']) && $settings['RECAPTCHA_MODULE'] == 'yes'): ?>
                                            <?php if(
                                                    isset($settings['google_recaptcha_version']) &&
                                                    $settings['google_recaptcha_version'] == 'v2-checkbox'
                                                ): ?>
                                                <div class="form-group mb-4">
                                                    <?php echo NoCaptcha::display(); ?>

                                                    <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="small text-danger" role="alert">
                                                            <strong><?php echo e($message); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            <?php else: ?>
                                                <div class="form-group mb-4">
                                                    <input type="hidden" id="g-recaptcha-response" name="g-recaptcha-response"
                                                        class="form-control">
                                                    <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="error small text-danger" role="alert">
                                                            <strong><?php echo e($message); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                    <div class="text-center ticket-btn-wrapper">
                                        <div class="d-block ">
                                            <input type="hidden" name="status" value="New Ticket" />
                                            <input type="hidden" name="type" value="Ticket" />
                                            <button class="btn btn-primary btn-block " id="ticket_button">
                                                <?php echo e(__('Create Ticket')); ?>

                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
        </div>

    <?php endif; ?>

    <div class="row w-100">
        <div class="col-sm-12 col-md-2 col-lg-2">
            <?php if(isset($settings['CHAT_MODULE']) && $settings['CHAT_MODULE'] == 'yes'): ?>
                <div class="fabs">
                    <div class="chat d-none">
                        <div class="chat_header">
                            <div class="chat_option btn-primary bg-primary">
                                <div class="header_img">
                                    
                                    <img src="<?php echo e(getFile(getSidebarLogo())); ?><?php echo e('?' . time()); ?>" alt="">
                                </div>
                                <span id="chat_head" class=""><?php echo e(__('Ticket')); ?></span>
                            </div>
                        </div>
                        <div class="msg_chat">
                            <div id="chat_fullscreen" class="chat_conversion chat_converse">
                                <h3 class="text-center mt-5 pt-5"><?php echo e(__('No Message Found.!')); ?></h3>
                            </div>
                            <div class="fab_field">
                                <textarea rows="1" id="chatSend" name="chat_message" placeholder="<?php echo e(__('Send a message')); ?>"
                                    class="chat_field chat_message"></textarea>
                                <button type="button" class="btn" id="Send">
                                    <svg width="21" height="21" viewBox="0 0 21 21" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_1_2514)">
                                            <path
                                                d="M19.3386 9.2414L2.40878 0.98294C2.26318 0.911916 2.1033 0.875 1.94129 0.875C1.3524 0.875 0.875 1.3524 0.875 1.94129V1.97207C0.875 2.11515 0.892544 2.25769 0.927246 2.3965L2.55122 8.89236C2.59557 9.06981 2.74559 9.20089 2.92735 9.2211L10.0652 10.0142C10.3128 10.0417 10.5 10.2509 10.5 10.5C10.5 10.7491 10.3128 10.9583 10.0652 10.9858L2.92735 11.7789C2.74559 11.7991 2.59557 11.9302 2.55122 12.1076L0.927246 18.6035C0.892544 18.7423 0.875 18.8849 0.875 19.0279V19.0587C0.875 19.6476 1.3524 20.125 1.94129 20.125C2.1033 20.125 2.26318 20.0881 2.40878 20.017L19.3386 11.7586C19.8197 11.5239 20.125 11.0354 20.125 10.5C20.125 9.96459 19.8197 9.47608 19.3386 9.2414Z"
                                                fill="white"></path>
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_1_2514">
                                                <rect width="21" height="21" fill="white"></rect>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </button>

                            </div>

                        </div>
                        <div class="msg_form">
                            <div id="chat_fullscreen" class="chat_conversion chat_converse">
                                <form class="pt-4" name="chat_form" id="chat_form">
                                    <div class="form-group row mb-3 ml-md-2">
                                        <div class="col-sm-12 col-md-12">

                                            <div class="">
                                                <div class="form-group">
                                                    <input type="text" class="form-control" id="chat_name" name="name"
                                                        placeholder="<?php echo e(__('Enter You Name')); ?>" autofocus>
                                                </div>
                                                <div class="input-group form-group">
                                                    <span class="input-group-text"><i class="fas fa-envelope"></i></span>
                                                    <input type="email" class="form-control" id="chat_email" name="email"
                                                        placeholder="<?php echo e(__('Enter You Email')); ?>" autofocus>
                                                </div>

                                                <div class="form-group">
                                                    <input type="text" class="form-control" id="chat_subject" name="subject"
                                                        placeholder="<?php echo e(__('Enter subject')); ?>" autofocus>
                                                </div>



                                                <div class="form-group">
                                                    <textarea name="description" id="chat_description" class="form-control"
                                                        cols="3" rows="1"
                                                        placeholder="<?php echo e(__('Enter Description')); ?>"></textarea>
                                                </div>



                                            </div>
                                            <div class="invalid-feedback d-block e_error">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row mb-4 ml-md-2">
                                        <div class="col-sm-12 col-md-7">
                                            <button class="btn-submit btn btn-primary  btn-block" id="chat_frm_submit"
                                                type="button"><span><?php echo e(__('Start Chat')); ?></span></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <a id="prime" class="fab btn-primary bg-primary">
                        <svg width="61" height="55" viewBox="0 0 61 55" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M53.6909 0H6.54767C4.81175 0.00204477 3.14751 0.692544 1.92003 1.92003C0.692544 3.14751 0.00204477 4.81175 0 6.54768V35.3574C0.00204477 37.0934 0.692544 38.7576 1.92003 39.9851C3.14751 41.2126 4.81175 41.9031 6.54767 41.9051H9.16674V52.3226C9.16187 52.8564 9.3177 53.3793 9.61397 53.8234C9.91024 54.2674 10.3333 54.6121 10.828 54.8125C11.307 55.0058 11.833 55.0502 12.3376 54.94C12.8422 54.8298 13.3018 54.5702 13.6566 54.1948L25.4401 41.9051H53.6909C55.4268 41.9031 57.0911 41.2126 58.3186 39.9851C59.5461 38.7576 60.2366 37.0934 60.2386 35.3574V6.54768C60.2366 4.81175 59.5461 3.14751 58.3186 1.92003C57.0911 0.692544 55.4268 0.00204477 53.6909 0ZM14.4049 11.7858H27.5002C27.8475 11.7858 28.1806 11.9238 28.4262 12.1694C28.6718 12.415 28.8098 12.748 28.8098 13.0954C28.8098 13.4427 28.6718 13.7757 28.4262 14.0213C28.1806 14.2669 27.8475 14.4049 27.5002 14.4049H14.4049C14.0576 14.4049 13.7245 14.2669 13.4789 14.0213C13.2333 13.7757 13.0953 13.4427 13.0953 13.0954C13.0953 12.748 13.2333 12.415 13.4789 12.1694C13.7245 11.9238 14.0576 11.7858 14.4049 11.7858ZM40.5956 30.1193H14.4049C14.0576 30.1193 13.7245 29.9813 13.4789 29.7358C13.2333 29.4902 13.0953 29.1571 13.0953 28.8098C13.0953 28.4625 13.2333 28.1294 13.4789 27.8838C13.7245 27.6382 14.0576 27.5002 14.4049 27.5002H40.5956C40.9429 27.5002 41.276 27.6382 41.5216 27.8838C41.7671 28.1294 41.9051 28.4625 41.9051 28.8098C41.9051 29.1571 41.7671 29.4902 41.5216 29.7358C41.276 29.9813 40.9429 30.1193 40.5956 30.1193ZM45.8337 22.2621H14.4049C14.0576 22.2621 13.7245 22.1241 13.4789 21.8785C13.2333 21.633 13.0953 21.2999 13.0953 20.9526C13.0953 20.6052 13.2333 20.2722 13.4789 20.0266C13.7245 19.781 14.0576 19.643 14.4049 19.643H45.8337C46.181 19.643 46.5141 19.781 46.7597 20.0266C47.0053 20.2722 47.1433 20.6052 47.1433 20.9526C47.1433 21.2999 47.0053 21.633 46.7597 21.8785C46.5141 22.1241 46.181 22.2621 45.8337 22.2621Z"
                                fill="white" />
                        </svg>

                    </a>
                </div>
            <?php endif; ?>

            
            <?php echo $__env->yieldPushContent('whatsappchatbot'); ?>
            
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('css/summernote/summernote-bs4.js')); ?>"></script>
    
    <?php if(moduleIsActive('TicketWidget')): ?>
    <script>
        window.TicketGoWidgetConfig = {        
            baseUrl: "<?php echo e(config('app.url')); ?>"
        };
    </script>
    <script src="<?php echo e(asset('packages/workdo/TicketWidget/src/Resources/assets/js/ticket-widget.js')); ?>"></script>
    <?php endif; ?>
    
    <script>
        $(document).ready(function () {
            $("#chat_frm_submit").click(function (e) {
                var form = $("#chat_form");
                if (form[0].checkValidity()) {
                    $(this).prop("disabled", true);
                }
            });
        });
    </script>

    <script>
        $(document).ready(function () {
            $(".form_data").submit(function (e) {
                $(".login_button").attr("disabled", true);
                return true;
            });
        });
    </script>

    <?php if(isset($settings['RECAPTCHA_MODULE']) && $settings['RECAPTCHA_MODULE'] == 'yes'): ?>
        <?php if(isset($settings['google_recaptcha_version']) && $settings['google_recaptcha_version'] == 'v2-checkbox'): ?>
            <?php echo NoCaptcha::renderJs(); ?>

        <?php else: ?>
            <script src="https://www.google.com/recaptcha/api.js?render=<?php echo e($settings['NOCAPTCHA_SITEKEY']); ?>"></script>
            <script>
                $(document).ready(function () {
                    grecaptcha.ready(function () {
                        grecaptcha.execute('<?php echo e($settings['NOCAPTCHA_SITEKEY']); ?>', {
                            action: 'submit'
                        }).then(function (token) {
                            $('#g-recaptcha-response').val(token);
                        });
                    });
                });
            </script>
        <?php endif; ?>
    <?php endif; ?>

    <script>
        if ($(".select2").length) {
            $('.select2').select2({
                "language": {
                    "noResults": function () {
                        return "<?php echo e(__('No result found')); ?>";
                    }
                },
            });
        }

        // for Choose file
        $(document).on('change', 'input[type=file]', function () {
            var names = '';
            var files = $('input[type=file]')[0].files;

            for (var i = 0; i < files.length; i++) {
                names += files[i].name + '<br>';
            }
            $('.' + $(this).attr('data-filename')).html(names);
        });
    </script>


    <?php if(isset($settings['CHAT_MODULE']) && $settings['CHAT_MODULE'] == 'yes'): ?>
        <script>
            //Toggle chat and links
            function toggleFab() {
                $('.chat').toggleClass('is-visible');
                $('.fab').toggleClass('is-visible');
                $('.chat').toggleClass('d-none');
            }

            $('#prime').click(function () {
                var old_ticket_user = getCookie('ticket_user');
                if (old_ticket_user != '') {
                    // has cookie
                    $('.msg_chat').removeClass('d-none');
                    $('.msg_form').removeClass('d-block');
                    $('.msg_chat').addClass('d-block');
                    $('.msg_form').addClass('d-none');

                    getMessage();
                } else {
                    // no cookie
                    $('.msg_chat').removeClass('d-block');
                    $('.msg_form').removeClass('d-none');
                    $('.msg_chat').addClass('d-none');
                    $('.msg_form').addClass('d-block');
                    $("form[name='chat_form']")[0].reset();
                }
                toggleFab();
            });

            $('#chat_frm_submit').on('click', function () {
                var name = $('#chat_name').val();
                var email = $('#chat_email').val();
                var subject = $('#chat_subject').val();
                var description = $('#chat_description').val();


                $.ajax({
                    type: 'POST',
                    url: "<?php echo e(route('home.store')); ?>",
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        name: name,
                        email: email,
                        subject: subject,
                        description: description,
                    },

                    success: function (data) {
                        // Clear previous errors
                        $('.e_error').html('');

                        if (data.status === 'error') {
                            // Display validation error message
                            $('.e_error').html(data
                                .message); // You can update this to display multiple errors if needed
                        } else {
                            setCookie('ticket_user', JSON.stringify(data), 3);
                            $('.msg_chat').removeClass('d-none').addClass('d-block');
                            $('.msg_form').removeClass('d-block').addClass('d-none');
                            getMessage();
                        }

                    },
                    error: function (xhr, status, error) {
                        // Handle any general error, for example, server errors
                        console.log('Request failed: ' + error);
                    }

                });

            });

            // Live chat Send Btn 
            $(document).on('click', '#Send', function (e) {
                var message = $('#chatSend').val();
                if (message != '') {
                    $('#chatSend').val('');
                    $.ajax({
                        type: "post",
                        url: "ticket_floating_message",
                        data: {
                            "_token": '<?php echo e(csrf_token()); ?>',
                            message: message,
                        },
                        cache: false,
                        success: function (data) { },
                        error: function (jqXHR, status, err) { },
                        complete: function () {
                            getMessage();
                            // For Establishing the Pusher Connection Called this function Here.
                            getMessageViaPusher();
                        }
                    });
                }
            });

            // make a function to scroll down auto
            function scrollToBottomFunc() {
                $('#chat_fullscreen').animate({
                    scrollTop: $('#chat_fullscreen').get(0).scrollHeight
                }, 10);
            }

            // get Message when page is load or when msg successfully send
            function getMessage() {
                $.ajax({
                    type: "get",
                    url: "<?php echo e(route('get_ticket_message')); ?>",
                    cache: false,
                    success: function (data) {
                        $('.msg_chat').removeClass('d-none').addClass('d-block');
                        $('.msg_form').removeClass('d-block').addClass('d-none');
                        $('#chat_fullscreen').html(data);

                        scrollToBottomFunc();
                    }
                });
            }

            function setCookie(cname, cvalue, exdays) {
                var d = new Date();
                d.setTime(d.getTime() + (exdays * 60 * 60 * 1000));
                var expires = "expires=" + d.toUTCString();
                document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
            }

            function getCookie(cname) {
                var name = cname + "=";
                var ca = document.cookie.split(';');
                for (var i = 0; i < ca.length; i++) {
                    var c = ca[i];
                    while (c.charAt(0) == ' ') {
                        c = c.substring(1);
                    }
                    if (c.indexOf(name) == 0) {
                        return c.substring(name.length, c.length);
                    }
                }
                return "";
            }

            // This function is for getting the Live message from admin or agent side.
            function getMessageViaPusher() {
                var ticketdata = getCookie('ticket_user');
                if (ticketdata != '') {
                    Pusher.logToConsole = false;

                    var pusher = new Pusher(
                        '<?php echo e(isset($settings["PUSHER_APP_KEY"]) ? $settings["PUSHER_APP_KEY"] : ""); ?>', {
                        cluster: '<?php echo e(isset($settings["PUSHER_APP_CLUSTER"]) ? $settings["PUSHER_APP_CLUSTER"] : ""); ?>',
                        forceTLS: true
                    });

                    var ticketdata = getCookie('ticket_user');
                    if (ticketdata) {
                        ticketdata = JSON.parse(ticketdata);
                        var ticket_id = ticketdata.tikcet_id;
                    } else {
                        console.log('No ticket user data found in cookie');
                    }
                    var ticket_id = ticketdata.tikcet_id

                    var channel = pusher.subscribe('ticket-reply-send-' + ticket_id);

                    channel.bind('ticket-reply-send-event-' + ticket_id, function (data) {
                        if (getCookie('ticket_user') != '') {
                            var k = JSON.parse(getCookie('ticket_user'));

                            var receiver_id = k.id;
                            var my_id = '1';

                            /*alert(JSON.stringify(data));*/
                            if (ticket_id == data.ticket_number) {
                                getMessage();
                                scrollToBottomFunc();
                            }
                        }
                    });
                }
            }
            // Get the Messages Via Pusher Channel & Event 
            $(document).ready(function () {
                getMessageViaPusher();
            });
            // end

            // $(document).ready(function() {
            //     $("#form-data").submit(function(e) {
            //         $("#ticket_button").attr("disabled", true);
            //         return true;
            //     });
            // });
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.auth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/sevenonesix/public_html/ticket.buffalorepair.net/resources/views/home.blade.php ENDPATH**/ ?>