<?php
// This file was auto-generated from sdk-root/src/data/connectcases/2022-10-03/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2022-10-03', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'cases', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceAbbreviation' => 'ConnectCases', 'serviceFullName' => 'Amazon Connect Cases', 'serviceId' => 'ConnectCases', 'signatureVersion' => 'v4', 'signingName' => 'cases', 'uid' => 'connectcases-2022-10-03', ], 'operations' => [ 'BatchGetCaseRule' => [ 'name' => 'BatchGetCaseRule', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/rules-batch', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchGetCaseRuleRequest', ], 'output' => [ 'shape' => 'BatchGetCaseRuleResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'BatchGetField' => [ 'name' => 'BatchGetField', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/fields-batch', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchGetFieldRequest', ], 'output' => [ 'shape' => 'BatchGetFieldResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'BatchPutFieldOptions' => [ 'name' => 'BatchPutFieldOptions', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{domainId}/fields/{fieldId}/options', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchPutFieldOptionsRequest', ], 'output' => [ 'shape' => 'BatchPutFieldOptionsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateCase' => [ 'name' => 'CreateCase', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/cases', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateCaseRequest', ], 'output' => [ 'shape' => 'CreateCaseResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'CreateCaseRule' => [ 'name' => 'CreateCaseRule', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/case-rules', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateCaseRuleRequest', ], 'output' => [ 'shape' => 'CreateCaseRuleResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateDomain' => [ 'name' => 'CreateDomain', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateDomainRequest', ], 'output' => [ 'shape' => 'CreateDomainResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateField' => [ 'name' => 'CreateField', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/fields', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateFieldRequest', ], 'output' => [ 'shape' => 'CreateFieldResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateLayout' => [ 'name' => 'CreateLayout', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/layouts', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateLayoutRequest', ], 'output' => [ 'shape' => 'CreateLayoutResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'CreateRelatedItem' => [ 'name' => 'CreateRelatedItem', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/cases/{caseId}/related-items/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateRelatedItemRequest', ], 'output' => [ 'shape' => 'CreateRelatedItemResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateTemplate' => [ 'name' => 'CreateTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/templates', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateTemplateRequest', ], 'output' => [ 'shape' => 'CreateTemplateResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'DeleteCase' => [ 'name' => 'DeleteCase', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{domainId}/cases/{caseId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteCaseRequest', ], 'output' => [ 'shape' => 'DeleteCaseResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'DeleteCaseRule' => [ 'name' => 'DeleteCaseRule', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{domainId}/case-rules/{caseRuleId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteCaseRuleRequest', ], 'output' => [ 'shape' => 'DeleteCaseRuleResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteDomain' => [ 'name' => 'DeleteDomain', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{domainId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteDomainRequest', ], 'output' => [ 'shape' => 'DeleteDomainResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteField' => [ 'name' => 'DeleteField', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{domainId}/fields/{fieldId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteFieldRequest', ], 'output' => [ 'shape' => 'DeleteFieldResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'DeleteLayout' => [ 'name' => 'DeleteLayout', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{domainId}/layouts/{layoutId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteLayoutRequest', ], 'output' => [ 'shape' => 'DeleteLayoutResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteRelatedItem' => [ 'name' => 'DeleteRelatedItem', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{domainId}/cases/{caseId}/related-items/{relatedItemId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteRelatedItemRequest', ], 'output' => [ 'shape' => 'DeleteRelatedItemResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'DeleteTemplate' => [ 'name' => 'DeleteTemplate', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{domainId}/templates/{templateId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteTemplateRequest', ], 'output' => [ 'shape' => 'DeleteTemplateResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'GetCase' => [ 'name' => 'GetCase', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/cases/{caseId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetCaseRequest', ], 'output' => [ 'shape' => 'GetCaseResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'GetCaseAuditEvents' => [ 'name' => 'GetCaseAuditEvents', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/cases/{caseId}/audit-history', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetCaseAuditEventsRequest', ], 'output' => [ 'shape' => 'GetCaseAuditEventsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'GetCaseEventConfiguration' => [ 'name' => 'GetCaseEventConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/case-event-configuration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetCaseEventConfigurationRequest', ], 'output' => [ 'shape' => 'GetCaseEventConfigurationResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'GetDomain' => [ 'name' => 'GetDomain', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDomainRequest', ], 'output' => [ 'shape' => 'GetDomainResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'GetLayout' => [ 'name' => 'GetLayout', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/layouts/{layoutId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetLayoutRequest', ], 'output' => [ 'shape' => 'GetLayoutResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'GetTemplate' => [ 'name' => 'GetTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/templates/{templateId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTemplateRequest', ], 'output' => [ 'shape' => 'GetTemplateResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'ListCaseRules' => [ 'name' => 'ListCaseRules', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/rules-list/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListCaseRulesRequest', ], 'output' => [ 'shape' => 'ListCaseRulesResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'ListCasesForContact' => [ 'name' => 'ListCasesForContact', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/list-cases-for-contact', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListCasesForContactRequest', ], 'output' => [ 'shape' => 'ListCasesForContactResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'ListDomains' => [ 'name' => 'ListDomains', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains-list', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDomainsRequest', ], 'output' => [ 'shape' => 'ListDomainsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'ListFieldOptions' => [ 'name' => 'ListFieldOptions', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/fields/{fieldId}/options-list', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListFieldOptionsRequest', ], 'output' => [ 'shape' => 'ListFieldOptionsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'ListFields' => [ 'name' => 'ListFields', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/fields-list', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListFieldsRequest', ], 'output' => [ 'shape' => 'ListFieldsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'ListLayouts' => [ 'name' => 'ListLayouts', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/layouts-list', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListLayoutsRequest', ], 'output' => [ 'shape' => 'ListLayoutsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{arn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'ListTemplates' => [ 'name' => 'ListTemplates', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/templates-list', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTemplatesRequest', ], 'output' => [ 'shape' => 'ListTemplatesResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'PutCaseEventConfiguration' => [ 'name' => 'PutCaseEventConfiguration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{domainId}/case-event-configuration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutCaseEventConfigurationRequest', ], 'output' => [ 'shape' => 'PutCaseEventConfigurationResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], ], ], 'SearchAllRelatedItems' => [ 'name' => 'SearchAllRelatedItems', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/related-items-search', 'responseCode' => 200, ], 'input' => [ 'shape' => 'SearchAllRelatedItemsRequest', ], 'output' => [ 'shape' => 'SearchAllRelatedItemsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'SearchCases' => [ 'name' => 'SearchCases', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/cases-search', 'responseCode' => 200, ], 'input' => [ 'shape' => 'SearchCasesRequest', ], 'output' => [ 'shape' => 'SearchCasesResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'SearchRelatedItems' => [ 'name' => 'SearchRelatedItems', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{domainId}/cases/{caseId}/related-items-search', 'responseCode' => 200, ], 'input' => [ 'shape' => 'SearchRelatedItemsRequest', ], 'output' => [ 'shape' => 'SearchRelatedItemsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{arn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{arn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'UpdateCase' => [ 'name' => 'UpdateCase', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{domainId}/cases/{caseId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateCaseRequest', ], 'output' => [ 'shape' => 'UpdateCaseResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'UpdateCaseRule' => [ 'name' => 'UpdateCaseRule', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{domainId}/case-rules/{caseRuleId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateCaseRuleRequest', ], 'output' => [ 'shape' => 'UpdateCaseRuleResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'UpdateField' => [ 'name' => 'UpdateField', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{domainId}/fields/{fieldId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateFieldRequest', ], 'output' => [ 'shape' => 'UpdateFieldResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'UpdateLayout' => [ 'name' => 'UpdateLayout', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{domainId}/layouts/{layoutId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateLayoutRequest', ], 'output' => [ 'shape' => 'UpdateLayoutResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'UpdateTemplate' => [ 'name' => 'UpdateTemplate', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{domainId}/templates/{templateId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateTemplateRequest', ], 'output' => [ 'shape' => 'UpdateTemplateResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'Arn' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'AssociationTime' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'AuditEvent' => [ 'type' => 'structure', 'required' => [ 'eventId', 'type', 'performedTime', 'fields', ], 'members' => [ 'eventId' => [ 'shape' => 'AuditEventId', ], 'type' => [ 'shape' => 'AuditEventType', ], 'relatedItemType' => [ 'shape' => 'RelatedItemType', ], 'performedTime' => [ 'shape' => 'AuditEventDateTime', ], 'fields' => [ 'shape' => 'AuditEventFieldList', ], 'performedBy' => [ 'shape' => 'AuditEventPerformedBy', ], ], ], 'AuditEventDateTime' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'AuditEventField' => [ 'type' => 'structure', 'required' => [ 'eventFieldId', 'newValue', ], 'members' => [ 'eventFieldId' => [ 'shape' => 'AuditEventFieldId', ], 'oldValue' => [ 'shape' => 'AuditEventFieldValueUnion', ], 'newValue' => [ 'shape' => 'AuditEventFieldValueUnion', ], ], ], 'AuditEventFieldId' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'AuditEventFieldList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AuditEventField', ], ], 'AuditEventFieldValueUnion' => [ 'type' => 'structure', 'members' => [ 'stringValue' => [ 'shape' => 'AuditEventFieldValueUnionStringValueString', ], 'doubleValue' => [ 'shape' => 'Double', ], 'booleanValue' => [ 'shape' => 'Boolean', ], 'emptyValue' => [ 'shape' => 'EmptyFieldValue', ], 'userArnValue' => [ 'shape' => 'String', ], ], 'union' => true, ], 'AuditEventFieldValueUnionStringValueString' => [ 'type' => 'string', 'max' => 500, 'min' => 0, ], 'AuditEventId' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'AuditEventPerformedBy' => [ 'type' => 'structure', 'required' => [ 'iamPrincipalArn', ], 'members' => [ 'user' => [ 'shape' => 'UserUnion', ], 'iamPrincipalArn' => [ 'shape' => 'IamPrincipalArn', ], ], ], 'AuditEventType' => [ 'type' => 'string', 'enum' => [ 'Case.Created', 'Case.Updated', 'RelatedItem.Created', ], ], 'BasicLayout' => [ 'type' => 'structure', 'members' => [ 'topPanel' => [ 'shape' => 'LayoutSections', ], 'moreInfo' => [ 'shape' => 'LayoutSections', ], ], ], 'BatchGetCaseRuleRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'caseRules', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'caseRules' => [ 'shape' => 'CaseRuleIdentifierList', ], ], ], 'BatchGetCaseRuleResponse' => [ 'type' => 'structure', 'required' => [ 'caseRules', 'errors', ], 'members' => [ 'caseRules' => [ 'shape' => 'BatchGetCaseRuleResponseCaseRulesList', ], 'errors' => [ 'shape' => 'BatchGetCaseRuleResponseErrorsList', ], 'unprocessedCaseRules' => [ 'shape' => 'BatchGetCaseRuleResponseUnprocessedCaseRulesList', ], ], ], 'BatchGetCaseRuleResponseCaseRulesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GetCaseRuleResponse', ], 'max' => 50, 'min' => 0, ], 'BatchGetCaseRuleResponseErrorsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CaseRuleError', ], 'max' => 50, 'min' => 0, ], 'BatchGetCaseRuleResponseUnprocessedCaseRulesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CaseRuleId', ], 'max' => 50, 'min' => 0, ], 'BatchGetFieldIdentifierList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldIdentifier', ], 'max' => 50, 'min' => 1, ], 'BatchGetFieldRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'fields', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'fields' => [ 'shape' => 'BatchGetFieldIdentifierList', ], ], ], 'BatchGetFieldResponse' => [ 'type' => 'structure', 'required' => [ 'fields', 'errors', ], 'members' => [ 'fields' => [ 'shape' => 'BatchGetFieldResponseFieldsList', ], 'errors' => [ 'shape' => 'BatchGetFieldResponseErrorsList', ], ], ], 'BatchGetFieldResponseErrorsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldError', ], 'max' => 50, 'min' => 0, ], 'BatchGetFieldResponseFieldsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GetFieldResponse', ], 'max' => 50, 'min' => 0, ], 'BatchPutFieldOptionsRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'fieldId', 'options', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'fieldId' => [ 'shape' => 'FieldId', 'location' => 'uri', 'locationName' => 'fieldId', ], 'options' => [ 'shape' => 'BatchPutFieldOptionsRequestOptionsList', ], ], ], 'BatchPutFieldOptionsRequestOptionsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldOption', ], 'max' => 50, 'min' => 0, ], 'BatchPutFieldOptionsResponse' => [ 'type' => 'structure', 'members' => [ 'errors' => [ 'shape' => 'BatchPutFieldOptionsResponseErrorsList', ], ], ], 'BatchPutFieldOptionsResponseErrorsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldOptionError', ], 'max' => 50, 'min' => 0, ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'BooleanCondition' => [ 'type' => 'structure', 'members' => [ 'equalTo' => [ 'shape' => 'BooleanOperands', ], 'notEqualTo' => [ 'shape' => 'BooleanOperands', ], ], 'union' => true, ], 'BooleanConditionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'BooleanCondition', ], 'max' => 100, 'min' => 0, ], 'BooleanOperands' => [ 'type' => 'structure', 'required' => [ 'operandOne', 'operandTwo', 'result', ], 'members' => [ 'operandOne' => [ 'shape' => 'OperandOne', ], 'operandTwo' => [ 'shape' => 'OperandTwo', ], 'result' => [ 'shape' => 'Boolean', ], ], ], 'CaseArn' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'CaseEventIncludedData' => [ 'type' => 'structure', 'required' => [ 'fields', ], 'members' => [ 'fields' => [ 'shape' => 'CaseEventIncludedDataFieldsList', ], ], ], 'CaseEventIncludedDataFieldsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldIdentifier', ], 'max' => 200, 'min' => 0, ], 'CaseFilter' => [ 'type' => 'structure', 'members' => [ 'field' => [ 'shape' => 'FieldFilter', ], 'not' => [ 'shape' => 'CaseFilter', ], 'tag' => [ 'shape' => 'TagFilter', ], 'andAll' => [ 'shape' => 'CaseFilterAndAllList', ], 'orAll' => [ 'shape' => 'CaseFilterOrAllList', ], ], 'union' => true, ], 'CaseFilterAndAllList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CaseFilter', ], 'max' => 10, 'min' => 0, ], 'CaseFilterOrAllList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CaseFilter', ], 'max' => 10, 'min' => 0, ], 'CaseId' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'CaseRuleArn' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'CaseRuleDescription' => [ 'type' => 'string', 'max' => 255, 'min' => 0, ], 'CaseRuleDetails' => [ 'type' => 'structure', 'members' => [ 'required' => [ 'shape' => 'RequiredCaseRule', ], 'fieldOptions' => [ 'shape' => 'FieldOptionsCaseRule', ], 'hidden' => [ 'shape' => 'HiddenCaseRule', ], ], 'union' => true, ], 'CaseRuleError' => [ 'type' => 'structure', 'required' => [ 'id', 'errorCode', ], 'members' => [ 'id' => [ 'shape' => 'CaseRuleId', ], 'errorCode' => [ 'shape' => 'String', ], 'message' => [ 'shape' => 'String', ], ], ], 'CaseRuleId' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'CaseRuleIdentifier' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'CaseRuleId', ], ], ], 'CaseRuleIdentifierList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CaseRuleIdentifier', ], 'max' => 50, 'min' => 1, ], 'CaseRuleName' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '.*[\\S]', ], 'CaseRuleSummary' => [ 'type' => 'structure', 'required' => [ 'caseRuleId', 'name', 'caseRuleArn', 'ruleType', ], 'members' => [ 'caseRuleId' => [ 'shape' => 'CaseRuleId', ], 'name' => [ 'shape' => 'CaseRuleName', ], 'caseRuleArn' => [ 'shape' => 'CaseRuleArn', ], 'ruleType' => [ 'shape' => 'RuleType', ], 'description' => [ 'shape' => 'CaseRuleDescription', ], ], ], 'CaseSummary' => [ 'type' => 'structure', 'required' => [ 'caseId', 'templateId', ], 'members' => [ 'caseId' => [ 'shape' => 'CaseId', ], 'templateId' => [ 'shape' => 'TemplateId', ], ], ], 'Channel' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'CommentBody' => [ 'type' => 'string', 'max' => 15000, 'min' => 1, ], 'CommentBodyTextType' => [ 'type' => 'string', 'enum' => [ 'Text/Plain', ], ], 'CommentContent' => [ 'type' => 'structure', 'required' => [ 'body', 'contentType', ], 'members' => [ 'body' => [ 'shape' => 'CommentBody', ], 'contentType' => [ 'shape' => 'CommentBodyTextType', ], ], ], 'CommentFilter' => [ 'type' => 'structure', 'members' => [], ], 'ConflictException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'ConnectCaseContent' => [ 'type' => 'structure', 'required' => [ 'caseId', ], 'members' => [ 'caseId' => [ 'shape' => 'CaseId', ], ], ], 'ConnectCaseFilter' => [ 'type' => 'structure', 'members' => [ 'caseId' => [ 'shape' => 'CaseId', ], ], ], 'ConnectCaseInputContent' => [ 'type' => 'structure', 'required' => [ 'caseId', ], 'members' => [ 'caseId' => [ 'shape' => 'CaseId', ], ], ], 'ConnectedToSystemTime' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'Contact' => [ 'type' => 'structure', 'required' => [ 'contactArn', ], 'members' => [ 'contactArn' => [ 'shape' => 'ContactArn', ], ], ], 'ContactArn' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'ContactContent' => [ 'type' => 'structure', 'required' => [ 'contactArn', 'channel', 'connectedToSystemTime', ], 'members' => [ 'contactArn' => [ 'shape' => 'ContactArn', ], 'channel' => [ 'shape' => 'Channel', ], 'connectedToSystemTime' => [ 'shape' => 'ConnectedToSystemTime', ], ], ], 'ContactFilter' => [ 'type' => 'structure', 'members' => [ 'channel' => [ 'shape' => 'ContactFilterChannelList', ], 'contactArn' => [ 'shape' => 'ContactArn', ], ], ], 'ContactFilterChannelList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Channel', ], 'max' => 3, 'min' => 0, ], 'CreateCaseRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'templateId', 'fields', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'templateId' => [ 'shape' => 'TemplateId', ], 'fields' => [ 'shape' => 'CreateCaseRequestFieldsList', ], 'clientToken' => [ 'shape' => 'CreateCaseRequestClientTokenString', 'idempotencyToken' => true, ], 'performedBy' => [ 'shape' => 'UserUnion', ], 'tags' => [ 'shape' => 'MutableTags', ], ], ], 'CreateCaseRequestClientTokenString' => [ 'type' => 'string', 'max' => 64, 'min' => 0, ], 'CreateCaseRequestFieldsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldValue', ], 'max' => 100, 'min' => 0, ], 'CreateCaseResponse' => [ 'type' => 'structure', 'required' => [ 'caseId', 'caseArn', ], 'members' => [ 'caseId' => [ 'shape' => 'CaseId', ], 'caseArn' => [ 'shape' => 'CaseArn', ], ], ], 'CreateCaseRuleRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'name', 'rule', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'name' => [ 'shape' => 'CaseRuleName', ], 'description' => [ 'shape' => 'CaseRuleDescription', ], 'rule' => [ 'shape' => 'CaseRuleDetails', ], ], ], 'CreateCaseRuleResponse' => [ 'type' => 'structure', 'required' => [ 'caseRuleId', 'caseRuleArn', ], 'members' => [ 'caseRuleId' => [ 'shape' => 'CaseRuleId', ], 'caseRuleArn' => [ 'shape' => 'CaseRuleArn', ], ], ], 'CreateDomainRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'DomainName', ], ], ], 'CreateDomainResponse' => [ 'type' => 'structure', 'required' => [ 'domainId', 'domainArn', 'domainStatus', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'domainArn' => [ 'shape' => 'DomainArn', ], 'domainStatus' => [ 'shape' => 'DomainStatus', ], ], ], 'CreateFieldRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'name', 'type', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'name' => [ 'shape' => 'FieldName', ], 'type' => [ 'shape' => 'FieldType', ], 'description' => [ 'shape' => 'FieldDescription', ], ], ], 'CreateFieldResponse' => [ 'type' => 'structure', 'required' => [ 'fieldId', 'fieldArn', ], 'members' => [ 'fieldId' => [ 'shape' => 'FieldId', ], 'fieldArn' => [ 'shape' => 'FieldArn', ], ], ], 'CreateLayoutRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'name', 'content', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'name' => [ 'shape' => 'LayoutName', ], 'content' => [ 'shape' => 'LayoutContent', ], ], ], 'CreateLayoutResponse' => [ 'type' => 'structure', 'required' => [ 'layoutId', 'layoutArn', ], 'members' => [ 'layoutId' => [ 'shape' => 'LayoutId', ], 'layoutArn' => [ 'shape' => 'LayoutArn', ], ], ], 'CreateRelatedItemRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'caseId', 'type', 'content', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'caseId' => [ 'shape' => 'CaseId', 'location' => 'uri', 'locationName' => 'caseId', ], 'type' => [ 'shape' => 'RelatedItemType', ], 'content' => [ 'shape' => 'RelatedItemInputContent', ], 'performedBy' => [ 'shape' => 'UserUnion', ], ], ], 'CreateRelatedItemResponse' => [ 'type' => 'structure', 'required' => [ 'relatedItemId', 'relatedItemArn', ], 'members' => [ 'relatedItemId' => [ 'shape' => 'RelatedItemId', ], 'relatedItemArn' => [ 'shape' => 'RelatedItemArn', ], ], ], 'CreateTemplateRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'name', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'name' => [ 'shape' => 'TemplateName', ], 'description' => [ 'shape' => 'TemplateDescription', ], 'layoutConfiguration' => [ 'shape' => 'LayoutConfiguration', ], 'requiredFields' => [ 'shape' => 'RequiredFieldList', ], 'status' => [ 'shape' => 'TemplateStatus', ], 'rules' => [ 'shape' => 'TemplateCaseRuleList', ], 'tagPropagationConfigurations' => [ 'shape' => 'TagPropagationConfigurationList', ], ], ], 'CreateTemplateResponse' => [ 'type' => 'structure', 'required' => [ 'templateId', 'templateArn', ], 'members' => [ 'templateId' => [ 'shape' => 'TemplateId', ], 'templateArn' => [ 'shape' => 'TemplateArn', ], ], ], 'CreatedTime' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'CustomContent' => [ 'type' => 'structure', 'required' => [ 'fields', ], 'members' => [ 'fields' => [ 'shape' => 'FieldValueList', ], ], ], 'CustomEntity' => [ 'type' => 'string', 'max' => 500, 'min' => 1, 'pattern' => '[a-zA-Z0-9_\\-\\.@:/ ]*[a-zA-Z0-9_\\-\\.@:/]', 'sensitive' => true, ], 'CustomFieldsFilter' => [ 'type' => 'structure', 'members' => [ 'field' => [ 'shape' => 'FieldFilter', ], 'not' => [ 'shape' => 'CustomFieldsFilter', ], 'andAll' => [ 'shape' => 'CustomFieldsFilterAndAllList', ], 'orAll' => [ 'shape' => 'CustomFieldsFilterOrAllList', ], ], 'union' => true, ], 'CustomFieldsFilterAndAllList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CustomFieldsFilter', ], 'max' => 10, 'min' => 0, ], 'CustomFieldsFilterOrAllList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CustomFieldsFilter', ], 'max' => 10, 'min' => 0, ], 'CustomFilter' => [ 'type' => 'structure', 'members' => [ 'fields' => [ 'shape' => 'CustomFieldsFilter', ], ], ], 'CustomInputContent' => [ 'type' => 'structure', 'required' => [ 'fields', ], 'members' => [ 'fields' => [ 'shape' => 'CustomInputContentFieldsList', ], ], ], 'CustomInputContentFieldsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldValue', ], 'max' => 50, 'min' => 1, ], 'DeleteCaseRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'caseId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'caseId' => [ 'shape' => 'CaseId', 'location' => 'uri', 'locationName' => 'caseId', ], ], ], 'DeleteCaseResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteCaseRuleRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'caseRuleId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'caseRuleId' => [ 'shape' => 'CaseRuleId', 'location' => 'uri', 'locationName' => 'caseRuleId', ], ], ], 'DeleteCaseRuleResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteDomainRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], ], ], 'DeleteDomainResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteFieldRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'fieldId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'fieldId' => [ 'shape' => 'FieldId', 'location' => 'uri', 'locationName' => 'fieldId', ], ], ], 'DeleteFieldResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteLayoutRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'layoutId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'layoutId' => [ 'shape' => 'LayoutId', 'location' => 'uri', 'locationName' => 'layoutId', ], ], ], 'DeleteLayoutResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteRelatedItemRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'caseId', 'relatedItemId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'caseId' => [ 'shape' => 'CaseId', 'location' => 'uri', 'locationName' => 'caseId', ], 'relatedItemId' => [ 'shape' => 'RelatedItemId', 'location' => 'uri', 'locationName' => 'relatedItemId', ], ], ], 'DeleteRelatedItemResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteTemplateRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'templateId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'templateId' => [ 'shape' => 'TemplateId', 'location' => 'uri', 'locationName' => 'templateId', ], ], ], 'DeleteTemplateResponse' => [ 'type' => 'structure', 'members' => [], ], 'Deleted' => [ 'type' => 'boolean', ], 'DomainArn' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'DomainId' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'DomainName' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '.*[\\S]', ], 'DomainStatus' => [ 'type' => 'string', 'enum' => [ 'Active', 'CreationInProgress', 'CreationFailed', ], ], 'DomainSummary' => [ 'type' => 'structure', 'required' => [ 'domainId', 'domainArn', 'name', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'domainArn' => [ 'shape' => 'DomainArn', ], 'name' => [ 'shape' => 'DomainName', ], ], ], 'DomainSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DomainSummary', ], ], 'Double' => [ 'type' => 'double', 'box' => true, ], 'EmptyFieldValue' => [ 'type' => 'structure', 'members' => [], ], 'EmptyOperandValue' => [ 'type' => 'structure', 'members' => [], ], 'EventBridgeConfiguration' => [ 'type' => 'structure', 'required' => [ 'enabled', ], 'members' => [ 'enabled' => [ 'shape' => 'Boolean', ], 'includedData' => [ 'shape' => 'EventIncludedData', ], ], ], 'EventIncludedData' => [ 'type' => 'structure', 'members' => [ 'caseData' => [ 'shape' => 'CaseEventIncludedData', ], 'relatedItemData' => [ 'shape' => 'RelatedItemEventIncludedData', ], ], ], 'FieldArn' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'FieldDescription' => [ 'type' => 'string', 'max' => 255, 'min' => 0, ], 'FieldError' => [ 'type' => 'structure', 'required' => [ 'id', 'errorCode', ], 'members' => [ 'id' => [ 'shape' => 'FieldId', ], 'errorCode' => [ 'shape' => 'String', ], 'message' => [ 'shape' => 'String', ], ], ], 'FieldFilter' => [ 'type' => 'structure', 'members' => [ 'equalTo' => [ 'shape' => 'FieldValue', ], 'contains' => [ 'shape' => 'FieldValue', ], 'greaterThan' => [ 'shape' => 'FieldValue', ], 'greaterThanOrEqualTo' => [ 'shape' => 'FieldValue', ], 'lessThan' => [ 'shape' => 'FieldValue', ], 'lessThanOrEqualTo' => [ 'shape' => 'FieldValue', ], ], 'union' => true, ], 'FieldGroup' => [ 'type' => 'structure', 'required' => [ 'fields', ], 'members' => [ 'name' => [ 'shape' => 'FieldGroupNameString', ], 'fields' => [ 'shape' => 'FieldGroupFieldsList', ], ], ], 'FieldGroupFieldsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldItem', ], 'max' => 100, 'min' => 0, ], 'FieldGroupNameString' => [ 'type' => 'string', 'max' => 100, 'min' => 0, ], 'FieldId' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'FieldIdentifier' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'FieldId', ], ], ], 'FieldItem' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'FieldId', ], ], ], 'FieldName' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '.*[\\S]', ], 'FieldNamespace' => [ 'type' => 'string', 'enum' => [ 'System', 'Custom', ], ], 'FieldOption' => [ 'type' => 'structure', 'required' => [ 'name', 'value', 'active', ], 'members' => [ 'name' => [ 'shape' => 'FieldOptionName', ], 'value' => [ 'shape' => 'FieldOptionValue', ], 'active' => [ 'shape' => 'Boolean', ], ], ], 'FieldOptionError' => [ 'type' => 'structure', 'required' => [ 'message', 'errorCode', 'value', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'errorCode' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'FieldOptionValue', ], ], ], 'FieldOptionName' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '.*[\\S]', ], 'FieldOptionValue' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '.*[\\S]', ], 'FieldOptionsCaseRule' => [ 'type' => 'structure', 'required' => [ 'parentChildFieldOptionsMappings', ], 'members' => [ 'parentFieldId' => [ 'shape' => 'FieldId', ], 'childFieldId' => [ 'shape' => 'FieldId', ], 'parentChildFieldOptionsMappings' => [ 'shape' => 'ParentChildFieldOptionsMappingList', ], ], ], 'FieldOptionsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldOption', ], ], 'FieldSummary' => [ 'type' => 'structure', 'required' => [ 'fieldId', 'fieldArn', 'name', 'type', 'namespace', ], 'members' => [ 'fieldId' => [ 'shape' => 'FieldId', ], 'fieldArn' => [ 'shape' => 'FieldArn', ], 'name' => [ 'shape' => 'FieldName', ], 'type' => [ 'shape' => 'FieldType', ], 'namespace' => [ 'shape' => 'FieldNamespace', ], ], ], 'FieldType' => [ 'type' => 'string', 'enum' => [ 'Text', 'Number', 'Boolean', 'DateTime', 'SingleSelect', 'Url', 'User', ], ], 'FieldValue' => [ 'type' => 'structure', 'required' => [ 'id', 'value', ], 'members' => [ 'id' => [ 'shape' => 'FieldId', ], 'value' => [ 'shape' => 'FieldValueUnion', ], ], ], 'FieldValueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldValue', ], ], 'FieldValueUnion' => [ 'type' => 'structure', 'members' => [ 'stringValue' => [ 'shape' => 'FieldValueUnionStringValueString', ], 'doubleValue' => [ 'shape' => 'Double', ], 'booleanValue' => [ 'shape' => 'Boolean', ], 'emptyValue' => [ 'shape' => 'EmptyFieldValue', ], 'userArnValue' => [ 'shape' => 'String', ], ], 'union' => true, ], 'FieldValueUnionStringValueString' => [ 'type' => 'string', 'max' => 3000, 'min' => 0, ], 'FileArn' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'FileContent' => [ 'type' => 'structure', 'required' => [ 'fileArn', ], 'members' => [ 'fileArn' => [ 'shape' => 'FileArn', ], ], ], 'FileFilter' => [ 'type' => 'structure', 'members' => [ 'fileArn' => [ 'shape' => 'FileArn', ], ], ], 'GetCaseAuditEventsRequest' => [ 'type' => 'structure', 'required' => [ 'caseId', 'domainId', ], 'members' => [ 'caseId' => [ 'shape' => 'CaseId', 'location' => 'uri', 'locationName' => 'caseId', ], 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'maxResults' => [ 'shape' => 'GetCaseAuditEventsRequestMaxResultsInteger', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'GetCaseAuditEventsRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 25, 'min' => 1, ], 'GetCaseAuditEventsResponse' => [ 'type' => 'structure', 'required' => [ 'auditEvents', ], 'members' => [ 'nextToken' => [ 'shape' => 'NextToken', ], 'auditEvents' => [ 'shape' => 'GetCaseAuditEventsResponseAuditEventsList', ], ], ], 'GetCaseAuditEventsResponseAuditEventsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AuditEvent', ], 'max' => 25, 'min' => 0, ], 'GetCaseEventConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], ], ], 'GetCaseEventConfigurationResponse' => [ 'type' => 'structure', 'required' => [ 'eventBridge', ], 'members' => [ 'eventBridge' => [ 'shape' => 'EventBridgeConfiguration', ], ], ], 'GetCaseRequest' => [ 'type' => 'structure', 'required' => [ 'caseId', 'domainId', 'fields', ], 'members' => [ 'caseId' => [ 'shape' => 'CaseId', 'location' => 'uri', 'locationName' => 'caseId', ], 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'fields' => [ 'shape' => 'GetCaseRequestFieldsList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'GetCaseRequestFieldsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldIdentifier', ], 'max' => 100, 'min' => 1, ], 'GetCaseResponse' => [ 'type' => 'structure', 'required' => [ 'fields', 'templateId', ], 'members' => [ 'fields' => [ 'shape' => 'GetCaseResponseFieldsList', ], 'templateId' => [ 'shape' => 'TemplateId', ], 'nextToken' => [ 'shape' => 'NextToken', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'GetCaseResponseFieldsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldValue', ], 'max' => 100, 'min' => 0, ], 'GetCaseRuleResponse' => [ 'type' => 'structure', 'required' => [ 'caseRuleId', 'name', 'caseRuleArn', 'rule', ], 'members' => [ 'caseRuleId' => [ 'shape' => 'CaseRuleId', ], 'name' => [ 'shape' => 'CaseRuleName', ], 'caseRuleArn' => [ 'shape' => 'CaseRuleArn', ], 'rule' => [ 'shape' => 'CaseRuleDetails', ], 'description' => [ 'shape' => 'CaseRuleDescription', ], 'deleted' => [ 'shape' => 'Deleted', ], 'createdTime' => [ 'shape' => 'CreatedTime', ], 'lastModifiedTime' => [ 'shape' => 'LastModifiedTime', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'GetDomainRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], ], ], 'GetDomainResponse' => [ 'type' => 'structure', 'required' => [ 'domainId', 'domainArn', 'name', 'createdTime', 'domainStatus', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'domainArn' => [ 'shape' => 'DomainArn', ], 'name' => [ 'shape' => 'DomainName', ], 'createdTime' => [ 'shape' => 'CreatedTime', ], 'domainStatus' => [ 'shape' => 'DomainStatus', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'GetFieldResponse' => [ 'type' => 'structure', 'required' => [ 'fieldId', 'name', 'fieldArn', 'type', 'namespace', ], 'members' => [ 'fieldId' => [ 'shape' => 'FieldId', ], 'name' => [ 'shape' => 'FieldName', ], 'fieldArn' => [ 'shape' => 'FieldArn', ], 'description' => [ 'shape' => 'FieldDescription', ], 'type' => [ 'shape' => 'FieldType', ], 'namespace' => [ 'shape' => 'FieldNamespace', ], 'tags' => [ 'shape' => 'Tags', ], 'deleted' => [ 'shape' => 'Deleted', ], 'createdTime' => [ 'shape' => 'CreatedTime', ], 'lastModifiedTime' => [ 'shape' => 'LastModifiedTime', ], ], ], 'GetLayoutRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'layoutId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'layoutId' => [ 'shape' => 'LayoutId', 'location' => 'uri', 'locationName' => 'layoutId', ], ], ], 'GetLayoutResponse' => [ 'type' => 'structure', 'required' => [ 'layoutId', 'layoutArn', 'name', 'content', ], 'members' => [ 'layoutId' => [ 'shape' => 'LayoutId', ], 'layoutArn' => [ 'shape' => 'LayoutArn', ], 'name' => [ 'shape' => 'LayoutName', ], 'content' => [ 'shape' => 'LayoutContent', ], 'tags' => [ 'shape' => 'Tags', ], 'deleted' => [ 'shape' => 'Deleted', ], 'createdTime' => [ 'shape' => 'CreatedTime', ], 'lastModifiedTime' => [ 'shape' => 'LastModifiedTime', ], ], ], 'GetTemplateRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'templateId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'templateId' => [ 'shape' => 'TemplateId', 'location' => 'uri', 'locationName' => 'templateId', ], ], ], 'GetTemplateResponse' => [ 'type' => 'structure', 'required' => [ 'templateId', 'templateArn', 'name', 'status', ], 'members' => [ 'templateId' => [ 'shape' => 'TemplateId', ], 'templateArn' => [ 'shape' => 'TemplateArn', ], 'name' => [ 'shape' => 'TemplateName', ], 'description' => [ 'shape' => 'TemplateDescription', ], 'layoutConfiguration' => [ 'shape' => 'LayoutConfiguration', ], 'requiredFields' => [ 'shape' => 'RequiredFieldList', ], 'tags' => [ 'shape' => 'Tags', ], 'status' => [ 'shape' => 'TemplateStatus', ], 'deleted' => [ 'shape' => 'Deleted', ], 'createdTime' => [ 'shape' => 'CreatedTime', ], 'lastModifiedTime' => [ 'shape' => 'LastModifiedTime', ], 'rules' => [ 'shape' => 'TemplateCaseRuleList', ], 'tagPropagationConfigurations' => [ 'shape' => 'TagPropagationConfigurationList', ], ], ], 'HiddenCaseRule' => [ 'type' => 'structure', 'required' => [ 'defaultValue', 'conditions', ], 'members' => [ 'defaultValue' => [ 'shape' => 'Boolean', ], 'conditions' => [ 'shape' => 'BooleanConditionList', ], ], ], 'IamPrincipalArn' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'Integer' => [ 'type' => 'integer', 'box' => true, ], 'InternalServerException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'retryAfterSeconds' => [ 'shape' => 'Integer', 'location' => 'header', 'locationName' => 'Retry-After', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, 'retryable' => [ 'throttling' => false, ], ], 'LastModifiedTime' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'LayoutArn' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'LayoutConfiguration' => [ 'type' => 'structure', 'members' => [ 'defaultLayout' => [ 'shape' => 'LayoutId', ], ], ], 'LayoutContent' => [ 'type' => 'structure', 'members' => [ 'basic' => [ 'shape' => 'BasicLayout', ], ], 'union' => true, ], 'LayoutId' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'LayoutName' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '.*[\\S]', ], 'LayoutSections' => [ 'type' => 'structure', 'members' => [ 'sections' => [ 'shape' => 'SectionsList', ], ], ], 'LayoutSummary' => [ 'type' => 'structure', 'required' => [ 'layoutId', 'layoutArn', 'name', ], 'members' => [ 'layoutId' => [ 'shape' => 'LayoutId', ], 'layoutArn' => [ 'shape' => 'LayoutArn', ], 'name' => [ 'shape' => 'LayoutName', ], ], ], 'LayoutSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'LayoutSummary', ], ], 'ListCaseRulesRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListCaseRulesResponse' => [ 'type' => 'structure', 'required' => [ 'caseRules', ], 'members' => [ 'caseRules' => [ 'shape' => 'ListCaseRulesResponseCaseRulesList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListCaseRulesResponseCaseRulesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CaseRuleSummary', ], 'max' => 100, 'min' => 0, ], 'ListCasesForContactRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'contactArn', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'contactArn' => [ 'shape' => 'ContactArn', ], 'maxResults' => [ 'shape' => 'ListCasesForContactRequestMaxResultsInteger', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListCasesForContactRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 10, 'min' => 1, ], 'ListCasesForContactResponse' => [ 'type' => 'structure', 'required' => [ 'cases', ], 'members' => [ 'cases' => [ 'shape' => 'ListCasesForContactResponseCasesList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListCasesForContactResponseCasesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CaseSummary', ], 'max' => 10, 'min' => 0, ], 'ListDomainsRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'ListDomainsRequestMaxResultsInteger', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListDomainsRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 10, 'min' => 1, ], 'ListDomainsResponse' => [ 'type' => 'structure', 'required' => [ 'domains', ], 'members' => [ 'domains' => [ 'shape' => 'DomainSummaryList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListFieldOptionsRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'fieldId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'fieldId' => [ 'shape' => 'FieldId', 'location' => 'uri', 'locationName' => 'fieldId', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'values' => [ 'shape' => 'ValuesList', 'location' => 'querystring', 'locationName' => 'values', ], ], ], 'ListFieldOptionsResponse' => [ 'type' => 'structure', 'required' => [ 'options', ], 'members' => [ 'options' => [ 'shape' => 'FieldOptionsList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListFieldsRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListFieldsResponse' => [ 'type' => 'structure', 'required' => [ 'fields', ], 'members' => [ 'fields' => [ 'shape' => 'ListFieldsResponseFieldsList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListFieldsResponseFieldsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldSummary', ], 'max' => 100, 'min' => 0, ], 'ListLayoutsRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListLayoutsResponse' => [ 'type' => 'structure', 'required' => [ 'layouts', ], 'members' => [ 'layouts' => [ 'shape' => 'LayoutSummaryList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'arn', ], 'members' => [ 'arn' => [ 'shape' => 'Arn', 'location' => 'uri', 'locationName' => 'arn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'Tags', ], ], ], 'ListTemplatesRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'status' => [ 'shape' => 'TemplateStatusFilters', 'location' => 'querystring', 'locationName' => 'status', ], ], ], 'ListTemplatesResponse' => [ 'type' => 'structure', 'required' => [ 'templates', ], 'members' => [ 'templates' => [ 'shape' => 'ListTemplatesResponseTemplatesList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTemplatesResponseTemplatesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TemplateSummary', ], 'max' => 100, 'min' => 0, ], 'MaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'MutableTagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '(?![aA][wW][sS]:)[a-zA-Z0-9 _.:/=+\\-@]+', ], 'MutableTags' => [ 'type' => 'map', 'key' => [ 'shape' => 'MutableTagKey', ], 'value' => [ 'shape' => 'TagValueString', ], 'max' => 50, 'min' => 0, ], 'NextToken' => [ 'type' => 'string', 'max' => 9000, 'min' => 0, ], 'OperandOne' => [ 'type' => 'structure', 'members' => [ 'fieldId' => [ 'shape' => 'FieldId', ], ], 'union' => true, ], 'OperandTwo' => [ 'type' => 'structure', 'members' => [ 'stringValue' => [ 'shape' => 'OperandTwoStringValueString', ], 'booleanValue' => [ 'shape' => 'Boolean', ], 'doubleValue' => [ 'shape' => 'Double', ], 'emptyValue' => [ 'shape' => 'EmptyOperandValue', ], ], 'union' => true, ], 'OperandTwoStringValueString' => [ 'type' => 'string', 'max' => 1500, 'min' => 1, ], 'Order' => [ 'type' => 'string', 'enum' => [ 'Asc', 'Desc', ], ], 'ParentChildFieldOptionValue' => [ 'type' => 'string', 'max' => 100, 'min' => 0, 'pattern' => '$|^.*[\\S]', ], 'ParentChildFieldOptionsMapping' => [ 'type' => 'structure', 'required' => [ 'parentFieldOptionValue', 'childFieldOptionValues', ], 'members' => [ 'parentFieldOptionValue' => [ 'shape' => 'ParentChildFieldOptionValue', ], 'childFieldOptionValues' => [ 'shape' => 'ParentChildFieldOptionsMappingChildFieldOptionValuesList', ], ], ], 'ParentChildFieldOptionsMappingChildFieldOptionValuesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ParentChildFieldOptionValue', ], 'max' => 1500, 'min' => 0, ], 'ParentChildFieldOptionsMappingList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ParentChildFieldOptionsMapping', ], 'max' => 200, 'min' => 1, ], 'PutCaseEventConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'eventBridge', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'eventBridge' => [ 'shape' => 'EventBridgeConfiguration', ], ], ], 'PutCaseEventConfigurationResponse' => [ 'type' => 'structure', 'members' => [], ], 'RelatedItemArn' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'RelatedItemContent' => [ 'type' => 'structure', 'members' => [ 'contact' => [ 'shape' => 'ContactContent', ], 'comment' => [ 'shape' => 'CommentContent', ], 'file' => [ 'shape' => 'FileContent', ], 'sla' => [ 'shape' => 'SlaContent', ], 'connectCase' => [ 'shape' => 'ConnectCaseContent', ], 'custom' => [ 'shape' => 'CustomContent', ], ], 'union' => true, ], 'RelatedItemEventIncludedData' => [ 'type' => 'structure', 'required' => [ 'includeContent', ], 'members' => [ 'includeContent' => [ 'shape' => 'Boolean', ], ], ], 'RelatedItemId' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'RelatedItemInputContent' => [ 'type' => 'structure', 'members' => [ 'contact' => [ 'shape' => 'Contact', ], 'comment' => [ 'shape' => 'CommentContent', ], 'file' => [ 'shape' => 'FileContent', ], 'sla' => [ 'shape' => 'SlaInputContent', ], 'connectCase' => [ 'shape' => 'ConnectCaseInputContent', ], 'custom' => [ 'shape' => 'CustomInputContent', ], ], 'union' => true, ], 'RelatedItemType' => [ 'type' => 'string', 'enum' => [ 'Contact', 'Comment', 'File', 'Sla', 'ConnectCase', 'Custom', ], ], 'RelatedItemTypeFilter' => [ 'type' => 'structure', 'members' => [ 'contact' => [ 'shape' => 'ContactFilter', ], 'comment' => [ 'shape' => 'CommentFilter', ], 'file' => [ 'shape' => 'FileFilter', ], 'sla' => [ 'shape' => 'SlaFilter', ], 'connectCase' => [ 'shape' => 'ConnectCaseFilter', ], 'custom' => [ 'shape' => 'CustomFilter', ], ], 'union' => true, ], 'RequiredCaseRule' => [ 'type' => 'structure', 'required' => [ 'defaultValue', 'conditions', ], 'members' => [ 'defaultValue' => [ 'shape' => 'Boolean', ], 'conditions' => [ 'shape' => 'BooleanConditionList', ], ], ], 'RequiredField' => [ 'type' => 'structure', 'required' => [ 'fieldId', ], 'members' => [ 'fieldId' => [ 'shape' => 'FieldId', ], ], ], 'RequiredFieldList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RequiredField', ], 'max' => 100, 'min' => 0, ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'required' => [ 'message', 'resourceId', 'resourceType', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'resourceId' => [ 'shape' => 'String', ], 'resourceType' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'RuleType' => [ 'type' => 'string', 'enum' => [ 'Required', 'Hidden', 'FieldOptions', ], ], 'SearchAllRelatedItemsRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'maxResults' => [ 'shape' => 'SearchAllRelatedItemsRequestMaxResultsInteger', ], 'nextToken' => [ 'shape' => 'NextToken', ], 'filters' => [ 'shape' => 'SearchAllRelatedItemsRequestFiltersList', ], 'sorts' => [ 'shape' => 'SearchAllRelatedItemsRequestSortsList', ], ], ], 'SearchAllRelatedItemsRequestFiltersList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RelatedItemTypeFilter', ], 'max' => 10, 'min' => 0, ], 'SearchAllRelatedItemsRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 25, 'min' => 1, ], 'SearchAllRelatedItemsRequestSortsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SearchAllRelatedItemsSort', ], 'max' => 2, 'min' => 0, ], 'SearchAllRelatedItemsResponse' => [ 'type' => 'structure', 'required' => [ 'relatedItems', ], 'members' => [ 'nextToken' => [ 'shape' => 'NextToken', ], 'relatedItems' => [ 'shape' => 'SearchAllRelatedItemsResponseRelatedItemsList', ], ], ], 'SearchAllRelatedItemsResponseItem' => [ 'type' => 'structure', 'required' => [ 'relatedItemId', 'caseId', 'type', 'associationTime', 'content', ], 'members' => [ 'relatedItemId' => [ 'shape' => 'RelatedItemId', ], 'caseId' => [ 'shape' => 'CaseId', ], 'type' => [ 'shape' => 'RelatedItemType', ], 'associationTime' => [ 'shape' => 'AssociationTime', ], 'content' => [ 'shape' => 'RelatedItemContent', ], 'performedBy' => [ 'shape' => 'UserUnion', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'SearchAllRelatedItemsResponseRelatedItemsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SearchAllRelatedItemsResponseItem', ], 'max' => 25, 'min' => 0, ], 'SearchAllRelatedItemsSort' => [ 'type' => 'structure', 'required' => [ 'sortProperty', 'sortOrder', ], 'members' => [ 'sortProperty' => [ 'shape' => 'SearchAllRelatedItemsSortProperty', ], 'sortOrder' => [ 'shape' => 'Order', ], ], ], 'SearchAllRelatedItemsSortProperty' => [ 'type' => 'string', 'enum' => [ 'AssociationTime', 'CaseId', ], ], 'SearchCasesRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'maxResults' => [ 'shape' => 'SearchCasesRequestMaxResultsInteger', ], 'nextToken' => [ 'shape' => 'NextToken', ], 'searchTerm' => [ 'shape' => 'SearchCasesRequestSearchTermString', ], 'filter' => [ 'shape' => 'CaseFilter', ], 'sorts' => [ 'shape' => 'SearchCasesRequestSortsList', ], 'fields' => [ 'shape' => 'SearchCasesRequestFieldsList', ], ], ], 'SearchCasesRequestFieldsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldIdentifier', ], 'max' => 10, 'min' => 0, ], 'SearchCasesRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'SearchCasesRequestSearchTermString' => [ 'type' => 'string', 'max' => 255, 'min' => 0, ], 'SearchCasesRequestSortsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Sort', ], 'max' => 2, 'min' => 0, ], 'SearchCasesResponse' => [ 'type' => 'structure', 'required' => [ 'cases', ], 'members' => [ 'nextToken' => [ 'shape' => 'NextToken', ], 'cases' => [ 'shape' => 'SearchCasesResponseCasesList', ], ], ], 'SearchCasesResponseCasesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SearchCasesResponseItem', ], 'max' => 100, 'min' => 0, ], 'SearchCasesResponseItem' => [ 'type' => 'structure', 'required' => [ 'caseId', 'templateId', 'fields', ], 'members' => [ 'caseId' => [ 'shape' => 'CaseId', ], 'templateId' => [ 'shape' => 'TemplateId', ], 'fields' => [ 'shape' => 'SearchCasesResponseItemFieldsList', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'SearchCasesResponseItemFieldsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldValue', ], 'max' => 10, 'min' => 0, ], 'SearchRelatedItemsRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'caseId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'caseId' => [ 'shape' => 'CaseId', 'location' => 'uri', 'locationName' => 'caseId', ], 'maxResults' => [ 'shape' => 'SearchRelatedItemsRequestMaxResultsInteger', ], 'nextToken' => [ 'shape' => 'NextToken', ], 'filters' => [ 'shape' => 'SearchRelatedItemsRequestFiltersList', ], ], ], 'SearchRelatedItemsRequestFiltersList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RelatedItemTypeFilter', ], 'max' => 10, 'min' => 0, ], 'SearchRelatedItemsRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 25, 'min' => 1, ], 'SearchRelatedItemsResponse' => [ 'type' => 'structure', 'required' => [ 'relatedItems', ], 'members' => [ 'nextToken' => [ 'shape' => 'NextToken', ], 'relatedItems' => [ 'shape' => 'SearchRelatedItemsResponseRelatedItemsList', ], ], ], 'SearchRelatedItemsResponseItem' => [ 'type' => 'structure', 'required' => [ 'relatedItemId', 'type', 'associationTime', 'content', ], 'members' => [ 'relatedItemId' => [ 'shape' => 'RelatedItemId', ], 'type' => [ 'shape' => 'RelatedItemType', ], 'associationTime' => [ 'shape' => 'AssociationTime', ], 'content' => [ 'shape' => 'RelatedItemContent', ], 'tags' => [ 'shape' => 'Tags', ], 'performedBy' => [ 'shape' => 'UserUnion', ], ], ], 'SearchRelatedItemsResponseRelatedItemsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SearchRelatedItemsResponseItem', ], 'max' => 25, 'min' => 0, ], 'SearchTagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9 _.:/=+\\-@]+', ], 'Section' => [ 'type' => 'structure', 'members' => [ 'fieldGroup' => [ 'shape' => 'FieldGroup', ], ], 'union' => true, ], 'SectionsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Section', ], 'max' => 1, 'min' => 0, ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'SlaCompletionTime' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'SlaConfiguration' => [ 'type' => 'structure', 'required' => [ 'name', 'type', 'status', 'targetTime', ], 'members' => [ 'name' => [ 'shape' => 'SlaName', ], 'type' => [ 'shape' => 'SlaType', ], 'status' => [ 'shape' => 'SlaStatus', ], 'fieldId' => [ 'shape' => 'FieldId', ], 'targetFieldValues' => [ 'shape' => 'SlaFieldValueUnionList', ], 'targetTime' => [ 'shape' => 'SlaTargetTime', ], 'completionTime' => [ 'shape' => 'SlaCompletionTime', ], ], ], 'SlaContent' => [ 'type' => 'structure', 'required' => [ 'slaConfiguration', ], 'members' => [ 'slaConfiguration' => [ 'shape' => 'SlaConfiguration', ], ], ], 'SlaFieldValueUnionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldValueUnion', ], 'max' => 1, 'min' => 1, ], 'SlaFilter' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'SlaName', ], 'status' => [ 'shape' => 'SlaStatus', ], ], ], 'SlaInputConfiguration' => [ 'type' => 'structure', 'required' => [ 'name', 'type', 'targetSlaMinutes', ], 'members' => [ 'name' => [ 'shape' => 'SlaName', ], 'type' => [ 'shape' => 'SlaType', ], 'fieldId' => [ 'shape' => 'FieldId', ], 'targetFieldValues' => [ 'shape' => 'SlaFieldValueUnionList', ], 'targetSlaMinutes' => [ 'shape' => 'TargetSlaMinutes', ], ], ], 'SlaInputContent' => [ 'type' => 'structure', 'members' => [ 'slaInputConfiguration' => [ 'shape' => 'SlaInputConfiguration', ], ], 'union' => true, ], 'SlaName' => [ 'type' => 'string', 'max' => 500, 'min' => 1, 'pattern' => '.*[\\S]', 'sensitive' => true, ], 'SlaStatus' => [ 'type' => 'string', 'enum' => [ 'Active', 'Overdue', 'Met', 'NotMet', ], ], 'SlaTargetTime' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'SlaType' => [ 'type' => 'string', 'enum' => [ 'CaseField', ], ], 'Sort' => [ 'type' => 'structure', 'required' => [ 'fieldId', 'sortOrder', ], 'members' => [ 'fieldId' => [ 'shape' => 'FieldId', ], 'sortOrder' => [ 'shape' => 'Order', ], ], ], 'String' => [ 'type' => 'string', ], 'TagFilter' => [ 'type' => 'structure', 'members' => [ 'equalTo' => [ 'shape' => 'TagValue', ], ], 'union' => true, ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '(?!aws:)[a-zA-Z+-=._:/]+', ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 50, 'min' => 0, ], 'TagPropagationConfiguration' => [ 'type' => 'structure', 'required' => [ 'resourceType', 'tagMap', ], 'members' => [ 'resourceType' => [ 'shape' => 'TagPropagationResourceType', ], 'tagMap' => [ 'shape' => 'TagPropagationConfigurationTagMapMap', ], ], ], 'TagPropagationConfigurationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagPropagationConfiguration', ], 'max' => 1, 'min' => 0, ], 'TagPropagationConfigurationTagMapMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'MutableTagKey', ], 'value' => [ 'shape' => 'TagValueString', ], 'max' => 10, 'min' => 0, ], 'TagPropagationResourceType' => [ 'type' => 'string', 'enum' => [ 'Cases', ], ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'arn', 'tags', ], 'members' => [ 'arn' => [ 'shape' => 'Arn', 'location' => 'uri', 'locationName' => 'arn', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'TagValue' => [ 'type' => 'structure', 'members' => [ 'key' => [ 'shape' => 'SearchTagKey', ], 'value' => [ 'shape' => 'TagValueString', ], ], ], 'TagValueString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '([a-zA-Z0-9 _.:/=+\\-@]*)', ], 'Tags' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'TargetSlaMinutes' => [ 'type' => 'long', 'box' => true, 'max' => 129600, 'min' => 1, ], 'TemplateArn' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'TemplateCaseRuleList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TemplateRule', ], 'max' => 50, 'min' => 0, ], 'TemplateDescription' => [ 'type' => 'string', 'max' => 255, 'min' => 0, ], 'TemplateId' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'TemplateName' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '.*[\\S]', ], 'TemplateRule' => [ 'type' => 'structure', 'required' => [ 'caseRuleId', ], 'members' => [ 'caseRuleId' => [ 'shape' => 'CaseRuleId', ], 'fieldId' => [ 'shape' => 'FieldId', ], ], ], 'TemplateStatus' => [ 'type' => 'string', 'enum' => [ 'Active', 'Inactive', ], ], 'TemplateStatusFilters' => [ 'type' => 'list', 'member' => [ 'shape' => 'TemplateStatus', ], 'max' => 2, 'min' => 1, ], 'TemplateSummary' => [ 'type' => 'structure', 'required' => [ 'templateId', 'templateArn', 'name', 'status', ], 'members' => [ 'templateId' => [ 'shape' => 'TemplateId', ], 'templateArn' => [ 'shape' => 'TemplateArn', ], 'name' => [ 'shape' => 'TemplateName', ], 'status' => [ 'shape' => 'TemplateStatus', ], 'tagPropagationConfigurations' => [ 'shape' => 'TagPropagationConfigurationList', ], ], ], 'ThrottlingException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, 'retryable' => [ 'throttling' => false, ], ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'arn', 'tagKeys', ], 'members' => [ 'arn' => [ 'shape' => 'Arn', 'location' => 'uri', 'locationName' => 'arn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UpdateCaseRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'caseId', 'fields', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'caseId' => [ 'shape' => 'CaseId', 'location' => 'uri', 'locationName' => 'caseId', ], 'fields' => [ 'shape' => 'UpdateCaseRequestFieldsList', ], 'performedBy' => [ 'shape' => 'UserUnion', ], ], ], 'UpdateCaseRequestFieldsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldValue', ], 'max' => 100, 'min' => 0, ], 'UpdateCaseResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateCaseRuleRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'caseRuleId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'caseRuleId' => [ 'shape' => 'CaseRuleId', 'location' => 'uri', 'locationName' => 'caseRuleId', ], 'name' => [ 'shape' => 'CaseRuleName', ], 'description' => [ 'shape' => 'CaseRuleDescription', ], 'rule' => [ 'shape' => 'CaseRuleDetails', ], ], ], 'UpdateCaseRuleResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateFieldRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'fieldId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'fieldId' => [ 'shape' => 'FieldId', 'location' => 'uri', 'locationName' => 'fieldId', ], 'name' => [ 'shape' => 'FieldName', ], 'description' => [ 'shape' => 'FieldDescription', ], ], ], 'UpdateFieldResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateLayoutRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'layoutId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'layoutId' => [ 'shape' => 'LayoutId', 'location' => 'uri', 'locationName' => 'layoutId', ], 'name' => [ 'shape' => 'LayoutName', ], 'content' => [ 'shape' => 'LayoutContent', ], ], ], 'UpdateLayoutResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateTemplateRequest' => [ 'type' => 'structure', 'required' => [ 'domainId', 'templateId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainId', ], 'templateId' => [ 'shape' => 'TemplateId', 'location' => 'uri', 'locationName' => 'templateId', ], 'name' => [ 'shape' => 'TemplateName', ], 'description' => [ 'shape' => 'TemplateDescription', ], 'layoutConfiguration' => [ 'shape' => 'LayoutConfiguration', ], 'requiredFields' => [ 'shape' => 'RequiredFieldList', ], 'status' => [ 'shape' => 'TemplateStatus', ], 'rules' => [ 'shape' => 'TemplateCaseRuleList', ], 'tagPropagationConfigurations' => [ 'shape' => 'TagPropagationConfigurationList', ], ], ], 'UpdateTemplateResponse' => [ 'type' => 'structure', 'members' => [], ], 'UserArn' => [ 'type' => 'string', 'max' => 500, 'min' => 1, ], 'UserUnion' => [ 'type' => 'structure', 'members' => [ 'userArn' => [ 'shape' => 'UserArn', ], 'customEntity' => [ 'shape' => 'CustomEntity', ], ], 'union' => true, ], 'ValidationException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'Value' => [ 'type' => 'string', 'max' => 100, 'min' => 0, ], 'ValuesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Value', ], 'max' => 1, 'min' => 0, ], ],];
